/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.peer.ComponentPeer;
import java.awt.peer.WindowPeer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.ComponentAccessor;
import sun.awt.DisplayChangedListener;
import sun.awt.SunToolkit;
import sun.awt.UngrabEvent;
import sun.awt.WindowAccessor;
import sun.awt.X11.MWMConstants;
import sun.awt.X11.Native;
import sun.awt.X11.PropMwmHints;
import sun.awt.X11.ToplevelStateListener;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAWTIcon32_java_icon16_png;
import sun.awt.X11.XAWTIcon32_java_icon24_png;
import sun.awt.X11.XAWTIcon32_java_icon32_png;
import sun.awt.X11.XAWTIcon32_java_icon48_png;
import sun.awt.X11.XAWTIcon64_java_icon16_png;
import sun.awt.X11.XAWTIcon64_java_icon24_png;
import sun.awt.X11.XAWTIcon64_java_icon32_png;
import sun.awt.X11.XAWTIcon64_java_icon48_png;
import sun.awt.X11.XAtom;
import sun.awt.X11.XAtomList;
import sun.awt.X11.XAwtState;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XButtonEvent;
import sun.awt.X11.XConfigureEvent;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XCrossingEvent;
import sun.awt.X11.XDecoratedPeer;
import sun.awt.X11.XDialogPeer;
import sun.awt.X11.XDropTargetRegistry;
import sun.awt.X11.XEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XFocusChangeEvent;
import sun.awt.X11.XFocusProxyWindow;
import sun.awt.X11.XIconInfo;
import sun.awt.X11.XKeyboardFocusManagerPeer;
import sun.awt.X11.XMotionEvent;
import sun.awt.X11.XNETProtocol;
import sun.awt.X11.XPanelPeer;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XQueryTree;
import sun.awt.X11.XSizeHints;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XTrayIconPeer;
import sun.awt.X11.XUnmapEvent;
import sun.awt.X11.XVisibilityEvent;
import sun.awt.X11.XWM;
import sun.awt.X11.XWMHints;
import sun.awt.X11.XWarningWindow;
import sun.awt.X11.XWindowAttributesData;
import sun.awt.X11.XlibUtil;
import sun.awt.X11.XlibWrapper;
import sun.awt.X11GraphicsDevice;
import sun.awt.X11GraphicsEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XWindowPeer
extends XPanelPeer
implements WindowPeer,
DisplayChangedListener,
MWMConstants {
    private static final Logger log = Logger.getLogger("sun.awt.X11.XWindowPeer");
    private static final Logger focusLog = Logger.getLogger("sun.awt.X11.focus.XWindowPeer");
    private static final Logger insLog = Logger.getLogger("sun.awt.X11.insets.XWindowPeer");
    private static final Logger grabLog = Logger.getLogger("sun.awt.X11.grab.XWindowPeer");
    private static final Logger iconLog = Logger.getLogger("sun.awt.X11.icon.XWindowPeer");
    private static Set<XWindowPeer> windows = new HashSet<XWindowPeer>();
    static XAtom wm_protocols;
    static XAtom wm_delete_window;
    static XAtom wm_take_focus;
    Insets insets = new Insets(0, 0, 0, 0);
    XWindowAttributesData winAttr;
    private boolean cachedFocusableWindow;
    XWarningWindow warningWindow;
    private boolean alwaysOnTop;
    PropMwmHints mwm_hints;
    private boolean locationByPlatform;
    Dialog modalBlocker;
    boolean delayedModalBlocking = false;
    Dimension targetMinimumSize = null;
    private XWindowPeer ownerPeer;
    protected XWindowPeer prevTransientFor;
    protected XWindowPeer nextTransientFor;
    private XWindowPeer curRealTransientFor;
    private boolean grab = false;
    private boolean isMapped = false;
    private boolean stateChanged;
    private int savedState;
    private boolean mustControlStackPosition = false;
    private XEventDispatcher rootPropertyEventDispatcher = null;
    private boolean isUnhiding = false;
    private boolean isBeforeFirstMapNotify = false;
    protected Vector<ToplevelStateListener> toplevelStateListeners = new Vector();
    static Font defaultFont;
    private static final int PREFERRED_SIZE_FOR_ICON = 128;
    private static final int MAXIMUM_BUFFER_LENGTH_NET_WM_ICON = 65535;
    private static ArrayList<XIconInfo> defaultIconInfo;
    private int dropTargetCount = 0;
    XAtom XA_NET_WM_STATE;
    XAtomList net_wm_state;
    private Insets wm_set_insets;
    private XBaseWindow pressTarget = this;

    XWindowPeer(XCreateWindowParams params) {
        super(params.putIfNull((Object)"parent window", (Object)0L));
    }

    XWindowPeer(Window target) {
        super(new XCreateWindowParams(new Object[]{"target", target, "parent window", 0L}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void preInit(XCreateWindowParams params) {
        Color c;
        this.target = (Component)params.get("target");
        params.put("reparented", this.isOverrideRedirect() || this.isSimpleWindow());
        super.preInit(params);
        params.putIfNull((Object)"bit gravity", (Object)1);
        this.savedState = 0;
        this.XA_NET_WM_STATE = XAtom.get("_NET_WM_STATE");
        this.winAttr = new XWindowAttributesData();
        this.insets = new Insets(0, 0, 0, 0);
        params.put("overrideRedirect", this.isOverrideRedirect());
        SunToolkit.awtLock();
        try {
            windows.add(this);
            if (wm_protocols == null) {
                wm_protocols = XAtom.get("WM_PROTOCOLS");
                wm_delete_window = XAtom.get("WM_DELETE_WINDOW");
                wm_take_focus = XAtom.get("WM_TAKE_FOCUS");
            }
        }
        finally {
            SunToolkit.awtUnlock();
        }
        this.cachedFocusableWindow = this.isFocusableWindow();
        Font f = this.target.getFont();
        if (f == null) {
            if (defaultFont == null) {
                defaultFont = new Font("Dialog", 0, 12);
            }
            f = defaultFont;
            this.target.setFont(f);
        }
        if ((c = this.target.getBackground()) == null) {
            SystemColor background = SystemColor.window;
            this.target.setBackground(background);
        }
        if ((c = this.target.getForeground()) == null) {
            this.target.setForeground(SystemColor.windowText);
        }
        this.alwaysOnTop = ((Window)this.target).isAlwaysOnTop() && ((Window)this.target).isAlwaysOnTopSupported();
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        ((X11GraphicsDevice)gc.getDevice()).addDisplayChangedListener(this);
        Rectangle bounds = (Rectangle)params.get("bounds");
        params.put("bounds", this.constrainBounds(bounds.x, bounds.y, bounds.width, bounds.height));
    }

    private void initWMProtocols() {
        wm_protocols.setAtomListProperty((XBaseWindow)this, this.getWMProtocols());
    }

    protected XAtomList getWMProtocols() {
        return new XAtomList();
    }

    @Override
    protected String getWMName() {
        String name = this.target.getName();
        if (name == null || name.trim().equals("")) {
            name = " ";
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void postInit(XCreateWindowParams params) {
        super.postInit(params);
        this.initWMProtocols();
        Window t_window = (Window)this.target;
        Window owner = t_window.getOwner();
        if (owner != null) {
            long ownerWindow;
            this.ownerPeer = (XWindowPeer)owner.getPeer();
            if (focusLog.isLoggable(Level.FINER)) {
                focusLog.fine("Owner is " + owner);
                focusLog.fine("Owner peer is " + this.ownerPeer);
                focusLog.fine("Owner X window " + Long.toHexString(this.ownerPeer.getWindow()));
                focusLog.fine("Owner content X window " + Long.toHexString(this.ownerPeer.getContentWindow()));
            }
            if ((ownerWindow = this.ownerPeer.getWindow()) != 0L) {
                XToolkit.awtLock();
                try {
                    if (focusLog.isLoggable(Level.FINE)) {
                        focusLog.fine("Setting transient on " + Long.toHexString(this.getWindow()) + " for " + Long.toHexString(ownerWindow));
                    }
                    XWindowPeer.setToplevelTransientFor(this, this.ownerPeer, false, true);
                    XWMHints hints = this.getWMHints();
                    hints.set_flags(hints.get_flags() | 0x40L);
                    hints.set_window_group(ownerWindow);
                    XlibWrapper.XSetWMHints(XToolkit.getDisplay(), this.getWindow(), hints.pData);
                }
                finally {
                    XToolkit.awtUnlock();
                }
            }
        }
        if (((Window)this.target).getWarningString() != null && !WindowAccessor.isTrayIconWindow((Window)this.target)) {
            this.warningWindow = new XWarningWindow((Window)this.target, this.getWindow());
        }
        this.setSaveUnder(true);
        XWM.requestWMExtents(this.getWindow());
        this.updateIconImages();
    }

    @Override
    public void updateIconImages() {
        Window target = (Window)this.target;
        List<Image> iconImages = target.getIconImages();
        XWindowPeer ownerPeer = this.getOwnerPeer();
        this.winAttr.icons = new ArrayList<XIconInfo>();
        if (iconImages.size() != 0) {
            this.winAttr.iconsInherited = false;
            for (Image image : iconImages) {
                XIconInfo iconInfo;
                if (image == null) {
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.finest("XWindowPeer.updateIconImages: Skipping the image passed into Java because it's null.");
                    continue;
                }
                try {
                    iconInfo = new XIconInfo(image);
                }
                catch (Exception e) {
                    if (!log.isLoggable(Level.FINEST)) continue;
                    log.finest("XWindowPeer.updateIconImages: Perhaps the image passed into Java is broken. Skipping this icon.");
                    continue;
                }
                if (!iconInfo.isValid()) continue;
                this.winAttr.icons.add(iconInfo);
            }
        }
        this.winAttr.icons = XWindowPeer.normalizeIconImages(this.winAttr.icons);
        if (this.winAttr.icons.size() == 0) {
            if (ownerPeer != null) {
                this.winAttr.iconsInherited = true;
                this.winAttr.icons = ownerPeer.getIconInfo();
            } else {
                this.winAttr.iconsInherited = false;
                this.winAttr.icons = XWindowPeer.getDefaultIconInfo();
            }
        }
        this.recursivelySetIcon(this.winAttr.icons);
    }

    static List<XIconInfo> normalizeIconImages(List<XIconInfo> icons) {
        ArrayList<XIconInfo> result = new ArrayList<XIconInfo>();
        int totalLength = 0;
        boolean haveLargeIcon = false;
        for (XIconInfo icon : icons) {
            int width = icon.getWidth();
            int height = icon.getHeight();
            int length = icon.getRawLength();
            if (width > 128 || height > 128) {
                int scaledHeight;
                if (haveLargeIcon) continue;
                int scaledWidth = width;
                for (scaledHeight = height; scaledWidth > 128 || scaledHeight > 128; scaledWidth /= 2, scaledHeight /= 2) {
                }
                icon.setScaledSize(scaledWidth, scaledHeight);
                length = icon.getRawLength();
            }
            if (totalLength + length > 65535) continue;
            totalLength += length;
            result.add(icon);
            if (width <= 128 && height <= 128) continue;
            haveLargeIcon = true;
        }
        if (iconLog.isLoggable(Level.FINEST)) {
            iconLog.log(Level.FINEST, ">>> Length_ of buffer of icons data: " + totalLength + ", maximum length: " + 65535);
        }
        return result;
    }

    static void dumpIcons(List<XIconInfo> icons) {
        if (iconLog.isLoggable(Level.FINEST)) {
            iconLog.log(Level.FINEST, ">>> Sizes of icon images:");
            Iterator<XIconInfo> i = icons.iterator();
            while (i.hasNext()) {
                iconLog.log(Level.FINEST, "    {0}", String.valueOf(i.next()));
            }
        }
    }

    public void recursivelySetIcon(List<XIconInfo> icons) {
        XWindowPeer.dumpIcons(this.winAttr.icons);
        this.setIconHints(icons);
        Window target = (Window)this.target;
        Window[] children = target.getOwnedWindows();
        int cnt = children.length;
        for (int i = 0; i < cnt; ++i) {
            ComponentPeer childPeer = children[i].getPeer();
            if (childPeer == null || !(childPeer instanceof XWindowPeer) || !((XWindowPeer)childPeer).winAttr.iconsInherited) continue;
            ((XWindowPeer)childPeer).winAttr.icons = icons;
            ((XWindowPeer)childPeer).recursivelySetIcon(icons);
        }
    }

    List<XIconInfo> getIconInfo() {
        return this.winAttr.icons;
    }

    void setIconHints(List<XIconInfo> icons) {
    }

    protected static synchronized List<XIconInfo> getDefaultIconInfo() {
        if (defaultIconInfo == null) {
            defaultIconInfo = new ArrayList();
            if (XlibWrapper.dataModel == 32) {
                defaultIconInfo.add(new XIconInfo(XAWTIcon32_java_icon16_png.java_icon16_png));
                defaultIconInfo.add(new XIconInfo(XAWTIcon32_java_icon24_png.java_icon24_png));
                defaultIconInfo.add(new XIconInfo(XAWTIcon32_java_icon32_png.java_icon32_png));
                defaultIconInfo.add(new XIconInfo(XAWTIcon32_java_icon48_png.java_icon48_png));
            } else {
                defaultIconInfo.add(new XIconInfo(XAWTIcon64_java_icon16_png.java_icon16_png));
                defaultIconInfo.add(new XIconInfo(XAWTIcon64_java_icon24_png.java_icon24_png));
                defaultIconInfo.add(new XIconInfo(XAWTIcon64_java_icon32_png.java_icon32_png));
                defaultIconInfo.add(new XIconInfo(XAWTIcon64_java_icon48_png.java_icon48_png));
            }
        }
        return defaultIconInfo;
    }

    @Override
    public void updateMinimumSize() {
        this.targetMinimumSize = this.target.isMinimumSizeSet() ? this.target.getMinimumSize() : null;
    }

    public Dimension getTargetMinimumSize() {
        return this.targetMinimumSize == null ? null : new Dimension(this.targetMinimumSize);
    }

    public XWindowPeer getOwnerPeer() {
        return this.ownerPeer;
    }

    Rectangle constrainBounds(int x, int y, int width, int height) {
        if (!this.hasWarningWindow()) {
            return new Rectangle(x, y, width, height);
        }
        int newX = x;
        int newY = y;
        int newW = width;
        int newH = height;
        GraphicsConfiguration gc = ((Window)this.target).getGraphicsConfiguration();
        Rectangle sB = gc.getBounds();
        Insets sIn = ((Window)this.target).getToolkit().getScreenInsets(gc);
        int screenX = sB.x + sIn.left;
        int screenY = sB.y + sIn.top;
        int screenW = sB.width - sIn.left - sIn.right;
        int screenH = sB.height - sIn.top - sIn.bottom;
        if (newW > screenW) {
            newW = screenW;
        }
        if (newH > screenH) {
            newH = screenH;
        }
        if (newX < screenX) {
            newX = screenX;
        } else if (newX + newW > screenX + screenW) {
            newX = screenX + screenW - newW;
        }
        if (newY < screenY) {
            newY = screenY;
        } else if (newY + newH > screenY + screenH) {
            newY = screenY + screenH - newH;
        }
        return new Rectangle(newX, newY, newW, newH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBounds(int x, int y, int width, int height, int op) {
        Rectangle newBounds = this.constrainBounds(x, y, width, height);
        XToolkit.awtLock();
        try {
            Rectangle oldBounds = this.getBounds();
            super.setBounds(newBounds.x, newBounds.y, newBounds.width, newBounds.height, op);
            Rectangle bounds = this.getBounds();
            XSizeHints hints = this.getHints();
            this.setSizeHints(hints.get_flags() | 4L | 8L, bounds.x, bounds.y, bounds.width, bounds.height);
            XWM.setMotifDecor(this, false, 0, 0);
            XNETProtocol protocol = XWM.getWM().getNETProtocol();
            if (protocol != null && protocol.active()) {
                XAtomList net_wm_state = this.getNETWMState();
                net_wm_state.add(protocol.XA_NET_WM_STATE_SKIP_TASKBAR);
                this.setNETWMState(net_wm_state);
            }
            if (!bounds.getSize().equals(oldBounds.getSize())) {
                this.postEventToEventQueue(new ComponentEvent(this.getEventSource(), 101));
            }
            if (!bounds.getLocation().equals(oldBounds.getLocation())) {
                this.postEventToEventQueue(new ComponentEvent(this.getEventSource(), 100));
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateFocusability() {
        this.updateFocusableWindowState();
        XToolkit.awtLock();
        try {
            XWMHints hints = this.getWMHints();
            hints.set_flags(hints.get_flags() | 1L);
            hints.set_input(false);
            XlibWrapper.XSetWMHints(XToolkit.getDisplay(), this.getWindow(), hints.pData);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    @Override
    public Insets getInsets() {
        Insets in = (Insets)this.insets.clone();
        in.top += this.getWarningWindowHeight();
        return in;
    }

    public void handleIconify() {
        this.postEvent(new WindowEvent((Window)this.target, 203));
    }

    public void handleDeiconify() {
        this.postEvent(new WindowEvent((Window)this.target, 204));
    }

    public void handleStateChange(int oldState, int newState) {
        this.postEvent(new WindowEvent((Window)this.target, 209, oldState, newState));
    }

    @Override
    public Insets insets() {
        return this.getInsets();
    }

    boolean isAutoRequestFocus() {
        return true;
    }

    static XWindowPeer getNativeFocusedWindowPeer() {
        XBaseWindow baseWindow = XToolkit.windowToXWindow(XWindowPeer.xGetInputFocus());
        return baseWindow instanceof XWindowPeer ? (XWindowPeer)baseWindow : (baseWindow instanceof XFocusProxyWindow ? ((XFocusProxyWindow)baseWindow).getOwner() : null);
    }

    boolean isFocusableWindow() {
        if (XToolkit.isToolkitThread() || SunToolkit.isAWTLockHeldByCurrentThread()) {
            return this.cachedFocusableWindow;
        }
        return ((Window)this.target).isFocusableWindow();
    }

    boolean isFocusedWindowModalBlocker() {
        return false;
    }

    long getFocusTargetWindow() {
        return this.getContentWindow();
    }

    boolean isNativelyNonFocusableWindow() {
        if (XToolkit.isToolkitThread() || SunToolkit.isAWTLockHeldByCurrentThread()) {
            return this.isSimpleWindow() || !this.cachedFocusableWindow;
        }
        return this.isSimpleWindow() || !((Window)this.target).isFocusableWindow();
    }

    public void handleWindowFocusIn_Dispatch() {
        if (EventQueue.isDispatchThread()) {
            XKeyboardFocusManagerPeer.setCurrentNativeFocusedWindow((Window)this.target);
            this.target.dispatchEvent(new WindowEvent((Window)this.target, 207));
        }
    }

    public void handleWindowFocusInSync(long serial) {
        WindowEvent we = new WindowEvent((Window)this.target, 207);
        XKeyboardFocusManagerPeer.setCurrentNativeFocusedWindow((Window)this.target);
        XWindowPeer.sendEvent(we);
    }

    public void handleWindowFocusIn(long serial) {
        WindowEvent we = new WindowEvent((Window)this.target, 207);
        XKeyboardFocusManagerPeer.setCurrentNativeFocusedWindow((Window)this.target);
        this.postEvent(XWindowPeer.wrapInSequenced(we));
    }

    public void handleWindowFocusOut(Window oppositeWindow, long serial) {
        WindowEvent we = new WindowEvent((Window)this.target, 208, oppositeWindow);
        XKeyboardFocusManagerPeer.setCurrentNativeFocusedWindow(null);
        XKeyboardFocusManagerPeer.setCurrentNativeFocusOwner(null);
        this.postEvent(XWindowPeer.wrapInSequenced(we));
    }

    public void handleWindowFocusOutSync(Window oppositeWindow, long serial) {
        WindowEvent we = new WindowEvent((Window)this.target, 208, oppositeWindow);
        XKeyboardFocusManagerPeer.setCurrentNativeFocusedWindow(null);
        XKeyboardFocusManagerPeer.setCurrentNativeFocusOwner(null);
        XWindowPeer.sendEvent(we);
    }

    public void checkIfOnNewScreen(Rectangle newBounds) {
        if (!XToolkit.localEnv.runningXinerama()) {
            return;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("XWindowPeer: Check if we've been moved to a new screen since we're running in Xinerama mode");
        }
        int area = newBounds.width * newBounds.height;
        int largestAmt = 0;
        int curScreenNum = ((X11GraphicsDevice)this.getGraphicsConfiguration().getDevice()).getScreen();
        int newScreenNum = 0;
        GraphicsDevice[] gds = XToolkit.localEnv.getScreenDevices();
        for (int i = 0; i < gds.length; ++i) {
            int vertAmt;
            Rectangle screenBounds = gds[i].getDefaultConfiguration().getBounds();
            if (!newBounds.intersects(screenBounds)) continue;
            int horizAmt = Math.min(newBounds.x + newBounds.width, screenBounds.x + screenBounds.width) - Math.max(newBounds.x, screenBounds.x);
            int intAmt = horizAmt * (vertAmt = Math.min(newBounds.y + newBounds.height, screenBounds.y + screenBounds.height) - Math.max(newBounds.y, screenBounds.y));
            if (intAmt == area) {
                newScreenNum = i;
                break;
            }
            if (intAmt <= largestAmt) continue;
            largestAmt = intAmt;
            newScreenNum = i;
        }
        if (newScreenNum != curScreenNum) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("XWindowPeer: Moved to a new screen");
            }
            this.draggedToNewScreen(newScreenNum);
        }
    }

    public void draggedToNewScreen(int screenNum) {
        this.executeDisplayChangedOnEDT(screenNum);
    }

    private void executeDisplayChangedOnEDT(final int screenNum) {
        Runnable dc = new Runnable(){

            public void run() {
                XWindowPeer.this.displayChanged(screenNum);
            }
        };
        SunToolkit.executeOnEventHandlerThread(this.target, dc);
    }

    @Override
    public void displayChanged() {
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        int curScreenNum = ((X11GraphicsDevice)gc.getDevice()).getScreen();
        this.executeDisplayChangedOnEDT(curScreenNum);
    }

    @Override
    public void paletteChanged() {
    }

    @Override
    public void handleConfigureNotifyEvent(XEvent xev) {
        XConfigureEvent xe = xev.get_xconfigure();
        this.checkIfOnNewScreen(new Rectangle(xe.get_x(), xe.get_y(), xe.get_width(), xe.get_height()));
        super.handleConfigureNotifyEvent(xev);
        this.updateChildrenSizes();
    }

    final void requestXFocus(long time) {
        this.requestXFocus(time, true);
    }

    final void requestXFocus() {
        this.requestXFocus(0L, false);
    }

    protected void requestXFocus(long time, boolean timeProvided) {
        if (focusLog.isLoggable(Level.FINE)) {
            focusLog.fine("Requesting window focus");
        }
        this.requestWindowFocus(time, timeProvided);
    }

    public final boolean focusAllowedFor() {
        if (this.isNativelyNonFocusableWindow()) {
            return false;
        }
        return !this.isModalBlocked();
    }

    public void handleFocusEvent(XEvent xev) {
        XFocusChangeEvent xfe = xev.get_xfocus();
        if (focusLog.isLoggable(Level.FINER)) {
            focusLog.log(Level.FINER, "{0}", new Object[]{String.valueOf(xfe)});
        }
        if (this.isEventDisabled(xev)) {
            return;
        }
        if (xev.get_type() == 9) {
            if (this.focusAllowedFor() && (xfe.get_mode() == 0 || xfe.get_mode() == 3)) {
                this.handleWindowFocusIn(xfe.get_serial());
            }
        } else if (!(xfe.get_mode() != 0 && xfe.get_mode() != 3 || this.isNativelyNonFocusableWindow())) {
            XWindowPeer oppositeXWindow = XWindowPeer.getNativeFocusedWindowPeer();
            Object oppositeTarget = oppositeXWindow != null ? oppositeXWindow.getTarget() : null;
            Window oppositeWindow = null;
            if (oppositeTarget instanceof Window) {
                oppositeWindow = (Window)oppositeTarget;
            }
            if (oppositeXWindow != null && oppositeXWindow.isNativelyNonFocusableWindow()) {
                return;
            }
            if (this == oppositeXWindow) {
                oppositeWindow = null;
            } else if (oppositeXWindow instanceof XDecoratedPeer && ((XDecoratedPeer)oppositeXWindow).actualFocusedWindow != null && (oppositeTarget = (oppositeXWindow = ((XDecoratedPeer)oppositeXWindow).actualFocusedWindow).getTarget()) instanceof Window && oppositeXWindow.isVisible() && oppositeXWindow.isNativelyNonFocusableWindow()) {
                oppositeWindow = (Window)oppositeTarget;
            }
            this.handleWindowFocusOut(oppositeWindow, xfe.get_serial());
        }
    }

    void setSaveUnder(boolean state) {
    }

    @Override
    public void toFront() {
        if (this.isOverrideRedirect() && this.mustControlStackPosition) {
            this.mustControlStackPosition = false;
            this.removeRootPropertyEventDispatcher();
        }
        if (this.isVisible()) {
            super.toFront();
            if (this.isFocusableWindow() && this.isAutoRequestFocus() && !this.isModalBlocked() && !this.isWithdrawn()) {
                this.requestInitialFocus();
            }
        } else {
            this.setVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void toBack() {
        XToolkit.awtLock();
        try {
            if (!this.isOverrideRedirect()) {
                XlibWrapper.XLowerWindow(XToolkit.getDisplay(), this.getWindow());
            } else {
                this.lowerOverrideRedirect();
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lowerOverrideRedirect() {
        HashSet<Long> toplevels = new HashSet<Long>();
        long topl = 0L;
        long mytopl = 0L;
        for (XWindowPeer xp : windows) {
            topl = this.getToplevelWindow(xp.getWindow());
            if (xp.equals(this)) {
                mytopl = topl;
            }
            if (topl <= 0L) continue;
            toplevels.add(topl);
        }
        long wDesktop = -1L;
        long wBottom = -1L;
        int iMy = -1;
        int iDesktop = -1;
        int iBottom = -1;
        int i = 0;
        XQueryTree xqt = new XQueryTree(XToolkit.getDefaultRootWindow());
        try {
            if (xqt.execute() > 0) {
                int nchildren = xqt.get_nchildren();
                long children = xqt.get_children();
                for (i = 0; i < nchildren; ++i) {
                    long laux = Native.getWindow(children, i);
                    if (laux == mytopl) {
                        iMy = i;
                        continue;
                    }
                    if (this.isDesktopWindow(laux)) {
                        iDesktop = i;
                        wDesktop = laux;
                        continue;
                    }
                    if (iBottom >= 0 || !toplevels.contains(laux) || laux == mytopl) continue;
                    iBottom = i;
                    wBottom = laux;
                }
            }
            if ((iMy < iBottom || iBottom < 0) && iDesktop < iMy) {
                return;
            }
            long to_restack = Native.allocateLongArray(2);
            Native.putLong(to_restack, 0, wBottom);
            Native.putLong(to_restack, 1, mytopl);
            XlibWrapper.XRestackWindows(XToolkit.getDisplay(), to_restack, 2);
            XlibWrapper.unsafe.freeMemory(to_restack);
            if (!this.mustControlStackPosition) {
                this.mustControlStackPosition = true;
                this.addRootPropertyEventDispatcher();
            }
        }
        finally {
            xqt.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getToplevelWindow(long w) {
        long ret;
        long root;
        long wi = w;
        do {
            ret = wi;
            XQueryTree qt = new XQueryTree(wi);
            try {
                if (qt.execute() == 0) {
                    long l = 0L;
                    return l;
                }
                root = qt.get_root();
                wi = qt.get_parent();
            }
            finally {
                qt.dispose();
            }
        } while (wi != root);
        return ret;
    }

    private boolean isDesktopWindow(long wi) {
        return XWM.getWM().isDesktopWindow(wi);
    }

    private void updateAlwaysOnTop() {
        log.log(Level.FINE, "Promoting always-on-top state {0}", this.alwaysOnTop);
        XWM.getWM().setLayer(this, this.alwaysOnTop ? 1 : 0);
    }

    @Override
    public void setAlwaysOnTop(boolean alwaysOnTop) {
        this.alwaysOnTop = alwaysOnTop;
        this.updateAlwaysOnTop();
    }

    @Override
    boolean isLocationByPlatform() {
        return this.locationByPlatform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promoteDefaultPosition() {
        this.locationByPlatform = ((Window)this.target).isLocationByPlatform();
        if (this.locationByPlatform) {
            XToolkit.awtLock();
            try {
                Rectangle bounds = this.getBounds();
                XSizeHints hints = this.getHints();
                this.setSizeHints(hints.get_flags() & 0xFFFFFFFFFFFFFFFAL, bounds.x, bounds.y, bounds.width, bounds.height);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisible(boolean vis) {
        if (!this.isVisible() && vis) {
            this.isBeforeFirstMapNotify = true;
            this.winAttr.initialFocus = this.isAutoRequestFocus();
            if (!this.winAttr.initialFocus) {
                this.suppressWmTakeFocus(true);
            }
        }
        this.updateFocusability();
        this.promoteDefaultPosition();
        super.setVisible(vis);
        if (!vis && !this.isWithdrawn()) {
            XToolkit.awtLock();
            try {
                XUnmapEvent unmap = new XUnmapEvent();
                unmap.set_window(this.window);
                unmap.set_event(XToolkit.getDefaultRootWindow());
                unmap.set_type(18);
                unmap.set_from_configure(false);
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), XToolkit.getDefaultRootWindow(), false, 0x180000L, unmap.pData);
                unmap.dispose();
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        if (this.isOverrideRedirect() && vis) {
            this.updateChildrenSizes();
        }
    }

    protected void suppressWmTakeFocus(boolean doSuppress) {
    }

    final boolean isSimpleWindow() {
        return !(this.target instanceof Frame) && !(this.target instanceof Dialog);
    }

    boolean hasWarningWindow() {
        return ((Window)this.target).getWarningString() != null;
    }

    int getMenuBarHeight() {
        return 0;
    }

    int getWarningWindowHeight() {
        if (this.warningWindow != null) {
            return this.warningWindow.getHeight();
        }
        return 0;
    }

    void updateChildrenSizes() {
        if (this.warningWindow != null) {
            this.warningWindow.reshape(0, this.getMenuBarHeight(), this.getSize().width, this.warningWindow.getHeight());
        }
    }

    boolean isOverrideRedirect() {
        return XWM.getWMID() == 4 || XWM.getWMID() == 11 || this.target.getName().equals("###overrideRedirect###") || XTrayIconPeer.isTrayIconStuffWindow((Window)this.target);
    }

    final boolean isOLWMDecorBug() {
        return XWM.getWMID() == 4 && !this.winAttr.nativeDecor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        SunToolkit.awtLock();
        try {
            windows.remove(this);
        }
        finally {
            SunToolkit.awtUnlock();
        }
        if (this.warningWindow != null) {
            this.warningWindow.destroy();
        }
        this.removeRootPropertyEventDispatcher();
        this.mustControlStackPosition = false;
        super.dispose();
        if (this.isSimpleWindow() && this.target == XKeyboardFocusManagerPeer.getCurrentNativeFocusedWindow()) {
            Window owner = XWindowPeer.getDecoratedOwner((Window)this.target);
            ((XWindowPeer)ComponentAccessor.getPeer(owner)).requestWindowFocus();
        }
    }

    @Override
    boolean isResizable() {
        return this.winAttr.isResizable;
    }

    @Override
    public void handleVisibilityEvent(XEvent xev) {
        super.handleVisibilityEvent(xev);
        XVisibilityEvent ve = xev.get_xvisibility();
        this.winAttr.visibilityState = ve.get_state();
    }

    @Override
    public void handlePropertyNotify(XEvent xev) {
        super.handlePropertyNotify(xev);
        XPropertyEvent ev = xev.get_xproperty();
        if (ev.get_atom() == XWM.XA_WM_STATE.getAtom()) {
            this.stateChanged = true;
            this.stateChanged(ev.get_time(), this.savedState, this.getWMState());
        } else if (ev.get_atom() == XWM.XA_KDE_NET_WM_FRAME_STRUT.getAtom() || ev.get_atom() == XWM.XA_NET_FRAME_EXTENTS.getAtom()) {
            this.getWMSetInsets(XAtom.get(ev.get_atom()));
        }
    }

    void handleRootPropertyNotify(XEvent xev) {
        XPropertyEvent ev = xev.get_xproperty();
        if (this.mustControlStackPosition && ev.get_atom() == XAtom.get("_NET_CLIENT_LIST_STACKING").getAtom() && this.isOverrideRedirect()) {
            this.toBack();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMapNotifyEvent(XEvent xev) {
        this.isUnhiding |= this.isWMStateNetHidden();
        super.handleMapNotifyEvent(xev);
        if (!this.winAttr.initialFocus) {
            this.suppressWmTakeFocus(false);
            XToolkit.awtLock();
            try {
                XlibWrapper.XRaiseWindow(XToolkit.getDisplay(), this.getWindow());
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        if (this.shouldFocusOnMapNotify()) {
            focusLog.fine("Automatically request focus on window");
            this.requestInitialFocus();
        }
        this.isUnhiding = false;
        this.isBeforeFirstMapNotify = false;
        this.updateAlwaysOnTop();
        Object object = this.getStateLock();
        synchronized (object) {
            if (!this.isMapped) {
                this.isMapped = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleUnmapNotifyEvent(XEvent xev) {
        super.handleUnmapNotifyEvent(xev);
        this.isUnhiding |= this.isWMStateNetHidden();
        Object object = this.getStateLock();
        synchronized (object) {
            if (this.isMapped) {
                this.isMapped = false;
            }
        }
    }

    private boolean shouldFocusOnMapNotify() {
        boolean res = false;
        res = this.isBeforeFirstMapNotify ? this.winAttr.initialFocus || this.isFocusedWindowModalBlocker() : this.isUnhiding;
        res = res && this.isFocusableWindow() && !this.isModalBlocked();
        return res;
    }

    private boolean isWMStateNetHidden() {
        XNETProtocol protocol = XWM.getWM().getNETProtocol();
        return protocol != null && protocol.isWMStateNetHidden(this);
    }

    protected void requestInitialFocus() {
        this.requestXFocus();
    }

    public void addToplevelStateListener(ToplevelStateListener l) {
        this.toplevelStateListeners.add(l);
    }

    public void removeToplevelStateListener(ToplevelStateListener l) {
        this.toplevelStateListeners.remove(l);
    }

    protected void stateChanged(long time, int oldState, int newState) {
        this.updateTransientFor();
        for (ToplevelStateListener topLevelListenerTmp : this.toplevelStateListeners) {
            topLevelListenerTmp.stateChangedICCCM(oldState, newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getWMState() {
        if (this.stateChanged) {
            this.stateChanged = false;
            WindowPropertyGetter getter = new WindowPropertyGetter(this.window, XWM.XA_WM_STATE, 0L, 1L, false, XWM.XA_WM_STATE);
            try {
                int status = getter.execute();
                if (status != 0 || getter.getData() == 0L) {
                    this.savedState = 0;
                    int n = 0;
                    return n;
                }
                if (getter.getActualType() != XWM.XA_WM_STATE.getAtom() && getter.getActualFormat() != 32) {
                    this.savedState = 0;
                    int n = 0;
                    return n;
                }
                this.savedState = (int)Native.getCard32(getter.getData());
            }
            finally {
                getter.dispose();
            }
        }
        return this.savedState;
    }

    boolean isWithdrawn() {
        return this.getWMState() == 0;
    }

    boolean hasDecorations(int decor) {
        boolean hasBits;
        if (!this.winAttr.nativeDecor) {
            return false;
        }
        int myDecor = this.winAttr.decorations;
        boolean bl = hasBits = (myDecor & decor) == decor;
        if ((myDecor & XWindowAttributesData.AWT_DECOR_ALL) != 0) {
            return !hasBits;
        }
        return hasBits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setReparented(boolean newValue) {
        super.setReparented(newValue);
        XToolkit.awtLock();
        try {
            if (this.isReparented() && this.delayedModalBlocking) {
                this.addToTransientFors((XDialogPeer)ComponentAccessor.getPeer(this.modalBlocker));
                this.delayedModalBlocking = false;
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Vector<XWindowPeer> collectJavaToplevels() {
        Vector<XWindowPeer> javaToplevels = new Vector<XWindowPeer>();
        Vector<Long> v = new Vector<Long>();
        X11GraphicsEnvironment ge = (X11GraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gds = ge.getScreenDevices();
        if (!ge.runningXinerama() && gds.length > 1) {
            for (GraphicsDevice gd : gds) {
                int screen = ((X11GraphicsDevice)gd).getScreen();
                long rootWindow = XlibWrapper.RootWindow(XToolkit.getDisplay(), screen);
                v.add(rootWindow);
            }
        } else {
            v.add(XToolkit.getDefaultRootWindow());
        }
        int windowsCount = windows.size();
        while (v.size() > 0 && javaToplevels.size() < windowsCount) {
            long win = (Long)v.remove(0);
            XQueryTree qt = new XQueryTree(win);
            try {
                if (qt.execute() == 0) continue;
                int nchildren = qt.get_nchildren();
                long children = qt.get_children();
                for (int i = 0; i < nchildren; ++i) {
                    long child = Native.getWindow(children, i);
                    XBaseWindow childWindow = XToolkit.windowToXWindow(child);
                    if (childWindow != null && !(childWindow instanceof XWindowPeer)) continue;
                    v.add(child);
                    if (!(childWindow instanceof XWindowPeer)) continue;
                    XWindowPeer np = (XWindowPeer)childWindow;
                    javaToplevels.add(np);
                    int k = 0;
                    XWindowPeer toCheck = javaToplevels.get(k);
                    while (toCheck != np) {
                        XWindowPeer toCheckOwnerPeer = toCheck.getOwnerPeer();
                        if (toCheckOwnerPeer == np) {
                            javaToplevels.remove(k);
                            javaToplevels.add(toCheck);
                        } else {
                            ++k;
                        }
                        toCheck = javaToplevels.get(k);
                    }
                }
            }
            finally {
                qt.dispose();
            }
        }
        return javaToplevels;
    }

    @Override
    public void setModalBlocked(Dialog d, boolean blocked) {
        this.setModalBlocked(d, blocked, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModalBlocked(Dialog d, boolean blocked, Vector<XWindowPeer> javaToplevels) {
        XToolkit.awtLock();
        try {
            Object object = this.getStateLock();
            synchronized (object) {
                XDialogPeer blockerPeer = (XDialogPeer)ComponentAccessor.getPeer(d);
                if (blocked) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, "{0} is blocked by {1}", new Object[]{String.valueOf(this), String.valueOf(blockerPeer)});
                    }
                    this.modalBlocker = d;
                    if (this.isReparented() || XWM.isNonReparentingWM()) {
                        this.addToTransientFors(blockerPeer, javaToplevels);
                    } else {
                        this.delayedModalBlocking = true;
                    }
                } else {
                    if (d != this.modalBlocker) {
                        throw new IllegalStateException("Trying to unblock window blocked by another dialog");
                    }
                    this.modalBlocker = null;
                    if (this.isReparented() || XWM.isNonReparentingWM()) {
                        this.removeFromTransientFors();
                    } else {
                        this.delayedModalBlocking = false;
                    }
                }
                this.updateTransientFor();
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    static void setToplevelTransientFor(XWindowPeer window, XWindowPeer transientForWindow, boolean updateChain, boolean allStates) {
        if (window == null || transientForWindow == null) {
            return;
        }
        if (updateChain) {
            window.prevTransientFor = transientForWindow;
            transientForWindow.nextTransientFor = window;
        }
        if (window.curRealTransientFor == transientForWindow) {
            return;
        }
        if (!allStates && window.getWMState() != transientForWindow.getWMState()) {
            return;
        }
        if (window.getScreenNumber() != transientForWindow.getScreenNumber()) {
            return;
        }
        long bpw = window.getWindow();
        while (!XlibUtil.isToplevelWindow(bpw) && !XlibUtil.isXAWTToplevelWindow(bpw)) {
            bpw = XlibUtil.getParentWindow(bpw);
        }
        long tpw = transientForWindow.getWindow();
        while (!XlibUtil.isToplevelWindow(tpw) && !XlibUtil.isXAWTToplevelWindow(tpw)) {
            tpw = XlibUtil.getParentWindow(tpw);
        }
        XlibWrapper.XSetTransientFor(XToolkit.getDisplay(), bpw, tpw);
        window.curRealTransientFor = transientForWindow;
    }

    void updateTransientFor() {
        int state = this.getWMState();
        XWindowPeer p = this.prevTransientFor;
        while (p != null && (p.getWMState() != state || p.getScreenNumber() != this.getScreenNumber())) {
            p = p.prevTransientFor;
        }
        if (p != null) {
            XWindowPeer.setToplevelTransientFor(this, p, false, false);
        } else {
            XWindowPeer.restoreTransientFor(this);
        }
        XWindowPeer n = this.nextTransientFor;
        while (n != null && (n.getWMState() != state || n.getScreenNumber() != this.getScreenNumber())) {
            n = n.nextTransientFor;
        }
        if (n != null) {
            XWindowPeer.setToplevelTransientFor(n, this, false, false);
        }
    }

    private static void removeTransientForHint(XWindowPeer window) {
        XAtom XA_WM_TRANSIENT_FOR = XAtom.get(68L);
        long bpw = window.getWindow();
        while (!XlibUtil.isToplevelWindow(bpw) && !XlibUtil.isXAWTToplevelWindow(bpw)) {
            bpw = XlibUtil.getParentWindow(bpw);
        }
        XlibWrapper.XDeleteProperty(XToolkit.getDisplay(), bpw, XA_WM_TRANSIENT_FOR.getAtom());
        window.curRealTransientFor = null;
    }

    private void addToTransientFors(XDialogPeer blockerPeer) {
        this.addToTransientFors(blockerPeer, null);
    }

    private void addToTransientFors(XDialogPeer blockerPeer, Vector<XWindowPeer> javaToplevels) {
        XWindowPeer blockerChain = blockerPeer;
        while (blockerChain.prevTransientFor != null) {
            blockerChain = blockerChain.prevTransientFor;
        }
        XWindowPeer thisChain = this;
        while (thisChain.prevTransientFor != null) {
            thisChain = thisChain.prevTransientFor;
        }
        if (blockerChain == blockerPeer) {
            XWindowPeer.setToplevelTransientFor(blockerPeer, this, true, false);
        } else {
            if (javaToplevels == null) {
                javaToplevels = XWindowPeer.collectJavaToplevels();
            }
            XWindowPeer mergedChain = null;
            for (XWindowPeer w : javaToplevels) {
                XWindowPeer prevMergedChain = mergedChain;
                if (w == thisChain) {
                    if (thisChain == this) {
                        if (prevMergedChain != null) {
                            XWindowPeer.setToplevelTransientFor(this, prevMergedChain, true, false);
                        }
                        XWindowPeer.setToplevelTransientFor(blockerChain, this, true, false);
                        break;
                    }
                    mergedChain = thisChain;
                    thisChain = thisChain.nextTransientFor;
                } else {
                    if (w != blockerChain) continue;
                    mergedChain = blockerChain;
                    blockerChain = blockerChain.nextTransientFor;
                }
                if (prevMergedChain == null) {
                    mergedChain.prevTransientFor = null;
                } else {
                    XWindowPeer.setToplevelTransientFor(mergedChain, prevMergedChain, true, false);
                    mergedChain.updateTransientFor();
                }
                if (blockerChain != blockerPeer) continue;
                XWindowPeer.setToplevelTransientFor(thisChain, mergedChain, true, false);
                XWindowPeer.setToplevelTransientFor(blockerChain, this, true, false);
                break;
            }
        }
        XToolkit.XSync();
    }

    static void restoreTransientFor(XWindowPeer window) {
        XWindowPeer ownerPeer = window.getOwnerPeer();
        if (ownerPeer != null) {
            XWindowPeer.setToplevelTransientFor(window, ownerPeer, false, true);
        } else {
            XWindowPeer.removeTransientForHint(window);
        }
    }

    private void removeFromTransientFors() {
        XWindowPeer thisChain = this;
        XWindowPeer otherChain = this.nextTransientFor;
        HashSet<XWindowPeer> thisChainBlockers = new HashSet<XWindowPeer>();
        thisChainBlockers.add(this);
        XWindowPeer chainToSplit = this.prevTransientFor;
        while (chainToSplit != null) {
            XWindowPeer blocker = (XWindowPeer)ComponentAccessor.getPeer(chainToSplit.modalBlocker);
            if (thisChainBlockers.contains(blocker)) {
                XWindowPeer.setToplevelTransientFor(thisChain, chainToSplit, true, false);
                thisChain = chainToSplit;
                thisChainBlockers.add(chainToSplit);
            } else {
                XWindowPeer.setToplevelTransientFor(otherChain, chainToSplit, true, false);
                otherChain = chainToSplit;
            }
            chainToSplit = chainToSplit.prevTransientFor;
        }
        XWindowPeer.restoreTransientFor(thisChain);
        thisChain.prevTransientFor = null;
        XWindowPeer.restoreTransientFor(otherChain);
        otherChain.prevTransientFor = null;
        this.nextTransientFor = null;
        XToolkit.XSync();
    }

    boolean isModalBlocked() {
        return this.modalBlocker != null;
    }

    static Window getDecoratedOwner(Window window) {
        while (null != window && !(window instanceof Frame) && !(window instanceof Dialog)) {
            window = (Window)ComponentAccessor.getParent_NoClientCode(window);
        }
        return window;
    }

    @Override
    public boolean requestWindowFocus() {
        return this.requestWindowFocus(0L, false);
    }

    public boolean requestWindowFocus(long time, boolean timeProvided) {
        XDecoratedPeer wpeer;
        focusLog.fine("Request for window focus");
        Window win = (Window)this.target;
        Window owner = XWindowPeer.getDecoratedOwner(win);
        Window activeWindow = XWindowPeer.getDecoratedOwner(XKeyboardFocusManagerPeer.getCurrentNativeFocusedWindow());
        if (activeWindow == owner) {
            focusLog.fine("Parent window is active - generating focus for this window");
            this.handleWindowFocusInSync(-1L);
            return true;
        }
        focusLog.fine("Parent window is not active");
        ComponentPeer peer = ComponentAccessor.getPeer(owner);
        if (peer instanceof XDecoratedPeer && (wpeer = (XDecoratedPeer)peer).requestWindowFocus(this, time, timeProvided)) {
            focusLog.fine("Parent window accepted focus request - generating focus for this window");
            return true;
        }
        focusLog.fine("Denied - parent window is not active and didn't accept focus request");
        return false;
    }

    void setActualFocusedWindow(XWindowPeer actualFocusedWindow) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void xSetVisible(boolean visible) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Setting visible on " + this + " to " + visible);
        }
        XToolkit.awtLock();
        try {
            this.visible = visible;
            if (visible) {
                XlibWrapper.XMapRaised(XToolkit.getDisplay(), this.getWindow());
            } else {
                XlibWrapper.XUnmapWindow(XToolkit.getDisplay(), this.getWindow());
            }
            XlibWrapper.XFlush(XToolkit.getDisplay());
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public synchronized void addDropTarget() {
        long window;
        if (this.dropTargetCount == 0 && (window = this.getWindow()) != 0L) {
            XDropTargetRegistry.getRegistry().registerDropSite(window);
        }
        ++this.dropTargetCount;
    }

    public synchronized void removeDropTarget() {
        long window;
        --this.dropTargetCount;
        if (this.dropTargetCount == 0 && (window = this.getWindow()) != 0L) {
            XDropTargetRegistry.getRegistry().unregisterDropSite(window);
        }
    }

    void addRootPropertyEventDispatcher() {
        if (this.rootPropertyEventDispatcher == null) {
            this.rootPropertyEventDispatcher = new XEventDispatcher(){

                public void dispatchEvent(XEvent ev) {
                    if (ev.get_type() == 28) {
                        XWindowPeer.this.handleRootPropertyNotify(ev);
                    }
                }
            };
            XlibWrapper.XSelectInput(XToolkit.getDisplay(), XToolkit.getDefaultRootWindow(), 0x400000L);
            XToolkit.addEventDispatcher(XToolkit.getDefaultRootWindow(), this.rootPropertyEventDispatcher);
        }
    }

    void removeRootPropertyEventDispatcher() {
        if (this.rootPropertyEventDispatcher != null) {
            XToolkit.removeEventDispatcher(XToolkit.getDefaultRootWindow(), this.rootPropertyEventDispatcher);
            this.rootPropertyEventDispatcher = null;
        }
    }

    @Override
    public void updateFocusableWindowState() {
        this.cachedFocusableWindow = this.isFocusableWindow();
    }

    public XAtomList getNETWMState() {
        if (this.net_wm_state == null) {
            this.net_wm_state = this.XA_NET_WM_STATE.getAtomListPropertyList(this);
        }
        return this.net_wm_state;
    }

    public void setNETWMState(XAtomList state) {
        this.net_wm_state = state;
        if (state != null) {
            this.XA_NET_WM_STATE.setAtomListProperty((XBaseWindow)this, state);
        }
    }

    public PropMwmHints getMWMHints() {
        if (this.mwm_hints == null) {
            this.mwm_hints = new PropMwmHints();
            if (!XWM.XA_MWM_HINTS.getAtomData(this.getWindow(), this.mwm_hints.pData, 5)) {
                this.mwm_hints.zero();
            }
        }
        return this.mwm_hints;
    }

    public void setMWMHints(PropMwmHints hints) {
        this.mwm_hints = hints;
        if (hints != null) {
            XWM.XA_MWM_HINTS.setAtomData(this.getWindow(), this.mwm_hints.pData, 5);
        }
    }

    public Insets getWMSetInsets(XAtom changedAtom) {
        if (this.isEmbedded()) {
            return null;
        }
        if (this.wm_set_insets != null) {
            return this.wm_set_insets;
        }
        this.wm_set_insets = changedAtom == null ? XWM.getInsetsFromExtents(this.getWindow()) : XWM.getInsetsFromProp(this.getWindow(), changedAtom);
        if (insLog.isLoggable(Level.FINER)) {
            insLog.log(Level.FINER, "FRAME_EXTENTS: {0}", new Object[]{String.valueOf(this.wm_set_insets)});
        }
        if (this.wm_set_insets != null) {
            this.handleWMSetInsets(this.wm_set_insets);
        }
        return this.wm_set_insets;
    }

    protected void handleWMSetInsets(Insets newInsets) {
        this.wm_set_insets = (Insets)newInsets.clone();
    }

    public void resetWMSetInsets() {
        this.wm_set_insets = null;
    }

    protected synchronized void updateDropTarget() {
        long window;
        if (this.dropTargetCount > 0 && (window = this.getWindow()) != 0L) {
            XDropTargetRegistry.getRegistry().unregisterDropSite(window);
            XDropTargetRegistry.getRegistry().registerDropSite(window);
        }
    }

    public void setGrab(boolean grab) {
        this.grab = grab;
        if (grab) {
            this.pressTarget = this;
            this.grabInput();
        } else {
            XWindowPeer.ungrabInput();
        }
    }

    public boolean isGrabbed() {
        return this.grab && XAwtState.getGrabWindow() == this;
    }

    @Override
    public void handleXCrossingEvent(XEvent xev) {
        XCrossingEvent xce = xev.get_xcrossing();
        if (grabLog.isLoggable(Level.FINE)) {
            grabLog.log(Level.FINE, "{0}, when grabbed {1}, contains {2}", new Object[]{String.valueOf(xce), this.isGrabbed(), this.containsGlobal(xce.get_x_root(), xce.get_y_root())});
        }
        if (this.isGrabbed()) {
            XBaseWindow target = XToolkit.windowToXWindow(xce.get_window());
            if (grabLog.isLoggable(Level.FINER)) {
                grabLog.log(Level.FINER, "  -  Grab event target {0}", new Object[]{String.valueOf(target)});
            }
            if (target != null && target != this) {
                target.dispatchEvent(xev);
                return;
            }
        }
        super.handleXCrossingEvent(xev);
    }

    @Override
    public void handleMotionNotify(XEvent xev) {
        XMotionEvent xme = xev.get_xmotion();
        if (grabLog.isLoggable(Level.FINE)) {
            grabLog.log(Level.FINER, "{0}, when grabbed {1}, contains {2}", new Object[]{String.valueOf(xme), this.isGrabbed(), this.containsGlobal(xme.get_x_root(), xme.get_y_root())});
        }
        if (this.isGrabbed()) {
            boolean dragging = (xme.get_state() & 0x700) != 0;
            XBaseWindow target = XToolkit.windowToXWindow(xme.get_window());
            if (dragging && this.pressTarget != target) {
                target = this.pressTarget.isVisible() ? this.pressTarget : this;
                xme.set_window(target.getWindow());
                xme.set_x(xme.get_x_root() - target.getX());
                xme.set_y(xme.get_y_root() - target.getY());
            }
            if (grabLog.isLoggable(Level.FINER)) {
                grabLog.log(Level.FINER, "  -  Grab event target {0}", new Object[]{String.valueOf(target)});
            }
            if (target != null && target != this.getContentXWindow() && target != this) {
                target.dispatchEvent(xev);
                return;
            }
            if (!this.containsGlobal(xme.get_x_root(), xme.get_y_root()) && !dragging) {
                return;
            }
        }
        super.handleMotionNotify(xev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleButtonPressRelease(XEvent xev) {
        block41: {
            block43: {
                XBaseWindow target;
                XButtonEvent xbe;
                block38: {
                    block39: {
                        XWindowPeer toplevel2;
                        block42: {
                            block40: {
                                xbe = xev.get_xbutton();
                                if (grabLog.isLoggable(Level.FINE)) {
                                    grabLog.log(Level.FINE, "{0}, when grabbed {1}, contains {2} ({3}, {4}, {5}x{6})", new Object[]{String.valueOf(xbe), this.isGrabbed(), this.containsGlobal(xbe.get_x_root(), xbe.get_y_root()), this.getAbsoluteX(), this.getAbsoluteY(), this.getWidth(), this.getHeight()});
                                }
                                if (!this.isGrabbed()) break block41;
                                target = XToolkit.windowToXWindow(xbe.get_window());
                                try {
                                    if (grabLog.isLoggable(Level.FINER)) {
                                        grabLog.log(Level.FINER, "  -  Grab event target {0} (press target {1})", new Object[]{String.valueOf(target), String.valueOf(this.pressTarget)});
                                    }
                                    if (xbe.get_type() == 4 && xbe.get_button() == 1) {
                                        this.pressTarget = target;
                                    } else if (xbe.get_type() == 5 && xbe.get_button() == 1 && this.pressTarget != target) {
                                        target = this.pressTarget.isVisible() ? this.pressTarget : this;
                                        xbe.set_window(target.getWindow());
                                        xbe.set_x(xbe.get_x_root() - target.getX());
                                        xbe.set_y(xbe.get_y_root() - target.getY());
                                        this.pressTarget = this;
                                    }
                                    if (target == null || target == this.getContentXWindow() || target == this) break block38;
                                    target.dispatchEvent(xev);
                                    Object var5_4 = null;
                                    if (target == null) break block39;
                                    if (target == this) break block40;
                                }
                                catch (Throwable throwable) {
                                    Object var5_6 = null;
                                    if (target != null) {
                                        if (!(target != this && target != this.getContentXWindow() || this.containsGlobal(xbe.get_x_root(), xbe.get_y_root()))) {
                                            if (grabLog.isLoggable(Level.FINE)) {
                                                grabLog.log(Level.FINE, "Generating UngrabEvent on {0} because not inside of shell", String.valueOf(this));
                                            }
                                            this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                                            return;
                                        }
                                        XWindowPeer toplevel2 = target.getToplevelXWindow();
                                        if (toplevel2 != null) {
                                            Window w = (Window)toplevel2.target;
                                            while (w != null && toplevel2 != this && !(toplevel2 instanceof XDialogPeer)) {
                                                if ((w = (Window)ComponentAccessor.getParent_NoClientCode(w)) == null) continue;
                                                toplevel2 = (XWindowPeer)ComponentAccessor.getPeer(w);
                                            }
                                            if (w != null) {
                                                if (w == this.target) throw throwable;
                                                if (!(w instanceof Dialog)) throw throwable;
                                            }
                                            if (grabLog.isLoggable(Level.FINE)) {
                                                grabLog.log(Level.FINE, "Generating UngrabEvent on {0} because hierarchy ended", String.valueOf(this));
                                            }
                                            this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                                            throw throwable;
                                        }
                                        if (grabLog.isLoggable(Level.FINE)) {
                                            grabLog.log(Level.FINE, "Generating UngrabEvent on {0} because toplevel is null", String.valueOf(this));
                                        }
                                        this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                                        return;
                                    }
                                    if (grabLog.isLoggable(Level.FINE)) {
                                        grabLog.log(Level.FINE, "Generating UngrabEvent on because target is null {0}", String.valueOf(this));
                                    }
                                    this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                                    return;
                                }
                                if (target != this.getContentXWindow()) break block42;
                            }
                            if (!this.containsGlobal(xbe.get_x_root(), xbe.get_y_root())) {
                                if (grabLog.isLoggable(Level.FINE)) {
                                    grabLog.log(Level.FINE, "Generating UngrabEvent on {0} because not inside of shell", String.valueOf(this));
                                }
                                this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                                return;
                            }
                        }
                        if ((toplevel2 = target.getToplevelXWindow()) != null) {
                            Window w = (Window)toplevel2.target;
                            while (w != null && toplevel2 != this && !(toplevel2 instanceof XDialogPeer)) {
                                if ((w = (Window)ComponentAccessor.getParent_NoClientCode(w)) == null) continue;
                                toplevel2 = (XWindowPeer)ComponentAccessor.getPeer(w);
                            }
                            if (w != null) {
                                if (w == this.target) return;
                                if (!(w instanceof Dialog)) return;
                            }
                            if (grabLog.isLoggable(Level.FINE)) {
                                grabLog.log(Level.FINE, "Generating UngrabEvent on {0} because hierarchy ended", String.valueOf(this));
                            }
                            this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                            return;
                        }
                        if (grabLog.isLoggable(Level.FINE)) {
                            grabLog.log(Level.FINE, "Generating UngrabEvent on {0} because toplevel is null", String.valueOf(this));
                        }
                        this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                        return;
                    }
                    if (grabLog.isLoggable(Level.FINE)) {
                        grabLog.log(Level.FINE, "Generating UngrabEvent on because target is null {0}", String.valueOf(this));
                    }
                    this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                    return;
                }
                Object var5_5 = null;
                if (target == null) break block43;
                if (!(target != this && target != this.getContentXWindow() || this.containsGlobal(xbe.get_x_root(), xbe.get_y_root()))) {
                    if (grabLog.isLoggable(Level.FINE)) {
                        grabLog.log(Level.FINE, "Generating UngrabEvent on {0} because not inside of shell", String.valueOf(this));
                    }
                    this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                    return;
                }
                XWindowPeer toplevel2 = target.getToplevelXWindow();
                if (toplevel2 != null) {
                    Window w = (Window)toplevel2.target;
                    while (w != null && toplevel2 != this && !(toplevel2 instanceof XDialogPeer)) {
                        if ((w = (Window)ComponentAccessor.getParent_NoClientCode(w)) == null) continue;
                        toplevel2 = (XWindowPeer)ComponentAccessor.getPeer(w);
                    }
                    if (w == null || w != this.target && w instanceof Dialog) {
                        if (grabLog.isLoggable(Level.FINE)) {
                            grabLog.log(Level.FINE, "Generating UngrabEvent on {0} because hierarchy ended", String.valueOf(this));
                        }
                        this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                    }
                    break block41;
                } else {
                    if (grabLog.isLoggable(Level.FINE)) {
                        grabLog.log(Level.FINE, "Generating UngrabEvent on {0} because toplevel is null", String.valueOf(this));
                    }
                    this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
                    return;
                }
            }
            if (grabLog.isLoggable(Level.FINE)) {
                grabLog.log(Level.FINE, "Generating UngrabEvent on because target is null {0}", String.valueOf(this));
            }
            this.postEventToEventQueue(new UngrabEvent(this.getEventSource()));
            return;
        }
        super.handleButtonPressRelease(xev);
    }
}

