/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.awt.X11.MWMConstants;
import sun.awt.X11.Native;
import sun.awt.X11.PropMwmHints;
import sun.awt.X11.WindowDimensions;
import sun.awt.X11.WindowPropertyGetter;
import sun.awt.X11.XAtom;
import sun.awt.X11.XAtomList;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XDecoratedPeer;
import sun.awt.X11.XErrorEvent;
import sun.awt.X11.XIconInfo;
import sun.awt.X11.XLayerProtocol;
import sun.awt.X11.XNETProtocol;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XProtocol;
import sun.awt.X11.XSetWindowAttributes;
import sun.awt.X11.XSizeHints;
import sun.awt.X11.XStateProtocol;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XUtilConstants;
import sun.awt.X11.XWINProtocol;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibUtil;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XWM
implements MWMConstants,
XUtilConstants {
    private static final Logger log = Logger.getLogger("sun.awt.X11.XWM");
    private static final Logger insLog = Logger.getLogger("sun.awt.X11.insets.XWM");
    private static final Logger stateLog = Logger.getLogger("sun.awt.X11.states.XWM");
    static final XAtom XA_MWM_HINTS = new XAtom();
    private static Unsafe unsafe = XlibWrapper.unsafe;
    static XAtom XA_WM_STATE = new XAtom();
    XAtom XA_UTF8_STRING = XAtom.get("UTF8_STRING");
    static final int AWT_NET_N_KNOWN_STATES = 2;
    static final XAtom XA_E_FRAME_SIZE = new XAtom();
    static final XAtom XA_KDE_NET_WM_FRAME_STRUT = new XAtom();
    static final XAtom XA_KWM_WIN_ICONIFIED = new XAtom();
    static final XAtom XA_KWM_WIN_MAXIMIZED = new XAtom();
    static final XAtom XA_OL_DECOR_DEL = new XAtom();
    static final XAtom XA_OL_DECOR_HEADER = new XAtom();
    static final XAtom XA_OL_DECOR_RESIZE = new XAtom();
    static final XAtom XA_OL_DECOR_PIN = new XAtom();
    static final XAtom XA_OL_DECOR_CLOSE = new XAtom();
    static final XAtom XA_NET_FRAME_EXTENTS = new XAtom();
    static final XAtom XA_NET_REQUEST_FRAME_EXTENTS = new XAtom();
    static final int UNDETERMINED_WM = 1;
    static final int NO_WM = 2;
    static final int OTHER_WM = 3;
    static final int OPENLOOK_WM = 4;
    static final int MOTIF_WM = 5;
    static final int CDE_WM = 6;
    static final int ENLIGHTEN_WM = 7;
    static final int KDE2_WM = 8;
    static final int SAWFISH_WM = 9;
    static final int ICE_WM = 10;
    static final int METACITY_WM = 11;
    static final int COMPIZ_WM = 12;
    static final int LG3D_WM = 13;
    int WMID;
    static final Insets zeroInsets = new Insets(0, 0, 0, 0);
    static final Insets defaultInsets = new Insets(25, 5, 5, 5);
    static XNETProtocol g_net_protocol = null;
    static XWINProtocol g_win_protocol = null;
    static XAtom XA_ENLIGHTENMENT_COMMS = new XAtom("ENLIGHTENMENT_COMMS", false);
    static final XAtom XA_DT_SM_WINDOW_INFO = new XAtom("_DT_SM_WINDOW_INFO", false);
    static final XAtom XA_DT_SM_STATE_INFO = new XAtom("_DT_SM_STATE_INFO", false);
    static final XAtom XA_MOTIF_WM_INFO = new XAtom("_MOTIF_WM_INFO", false);
    static final XAtom XA_DT_WORKSPACE_CURRENT = new XAtom("_DT_WORKSPACE_CURRENT", false);
    static XToolkit.XErrorHandler VerifyChangePropertyHandler = new XToolkit.XErrorHandler(){

        public int handleError(long display, XErrorEvent err) {
            XToolkit.XERROR_SAVE(err);
            if (err.get_request_code() == 18) {
                return 0;
            }
            return XToolkit.SAVED_ERROR_HANDLER(display, err);
        }
    };
    static final XAtom XA_ICEWM_WINOPTHINT = new XAtom("_ICEWM_WINOPTHINT", false);
    static final char[] opt = new char[]{'A', 'W', 'T', '_', 'I', 'C', 'E', 'W', 'M', '_', 'T', 'E', 'S', 'T', '\u0000', 'a', 'l', 'l', 'W', 'o', 'r', 'k', 's', 'p', 'a', 'c', 'e', 's', '\u0000', '0', '\u0000'};
    static final XAtom XA_SUN_WM_PROTOCOLS = new XAtom("_SUN_WM_PROTOCOLS", false);
    static boolean winmgr_running = false;
    static XToolkit.XErrorHandler DetectWMHandler = new XToolkit.XErrorHandler(){

        public int handleError(long display, XErrorEvent err) {
            XToolkit.XERROR_SAVE(err);
            if (err.get_request_code() == 2 && err.get_error_code() == 10) {
                winmgr_running = true;
                return 0;
            }
            return XToolkit.SAVED_ERROR_HANDLER(display, err);
        }
    };
    static int awt_wmgr = 1;
    static XWM wm;
    HashMap<Class<?>, Collection<XProtocol>> protocolsMap = new HashMap();
    static boolean inited;
    HashMap storedInsets = new HashMap();
    static int awtWMStaticGravity;

    public String toString() {
        switch (this.WMID) {
            case 2: {
                return "NO WM";
            }
            case 3: {
                return "Other WM";
            }
            case 4: {
                return "OPENLOOK";
            }
            case 5: {
                return "MWM";
            }
            case 6: {
                return "DTWM";
            }
            case 7: {
                return "Enlightenment";
            }
            case 8: {
                return "KWM2";
            }
            case 9: {
                return "Sawfish";
            }
            case 10: {
                return "IceWM";
            }
            case 11: {
                return "Metacity";
            }
            case 12: {
                return "Compiz";
            }
            case 13: {
                return "LookingGlass";
            }
        }
        return "Undetermined WM";
    }

    XWM(int WMID) {
        this.WMID = WMID;
        this.initializeProtocols();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Window manager: " + this.toString());
        }
    }

    int getID() {
        return this.WMID;
    }

    static Insets normalize(Insets insets) {
        if (insets.top > 64 || insets.top < 0) {
            insets.top = 28;
        }
        if (insets.left > 32 || insets.left < 0) {
            insets.left = 6;
        }
        if (insets.right > 32 || insets.right < 0) {
            insets.right = 6;
        }
        if (insets.bottom > 32 || insets.bottom < 0) {
            insets.bottom = 6;
        }
        return insets;
    }

    static boolean isNetWMName(String name) {
        if (g_net_protocol != null) {
            return g_net_protocol.isWMName(name);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initAtoms() {
        Object[][] atomInitList = new Object[][]{{XA_WM_STATE, "WM_STATE"}, {XA_KDE_NET_WM_FRAME_STRUT, "_KDE_NET_WM_FRAME_STRUT"}, {XA_E_FRAME_SIZE, "_E_FRAME_SIZE"}, {XA_KWM_WIN_ICONIFIED, "KWM_WIN_ICONIFIED"}, {XA_KWM_WIN_MAXIMIZED, "KWM_WIN_MAXIMIZED"}, {XA_OL_DECOR_DEL, "_OL_DECOR_DEL"}, {XA_OL_DECOR_HEADER, "_OL_DECOR_HEADER"}, {XA_OL_DECOR_RESIZE, "_OL_DECOR_RESIZE"}, {XA_OL_DECOR_PIN, "_OL_DECOR_PIN"}, {XA_OL_DECOR_CLOSE, "_OL_DECOR_CLOSE"}, {XA_MWM_HINTS, "_MOTIF_WM_HINTS"}, {XA_NET_FRAME_EXTENTS, "_NET_FRAME_EXTENTS"}, {XA_NET_REQUEST_FRAME_EXTENTS, "_NET_REQUEST_FRAME_EXTENTS"}};
        String[] names = new String[atomInitList.length];
        for (int index = 0; index < names.length; ++index) {
            names[index] = (String)atomInitList[index][1];
        }
        int atomSize = XAtom.getAtomSize();
        long atoms = unsafe.allocateMemory(names.length * atomSize);
        XToolkit.awtLock();
        try {
            int status = XlibWrapper.XInternAtoms(XToolkit.getDisplay(), names, false, atoms);
            if (status == 0) {
                return;
            }
            int atom = 0;
            int atomPtr = 0;
            while (atom < names.length) {
                ((XAtom)atomInitList[atom][0]).setValues(XToolkit.getDisplay(), names[atom], XAtom.getAtom(atoms + (long)atomPtr));
                ++atom;
                atomPtr += atomSize;
            }
        }
        finally {
            XToolkit.awtUnlock();
            unsafe.freeMemory(atoms);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isNoWM() {
        String vendor_string = XlibWrapper.ServerVendor(XToolkit.getDisplay());
        if (vendor_string.indexOf("eXcursion") != -1) {
            if (insLog.isLoggable(Level.FINE)) {
                insLog.finer("eXcursion means NO_WM");
            }
            return true;
        }
        XSetWindowAttributes substruct = new XSetWindowAttributes();
        try {
            long default_screen_number = XlibWrapper.DefaultScreen(XToolkit.getDisplay());
            String selection_name = "WM_S" + default_screen_number;
            long selection_owner = XlibWrapper.XGetSelectionOwner(XToolkit.getDisplay(), XAtom.get(selection_name).getAtom());
            if (insLog.isLoggable(Level.FINE)) {
                insLog.finer("selection owner of " + selection_name + " is " + selection_owner);
            }
            if (selection_owner != 0L) {
                boolean bl = false;
                return bl;
            }
            winmgr_running = false;
            substruct.set_event_mask(0x100000L);
            XToolkit.WITH_XERROR_HANDLER(DetectWMHandler);
            XlibWrapper.XChangeWindowAttributes(XToolkit.getDisplay(), XToolkit.getDefaultRootWindow(), 2048L, substruct.pData);
            XToolkit.RESTORE_XERROR_HANDLER();
            if (!winmgr_running) {
                substruct.set_event_mask(0L);
                XlibWrapper.XChangeWindowAttributes(XToolkit.getDisplay(), XToolkit.getDefaultRootWindow(), 2048L, substruct.pData);
                if (insLog.isLoggable(Level.FINE)) {
                    insLog.finer("It looks like there is no WM thus NO_WM");
                }
            }
            boolean bl = !winmgr_running;
            return bl;
        }
        finally {
            substruct.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getECommsWindowIDProperty(long window) {
        if (!XA_ENLIGHTENMENT_COMMS.isInterned()) {
            return 0L;
        }
        WindowPropertyGetter getter = new WindowPropertyGetter(window, XA_ENLIGHTENMENT_COMMS, 0L, 14L, false, 31L);
        try {
            int status = getter.execute(XToolkit.IgnoreBadWindowHandler);
            if (status != 0 || getter.getData() == 0L) {
                long l = 0L;
                return l;
            }
            if (getter.getActualType() != 31L || getter.getActualFormat() != 8 || getter.getNumberOfItems() != 14 || getter.getBytesAfter() != 0L) {
                long l = 0L;
                return l;
            }
            byte[] bytes = XlibWrapper.getStringBytes(getter.getData());
            String id = new String(bytes);
            log.finer("ENLIGHTENMENT_COMMS is " + id);
            Pattern winIdPat = Pattern.compile("WINID\\s+(\\p{XDigit}{0,8})");
            try {
                Matcher match = winIdPat.matcher(id);
                if (match.matches()) {
                    log.finest("Match group count: " + match.groupCount());
                    String longId = match.group(1);
                    log.finest("Match group 1 " + longId);
                    long winid = Long.parseLong(longId, 16);
                    log.finer("Enlightenment communication window " + winid);
                    long l = winid;
                    return l;
                }
                log.finer("ENLIGHTENMENT_COMMS has wrong format");
                long l = 0L;
                return l;
            }
            catch (Exception e) {
                if (log.isLoggable(Level.FINER)) {
                    e.printStackTrace();
                }
                long l = 0L;
                return l;
            }
        }
        finally {
            getter.dispose();
        }
    }

    static boolean isEnlightenment() {
        long root_xref = XWM.getECommsWindowIDProperty(XToolkit.getDefaultRootWindow());
        if (root_xref == 0L) {
            return false;
        }
        long self_xref = XWM.getECommsWindowIDProperty(root_xref);
        return self_xref == root_xref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isCDE() {
        if (!XA_DT_SM_WINDOW_INFO.isInterned()) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "{0} is not interned", new Object[]{String.valueOf(XA_DT_SM_WINDOW_INFO)});
            }
            return false;
        }
        WindowPropertyGetter getter = new WindowPropertyGetter(XToolkit.getDefaultRootWindow(), XA_DT_SM_WINDOW_INFO, 0L, 2L, false, XA_DT_SM_WINDOW_INFO);
        try {
            WindowPropertyGetter getter2;
            block22: {
                block21: {
                    int status = getter.execute();
                    if (status != 0 || getter.getData() == 0L) {
                        log.finer("Getting of _DT_SM_WINDOW_INFO is not successfull");
                        boolean bl = false;
                        return bl;
                    }
                    if (getter.getActualType() != XA_DT_SM_WINDOW_INFO.getAtom() || getter.getActualFormat() != 32 || getter.getNumberOfItems() != 2 || getter.getBytesAfter() != 0L) {
                        log.finer("Wrong format of _DT_SM_WINDOW_INFO");
                        boolean bl = false;
                        return bl;
                    }
                    long wmwin = Native.getWindow(getter.getData(), 1);
                    if (wmwin == 0L) {
                        log.fine("WARNING: DT_SM_WINDOW_INFO exists but returns zero windows");
                        boolean bl = false;
                        return bl;
                    }
                    if (!XA_DT_SM_STATE_INFO.isInterned()) {
                        if (log.isLoggable(Level.FINER)) {
                            log.log(Level.FINER, "{0} is not interned", new Object[]{String.valueOf(XA_DT_SM_STATE_INFO)});
                        }
                        boolean bl = false;
                        return bl;
                    }
                    getter2 = new WindowPropertyGetter(wmwin, XA_DT_SM_STATE_INFO, 0L, 1L, false, XA_DT_SM_STATE_INFO);
                    try {
                        status = getter2.execute(XToolkit.IgnoreBadWindowHandler);
                        if (status == 0 && getter2.getData() != 0L) break block21;
                        log.finer("Getting of _DT_SM_STATE_INFO is not successfull");
                        boolean bl = false;
                        getter2.dispose();
                        return bl;
                    }
                    catch (Throwable throwable) {
                        getter2.dispose();
                        throw throwable;
                    }
                }
                if (getter2.getActualType() == XA_DT_SM_STATE_INFO.getAtom() && getter2.getActualFormat() == 32) break block22;
                log.finer("Wrong format of _DT_SM_STATE_INFO");
                boolean bl = false;
                getter2.dispose();
                return bl;
            }
            boolean bl = true;
            getter2.dispose();
            return bl;
        }
        finally {
            getter.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isMotif() {
        block17: {
            if (!XA_MOTIF_WM_INFO.isInterned()) {
                return false;
            }
            WindowPropertyGetter getter = new WindowPropertyGetter(XToolkit.getDefaultRootWindow(), XA_MOTIF_WM_INFO, 0L, 2L, false, XA_MOTIF_WM_INFO);
            try {
                int status = getter.execute();
                if (status != 0 || getter.getData() == 0L) {
                    boolean bl = false;
                    return bl;
                }
                if (getter.getActualType() != XA_MOTIF_WM_INFO.getAtom() || getter.getActualFormat() != 32 || getter.getNumberOfItems() != 2 || getter.getBytesAfter() != 0L) {
                    boolean bl = false;
                    return bl;
                }
                long wmwin = Native.getLong(getter.getData(), 1);
                if (wmwin == 0L) break block17;
                if (XA_DT_WORKSPACE_CURRENT.isInterned()) {
                    XAtom[] curws = XA_DT_WORKSPACE_CURRENT.getAtomListProperty(wmwin);
                    if (curws.length == 0) {
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = true;
                    return bl;
                }
                WindowPropertyGetter state_getter = new WindowPropertyGetter(wmwin, XA_WM_STATE, 0L, 1L, false, XA_WM_STATE);
                try {
                    if (state_getter.execute() == 0 && state_getter.getData() != 0L && state_getter.getActualType() == XA_WM_STATE.getAtom()) {
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    state_getter.dispose();
                }
            }
            finally {
                getter.dispose();
            }
        }
        return false;
    }

    static boolean isSawfish() {
        return XWM.isNetWMName("Sawfish");
    }

    static boolean isKDE2() {
        return XWM.isNetWMName("KWin");
    }

    static boolean isCompiz() {
        return XWM.isNetWMName("compiz");
    }

    static boolean isLookingGlass() {
        return XWM.isNetWMName("LG3D");
    }

    static boolean isMetacity() {
        return XWM.isNetWMName("Metacity");
    }

    static boolean isNonReparentingWM() {
        return XWM.getWMID() == 12 || XWM.getWMID() == 13;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean prepareIsIceWM() {
        if (!XA_ICEWM_WINOPTHINT.isInterned()) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "{0} is not interned", new Object[]{String.valueOf(XA_ICEWM_WINOPTHINT)});
            }
            return false;
        }
        XToolkit.awtLock();
        try {
            XToolkit.WITH_XERROR_HANDLER(VerifyChangePropertyHandler);
            XlibWrapper.XChangePropertyS(XToolkit.getDisplay(), XToolkit.getDefaultRootWindow(), XA_ICEWM_WINOPTHINT.getAtom(), XA_ICEWM_WINOPTHINT.getAtom(), 8, 0, new String(opt));
            XToolkit.RESTORE_XERROR_HANDLER();
            if (XToolkit.saved_error != null && XToolkit.saved_error.get_error_code() != 0) {
                log.finer("Erorr getting XA_ICEWM_WINOPTHINT property");
                boolean bl = false;
                return bl;
            }
            log.finer("Prepared for IceWM detection");
            boolean bl = true;
            return bl;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isIceWM() {
        if (!XA_ICEWM_WINOPTHINT.isInterned()) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, "{0} is not interned", new Object[]{String.valueOf(XA_ICEWM_WINOPTHINT)});
            }
            return false;
        }
        WindowPropertyGetter getter = new WindowPropertyGetter(XToolkit.getDefaultRootWindow(), XA_ICEWM_WINOPTHINT, 0L, 65535L, true, XA_ICEWM_WINOPTHINT);
        try {
            int status = getter.execute();
            boolean res = status == 0 && getter.getActualType() != 0L;
            log.finer("Status getting XA_ICEWM_WINOPTHINT: " + !res);
            boolean bl = !res || XWM.isNetWMName("IceWM");
            return bl;
        }
        finally {
            getter.dispose();
        }
    }

    static boolean isOpenLook() {
        if (!XA_SUN_WM_PROTOCOLS.isInterned()) {
            return false;
        }
        XAtom[] list = XA_SUN_WM_PROTOCOLS.getAtomListProperty(XToolkit.getDefaultRootWindow());
        return list.length != 0;
    }

    static XWM getWM() {
        if (wm == null) {
            awt_wmgr = XWM.getWMID();
            wm = new XWM(awt_wmgr);
        }
        return wm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getWMID() {
        if (insLog.isLoggable(Level.FINEST)) {
            insLog.finest("awt_wmgr = " + awt_wmgr);
        }
        if (awt_wmgr != 1) {
            return awt_wmgr;
        }
        XSetWindowAttributes substruct = new XSetWindowAttributes();
        XToolkit.awtLock();
        try {
            if (XWM.isNoWM()) {
                int n = awt_wmgr = 2;
                return n;
            }
            XNETProtocol l_net_protocol = g_net_protocol = new XNETProtocol();
            l_net_protocol.detect();
            if (log.isLoggable(Level.FINE) && l_net_protocol.active()) {
                log.fine("_NET_WM_NAME is " + l_net_protocol.getWMName());
            }
            XWINProtocol win = g_win_protocol = new XWINProtocol();
            win.detect();
            boolean doIsIceWM = XWM.prepareIsIceWM();
            awt_wmgr = XWM.isEnlightenment() ? 7 : (XWM.isMetacity() ? 11 : (XWM.isSawfish() ? 9 : (XWM.isKDE2() ? 8 : (XWM.isCompiz() ? 12 : (XWM.isLookingGlass() ? 13 : (doIsIceWM && XWM.isIceWM() ? 10 : (l_net_protocol.active() ? 3 : (win.active() ? 3 : (XWM.isCDE() ? 6 : (XWM.isMotif() ? 5 : (XWM.isOpenLook() ? 4 : 3)))))))))));
            int n = awt_wmgr;
            return n;
        }
        finally {
            XToolkit.awtUnlock();
            substruct.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeSizeHints(XDecoratedPeer window, long mask) {
        mask &= 0x30L;
        XToolkit.awtLock();
        try {
            XSizeHints hints = window.getHints();
            if ((hints.get_flags() & mask) == 0L) {
                return;
            }
            hints.set_flags(hints.get_flags() & (mask ^ 0xFFFFFFFFFFFFFFFFL));
            if (insLog.isLoggable(Level.FINER)) {
                insLog.finer("Setting hints, flags " + XlibWrapper.hintsToString(hints.get_flags()));
            }
            XlibWrapper.XSetWMNormalHints(XToolkit.getDisplay(), window.getWindow(), hints.pData);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    static int normalizeMotifDecor(int decorations) {
        if ((decorations & 1) == 0) {
            return decorations;
        }
        int d = 126;
        return d &= ~decorations;
    }

    static int normalizeMotifFunc(int functions) {
        if ((functions & 1) == 0) {
            return functions;
        }
        int f = 62;
        return f &= ~functions;
    }

    static void setOLDecor(XWindow window, boolean resizable, int decorations) {
        if (window == null) {
            return;
        }
        XAtomList decorDel = new XAtomList();
        decorations = XWM.normalizeMotifDecor(decorations);
        if (insLog.isLoggable(Level.FINER)) {
            insLog.finer("Setting OL_DECOR to " + Integer.toBinaryString(decorations));
        }
        if ((decorations & 8) == 0) {
            decorDel.add(XA_OL_DECOR_HEADER);
        }
        if ((decorations & 0x44) == 0) {
            decorDel.add(XA_OL_DECOR_RESIZE);
        }
        if ((decorations & 0x70) == 0) {
            decorDel.add(XA_OL_DECOR_CLOSE);
        }
        if (decorDel.size() == 0) {
            insLog.finer("Deleting OL_DECOR");
            XA_OL_DECOR_DEL.DeleteProperty(window);
        } else {
            if (insLog.isLoggable(Level.FINER)) {
                insLog.finer("Setting OL_DECOR to " + decorDel);
            }
            XA_OL_DECOR_DEL.setAtomListProperty((XBaseWindow)window, decorDel);
        }
    }

    static void setMotifDecor(XWindowPeer window, boolean resizable, int decorations, int functions) {
        if ((decorations & 1) != 0 && decorations != 1) {
            decorations = XWM.normalizeMotifDecor(decorations);
        }
        if ((functions & 1) != 0 && functions != 1) {
            functions = XWM.normalizeMotifFunc(functions);
        }
        PropMwmHints hints = window.getMWMHints();
        hints.set_flags(hints.get_flags() | 1L | 2L);
        hints.set_functions(functions);
        hints.set_decorations(decorations);
        if (stateLog.isLoggable(Level.FINER)) {
            stateLog.finer("Setting MWM_HINTS to " + hints);
        }
        window.setMWMHints(hints);
    }

    static boolean needRemap(XDecoratedPeer window) {
        return !window.isEmbedded();
    }

    static void setShellDecor(XDecoratedPeer window) {
        int decorations = window.getDecorations();
        int functions = window.getFunctions();
        boolean resizable = window.isResizable();
        if (!resizable) {
            decorations = (decorations & 1) != 0 ? (decorations |= 0x44) : (decorations &= 0xFFFFFFBB);
        }
        XWM.setMotifDecor(window, resizable, decorations, functions);
        XWM.setOLDecor(window, resizable, decorations);
        if (window.isShowing() && XWM.needRemap(window)) {
            window.xSetVisible(false);
            XToolkit.XSync();
            window.xSetVisible(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setShellResizable(XDecoratedPeer window) {
        if (insLog.isLoggable(Level.FINE)) {
            insLog.fine("Setting shell resizable " + window);
        }
        XToolkit.awtLock();
        try {
            Rectangle shellBounds = window.getShellBounds();
            shellBounds.translate(-window.currentInsets.left, -window.currentInsets.top);
            window.updateSizeHints(window.getDimensions());
            XWM.requestWMExtents(window.getWindow());
            XlibWrapper.XMoveResizeWindow(XToolkit.getDisplay(), window.getShell(), shellBounds.x, shellBounds.y, shellBounds.width, shellBounds.height);
            XWM.removeSizeHints(window, 32L);
            window.updateMinimumSize();
            XWM.setShellDecor(window);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setShellNotResizable(XDecoratedPeer window, WindowDimensions newDimensions, Rectangle shellBounds, boolean justChangeSize) {
        if (insLog.isLoggable(Level.FINE)) {
            insLog.fine("Setting non-resizable shell " + window + ", dimensions " + newDimensions + ", shellBounds " + shellBounds + ", just change size: " + justChangeSize);
        }
        XToolkit.awtLock();
        try {
            if (!shellBounds.isEmpty()) {
                window.updateSizeHints(newDimensions);
                XWM.requestWMExtents(window.getWindow());
                XToolkit.XSync();
                XlibWrapper.XMoveResizeWindow(XToolkit.getDisplay(), window.getShell(), shellBounds.x, shellBounds.y, shellBounds.width, shellBounds.height);
            }
            if (!justChangeSize) {
                XWM.setShellDecor(window);
            }
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    Collection<XProtocol> getProtocols(Class protocolInterface) {
        Collection<XProtocol> res = this.protocolsMap.get(protocolInterface);
        if (res != null) {
            return res;
        }
        return new LinkedList<XProtocol>();
    }

    void addProtocol(Class protocolInterface, XProtocol protocol) {
        Collection<XProtocol> protocols = this.getProtocols(protocolInterface);
        protocols.add(protocol);
        this.protocolsMap.put(protocolInterface, protocols);
    }

    boolean supportsDynamicLayout() {
        int wm = XWM.getWMID();
        switch (wm) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
            case 4: 
            case 5: 
            case 6: {
                return false;
            }
        }
        return false;
    }

    boolean supportsExtendedState(int state) {
        switch (state) {
            case 2: 
            case 4: {
                if (XWM.getWMID() == 11) {
                    return false;
                }
            }
            case 6: {
                for (XStateProtocol xStateProtocol : this.getProtocols(XStateProtocol.class)) {
                    if (!xStateProtocol.supportsState(state)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    int getExtendedState(XWindowPeer window) {
        Iterator<XProtocol> iter = this.getProtocols(XStateProtocol.class).iterator();
        int state = 0;
        while (iter.hasNext()) {
            XStateProtocol proto = (XStateProtocol)((Object)iter.next());
            state |= proto.getState(window);
        }
        if (state != 0) {
            return state;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    Integer isStateChange(XDecoratedPeer window, XPropertyEvent e) {
        int n;
        if (!window.isShowing()) {
            stateLog.finer("Window is not showing");
            return null;
        }
        int wm_state = window.getWMState();
        if (wm_state == 0) {
            stateLog.finer("WithdrawnState");
            return null;
        }
        stateLog.finer("Window WM_STATE is " + wm_state);
        boolean is_state_change = false;
        if (e.get_atom() == XA_WM_STATE.getAtom()) {
            is_state_change = true;
        }
        for (XStateProtocol xStateProtocol : this.getProtocols(XStateProtocol.class)) {
            is_state_change |= xStateProtocol.isStateChange(e);
        }
        boolean bl = false;
        if (is_state_change) {
            void var6_10;
            if (wm_state == 3) {
                boolean bl2 = true;
            } else {
                boolean bl3 = false;
            }
            n = var6_10 | this.getExtendedState(window);
        }
        if (is_state_change) {
            return n;
        }
        return null;
    }

    void setLayer(XWindowPeer window, int layer) {
        for (XLayerProtocol xLayerProtocol : this.getProtocols(XLayerProtocol.class)) {
            if (!xLayerProtocol.supportsLayer(layer)) continue;
            xLayerProtocol.setLayer(window, layer);
        }
        XToolkit.XSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setExtendedState(XWindowPeer window, int state) {
        for (XStateProtocol xStateProtocol : this.getProtocols(XStateProtocol.class)) {
            if (!xStateProtocol.supportsState(state)) continue;
            xStateProtocol.setState(window, state);
            break;
        }
        if (!window.isShowing()) {
            XToolkit.awtLock();
            try {
                XlibWrapper.XDeleteProperty(XToolkit.getDisplay(), window.getWindow(), XA_KWM_WIN_ICONIFIED.getAtom());
                XlibWrapper.XDeleteProperty(XToolkit.getDisplay(), window.getWindow(), XA_KWM_WIN_MAXIMIZED.getAtom());
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        XToolkit.XSync();
    }

    void unshadeKludge(XDecoratedPeer window) {
        assert (window.isShowing());
        for (XStateProtocol xStateProtocol : this.getProtocols(XStateProtocol.class)) {
            xStateProtocol.unshadeKludge(window);
        }
        XToolkit.XSync();
    }

    static void init() {
        if (inited) {
            return;
        }
        XWM.initAtoms();
        XWM.getWM();
        inited = true;
    }

    void initializeProtocols() {
        XWINProtocol win;
        XNETProtocol net_protocol = g_net_protocol;
        if (net_protocol != null) {
            if (!net_protocol.active()) {
                net_protocol = null;
            } else {
                if (net_protocol.doStateProtocol()) {
                    this.addProtocol(XStateProtocol.class, net_protocol);
                }
                if (net_protocol.doLayerProtocol()) {
                    this.addProtocol(XLayerProtocol.class, net_protocol);
                }
            }
        }
        if ((win = g_win_protocol) != null && win.active()) {
            if (win.doStateProtocol()) {
                this.addProtocol(XStateProtocol.class, win);
            }
            if (win.doLayerProtocol()) {
                this.addProtocol(XLayerProtocol.class, win);
            }
        }
    }

    Insets guessInsets(XDecoratedPeer window) {
        Insets res = (Insets)this.storedInsets.get(window.getClass());
        if (res == null) {
            switch (this.WMID) {
                case 7: {
                    res = new Insets(19, 4, 4, 4);
                    break;
                }
                case 6: {
                    res = new Insets(28, 6, 6, 6);
                    break;
                }
                case 2: 
                case 13: {
                    res = zeroInsets;
                    break;
                }
                default: {
                    res = defaultInsets;
                }
            }
        }
        if (insLog.isLoggable(Level.FINEST)) {
            insLog.finest("WM guessed insets: " + res);
        }
        return res;
    }

    static boolean configureGravityBuggy() {
        if (awtWMStaticGravity == -1) {
            int n = awtWMStaticGravity = XToolkit.getEnv("_JAVA_AWT_WM_STATIC_GRAVITY") != null ? 1 : 0;
        }
        if (awtWMStaticGravity == 1) {
            return true;
        }
        switch (XWM.getWMID()) {
            case 10: {
                if (g_net_protocol != null) {
                    String wm_name = g_net_protocol.getWMName();
                    Pattern pat = Pattern.compile("^IceWM (\\d+)\\.(\\d+)\\.(\\d+).*$");
                    try {
                        Matcher match = pat.matcher(wm_name);
                        if (match.matches()) {
                            int v1 = Integer.parseInt(match.group(1));
                            int v2 = Integer.parseInt(match.group(2));
                            int v3 = Integer.parseInt(match.group(3));
                            return v1 <= 1 && (v1 != 1 || v2 <= 2 && (v2 != 2 || v3 < 2));
                        }
                    }
                    catch (Exception e) {
                        return true;
                    }
                }
                return true;
            }
            case 7: {
                return true;
            }
        }
        return false;
    }

    public static Insets getInsetsFromExtents(long window) {
        if (window == 0L) {
            return null;
        }
        XNETProtocol net_protocol = XWM.getWM().getNETProtocol();
        if (net_protocol != null && net_protocol.active()) {
            Insets insets = XWM.getInsetsFromProp(window, XA_NET_FRAME_EXTENTS);
            if (insLog.isLoggable(Level.FINE)) {
                insLog.log(Level.FINE, "_NET_FRAME_EXTENTS: {0}", String.valueOf(insets));
            }
            if (insets != null) {
                return insets;
            }
        }
        switch (XWM.getWMID()) {
            case 8: {
                return XWM.getInsetsFromProp(window, XA_KDE_NET_WM_FRAME_STRUT);
            }
            case 7: {
                return XWM.getInsetsFromProp(window, XA_E_FRAME_SIZE);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Insets getInsetsFromProp(long window, XAtom atom) {
        if (window == 0L) {
            return null;
        }
        WindowPropertyGetter getter = new WindowPropertyGetter(window, atom, 0L, 4L, false, 6L);
        try {
            if (getter.execute() != 0 || getter.getData() == 0L || getter.getActualType() != 6L || getter.getActualFormat() != 32) {
                Insets insets = null;
                return insets;
            }
            Insets insets = new Insets((int)Native.getCard32(getter.getData(), 2), (int)Native.getCard32(getter.getData(), 0), (int)Native.getCard32(getter.getData(), 3), (int)Native.getCard32(getter.getData(), 1));
            return insets;
        }
        finally {
            getter.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void requestWMExtents(long window) {
        if (window == 0L) {
            return;
        }
        log.fine("Requesting FRAME_EXTENTS");
        XClientMessageEvent msg = new XClientMessageEvent();
        msg.zero();
        msg.set_type(33);
        msg.set_display(XToolkit.getDisplay());
        msg.set_window(window);
        msg.set_format(32);
        XToolkit.awtLock();
        try {
            XNETProtocol net_protocol = XWM.getWM().getNETProtocol();
            if (net_protocol != null && net_protocol.active()) {
                msg.set_message_type(XA_NET_REQUEST_FRAME_EXTENTS.getAtom());
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), XToolkit.getDefaultRootWindow(), false, 0x180000L, msg.getPData());
            }
            if (XWM.getWMID() == 8) {
                msg.set_message_type(XA_KDE_NET_WM_FRAME_STRUT.getAtom());
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), XToolkit.getDefaultRootWindow(), false, 0x180000L, msg.getPData());
            }
        }
        finally {
            XToolkit.awtUnlock();
            msg.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean syncTopLevelPos(long window, XWindowAttributes attrs) {
        int tries = 0;
        XToolkit.awtLock();
        try {
            do {
                XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), window, attrs.pData);
                if (attrs.get_x() != 0 || attrs.get_y() != 0) {
                    boolean bl = true;
                    return bl;
                }
                XToolkit.XSync();
            } while (++tries < 50);
        }
        finally {
            XToolkit.awtUnlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    Insets getInsets(XDecoratedPeer win, long window, long parent) {
        correctWM = XWM.getInsetsFromExtents(window);
        if (XWM.insLog.isLoggable(Level.FINER)) {
            XWM.insLog.log(Level.FINER, "Got insets from property: {0}", String.valueOf(correctWM));
        }
        if (correctWM == null) {
            correctWM = new Insets(0, 0, 0, 0);
            correctWM.top = -1;
            correctWM.left = -1;
            lwinAttr = new XWindowAttributes();
            pattr = new XWindowAttributes();
            try {
                switch (XWM.getWMID()) {
                    case 7: {
                        this.syncTopLevelPos(parent, lwinAttr);
                        correctWM.left = lwinAttr.get_x();
                        correctWM.top = lwinAttr.get_y();
                        XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), XlibUtil.getParentWindow(parent), pattr.pData);
                        correctWM.right = pattr.get_width() - (lwinAttr.get_width() + correctWM.left);
                        correctWM.bottom = pattr.get_height() - (lwinAttr.get_height() + correctWM.top);
                        ** break;
lbl22:
                        // 1 sources

                        break;
                    }
                    case 5: 
                    case 6: 
                    case 8: 
                    case 10: {
                        if (this.syncTopLevelPos(parent, lwinAttr)) {
                            correctWM.top = lwinAttr.get_y();
                            correctWM.right = correctWM.left = lwinAttr.get_x();
                            correctWM.bottom = correctWM.left;
                            ** break;
lbl29:
                            // 1 sources

                            break;
                        }
                        var9_7 = null;
                        return var9_7;
                    }
                    case 4: 
                    case 9: {
                        this.syncTopLevelPos(window, lwinAttr);
                        correctWM.top = lwinAttr.get_y();
                        correctWM.right = correctWM.left = lwinAttr.get_x();
                        correctWM.bottom = correctWM.left;
                        ** break;
lbl39:
                        // 1 sources

                        break;
                    }
                    default: {
                        if (XWM.insLog.isLoggable(Level.FINEST)) {
                            XWM.insLog.log(Level.FINEST, "Getting correct insets for OTHER_WM/default, parent: {0}", String.valueOf(parent));
                        }
                        this.syncTopLevelPos(parent, lwinAttr);
                        status = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), window, lwinAttr.pData);
                        status = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), parent, pattr.pData);
                        if (lwinAttr.get_root() == parent) {
                            XWM.insLog.finest("our parent is root so insets should be zero");
                            correctWM = new Insets(0, 0, 0, 0);
                            ** break;
lbl51:
                            // 1 sources

                        } else {
                            if (lwinAttr.get_x() == 0 && lwinAttr.get_y() == 0 && lwinAttr.get_width() + 2 * lwinAttr.get_border_width() == pattr.get_width() && lwinAttr.get_height() + 2 * lwinAttr.get_border_width() == pattr.get_height()) {
                                if (XWM.insLog.isLoggable(Level.FINEST)) {
                                    XWM.insLog.log(Level.FINEST, "Double reparenting detected, pattr({2})={0}, lwinAttr({3})={1}", new Object[]{String.valueOf(lwinAttr), String.valueOf(pattr), String.valueOf(parent), String.valueOf(window)});
                                }
                                lwinAttr.set_x(pattr.get_x());
                                lwinAttr.set_y(pattr.get_y());
                                lwinAttr.set_border_width(lwinAttr.get_border_width() + pattr.get_border_width());
                                grand_parent = XlibUtil.getParentWindow(parent);
                                if (grand_parent == lwinAttr.get_root()) {
                                    var12_10 = null;
                                    return var12_10;
                                }
                                parent = grand_parent;
                                XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), parent, pattr.pData);
                            }
                            if (XWM.insLog.isLoggable(Level.FINEST)) {
                                XWM.insLog.log(Level.FINEST, "Attrs before calculation: pattr({2})={0}, lwinAttr({3})={1}", new Object[]{String.valueOf(lwinAttr), String.valueOf(pattr), String.valueOf(parent), String.valueOf(window)});
                            }
                            correctWM = new Insets(lwinAttr.get_y() + lwinAttr.get_border_width(), lwinAttr.get_x() + lwinAttr.get_border_width(), pattr.get_height() - (lwinAttr.get_y() + lwinAttr.get_height() + 2 * lwinAttr.get_border_width()), pattr.get_width() - (lwinAttr.get_x() + lwinAttr.get_width() + 2 * lwinAttr.get_border_width()));
                            ** break;
                        }
lbl69:
                        // 1 sources

                        break;
                    }
                }
            }
            finally {
                lwinAttr.dispose();
                pattr.dispose();
            }
        }
        if (this.storedInsets.get(win.getClass()) == null) {
            this.storedInsets.put(win.getClass(), correctWM);
        }
        return correctWM;
    }

    boolean isDesktopWindow(long w) {
        if (g_net_protocol != null) {
            XAtomList wtype = XAtom.get("_NET_WM_WINDOW_TYPE").getAtomListPropertyList(w);
            return wtype.contains(XAtom.get("_NET_WM_WINDOW_TYPE_DESKTOP"));
        }
        return false;
    }

    public XNETProtocol getNETProtocol() {
        return g_net_protocol;
    }

    public boolean setNetWMIcon(XWindowPeer window, List<XIconInfo> icons) {
        if (g_net_protocol != null && g_net_protocol.active()) {
            g_net_protocol.setWMIcons(window, icons);
            return XWM.getWMID() != 10;
        }
        return false;
    }

    static {
        inited = false;
        awtWMStaticGravity = -1;
    }
}

