/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.UnsafeXDisposerRecord;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XlibWrapper;
import sun.java2d.Disposer;
import sun.misc.Unsafe;

public class XTranslateCoordinates {
    private static Unsafe unsafe = XlibWrapper.unsafe;
    private boolean __executed = false;
    long _scr_w;
    long _dest_w;
    int _src_x;
    int _src_y;
    long dest_x_ptr = unsafe.allocateMemory(Native.getIntSize());
    long dest_y_ptr = unsafe.allocateMemory(Native.getIntSize());
    long child_ptr = unsafe.allocateMemory(Native.getLongSize());
    UnsafeXDisposerRecord disposer;

    public XTranslateCoordinates(long scr_w, long dest_w, int src_x, int src_y) {
        this.set_scr_w(scr_w);
        this.set_dest_w(dest_w);
        this.set_src_x(src_x);
        this.set_src_y(src_y);
        this.disposer = new UnsafeXDisposerRecord("XTranslateCoordinates", this.dest_x_ptr, this.dest_y_ptr, this.child_ptr);
        Disposer.addRecord(this, this.disposer);
    }

    public int execute() {
        return this.execute(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(XToolkit.XErrorHandler errorHandler) {
        XToolkit.awtLock();
        try {
            if (this.isDisposed()) {
                throw new IllegalStateException("Disposed");
            }
            if (this.__executed) {
                throw new IllegalStateException("Already executed");
            }
            this.__executed = true;
            if (errorHandler != null) {
                XToolkit.WITH_XERROR_HANDLER(errorHandler);
            }
            int status = XlibWrapper.XTranslateCoordinates(XToolkit.getDisplay(), this.get_scr_w(), this.get_dest_w(), this.get_src_x(), this.get_src_y(), this.dest_x_ptr, this.dest_y_ptr, this.child_ptr);
            if (errorHandler != null) {
                XToolkit.RESTORE_XERROR_HANDLER();
            }
            int n = status;
            return n;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public boolean isExecuted() {
        return this.__executed;
    }

    public boolean isDisposed() {
        return this.disposer.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        XToolkit.awtLock();
        try {
            if (this.isDisposed()) {
                return;
            }
            this.disposer.dispose();
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public long get_scr_w() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.__executed) {
            throw new IllegalStateException("Not executed");
        }
        return this._scr_w;
    }

    public void set_scr_w(long data) {
        this._scr_w = data;
    }

    public long get_dest_w() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.__executed) {
            throw new IllegalStateException("Not executed");
        }
        return this._dest_w;
    }

    public void set_dest_w(long data) {
        this._dest_w = data;
    }

    public int get_src_x() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.__executed) {
            throw new IllegalStateException("Not executed");
        }
        return this._src_x;
    }

    public void set_src_x(int data) {
        this._src_x = data;
    }

    public int get_src_y() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.__executed) {
            throw new IllegalStateException("Not executed");
        }
        return this._src_y;
    }

    public void set_src_y(int data) {
        this._src_y = data;
    }

    public int get_dest_x() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.__executed) {
            throw new IllegalStateException("Not executed");
        }
        return Native.getInt(this.dest_x_ptr);
    }

    public void set_dest_x(int data) {
        Native.putInt(this.dest_x_ptr, data);
    }

    public int get_dest_y() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.__executed) {
            throw new IllegalStateException("Not executed");
        }
        return Native.getInt(this.dest_y_ptr);
    }

    public void set_dest_y(int data) {
        Native.putInt(this.dest_y_ptr, data);
    }

    public long get_child() {
        if (this.isDisposed()) {
            throw new IllegalStateException("Disposed");
        }
        if (!this.__executed) {
            throw new IllegalStateException("Not executed");
        }
        return Native.getLong(this.child_ptr);
    }

    public void set_child(long data) {
        Native.putLong(this.child_ptr, data);
    }
}

