/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.MotifDnDConstants;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XDropTargetProtocolListener;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XlibWrapper;

abstract class XDropTargetProtocol {
    private static final Logger logger = Logger.getLogger("sun.awt.X11.xembed.xdnd.XDropTargetProtocol");
    private final XDropTargetProtocolListener listener;
    public static final int EMBEDDER_ALREADY_REGISTERED = 0;
    public static final int UNKNOWN_MESSAGE = 0;
    public static final int ENTER_MESSAGE = 1;
    public static final int MOTION_MESSAGE = 2;
    public static final int LEAVE_MESSAGE = 3;
    public static final int DROP_MESSAGE = 4;
    private boolean motionPassedAlong = false;
    private final HashMap embedderRegistry = new HashMap();

    protected XDropTargetProtocol(XDropTargetProtocolListener listener) {
        if (listener == null) {
            throw new NullPointerException("Null XDropTargetProtocolListener");
        }
        this.listener = listener;
    }

    protected final XDropTargetProtocolListener getProtocolListener() {
        return this.listener;
    }

    public abstract String getProtocolName();

    public abstract void registerDropTarget(long var1);

    public abstract void unregisterDropTarget(long var1);

    public abstract void registerEmbedderDropSite(long var1);

    public abstract void unregisterEmbedderDropSite(long var1);

    public abstract void registerEmbeddedDropSite(long var1);

    public final void unregisterEmbeddedDropSite(long embedded) {
        this.removeEmbedderRegistryEntry(embedded);
    }

    public abstract boolean isProtocolSupported(long var1);

    public abstract int getMessageType(XClientMessageEvent var1);

    public final boolean processClientMessage(XClientMessageEvent xclient) {
        int type = this.getMessageType(xclient);
        boolean processed = this.processClientMessageImpl(xclient);
        this.postProcessClientMessage(xclient, processed, type);
        return processed;
    }

    protected abstract boolean processClientMessageImpl(XClientMessageEvent var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean forwardClientMessageToToplevel(long toplevel, XClientMessageEvent xclient) {
        EmbedderRegistryEntry entry = this.getEmbedderRegistryEntry(toplevel);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "        entry={0}", new Object[]{String.valueOf(entry)});
        }
        if (entry == null) {
            return false;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "        entry.isOverriden()={0}", new Object[]{entry.isOverriden()});
        }
        if (!entry.isOverriden()) {
            return false;
        }
        this.adjustEventForForwarding(xclient, entry);
        long proxy = entry.getProxy();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "        proxy={0} toplevel={1}", new Object[]{String.valueOf(proxy), String.valueOf(toplevel)});
        }
        if (proxy == 0L) {
            proxy = toplevel;
        }
        xclient.set_window(toplevel);
        XToolkit.awtLock();
        try {
            XlibWrapper.XSendEvent(XToolkit.getDisplay(), proxy, false, 0L, xclient.pData);
        }
        finally {
            XToolkit.awtUnlock();
        }
        return true;
    }

    protected abstract void sendEnterMessageToToplevel(long var1, XClientMessageEvent var3);

    protected abstract void sendLeaveMessageToToplevel(long var1, XClientMessageEvent var3);

    private void postProcessClientMessage(XClientMessageEvent xclient, boolean processed, int type) {
        long toplevel = xclient.get_window();
        if (this.getEmbedderRegistryEntry(toplevel) != null) {
            if (!processed) {
                this.forwardClientMessageToToplevel(toplevel, xclient);
            } else {
                boolean motifProtocol = xclient.get_message_type() == MotifDnDConstants.XA_MOTIF_DRAG_AND_DROP_MESSAGE.getAtom();
                switch (type) {
                    case 2: {
                        if (!this.isDragOverComponent()) {
                            if (!this.motionPassedAlong && !motifProtocol) {
                                this.sendEnterMessageToToplevel(toplevel, xclient);
                            }
                            this.forwardClientMessageToToplevel(toplevel, xclient);
                            this.motionPassedAlong = true;
                            break;
                        }
                        if (this.motionPassedAlong && !motifProtocol) {
                            this.sendLeaveMessageToToplevel(toplevel, xclient);
                        }
                        this.motionPassedAlong = false;
                        break;
                    }
                    case 4: {
                        if (!this.isDragOverComponent()) {
                            this.forwardClientMessageToToplevel(toplevel, xclient);
                        }
                        this.motionPassedAlong = false;
                        break;
                    }
                    case 1: 
                    case 3: {
                        if (motifProtocol) {
                            this.forwardClientMessageToToplevel(toplevel, xclient);
                        }
                        this.motionPassedAlong = false;
                    }
                }
            }
        }
    }

    public abstract boolean sendResponse(long var1, int var3, int var4);

    public abstract Object getData(long var1, long var3) throws IllegalArgumentException, IOException;

    public abstract boolean sendDropDone(long var1, boolean var3, int var4);

    public abstract long getSourceWindow();

    public abstract void cleanup();

    public abstract boolean isDragOverComponent();

    public void adjustEventForForwarding(XClientMessageEvent xclient, EmbedderRegistryEntry entry) {
    }

    public abstract boolean forwardEventToEmbedded(long var1, long var3, int var5);

    public abstract boolean isXEmbedSupported();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void putEmbedderRegistryEntry(long embedder, boolean overriden, int version, long proxy) {
        XDropTargetProtocol xDropTargetProtocol = this;
        synchronized (xDropTargetProtocol) {
            this.embedderRegistry.put(embedder, new EmbedderRegistryEntry(overriden, version, proxy));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final EmbedderRegistryEntry getEmbedderRegistryEntry(long embedder) {
        XDropTargetProtocol xDropTargetProtocol = this;
        synchronized (xDropTargetProtocol) {
            return (EmbedderRegistryEntry)this.embedderRegistry.get(embedder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeEmbedderRegistryEntry(long embedder) {
        XDropTargetProtocol xDropTargetProtocol = this;
        synchronized (xDropTargetProtocol) {
            this.embedderRegistry.remove(new Long(embedder));
        }
    }

    protected static final class EmbedderRegistryEntry {
        private final boolean overriden;
        private final int version;
        private final long proxy;

        EmbedderRegistryEntry(boolean overriden, int version, long proxy) {
            this.overriden = overriden;
            this.version = version;
            this.proxy = proxy;
        }

        public boolean isOverriden() {
            return this.overriden;
        }

        public int getVersion() {
            return this.version;
        }

        public long getProxy() {
            return this.proxy;
        }
    }
}

