/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTEvent;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.peer.ChoicePeer;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.ListHelper;
import sun.awt.X11.ToplevelStateListener;
import sun.awt.X11.XChoicePeerListener;
import sun.awt.X11.XComponentPeer;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XEvent;
import sun.awt.X11.XWindow;

public class XChoicePeer
extends XComponentPeer
implements ChoicePeer,
ToplevelStateListener {
    private static final Logger log = Logger.getLogger("sun.awt.X11.XChoicePeer");
    private static final int MAX_UNFURLED_ITEMS = 10;
    public static final int TEXT_SPACE = 1;
    public static final int BORDER_WIDTH = 1;
    public static final int ITEM_MARGIN = 1;
    public static final int SCROLLBAR_WIDTH = 15;
    private static final Insets focusInsets = new Insets(0, 0, 0, 0);
    static final int WIDGET_OFFSET = 18;
    static final int TEXT_XPAD = 8;
    static final int TEXT_YPAD = 6;
    static final Color focusColor = Color.black;
    private boolean unfurled = false;
    private boolean dragging = false;
    private boolean mouseInSB = false;
    private boolean firstPress = false;
    private boolean wasDragged = false;
    private ListHelper helper;
    private UnfurledChoice unfurledChoice;
    private boolean drawSelectedItem = true;
    private Component alignUnder;
    private int dragStartIdx = -1;
    private XChoicePeerListener choiceListener;

    XChoicePeer(Choice target) {
        super(target);
    }

    void preInit(XCreateWindowParams params) {
        super.preInit(params);
        Choice target = (Choice)this.target;
        int numItems = target.getItemCount();
        this.unfurledChoice = new UnfurledChoice(target);
        this.getToplevelXWindow().addToplevelStateListener(this);
        this.helper = new ListHelper(this.unfurledChoice, this.getGUIcolors(), numItems, false, true, false, target.getFont(), 10, 1, 1, 1, 15);
    }

    void postInit(XCreateWindowParams params) {
        super.postInit(params);
        Choice target = (Choice)this.target;
        int numItems = target.getItemCount();
        for (int i = 0; i < numItems; ++i) {
            this.helper.add(target.getItem(i));
        }
        if (!this.helper.isEmpty()) {
            this.helper.select(target.getSelectedIndex());
            this.helper.setFocusedIndex(target.getSelectedIndex());
        }
        this.helper.updateColors(this.getGUIcolors());
        this.updateMotifColors(this.getPeerBackground());
    }

    public boolean isFocusable() {
        return true;
    }

    public void setBounds(int x, int y, int width, int height, int op) {
        int oldX = this.x;
        int oldY = this.y;
        int oldWidth = this.width;
        int oldHeight = this.height;
        super.setBounds(x, y, width, height, op);
        if (this.unfurled && (oldX != this.x || oldY != this.y || oldWidth != this.width || oldHeight != this.height)) {
            this.hidePopdownMenu();
        }
    }

    public void focusGained(FocusEvent e) {
        super.focusGained(e);
        this.repaint();
    }

    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.helper.updateColors(this.getGUIcolors());
        if (!value && this.unfurled) {
            this.hidePopdownMenu();
        }
    }

    public void focusLost(FocusEvent e) {
        super.focusLost(e);
        this.repaint();
    }

    void ungrabInputImpl() {
        if (this.unfurled) {
            this.unfurled = false;
            this.dragging = false;
            this.mouseInSB = false;
            this.unfurledChoice.setVisible(false);
        }
        super.ungrabInputImpl();
    }

    void handleJavaKeyEvent(KeyEvent e) {
        if (e.getID() == 401) {
            this.keyPressed(e);
        }
    }

    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 40: 
            case 225: {
                if (this.helper.getItemCount() <= 1) break;
                this.helper.down();
                int newIdx = this.helper.getSelectedIndex();
                ((Choice)this.target).select(newIdx);
                this.postEvent(new ItemEvent((Choice)this.target, 701, ((Choice)this.target).getItem(newIdx), 1));
                this.repaint();
                break;
            }
            case 38: 
            case 224: {
                if (this.helper.getItemCount() <= 1) break;
                this.helper.up();
                int newIdx = this.helper.getSelectedIndex();
                ((Choice)this.target).select(newIdx);
                this.postEvent(new ItemEvent((Choice)this.target, 701, ((Choice)this.target).getItem(newIdx), 1));
                this.repaint();
                break;
            }
            case 34: {
                if (!this.unfurled || this.dragging) break;
                int oldIdx = this.helper.getSelectedIndex();
                this.helper.pageDown();
                int newIdx = this.helper.getSelectedIndex();
                if (oldIdx == newIdx) break;
                ((Choice)this.target).select(newIdx);
                this.postEvent(new ItemEvent((Choice)this.target, 701, ((Choice)this.target).getItem(newIdx), 1));
                this.repaint();
                break;
            }
            case 33: {
                if (!this.unfurled || this.dragging) break;
                int oldIdx = this.helper.getSelectedIndex();
                this.helper.pageUp();
                int newIdx = this.helper.getSelectedIndex();
                if (oldIdx == newIdx) break;
                ((Choice)this.target).select(newIdx);
                this.postEvent(new ItemEvent((Choice)this.target, 701, ((Choice)this.target).getItem(newIdx), 1));
                this.repaint();
                break;
            }
            case 10: 
            case 27: {
                if (!this.unfurled) break;
                if (this.dragging) {
                    if (e.getKeyCode() == 27) {
                        this.helper.select(this.dragStartIdx);
                    } else {
                        int newIdx = this.helper.getSelectedIndex();
                        ((Choice)this.target).select(newIdx);
                        this.postEvent(new ItemEvent((Choice)this.target, 701, ((Choice)this.target).getItem(newIdx), 1));
                    }
                }
                this.hidePopdownMenu();
                this.dragging = false;
                this.wasDragged = false;
                this.mouseInSB = false;
                if (this.choiceListener == null) break;
                this.choiceListener.unfurledChoiceClosing();
                break;
            }
            default: {
                if (!this.unfurled) break;
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    public boolean handlesWheelScrolling() {
        return true;
    }

    void handleJavaMouseWheelEvent(MouseWheelEvent e) {
        if (this.unfurled && this.helper.isVSBVisible() && ListHelper.doWheelScroll(this.helper.getVSB(), null, e)) {
            this.repaint();
        }
    }

    void handleJavaMouseEvent(MouseEvent e) {
        super.handleJavaMouseEvent(e);
        int i = e.getID();
        switch (i) {
            case 501: {
                this.mousePressed(e);
                break;
            }
            case 502: {
                this.mouseReleased(e);
                break;
            }
            case 506: {
                this.mouseDragged(e);
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.dragStartIdx = this.helper.getSelectedIndex();
            if (this.unfurled) {
                if (!this.isMouseEventInChoice(e) && !this.unfurledChoice.isMouseEventInside(e)) {
                    this.hidePopdownMenu();
                }
                this.unfurledChoice.trackMouse(e);
            } else {
                this.grabInput();
                this.unfurledChoice.toFront();
                this.firstPress = true;
                this.wasDragged = false;
                this.unfurled = true;
            }
        }
    }

    void hidePopdownMenu() {
        XChoicePeer.ungrabInput();
        this.unfurledChoice.setVisible(false);
        this.unfurled = false;
    }

    public void mouseReleased(MouseEvent e) {
        if (this.unfurled) {
            if (this.mouseInSB) {
                this.unfurledChoice.trackMouse(e);
            } else {
                int newIdx;
                boolean isMouseEventInside = this.unfurledChoice.isMouseEventInside(e);
                boolean isMouseInListArea = this.unfurledChoice.isMouseInListArea(e);
                if (!this.helper.isEmpty() && !isMouseInListArea && this.dragging) {
                    ((Choice)this.target).select(this.dragStartIdx);
                }
                if (!this.firstPress && isMouseInListArea) {
                    this.hidePopdownMenu();
                }
                if (!this.firstPress && !isMouseEventInside) {
                    this.hidePopdownMenu();
                }
                if (this.firstPress && this.dragging) {
                    this.hidePopdownMenu();
                }
                if (!this.firstPress && !isMouseInListArea && isMouseEventInside && this.dragging) {
                    this.hidePopdownMenu();
                }
                if (!this.helper.isEmpty() && this.unfurledChoice.isMouseInListArea(e) && (newIdx = this.helper.getSelectedIndex()) >= 0) {
                    if (newIdx != this.dragStartIdx) {
                        ((Choice)this.target).select(newIdx);
                    }
                    if (this.wasDragged && e.getButton() != 1) {
                        ((Choice)this.target).select(this.dragStartIdx);
                    }
                    if (e.getButton() == 1 && (!this.firstPress || this.wasDragged)) {
                        this.postEvent(new ItemEvent((Choice)this.target, 701, ((Choice)this.target).getItem(newIdx), 1));
                    }
                    if (this.choiceListener != null) {
                        this.choiceListener.unfurledChoiceClosing();
                    }
                }
                this.unfurledChoice.trackMouse(e);
            }
        }
        this.dragging = false;
        this.wasDragged = false;
        this.firstPress = false;
        this.dragStartIdx = -1;
    }

    public void mouseDragged(MouseEvent e) {
        if (e.getModifiers() == 16) {
            this.dragging = true;
            this.wasDragged = true;
            this.unfurledChoice.trackMouse(e);
        }
    }

    public Dimension getMinimumSize() {
        FontMetrics fm = this.getFontMetrics(this.target.getFont());
        Choice c = (Choice)this.target;
        int w = 0;
        int i = c.countItems();
        while (i-- > 0) {
            w = Math.max(fm.stringWidth(c.getItem(i)), w);
        }
        return new Dimension(w + 8 + 18, fm.getMaxAscent() + fm.getMaxDescent() + 6);
    }

    public void layout() {
    }

    public void paint(Graphics g) {
        this.flush();
        Dimension size = this.getPeerSize();
        g.setColor(this.getPeerBackground());
        g.fillRect(0, 0, this.width, this.height);
        this.drawMotif3DRect(g, 1, 1, this.width - 2, this.height - 2, false);
        this.drawMotif3DRect(g, this.width - 18, this.height / 2 - 3, 12, 6, false);
        if (!this.helper.isEmpty() && this.helper.getSelectedIndex() != -1) {
            g.setFont(this.getPeerFont());
            FontMetrics fm = g.getFontMetrics();
            String lbl = this.helper.getItem(this.helper.getSelectedIndex());
            if (lbl != null && this.drawSelectedItem) {
                g.setClip(1, 1, this.width - 18 - 2, this.height);
                if (this.isEnabled()) {
                    g.setColor(this.getPeerForeground());
                    g.drawString(lbl, 5, (this.height + fm.getMaxAscent() - fm.getMaxDescent()) / 2);
                } else {
                    g.setColor(this.getPeerBackground().brighter());
                    g.drawString(lbl, 5, (this.height + fm.getMaxAscent() - fm.getMaxDescent()) / 2);
                    g.setColor(this.getPeerBackground().darker());
                    g.drawString(lbl, 4, (this.height + fm.getMaxAscent() - fm.getMaxDescent()) / 2 - 1);
                }
                g.setClip(0, 0, this.width, this.height);
            }
        }
        if (this.hasFocus()) {
            this.paintFocus(g, XChoicePeer.focusInsets.left, XChoicePeer.focusInsets.top, size.width - (XChoicePeer.focusInsets.left + XChoicePeer.focusInsets.right) - 1, size.height - (XChoicePeer.focusInsets.top + XChoicePeer.focusInsets.bottom) - 1);
        }
        if (this.unfurled) {
            this.unfurledChoice.repaint();
        }
        this.flush();
    }

    protected void paintFocus(Graphics g, int x, int y, int w, int h) {
        g.setColor(focusColor);
        g.drawRect(x, y, w, h);
    }

    public void select(int index) {
        this.helper.select(index);
        this.helper.setFocusedIndex(index);
        this.repaint();
    }

    public void add(String item, int index) {
        this.helper.add(item, index);
        this.repaint();
    }

    public void remove(int index) {
        boolean selected = index == this.helper.getSelectedIndex();
        boolean visibled = index >= this.helper.firstDisplayedIndex() && index <= this.helper.lastDisplayedIndex();
        this.helper.remove(index);
        if (selected) {
            if (this.helper.isEmpty()) {
                this.helper.select(-1);
            } else {
                this.helper.select(0);
            }
        }
        if (!this.unfurled) {
            if (this.helper.isEmpty()) {
                this.repaint();
            }
            return;
        }
        if (visibled) {
            Rectangle r = this.unfurledChoice.placeOnScreen();
            this.unfurledChoice.reshape(r.x, r.y, r.width, r.height);
            return;
        }
        if (visibled || selected) {
            this.repaint();
        }
    }

    public void removeAll() {
        this.helper.removeAll();
        this.helper.select(-1);
        Rectangle r = this.unfurledChoice.placeOnScreen();
        this.unfurledChoice.reshape(r.x, r.y, r.width, r.height);
        this.repaint();
    }

    public void addItem(String item, int index) {
        this.add(item, index);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.helper.setFont(this.font);
    }

    public void setForeground(Color c) {
        super.setForeground(c);
        this.helper.updateColors(this.getGUIcolors());
    }

    public void setBackground(Color c) {
        super.setBackground(c);
        this.unfurledChoice.setBackground(c);
        this.helper.updateColors(this.getGUIcolors());
        this.updateMotifColors(c);
    }

    public void setDrawSelectedItem(boolean value) {
        this.drawSelectedItem = value;
    }

    public void setAlignUnder(Component comp) {
        this.alignUnder = comp;
    }

    public void addXChoicePeerListener(XChoicePeerListener l) {
        this.choiceListener = l;
    }

    public void removeXChoicePeerListener() {
        this.choiceListener = null;
    }

    public boolean isUnfurled() {
        return this.unfurled;
    }

    public void stateChangedICCCM(int oldState, int newState) {
        if (this.unfurled && oldState != newState) {
            this.hidePopdownMenu();
        }
    }

    public void stateChangedJava(int oldState, int newState) {
        if (this.unfurled && oldState != newState) {
            this.hidePopdownMenu();
        }
    }

    public void dispose() {
        if (this.unfurledChoice != null) {
            this.unfurledChoice.destroy();
        }
        super.dispose();
    }

    boolean prePostEvent(final AWTEvent e) {
        if (this.unfurled) {
            if (e instanceof MouseWheelEvent) {
                return super.prePostEvent(e);
            }
            if (e instanceof KeyEvent) {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        if (XChoicePeer.this.target.isFocusable() && XChoicePeer.this.getParentTopLevel().isFocusableWindow()) {
                            XChoicePeer.this.handleJavaKeyEvent((KeyEvent)e);
                        }
                    }
                });
                return true;
            }
            if (e instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)e;
                int eventId = e.getID();
                if (this.unfurledChoice.isMouseEventInside(me) || !this.firstPress && eventId == 506) {
                    return this.handleMouseEventByChoice(me);
                }
                if (eventId == 503) {
                    return this.handleMouseEventByChoice(me);
                }
                if (!(this.firstPress || this.isMouseEventInChoice(me) || this.unfurledChoice.isMouseEventInside(me) || eventId != 501 && eventId != 502 && eventId != 500)) {
                    return this.handleMouseEventByChoice(me);
                }
            }
        }
        return super.prePostEvent(e);
    }

    public boolean handleMouseEventByChoice(final MouseEvent me) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                XChoicePeer.this.handleJavaMouseEvent(me);
            }
        });
        return true;
    }

    private boolean isMouseEventInChoice(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        Rectangle choiceRect = this.getBounds();
        return x >= 0 && x <= choiceRect.width && y >= 0 && y <= choiceRect.height;
    }

    class UnfurledChoice
    extends XWindow {
        public UnfurledChoice(Component target) {
            super(target);
        }

        public void preInit(XCreateWindowParams params) {
            params.delete("parent window");
            super.preInit(params);
            params.remove("bounds");
            params.add((Object)"overrideRedirect", Boolean.TRUE);
        }

        Rectangle placeOnScreen() {
            int numItemsDisplayed;
            if (XChoicePeer.this.helper.isEmpty()) {
                numItemsDisplayed = 1;
            } else {
                int numItems = XChoicePeer.this.helper.getItemCount();
                numItemsDisplayed = Math.min(10, numItems);
            }
            Point global = XChoicePeer.this.toGlobal(0, 0);
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            if (XChoicePeer.this.alignUnder != null) {
                Rectangle choiceRec = XChoicePeer.this.getBounds();
                choiceRec.setLocation(0, 0);
                choiceRec = XChoicePeer.this.toGlobal(choiceRec);
                Rectangle alignUnderRec = new Rectangle(XChoicePeer.this.alignUnder.getLocationOnScreen(), XChoicePeer.this.alignUnder.getSize());
                Rectangle result = choiceRec.union(alignUnderRec);
                this.width = result.width;
                this.x = result.x;
                this.y = result.y + result.height;
                this.height = 2 + numItemsDisplayed * (XChoicePeer.this.helper.getItemHeight() + 2);
            } else {
                this.x = global.x;
                this.y = global.y + XChoicePeer.this.height;
                this.width = Math.max(XChoicePeer.this.width, XChoicePeer.this.helper.getMaxItemWidth() + 6 + (XChoicePeer.this.helper.isVSBVisible() ? 15 : 0));
                this.height = 2 + numItemsDisplayed * (XChoicePeer.this.helper.getItemHeight() + 2);
            }
            if (this.x < 0) {
                this.x = 0;
            } else if (this.x + this.width > screen.width) {
                this.x = screen.width - this.width;
            }
            if (this.y < 0) {
                this.y = 0;
            } else if (this.y + this.height > screen.height) {
                this.y = screen.height - this.height;
            }
            return new Rectangle(this.x, this.y, this.width, this.height);
        }

        public void toFront() {
            if (XChoicePeer.this.choiceListener != null) {
                XChoicePeer.this.choiceListener.unfurledChoiceOpening(XChoicePeer.this.helper);
            }
            Rectangle r = this.placeOnScreen();
            this.reshape(r.x, r.y, r.width, r.height);
            super.toFront();
            this.setVisible(true);
        }

        public void trackMouse(MouseEvent e) {
            Point local = this.toLocalCoords(e);
            switch (e.getID()) {
                case 501: {
                    if (XChoicePeer.this.helper.isInVertSB(this.getBounds(), local.x, local.y)) {
                        XChoicePeer.this.mouseInSB = true;
                        XChoicePeer.this.helper.handleVSBEvent(e, this.getBounds(), local.x, local.y);
                        break;
                    }
                    this.trackSelection(local.x, local.y);
                    break;
                }
                case 502: {
                    if (XChoicePeer.this.mouseInSB) {
                        XChoicePeer.this.mouseInSB = false;
                        XChoicePeer.this.helper.handleVSBEvent(e, this.getBounds(), local.x, local.y);
                        break;
                    }
                    XChoicePeer.this.helper.trackMouseReleasedScroll();
                    break;
                }
                case 506: {
                    if (XChoicePeer.this.mouseInSB) {
                        XChoicePeer.this.helper.handleVSBEvent(e, this.getBounds(), local.x, local.y);
                        break;
                    }
                    XChoicePeer.this.helper.trackMouseDraggedScroll(local.x, local.y, this.width, this.height);
                    this.trackSelection(local.x, local.y);
                }
            }
        }

        private void trackSelection(int transX, int transY) {
            if (!XChoicePeer.this.helper.isEmpty() && transX > 0 && transX < this.width && transY > 0 && transY < this.height) {
                int newIdx = XChoicePeer.this.helper.y2index(transY);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("transX=" + transX + ", transY=" + transY + ",width=" + this.width + ", height=" + this.height + ", newIdx=" + newIdx + " on " + this.target);
                }
                if (newIdx >= 0 && newIdx < XChoicePeer.this.helper.getItemCount() && newIdx != XChoicePeer.this.helper.getSelectedIndex()) {
                    XChoicePeer.this.helper.select(newIdx);
                    XChoicePeer.this.unfurledChoice.repaint();
                }
            }
        }

        public void paintBackground() {
            Graphics g = this.getGraphics();
            g.setColor(XChoicePeer.this.getPeerBackground());
            g.fillRect(0, 0, this.width, this.height);
        }

        public void repaint() {
            if (!this.isVisible()) {
                return;
            }
            if (XChoicePeer.this.helper.checkVsbVisibilityChangedAndReset()) {
                this.paintBackground();
            }
            super.repaint();
        }

        public void paint(Graphics g) {
            Choice choice = (Choice)this.target;
            Color[] colors = XChoicePeer.this.getGUIcolors();
            XChoicePeer.this.draw3DRect(g, XComponentPeer.getSystemColors(), 0, 0, this.width - 1, this.height - 1, true);
            XChoicePeer.this.draw3DRect(g, XComponentPeer.getSystemColors(), 1, 1, this.width - 3, this.height - 3, true);
            XChoicePeer.this.helper.paintAllItems(g, colors, this.getBounds());
        }

        public void setVisible(boolean vis) {
            this.xSetVisible(vis);
            if (!vis && XChoicePeer.this.alignUnder != null) {
                XChoicePeer.this.alignUnder.requestFocusInWindow();
            }
        }

        private Point toLocalCoords(MouseEvent e) {
            Point global = e.getLocationOnScreen();
            global.x -= this.x;
            global.y -= this.y;
            return global;
        }

        private boolean isMouseEventInside(MouseEvent e) {
            Point local = this.toLocalCoords(e);
            return local.x > 0 && local.x < this.width && local.y > 0 && local.y < this.height;
        }

        private boolean isMouseInListArea(MouseEvent e) {
            if (this.isMouseEventInside(e)) {
                Point local = this.toLocalCoords(e);
                Rectangle bounds = this.getBounds();
                if (!XChoicePeer.this.helper.isInVertSB(bounds, local.x, local.y)) {
                    return true;
                }
            }
            return false;
        }

        public void handleConfigureNotifyEvent(XEvent xev) {
        }

        public void handleMapNotifyEvent(XEvent xev) {
        }

        public void handleUnmapNotifyEvent(XEvent xev) {
        }
    }
}

