/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import sun.security.action.GetPropertyAction;

public class XAWTFormatter
extends Formatter {
    Date dat = new Date();
    private static final String format = "{0,date} {0,time}";
    private MessageFormat formatter;
    private Object[] args = new Object[1];
    private String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    boolean displayFullRecord = "true".equals(LogManager.getLogManager().getProperty("XAWTFormatter.displayFullRecord"));
    boolean useANSI = "true".equals(LogManager.getLogManager().getProperty("XAWTFormatter.useANSI"));
    boolean showDate = !"false".equals(LogManager.getLogManager().getProperty("XAWTFormatter.showDate"));
    boolean showLevel = !"false".equals(LogManager.getLogManager().getProperty("XAWTFormatter.showLevel"));
    boolean swapMethodClass = "true".equals(LogManager.getLogManager().getProperty("XAWTFormatter.swapMethodClass"));

    public synchronized String format(LogRecord record) {
        Level lev;
        StringBuffer sb = new StringBuffer();
        if (this.useANSI) {
            lev = record.getLevel();
            if (Level.FINEST.equals(lev)) {
                sb.append("\u001b[36m");
            } else if (Level.FINER.equals(lev)) {
                sb.append("\u001b[32m");
            } else if (Level.FINE.equals(lev)) {
                sb.append("\u001b[34m");
            }
        }
        if (this.displayFullRecord) {
            if (this.showDate) {
                this.dat.setTime(record.getMillis());
                this.args[0] = this.dat;
                StringBuffer text = new StringBuffer();
                if (this.formatter == null) {
                    this.formatter = new MessageFormat(format);
                }
                this.formatter.format(this.args, text, (FieldPosition)null);
                sb.append(text);
                sb.append(" ");
            } else {
                sb.append("    ");
            }
            if (this.swapMethodClass) {
                if (record.getSourceMethodName() != null) {
                    sb.append(" \u001b[35m");
                    sb.append(record.getSourceMethodName());
                    sb.append("\u001b[30m ");
                }
                if (record.getSourceClassName() != null) {
                    sb.append(record.getSourceClassName());
                } else {
                    sb.append(record.getLoggerName());
                }
            } else {
                if (record.getSourceClassName() != null) {
                    sb.append(record.getSourceClassName());
                } else {
                    sb.append(record.getLoggerName());
                }
                if (record.getSourceMethodName() != null) {
                    sb.append(" \u001b[35m");
                    sb.append(record.getSourceMethodName());
                    sb.append("\u001b[30m");
                }
            }
            sb.append(this.lineSeparator);
        }
        if (this.useANSI) {
            lev = record.getLevel();
            if (Level.FINEST.equals(lev)) {
                sb.append("\u001b[36m");
            } else if (Level.FINER.equals(lev)) {
                sb.append("\u001b[32m");
            } else if (Level.FINE.equals(lev)) {
                sb.append("\u001b[34m");
            }
        }
        if (this.showLevel) {
            sb.append(record.getLevel().getLocalizedName());
            sb.append(": ");
        }
        String message = this.formatMessage(record);
        sb.append(message);
        sb.append(this.lineSeparator);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw.toString());
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (this.useANSI) {
            sb.append("\u001b[30m");
        }
        return sb.toString();
    }
}

