/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.IllegalComponentStateException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.DisplayChangedListener;

public class SunDisplayChanger {
    private static final Logger log = Logger.getLogger("sun.awt.multiscreen.SunDisplayChanger");
    private Map listeners = Collections.synchronizedMap(new WeakHashMap(1));

    public void add(DisplayChangedListener theListener) {
        if (log.isLoggable(Level.FINE) && theListener == null) {
            log.log(Level.FINE, "Assertion (theListener != null) failed");
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Adding listener: " + theListener);
        }
        this.listeners.put(theListener, null);
    }

    public void remove(DisplayChangedListener theListener) {
        if (log.isLoggable(Level.FINE) && theListener == null) {
            log.log(Level.FINE, "Assertion (theListener != null) failed");
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Removing listener: " + theListener);
        }
        this.listeners.remove(theListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners() {
        HashMap listClone;
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "notifyListeners");
        }
        Map map = this.listeners;
        synchronized (map) {
            listClone = new HashMap(this.listeners);
        }
        Set cloneSet = listClone.keySet();
        for (DisplayChangedListener current : cloneSet) {
            try {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "displayChanged for listener: " + current);
                }
                current.displayChanged();
            }
            catch (IllegalComponentStateException e) {
                this.listeners.remove(current);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyPaletteChanged() {
        HashMap listClone;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("notifyPaletteChanged");
        }
        Map map = this.listeners;
        synchronized (map) {
            listClone = new HashMap(this.listeners);
        }
        Set cloneSet = listClone.keySet();
        for (DisplayChangedListener current : cloneSet) {
            try {
                if (log.isLoggable(Level.FINEST)) {
                    log.log(Level.FINEST, "paletteChanged for listener: " + current);
                }
                current.paletteChanged();
            }
            catch (IllegalComponentStateException e) {
                this.listeners.remove(current);
            }
        }
    }
}

