/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import sun.applet.AppletSecurityContextManager;
import sun.applet.JavaConsole;
import sun.applet.PluginAppletViewer;
import sun.applet.PluginCallRequest;
import sun.applet.PluginDebug;
import sun.applet.PluginException;
import sun.applet.PluginMessageConsumer;
import sun.applet.RequestQueue;

public class PluginStreamHandler {
    private BufferedReader pluginInputReader;
    private StreamTokenizer pluginInputTokenizer;
    private BufferedWriter pluginOutputWriter;
    private RequestQueue queue = new RequestQueue();
    private JavaConsole console = new JavaConsole();
    LinkedList<String> writeQueue = new LinkedList();
    PluginMessageConsumer consumer;
    Boolean shuttingDown = false;
    PluginAppletViewer pav;
    static Date d = new Date();
    static long startTime = d.getTime();
    static long totalWait = 0L;

    public PluginStreamHandler(InputStream inputstream, OutputStream outputstream) throws MalformedURLException, IOException {
        PluginDebug.debug("Current context CL=" + Thread.currentThread().getContextClassLoader());
        try {
            this.pav = (PluginAppletViewer)ClassLoader.getSystemClassLoader().loadClass("sun.applet.PluginAppletViewer").newInstance();
            PluginDebug.debug("Loaded: " + this.pav + " CL=" + this.pav.getClass().getClassLoader());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        PluginDebug.debug("Creating consumer...");
        this.consumer = new PluginMessageConsumer(this);
        this.pluginInputReader = new BufferedReader(new InputStreamReader(inputstream, Charset.forName("UTF-8")));
        this.pluginOutputWriter = new BufferedWriter(new OutputStreamWriter(outputstream, Charset.forName("UTF-8")));
    }

    public void startProcessing() {
        Thread listenerThread = new Thread(){

            public void run() {
                while (true) {
                    PluginDebug.debug("Waiting for data...");
                    long b4 = new Date().getTime();
                    String s = PluginStreamHandler.this.read();
                    long after = new Date().getTime();
                    totalWait += after - b4;
                    if (s != null) {
                        PluginStreamHandler.this.consumer.consume(s);
                        continue;
                    }
                    try {
                        PluginStreamHandler.this.pluginInputReader.close();
                        PluginStreamHandler.this.pluginOutputWriter.close();
                    }
                    catch (IOException exception) {
                        // empty catch block
                    }
                    AppletSecurityContextManager.dumpStore(0);
                    PluginDebug.debug("APPLETVIEWER: exiting appletviewer");
                    System.exit(0);
                }
            }
        };
        listenerThread.start();
    }

    public void postMessage(String s) {
        if (s == null || s.equals("shutdown")) {
            try {
                this.pluginInputReader.close();
                this.pluginOutputWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            AppletSecurityContextManager.dumpStore(0);
            PluginDebug.debug("APPLETVIEWER: exiting appletviewer");
            System.exit(0);
        }
        PluginDebug.debug("Plugin posted: " + s);
        PluginDebug.debug("Consuming " + s);
        this.consumer.consume(s);
        PluginDebug.debug("Added to queue");
    }

    public void handleMessage(String message) throws PluginException {
        int nextIndex = 0;
        int reference = -1;
        String src = null;
        String[] privileges = null;
        String rest = "";
        String[] msgComponents = message.split(" ");
        if (msgComponents.length < 2) {
            return;
        }
        if (msgComponents[0].startsWith("plugin")) {
            this.handlePluginMessage(message);
            return;
        }
        String type = msgComponents[0];
        int identifier = Integer.parseInt(msgComponents[1]);
        nextIndex = 2;
        if (msgComponents[nextIndex].equals("reference")) {
            reference = Integer.parseInt(msgComponents[nextIndex + 1]);
            nextIndex += 2;
        }
        if (msgComponents[nextIndex].equals("src")) {
            src = msgComponents[nextIndex + 1];
            nextIndex += 2;
        }
        if (msgComponents[nextIndex].equals("privileges")) {
            String privs = msgComponents[nextIndex + 1];
            privileges = privs.split(",");
            nextIndex += 2;
        }
        for (int i = nextIndex; i < msgComponents.length; ++i) {
            rest = rest + msgComponents[i];
            rest = rest + " ";
        }
        rest = rest.trim();
        try {
            PluginDebug.debug("Breakdown -- type: " + type + " identifier: " + identifier + " reference: " + reference + " src: " + src + " privileges: " + privileges + " rest: \"" + rest + "\"");
            if (rest.contains("JavaScriptGetWindow") || rest.contains("JavaScriptGetMember") || rest.contains("JavaScriptSetMember") || rest.contains("JavaScriptGetSlot") || rest.contains("JavaScriptSetSlot") || rest.contains("JavaScriptEval") || rest.contains("JavaScriptRemoveMember") || rest.contains("JavaScriptCall") || rest.contains("JavaScriptFinalize") || rest.contains("JavaScriptToString")) {
                this.finishCallRequest(rest);
                return;
            }
            int freference = reference;
            String frest = rest;
            if (type.equals("instance")) {
                PluginAppletViewer.handleMessage(identifier, freference, frest);
            } else if (type.equals("context")) {
                PluginDebug.debug("Sending to PASC: " + identifier + "/" + reference + " and " + rest);
                AppletSecurityContextManager.handleMessage(identifier, reference, src, privileges, rest);
            }
        }
        catch (Exception e) {
            throw new PluginException(this, identifier, reference, e);
        }
    }

    private void handlePluginMessage(String message) {
        if (message.equals("plugin showconsole")) {
            this.showConsole();
        } else if (message.equals("plugin hideconsole")) {
            this.hideConsole();
        } else {
            this.finishCallRequest(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCallRequest(PluginCallRequest request) {
        RequestQueue requestQueue = this.queue;
        synchronized (requestQueue) {
            this.queue.post(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishCallRequest(String message) {
        PluginDebug.debug("DISPATCHCALLREQUESTS 1");
        RequestQueue requestQueue = this.queue;
        synchronized (requestQueue) {
            PluginDebug.debug("DISPATCHCALLREQUESTS 2");
            PluginCallRequest request = this.queue.pop();
            if (this.queue.size() != 0) {
                int size = this.queue.size();
                int count = 0;
                while (!request.serviceable(message)) {
                    PluginDebug.debug(request + " cannot service " + message);
                    if (count >= size) {
                        throw new RuntimeException("Unable to find processor for message " + message);
                    }
                    this.queue.post(request);
                    request = this.queue.pop();
                    ++count;
                }
            }
            PluginDebug.debug("DISPATCHCALLREQUESTS 3");
            if (request != null) {
                PluginDebug.debug("DISPATCHCALLREQUESTS 5");
                PluginCallRequest pluginCallRequest = request;
                synchronized (pluginCallRequest) {
                    request.parseReturn(message);
                    request.notifyAll();
                }
                PluginDebug.debug("DISPATCHCALLREQUESTS 6");
                PluginDebug.debug("DISPATCHCALLREQUESTS 7");
            }
        }
        PluginDebug.debug("DISPATCHCALLREQUESTS 8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String read() {
        String message;
        block7: {
            message = null;
            try {
                message = this.pluginInputReader.readLine();
                PluginDebug.debug("  PIPE: appletviewer read: " + message);
                if (message != null && !message.equals("shutdown")) break block7;
                Boolean bl = this.shuttingDown;
                synchronized (bl) {
                    this.shuttingDown = true;
                }
                try {
                    this.pluginInputReader.close();
                    this.pluginOutputWriter.close();
                }
                catch (IOException exception) {
                    // empty catch block
                }
                AppletSecurityContextManager.dumpStore(0);
                PluginDebug.debug("APPLETVIEWER: exiting appletviewer");
                System.exit(0);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String message) {
        PluginDebug.debug("  PIPE: appletviewer wrote: " + message);
        BufferedWriter bufferedWriter = this.pluginOutputWriter;
        synchronized (bufferedWriter) {
            try {
                this.pluginOutputWriter.write(message + "\n", 0, message.length());
                this.pluginOutputWriter.write(0);
                this.pluginOutputWriter.flush();
            }
            catch (IOException e) {
                Boolean bl = this.shuttingDown;
                synchronized (bl) {
                    if (!this.shuttingDown.booleanValue()) {
                        e.printStackTrace();
                    }
                }
                PluginDebug.debug("Unable to write to PIPE. APPLETVIEWER exiting");
                System.exit(1);
            }
        }
    }

    public boolean messageAvailable() {
        return this.writeQueue.size() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessage() {
        LinkedList<String> linkedList = this.writeQueue;
        synchronized (linkedList) {
            String ret = this.writeQueue.size() > 0 ? this.writeQueue.poll() : "";
            return ret;
        }
    }

    private void showConsole() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PluginStreamHandler.this.console.showConsole();
            }
        });
    }

    private void hideConsole() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PluginStreamHandler.this.console.hideConsole();
            }
        });
    }
}

