/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import sun.applet.PluginDebug;
import sun.applet.PluginException;
import sun.applet.PluginStreamHandler;

class PluginMessageHandlerWorker
extends Thread {
    private boolean free = true;
    private int id;
    private String message = null;
    private SecurityManager sm;
    PluginStreamHandler streamHandler = null;

    public PluginMessageHandlerWorker(PluginStreamHandler streamHandler, int id, SecurityManager sm) {
        this.id = id;
        this.streamHandler = streamHandler;
        this.sm = sm;
    }

    public void setmessage(String message) {
        this.message = message;
    }

    public void run() {
        while (true) {
            if (this.message != null) {
                PluginDebug.debug("Consumer thread " + this.id + " consuming " + this.message);
                this.busy();
                try {
                    this.streamHandler.handleMessage(this.message);
                }
                catch (PluginException pe) {
                    // empty catch block
                }
                this.message = null;
                PluginDebug.debug("Consumption completed by consumer thread " + this.id);
                this.free();
                continue;
            }
            try {
                Thread.sleep(Integer.MAX_VALUE);
                PluginDebug.debug("Consumer thread " + this.id + " sleeping...");
                continue;
            }
            catch (InterruptedException ie) {
                PluginDebug.debug("Consumer thread " + this.id + " woken...");
                continue;
            }
            break;
        }
    }

    public int getWorkerId() {
        return this.id;
    }

    public void busy() {
        this.free = false;
    }

    public void free() {
        this.free = true;
    }

    public boolean isFree() {
        return this.free;
    }
}

