/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.util.ArrayList;
import java.util.LinkedList;
import sun.applet.AppletSecurity;
import sun.applet.PluginDebug;
import sun.applet.PluginMessageHandlerWorker;
import sun.applet.PluginStreamHandler;

class PluginMessageConsumer {
    int MAX_WORKERS = 20;
    LinkedList<String> readQueue = new LinkedList();
    ArrayList<PluginMessageHandlerWorker> workers = new ArrayList();
    PluginStreamHandler streamHandler = null;
    AppletSecurity as = new AppletSecurity();

    public PluginMessageConsumer(PluginStreamHandler streamHandler) {
        this.streamHandler = streamHandler;
        for (int i = 0; i < 3; ++i) {
            PluginDebug.debug("Creating worker " + i);
            PluginMessageHandlerWorker worker = new PluginMessageHandlerWorker(streamHandler, i, this.as);
            worker.start();
            this.workers.add(worker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(String message) {
        PluginDebug.debug("Consumer received message " + message);
        LinkedList<String> linkedList = this.readQueue;
        synchronized (linkedList) {
            this.readQueue.add(message);
        }
        PluginDebug.debug("Message " + message + " added to queue. Looking for free worker...");
        PluginMessageHandlerWorker worker = this.getFreeWorker();
        LinkedList<String> linkedList2 = this.readQueue;
        synchronized (linkedList2) {
            if (this.readQueue.size() > 0) {
                worker.setmessage(this.readQueue.poll());
            }
        }
        worker.interrupt();
    }

    private PluginMessageHandlerWorker getFreeWorker() {
        while (true) {
            for (PluginMessageHandlerWorker worker : this.workers) {
                if (!worker.isFree()) continue;
                PluginDebug.debug("Found free worker with id " + worker.getWorkerId());
                worker.busy();
                return worker;
            }
            if (this.workers.size() <= this.MAX_WORKERS) {
                PluginDebug.debug("Cannot find free worker, creating worker " + this.workers.size());
                PluginMessageHandlerWorker worker = new PluginMessageHandlerWorker(this.streamHandler, this.workers.size(), this.as);
                worker.start();
                this.workers.add(worker);
                worker.busy();
                return worker;
            }
            Thread.yield();
        }
    }
}

