/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.util.Enumeration;
import java.util.Properties;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import net.sourceforge.jnlp.security.VariableX509TrustManager;
import sun.applet.AppletSecurityContextManager;
import sun.applet.PasswordAuthenticationDialog;
import sun.applet.PluginAppletSecurityContext;
import sun.applet.PluginAppletViewer;
import sun.applet.PluginCallRequestFactory;
import sun.applet.PluginCookieManager;
import sun.applet.PluginDebug;
import sun.applet.PluginProxySelector;
import sun.applet.PluginStreamHandler;

public class PluginMain {
    public static final String PLUGIN_STDERR_FILE = System.getProperty("user.home") + "/.icedteaplugin/java.stderr";
    public static final String PLUGIN_STDOUT_FILE = System.getProperty("user.home") + "/.icedteaplugin/java.stdout";
    final boolean redirectStreams = System.getenv().containsKey("ICEDTEAPLUGIN_DEBUG");
    static PluginStreamHandler streamHandler;
    public static final String theVersion;
    private PluginAppletSecurityContext securityContext;

    public static void main(String[] args) throws IOException {
        try {
            PluginMain pm = new PluginMain(System.getProperty("user.home") + "/.icedteaplugin/icedtea-plugin-to-appletviewer", System.getProperty("user.home") + "/.icedteaplugin/icedtea-appletviewer-to-plugin");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("Something very bad happened. I don't know what to do, so I am going to exit :(");
            System.exit(1);
        }
    }

    public PluginMain(String inPipe, String outPipe) {
        try {
            File errFile = new File(PLUGIN_STDERR_FILE);
            File outFile = new File(PLUGIN_STDOUT_FILE);
            System.setErr(new TeeOutputStream(new FileOutputStream(errFile), System.err));
            System.setOut(new TeeOutputStream(new FileOutputStream(outFile), System.out));
        }
        catch (Exception e) {
            PluginDebug.debug("Unable to redirect streams");
            e.printStackTrace();
        }
        this.connect(inPipe, outPipe);
        this.securityContext = new PluginAppletSecurityContext(0);
        this.securityContext.prePopulateLCClasses();
        PluginAppletSecurityContext.setStreamhandler(streamHandler);
        AppletSecurityContextManager.addContext(0, this.securityContext);
        PluginAppletViewer.setStreamhandler(streamHandler);
        PluginAppletViewer.setPluginCallRequestFactory(new PluginCallRequestFactory());
        PluginMain.init();
        streamHandler.startProcessing();
    }

    public void connect(String inPipe, String outPipe) {
        try {
            streamHandler = new PluginStreamHandler(new FileInputStream(inPipe), new FileOutputStream(outPipe));
            PluginDebug.debug("Streams initialized");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static void init() {
        Properties avProps = new Properties();
        avProps.put("browser", "sun.applet.AppletViewer");
        avProps.put("browser.version", "1.06");
        avProps.put("browser.vendor", "Sun Microsystems Inc.");
        avProps.put("http.agent", "Java(tm) 2 SDK, Standard Edition v" + theVersion);
        avProps.put("package.restrict.definition.java", "true");
        avProps.put("package.restrict.definition.sun", "true");
        avProps.put("java.version.applet", "true");
        avProps.put("java.vendor.applet", "true");
        avProps.put("java.vendor.url.applet", "true");
        avProps.put("java.class.version.applet", "true");
        avProps.put("os.name.applet", "true");
        avProps.put("os.version.applet", "true");
        avProps.put("os.arch.applet", "true");
        avProps.put("file.separator.applet", "true");
        avProps.put("path.separator.applet", "true");
        avProps.put("line.separator.applet", "true");
        Properties sysProps = System.getProperties();
        Enumeration<?> e = sysProps.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = sysProps.getProperty(key);
            avProps.setProperty(key, val);
        }
        System.setProperties(avProps);
        try {
            SSLContext context = SSLContext.getInstance("SSL");
            TrustManager[] trust = new TrustManager[]{VariableX509TrustManager.getInstance()};
            context.init(null, trust, null);
            SSLSocketFactory sslSocketFactory = context.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sslSocketFactory);
        }
        catch (Exception e2) {
            System.err.println("Unable to set SSLSocketfactory (may _prevent_ access to sites that should be trusted)! Continuing anyway...");
            e2.printStackTrace();
        }
        Authenticator.setDefault(new CustomAuthenticator());
        ProxySelector.setDefault(new PluginProxySelector());
        PluginCookieManager ckManager = new PluginCookieManager();
        CookieHandler.setDefault(ckManager);
    }

    static boolean messageAvailable() {
        return streamHandler.messageAvailable();
    }

    static String getMessage() {
        return streamHandler.getMessage();
    }

    static {
        theVersion = System.getProperty("java.version");
    }

    class TeeOutputStream
    extends PrintStream {
        PrintStream logFile;

        public TeeOutputStream(FileOutputStream fileOutputStream, PrintStream stdStream) {
            super(stdStream);
            this.logFile = new PrintStream(fileOutputStream);
        }

        public boolean checkError() {
            boolean thisError = super.checkError();
            boolean fileError = this.logFile.checkError();
            return thisError || fileError;
        }

        public void close() {
            this.logFile.close();
            super.close();
        }

        public void flush() {
            this.logFile.flush();
            super.flush();
        }

        public void write(byte[] buf, int off, int len) {
            this.logFile.write(buf, off, len);
            if (!PluginMain.this.redirectStreams) {
                super.write(buf, off, len);
            }
        }

        public void write(int b) {
            this.logFile.write(b);
            if (!PluginMain.this.redirectStreams) {
                super.write(b);
            }
        }

        public void write(byte[] b) throws IOException {
            this.logFile.write(b);
            if (!PluginMain.this.redirectStreams) {
                super.write(b);
            }
        }
    }

    static class CustomAuthenticator
    extends Authenticator {
        CustomAuthenticator() {
        }

        public PasswordAuthentication getPasswordAuthentication() {
            String type = this.getRequestorType() == Authenticator.RequestorType.PROXY ? "proxy" : "web";
            PasswordAuthenticationDialog pwDialog = new PasswordAuthenticationDialog();
            PasswordAuthentication auth = pwDialog.askUser(this.getRequestingHost(), this.getRequestingPort(), this.getRequestingPrompt(), type);
            return auth;
        }
    }
}

