/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.cache;

import java.io.File;
import java.net.URL;
import java.net.URLConnection;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.util.PropertiesFile;

public class CacheEntry {
    private URL location;
    private Version version;
    private PropertiesFile properties;

    public CacheEntry(URL location, Version version) {
        this.location = location;
        this.version = version;
        File infoFile = CacheUtil.getCacheFile(location, version);
        infoFile = new File(infoFile.getPath() + ".info");
        this.properties = new PropertiesFile(infoFile, JNLPRuntime.getMessage("CAutoGen"));
    }

    void initialize(URLConnection connection) {
        long modified = connection.getLastModified();
        long length = connection.getContentLength();
        this.properties.setProperty("content-length", Long.toString(length));
        this.properties.setProperty("last-modified", Long.toString(modified));
    }

    public URL getLocation() {
        return this.location;
    }

    public long getLastUpdated() {
        try {
            return Long.parseLong(this.properties.getProperty("last-updated"));
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    public void setLastUpdated(long updatedTime) {
        this.properties.setProperty("last-updated", Long.toString(updatedTime));
    }

    public boolean isCurrent(URLConnection connection) {
        boolean cached = this.isCached();
        if (!cached) {
            return false;
        }
        try {
            long remoteModified = connection.getLastModified();
            long cachedModified = Long.parseLong(this.properties.getProperty("last-modified"));
            return remoteModified > 0L && remoteModified <= cachedModified;
        }
        catch (Exception ex) {
            if (JNLPRuntime.isDebug()) {
                ex.printStackTrace();
            }
            return cached;
        }
    }

    public boolean isCached() {
        File localFile = CacheUtil.getCacheFile(this.location, this.version);
        if (!localFile.exists()) {
            return false;
        }
        try {
            long cachedLength = localFile.length();
            long remoteLength = Long.parseLong(this.properties.getProperty("content-length", "-1"));
            return remoteLength < 0L || cachedLength == remoteLength;
        }
        catch (Exception ex) {
            if (JNLPRuntime.isDebug()) {
                ex.printStackTrace();
            }
            return false;
        }
    }

    protected void store() {
        this.properties.store();
    }
}

