/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp;

import java.applet.Applet;
import java.awt.Container;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarFile;
import net.sourceforge.jnlp.IconDesc;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.JNLPSplashScreen;
import net.sourceforge.jnlp.LaunchException;
import net.sourceforge.jnlp.LaunchHandler;
import net.sourceforge.jnlp.ParseException;
import net.sourceforge.jnlp.PluginBridge;
import net.sourceforge.jnlp.StreamEater;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.cache.ResourceTracker;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.AppThreadGroup;
import net.sourceforge.jnlp.runtime.AppletInstance;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.JNLPClassLoader;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.services.InstanceExistsException;
import net.sourceforge.jnlp.services.ServiceUtil;
import net.sourceforge.jnlp.util.Reflect;

public class Launcher {
    private static final ThreadGroup mainGroup = new ThreadGroup(Launcher.R("LAllThreadGroup"));
    private LaunchHandler handler = null;
    private UpdatePolicy updatePolicy = JNLPRuntime.getDefaultUpdatePolicy();
    private boolean context = true;
    private boolean exitOnFailure = true;

    private static String R(String key) {
        return JNLPRuntime.getMessage(key);
    }

    public Launcher() {
        this(null, null);
        if (this.handler == null) {
            this.handler = JNLPRuntime.getDefaultLaunchHandler();
        }
    }

    public Launcher(boolean exitOnFailure) {
        this(null, null);
        if (this.handler == null) {
            this.handler = JNLPRuntime.getDefaultLaunchHandler();
        }
        this.exitOnFailure = exitOnFailure;
    }

    public Launcher(LaunchHandler handler) {
        this(handler, null);
    }

    public Launcher(LaunchHandler handler, UpdatePolicy policy) {
        if (policy == null) {
            policy = JNLPRuntime.getDefaultUpdatePolicy();
        }
        this.handler = handler;
        this.updatePolicy = policy;
    }

    public void setUpdatePolicy(UpdatePolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException(Launcher.R("LNullUpdatePolicy"));
        }
        this.updatePolicy = policy;
    }

    public UpdatePolicy getUpdatePolicy() {
        return this.updatePolicy;
    }

    public void setCreateAppContext(boolean context) {
        this.context = context;
    }

    public boolean isCreateAppContext() {
        return this.context;
    }

    public ApplicationInstance launch(JNLPFile file) throws LaunchException {
        return this.launch(file, null);
    }

    public ApplicationInstance launch(JNLPFile file, Container cont) throws LaunchException {
        TgThread tg = file instanceof PluginBridge && cont != null ? new TgThread(file, cont, true) : (cont == null ? new TgThread(file) : new TgThread(file, cont));
        tg.start();
        try {
            tg.join();
        }
        catch (InterruptedException ex) {
            throw this.launchWarning(new LaunchException(file, ex, Launcher.R("LSMinor"), Launcher.R("LCSystem"), Launcher.R("LThreadInterrupted"), Launcher.R("LThreadInterruptedInfo")));
        }
        if (tg.getException() != null) {
            throw tg.getException();
        }
        if (this.handler != null) {
            this.handler.launchCompleted(tg.getApplication());
        }
        return tg.getApplication();
    }

    public ApplicationInstance launch(URL location) throws LaunchException {
        return this.launch(this.toFile(location));
    }

    public void launchBackground(JNLPFile file) {
        BgRunner runner = new BgRunner(file, null);
        new Thread(runner).start();
    }

    public void launchBackground(URL location) {
        BgRunner runner = new BgRunner(null, location);
        new Thread(runner).start();
    }

    public void launchExternal(List<String> vmArgs, JNLPFile file, List<String> javawsArgs) throws LaunchException {
        LinkedList<String> updatedArgs = new LinkedList<String>(javawsArgs);
        if (file.getFileLocation() != null) {
            updatedArgs.add(file.getFileLocation().toString());
        } else if (file.getSourceLocation() != null) {
            updatedArgs.add(file.getFileLocation().toString());
        } else {
            this.launchError(new LaunchException(file, null, Launcher.R("LSFatal"), Launcher.R("LCExternalLaunch"), Launcher.R("LNullLocation"), Launcher.R("LNullLocationInfo")));
        }
        this.launchExternal(vmArgs, updatedArgs);
    }

    public void launchExternal(URL url) throws LaunchException {
        LinkedList<String> javawsArgs = new LinkedList<String>();
        javawsArgs.add(url.toString());
        this.launchExternal(new LinkedList<String>(), javawsArgs);
    }

    public void launchExternal(List<String> vmArgs, List<String> javawsArgs) throws LaunchException {
        try {
            LinkedList<String> commands = new LinkedList<String>();
            String pathToWebstartBinary = System.getProperty("java.home") + File.separatorChar + "bin" + File.separatorChar + "javaws";
            commands.add(pathToWebstartBinary);
            for (String arg : vmArgs) {
                commands.add("-J" + arg);
            }
            commands.addAll(javawsArgs);
            String[] command = commands.toArray(new String[0]);
            Process p = Runtime.getRuntime().exec(command);
            new StreamEater(p.getErrorStream()).start();
            new StreamEater(p.getInputStream()).start();
            p.getOutputStream().close();
        }
        catch (NullPointerException ex) {
            throw this.launchError(new LaunchException(null, null, Launcher.R("LSFatal"), Launcher.R("LCExternalLaunch"), Launcher.R("LNetxJarMissing"), Launcher.R("LNetxJarMissingInfo")));
        }
        catch (Exception ex) {
            throw this.launchError(new LaunchException(null, ex, Launcher.R("LSFatal"), Launcher.R("LCExternalLaunch"), Launcher.R("LCouldNotLaunch"), Launcher.R("LCouldNotLaunchInfo")));
        }
    }

    private JNLPFile toFile(URL location) throws LaunchException {
        try {
            JNLPFile file;
            block5: {
                file = null;
                try {
                    file = new JNLPFile(location, null, true, this.updatePolicy);
                }
                catch (ParseException ex) {
                    file = new JNLPFile(location, null, false, this.updatePolicy);
                    LaunchException lex = this.launchWarning(new LaunchException(file, ex, Launcher.R("LSMinor"), Launcher.R("LCFileFormat"), Launcher.R("LNotToSpec"), Launcher.R("LNotToSpecInfo")));
                    if (lex == null) break block5;
                    throw lex;
                }
            }
            return file;
        }
        catch (Exception ex) {
            if (ex instanceof LaunchException) {
                throw (LaunchException)ex;
            }
            throw this.launchError(new LaunchException(null, ex, Launcher.R("LSFatal"), Launcher.R("LCReadError"), Launcher.R("LCantRead"), Launcher.R("LCantReadInfo")));
        }
    }

    protected ApplicationInstance launchApplication(JNLPFile file) throws LaunchException {
        if (!file.isApplication()) {
            throw this.launchError(new LaunchException(file, null, Launcher.R("LSFatal"), Launcher.R("LCClient"), Launcher.R("LNotApplication"), Launcher.R("LNotApplicationInfo")));
        }
        try {
            JARDesc mainJarDesc;
            File f;
            try {
                ServiceUtil.checkExistingSingleInstance(file);
            }
            catch (InstanceExistsException e) {
                return null;
            }
            if (JNLPRuntime.getForksAllowed() && file.needsNewVM()) {
                LinkedList<String> netxArguments = new LinkedList<String>();
                netxArguments.add("-Xnofork");
                netxArguments.addAll(JNLPRuntime.getInitialArguments());
                this.launchExternal(file.getNewVMArgs(), netxArguments);
                return null;
            }
            int preferredWidth = 500;
            int preferredHeight = 400;
            JNLPSplashScreen splashScreen = null;
            URL splashImageURL = file.getInformation().getIconLocation(IconDesc.SPLASH, 500, 400);
            if (splashImageURL != null) {
                ResourceTracker resourceTracker = new ResourceTracker(true);
                resourceTracker.addResource(splashImageURL, file.getFileVersion(), this.updatePolicy);
                splashScreen = new JNLPSplashScreen(resourceTracker, null, null);
                splashScreen.setSplashImageURL(splashImageURL);
                if (splashScreen.isSplashScreenValid()) {
                    splashScreen.setVisible(true);
                }
            }
            ApplicationInstance app = this.createApplication(file);
            app.initialize();
            String mainName = file.getApplication().getMainClass();
            if (mainName == null && (f = CacheUtil.getCacheFile((mainJarDesc = file.getResources().getMainJAR()).getLocation(), null)) != null) {
                JarFile mainJar = new JarFile(f);
                mainName = mainJar.getManifest().getMainAttributes().getValue("Main-Class");
            }
            if (mainName == null) {
                throw this.launchError(new LaunchException(file, null, Launcher.R("LSFatal"), Launcher.R("LCClient"), Launcher.R("LCantDetermineMainClass"), Launcher.R("LCantDetermineMainClassInfo")));
            }
            Class<?> mainClass = app.getClassLoader().loadClass(mainName);
            Method main = mainClass.getDeclaredMethod("main", String[].class);
            String[] args = file.getApplication().getArguments();
            this.setContextClassLoaderForAllThreads(app.getClassLoader());
            if (splashScreen != null) {
                if (splashScreen.isSplashScreenValid()) {
                    splashScreen.setVisible(false);
                }
                splashScreen.dispose();
            }
            main.invoke(null, new Object[]{args});
            return app;
        }
        catch (LaunchException lex) {
            throw this.launchError(lex);
        }
        catch (Exception ex) {
            throw this.launchError(new LaunchException(file, ex, Launcher.R("LSFatal"), Launcher.R("LCLaunching"), Launcher.R("LCouldNotLaunch"), Launcher.R("LCouldNotLaunchInfo")));
        }
    }

    private void setContextClassLoaderForAllThreads(ClassLoader classLoader) {
        Thread[] threads;
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        ThreadGroup root = Thread.currentThread().getThreadGroup();
        while (root.getParent() != null) {
            root = root.getParent();
        }
        int threadCountGuess = threadBean.getThreadCount();
        do {
            threads = new Thread[threadCountGuess *= 2];
            root.enumerate(threads, true);
        } while (threads[threadCountGuess - 1] != null);
        for (Thread thread : threads) {
            if (thread == null) continue;
            if (JNLPRuntime.isDebug()) {
                System.err.println("Setting " + classLoader + " as the classloader for thread " + thread.getName());
            }
            thread.setContextClassLoader(classLoader);
        }
    }

    protected ApplicationInstance launchApplet(JNLPFile file, boolean enableCodeBase, Container cont) throws LaunchException {
        if (!file.isApplet()) {
            throw this.launchError(new LaunchException(file, null, Launcher.R("LSFatal"), Launcher.R("LCClient"), Launcher.R("LNotApplet"), Launcher.R("LNotAppletInfo")));
        }
        try {
            AppletInstance applet = this.createApplet(file, enableCodeBase, cont);
            applet.initialize();
            applet.getAppletEnvironment().startApplet();
            return applet;
        }
        catch (LaunchException lex) {
            throw this.launchError(lex);
        }
        catch (Exception ex) {
            throw this.launchError(new LaunchException(file, ex, Launcher.R("LSFatal"), Launcher.R("LCLaunching"), Launcher.R("LCouldNotLaunch"), Launcher.R("LCouldNotLaunchInfo")));
        }
    }

    protected ApplicationInstance getApplet(JNLPFile file, boolean enableCodeBase, Container cont) throws LaunchException {
        if (!file.isApplet()) {
            throw this.launchError(new LaunchException(file, null, Launcher.R("LSFatal"), Launcher.R("LCClient"), Launcher.R("LNotApplet"), Launcher.R("LNotAppletInfo")));
        }
        try {
            AppletInstance applet = this.createApplet(file, enableCodeBase, cont);
            applet.initialize();
            return applet;
        }
        catch (LaunchException lex) {
            throw this.launchError(lex);
        }
        catch (Exception ex) {
            throw this.launchError(new LaunchException(file, ex, Launcher.R("LSFatal"), Launcher.R("LCLaunching"), Launcher.R("LCouldNotLaunch"), Launcher.R("LCouldNotLaunchInfo")));
        }
    }

    protected ApplicationInstance launchInstaller(JNLPFile file) throws LaunchException {
        throw this.launchError(new LaunchException(file, null, Launcher.R("LSFatal"), Launcher.R("LCNotSupported"), Launcher.R("LNoInstallers"), Launcher.R("LNoInstallersInfo")));
    }

    protected AppletInstance createApplet(JNLPFile file, boolean enableCodeBase, Container cont) throws LaunchException {
        try {
            JNLPClassLoader loader = JNLPClassLoader.getInstance(file, this.updatePolicy);
            if (enableCodeBase || file.getResources().getJARs().length == 0) {
                loader.enableCodeBase();
            }
            AppThreadGroup group = (AppThreadGroup)Thread.currentThread().getThreadGroup();
            String appletName = file.getApplet().getMainClass();
            appletName = appletName.replace('/', '.');
            Class appletClass = loader.loadClass(appletName);
            Applet applet = (Applet)appletClass.newInstance();
            AppletInstance appletInstance = cont == null ? new AppletInstance(file, group, loader, applet) : new AppletInstance(file, group, loader, applet, cont);
            group.setApplication(appletInstance);
            loader.setApplication(appletInstance);
            return appletInstance;
        }
        catch (Exception ex) {
            throw this.launchError(new LaunchException(file, ex, Launcher.R("LSFatal"), Launcher.R("LCInit"), Launcher.R("LInitApplet"), Launcher.R("LInitAppletInfo")));
        }
    }

    protected Applet createAppletObject(JNLPFile file, boolean enableCodeBase, Container cont) throws LaunchException {
        try {
            JNLPClassLoader loader = JNLPClassLoader.getInstance(file, this.updatePolicy);
            if (enableCodeBase || file.getResources().getJARs().length == 0) {
                loader.enableCodeBase();
            }
            String appletName = file.getApplet().getMainClass();
            appletName = appletName.replace('/', '.');
            Class appletClass = loader.loadClass(appletName);
            Applet applet = (Applet)appletClass.newInstance();
            return applet;
        }
        catch (Exception ex) {
            throw this.launchError(new LaunchException(file, ex, Launcher.R("LSFatal"), Launcher.R("LCInit"), Launcher.R("LInitApplet"), Launcher.R("LInitAppletInfo")));
        }
    }

    protected ApplicationInstance createApplication(JNLPFile file) throws LaunchException {
        try {
            JNLPClassLoader loader = JNLPClassLoader.getInstance(file, this.updatePolicy);
            AppThreadGroup group = (AppThreadGroup)Thread.currentThread().getThreadGroup();
            ApplicationInstance app = new ApplicationInstance(file, group, loader);
            group.setApplication(app);
            loader.setApplication(app);
            return app;
        }
        catch (Exception ex) {
            throw new LaunchException(file, ex, Launcher.R("LSFatal"), Launcher.R("LCInit"), Launcher.R("LInitApplication"), Launcher.R("LInitApplicationInfo"));
        }
    }

    protected AppThreadGroup createThreadGroup(JNLPFile file) {
        return new AppThreadGroup(mainGroup, file.getTitle());
    }

    private LaunchException launchError(LaunchException ex) {
        if (this.handler != null) {
            this.handler.launchError(ex);
        }
        return ex;
    }

    private LaunchException launchWarning(LaunchException ex) {
        if (this.handler != null && !this.handler.launchWarning(ex)) {
            return ex;
        }
        return null;
    }

    private class BgRunner
    implements Runnable {
        private JNLPFile file;
        private URL location;

        BgRunner(JNLPFile file, URL location) {
            this.file = file;
            this.location = location;
        }

        @Override
        public void run() {
            try {
                if (this.file != null) {
                    Launcher.this.launch(this.file);
                }
                if (this.location != null) {
                    Launcher.this.launch(this.location);
                }
            }
            catch (LaunchException launchException) {
                // empty catch block
            }
        }
    }

    private class TgThread
    extends Thread {
        private JNLPFile file;
        private ApplicationInstance application;
        private LaunchException exception;
        private Container cont;
        private boolean isPlugin;

        TgThread(JNLPFile file) {
            this(file, null);
        }

        TgThread(JNLPFile file, Container cont) {
            super((ThreadGroup)Launcher.this.createThreadGroup(file), file.getTitle());
            this.isPlugin = false;
            this.file = file;
            this.cont = cont;
        }

        TgThread(JNLPFile file, Container cont, boolean isPlugin) {
            super((ThreadGroup)Launcher.this.createThreadGroup(file), file.getTitle());
            this.isPlugin = false;
            this.file = file;
            this.cont = cont;
            this.isPlugin = isPlugin;
        }

        @Override
        public void run() {
            block7: {
                try {
                    if (Launcher.this.context && !this.isPlugin) {
                        new Reflect().invokeStatic("sun.awt.SunToolkit", "createNewAppContext");
                    }
                    if (this.isPlugin) {
                        JNLPRuntime.setDefaultDownloadIndicator(null);
                        this.application = Launcher.this.getApplet(this.file, true, this.cont);
                        break block7;
                    }
                    if (this.file.isApplication()) {
                        this.application = Launcher.this.launchApplication(this.file);
                        break block7;
                    }
                    if (this.file.isApplet()) {
                        this.application = Launcher.this.launchApplet(this.file, true, this.cont);
                        break block7;
                    }
                    if (this.file.isInstaller()) {
                        this.application = Launcher.this.launchInstaller(this.file);
                        break block7;
                    }
                    throw Launcher.this.launchError(new LaunchException(this.file, null, Launcher.R("LSFatal"), Launcher.R("LCClient"), Launcher.R("LNotLaunchable"), Launcher.R("LNotLaunchableInfo")));
                }
                catch (LaunchException ex) {
                    ex.printStackTrace();
                    this.exception = ex;
                    if (!Launcher.this.exitOnFailure) break block7;
                    System.exit(0);
                }
            }
        }

        public LaunchException getException() {
            return this.exception;
        }

        public ApplicationInstance getApplication() {
            return this.application;
        }
    }
}

