/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.dsig;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.List;
import java.util.Map;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import sun.security.jca.GetInstance;

public abstract class TransformService
implements Transform {
    private String algorithm;
    private String mechanism;
    private Provider provider;

    protected TransformService() {
    }

    public static TransformService getInstance(String algorithm, String mechanismType) throws NoSuchAlgorithmException {
        if (mechanismType == null || algorithm == null) {
            throw new NullPointerException();
        }
        boolean dom = false;
        if (mechanismType.equals("DOM")) {
            dom = true;
        }
        List<Provider.Service> services = GetInstance.getServices("TransformService", algorithm);
        for (Provider.Service s : services) {
            String value = s.getAttribute("MechanismType");
            if ((value != null || !dom) && (value == null || !value.equals(mechanismType))) continue;
            GetInstance.Instance instance = GetInstance.getInstance(s, null);
            TransformService ts = (TransformService)instance.impl;
            ts.algorithm = algorithm;
            ts.mechanism = mechanismType;
            ts.provider = instance.provider;
            return ts;
        }
        throw new NoSuchAlgorithmException(algorithm + " algorithm and " + mechanismType + " mechanism not available");
    }

    public static TransformService getInstance(String algorithm, String mechanismType, Provider provider) throws NoSuchAlgorithmException {
        Provider.Service s;
        String value;
        if (mechanismType == null || algorithm == null || provider == null) {
            throw new NullPointerException();
        }
        boolean dom = false;
        if (mechanismType.equals("DOM")) {
            dom = true;
        }
        if ((value = (s = GetInstance.getService("TransformService", algorithm, provider)).getAttribute("MechanismType")) == null && dom || value != null && value.equals(mechanismType)) {
            GetInstance.Instance instance = GetInstance.getInstance(s, null);
            TransformService ts = (TransformService)instance.impl;
            ts.algorithm = algorithm;
            ts.mechanism = mechanismType;
            ts.provider = instance.provider;
            return ts;
        }
        throw new NoSuchAlgorithmException(algorithm + " algorithm and " + mechanismType + " mechanism not available");
    }

    public static TransformService getInstance(String algorithm, String mechanismType, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider.Service s;
        String value;
        if (mechanismType == null || algorithm == null || provider == null) {
            throw new NullPointerException();
        }
        if (provider.length() == 0) {
            throw new NoSuchProviderException();
        }
        boolean dom = false;
        if (mechanismType.equals("DOM")) {
            dom = true;
        }
        if ((value = (s = GetInstance.getService("TransformService", algorithm, provider)).getAttribute("MechanismType")) == null && dom || value != null && value.equals(mechanismType)) {
            GetInstance.Instance instance = GetInstance.getInstance(s, null);
            TransformService ts = (TransformService)instance.impl;
            ts.algorithm = algorithm;
            ts.mechanism = mechanismType;
            ts.provider = instance.provider;
            return ts;
        }
        throw new NoSuchAlgorithmException(algorithm + " algorithm and " + mechanismType + " mechanism not available");
    }

    public final String getMechanismType() {
        return this.mechanism;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public abstract void init(TransformParameterSpec var1) throws InvalidAlgorithmParameterException;

    public abstract void marshalParams(XMLStructure var1, XMLCryptoContext var2) throws MarshalException;

    public abstract void init(XMLStructure var1, XMLCryptoContext var2) throws InvalidAlgorithmParameterException;

    private static class MechanismMapEntry
    implements Map.Entry {
        private final String mechanism;
        private final String algorithm;
        private final String key;

        MechanismMapEntry(String algorithm, String mechanism) {
            this.algorithm = algorithm;
            this.mechanism = mechanism;
            this.key = "TransformService." + algorithm + " MechanismType";
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.getKey() == null ? e.getKey() == null : this.getKey().equals(e.getKey())) && (this.getValue() == null ? e.getValue() == null : this.getValue().equals(e.getValue()));
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.mechanism;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }
    }
}

