/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.Element;
import javax.swing.text.html.BlockView;
import javax.swing.text.html.StyleSheet;

public class ListView
extends BlockView {
    private StyleSheet.ListPainter listPainter;

    public ListView(Element elem) {
        super(elem, 1);
    }

    public float getAlignment(int axis) {
        switch (axis) {
            case 0: {
                return 0.5f;
            }
            case 1: {
                return 0.5f;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + axis);
    }

    public void paint(Graphics g, Shape allocation) {
        super.paint(g, allocation);
        Rectangle alloc = allocation.getBounds();
        Rectangle clip = g.getClipBounds();
        if (clip.x + clip.width < alloc.x + this.getLeftInset()) {
            Rectangle childRect = alloc;
            alloc = this.getInsideAllocation(allocation);
            int n = this.getViewCount();
            int endY = clip.y + clip.height;
            for (int i = 0; i < n; ++i) {
                childRect.setBounds(alloc);
                this.childAllocation(i, childRect);
                if (childRect.y >= endY) break;
                if (childRect.y + childRect.height < clip.y) continue;
                this.listPainter.paint(g, childRect.x, childRect.y, childRect.width, childRect.height, this, i);
            }
        }
    }

    protected void paintChild(Graphics g, Rectangle alloc, int index) {
        this.listPainter.paint(g, alloc.x, alloc.y, alloc.width, alloc.height, this, index);
        super.paintChild(g, alloc, index);
    }

    protected void setPropertiesFromAttributes() {
        super.setPropertiesFromAttributes();
        this.listPainter = this.getStyleSheet().getListPainter(this.getAttributes());
    }
}

