/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Graphics;
import java.awt.Shape;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AsyncBoxView;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StateInvariantError;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class ZoneView
extends BoxView {
    int maxZoneSize = 8192;
    int maxZonesLoaded = 3;
    Vector loadedZones = new Vector();

    public ZoneView(Element elem, int axis) {
        super(elem, axis);
    }

    public int getMaximumZoneSize() {
        return this.maxZoneSize;
    }

    public void setMaximumZoneSize(int size) {
        this.maxZoneSize = size;
    }

    public int getMaxZonesLoaded() {
        return this.maxZonesLoaded;
    }

    public void setMaxZonesLoaded(int mzl) {
        if (mzl < 1) {
            throw new IllegalArgumentException("ZoneView.setMaxZonesLoaded must be greater than 0.");
        }
        this.maxZonesLoaded = mzl;
        this.unloadOldZones();
    }

    protected void zoneWasLoaded(View zone) {
        this.loadedZones.addElement(zone);
        this.unloadOldZones();
    }

    void unloadOldZones() {
        while (this.loadedZones.size() > this.getMaxZonesLoaded()) {
            View zone = (View)this.loadedZones.elementAt(0);
            this.loadedZones.removeElementAt(0);
            this.unloadZone(zone);
        }
    }

    protected void unloadZone(View zone) {
        zone.removeAll();
    }

    protected boolean isZoneLoaded(View zone) {
        return zone.getViewCount() > 0;
    }

    protected View createZone(int p0, int p1) {
        Document doc = this.getDocument();
        Zone zone = null;
        try {
            zone = new Zone(this.getElement(), doc.createPosition(p0), doc.createPosition(p1));
        }
        catch (BadLocationException ble) {
            throw new StateInvariantError(ble.getMessage());
        }
        return zone;
    }

    protected void loadChildren(ViewFactory f) {
        Document doc = this.getDocument();
        int offs0 = this.getStartOffset();
        int offs1 = this.getEndOffset();
        this.append(this.createZone(offs0, offs1));
        this.handleInsert(offs0, offs1 - offs0);
    }

    protected int getViewIndexAtPosition(int pos) {
        int n = this.getViewCount();
        if (pos == this.getEndOffset()) {
            return n - 1;
        }
        for (int i = 0; i < n; ++i) {
            View v = this.getView(i);
            if (pos < v.getStartOffset() || pos >= v.getEndOffset()) continue;
            return i;
        }
        return -1;
    }

    void handleInsert(int pos, int length) {
        int index = this.getViewIndex(pos, Position.Bias.Forward);
        View v = this.getView(index);
        int offs0 = v.getStartOffset();
        int offs1 = v.getEndOffset();
        if (offs1 - offs0 > this.maxZoneSize) {
            this.splitZone(index, offs0, offs1);
        }
    }

    void handleRemove(int pos, int length) {
    }

    void splitZone(int index, int offs0, int offs1) {
        Element elem = this.getElement();
        Document doc = elem.getDocument();
        Vector<View> zones = new Vector<View>();
        int offs = offs0;
        do {
            offs0 = offs;
            offs = Math.min(this.getDesiredZoneEnd(offs0), offs1);
            zones.addElement(this.createZone(offs0, offs));
        } while (offs < offs1);
        View oldZone = this.getView(index);
        Object[] newZones = new View[zones.size()];
        zones.copyInto(newZones);
        this.replace(index, 1, (View[])newZones);
    }

    int getDesiredZoneEnd(int pos) {
        Element elem = this.getElement();
        int index = elem.getElementIndex(pos + this.maxZoneSize / 2);
        Element child = elem.getElement(index);
        int offs0 = child.getStartOffset();
        int offs1 = child.getEndOffset();
        if (offs1 - pos > this.maxZoneSize && offs0 > pos) {
            return offs0;
        }
        return offs1;
    }

    protected boolean updateChildren(DocumentEvent.ElementChange ec, DocumentEvent e, ViewFactory f) {
        return false;
    }

    public void insertUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
        this.handleInsert(changes.getOffset(), changes.getLength());
        super.insertUpdate(changes, a, f);
    }

    public void removeUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
        this.handleRemove(changes.getOffset(), changes.getLength());
        super.removeUpdate(changes, a, f);
    }

    class Zone
    extends AsyncBoxView {
        private Position start;
        private Position end;

        public Zone(Element elem, Position start, Position end) {
            super(elem, ZoneView.this.getAxis());
            this.start = start;
            this.end = end;
        }

        public void load() {
            if (!this.isLoaded()) {
                this.setEstimatedMajorSpan(true);
                Element e = this.getElement();
                ViewFactory f = this.getViewFactory();
                int index0 = e.getElementIndex(this.getStartOffset());
                int index1 = e.getElementIndex(this.getEndOffset());
                View[] added = new View[index1 - index0 + 1];
                for (int i = index0; i <= index1; ++i) {
                    added[i - index0] = f.create(e.getElement(i));
                }
                this.replace(0, 0, added);
                ZoneView.this.zoneWasLoaded(this);
            }
        }

        public void unload() {
            this.setEstimatedMajorSpan(true);
            this.removeAll();
        }

        public boolean isLoaded() {
            return this.getViewCount() != 0;
        }

        protected void loadChildren(ViewFactory f) {
            this.setEstimatedMajorSpan(true);
            Element elem = this.getElement();
            int index0 = elem.getElementIndex(this.getStartOffset());
            int index1 = elem.getElementIndex(this.getEndOffset());
            int nChildren = index1 - index0;
            View first = f.create(elem.getElement(index0));
            first.setParent(this);
            float w = first.getPreferredSpan(0);
            float h = first.getPreferredSpan(1);
            if (this.getMajorAxis() == 0) {
                w *= (float)nChildren;
            } else {
                h += (float)nChildren;
            }
            this.setSize(w, h);
        }

        protected void flushRequirementChanges() {
            if (this.isLoaded()) {
                super.flushRequirementChanges();
            }
        }

        public int getViewIndex(int pos, Position.Bias b) {
            boolean isBackward = b == Position.Bias.Backward;
            pos = isBackward ? Math.max(0, pos - 1) : pos;
            Element elem = this.getElement();
            int index1 = elem.getElementIndex(pos);
            int index0 = elem.getElementIndex(this.getStartOffset());
            return index1 - index0;
        }

        protected boolean updateChildren(DocumentEvent.ElementChange ec, DocumentEvent e, ViewFactory f) {
            Element[] removedElems = ec.getChildrenRemoved();
            Element[] addedElems = ec.getChildrenAdded();
            Element elem = this.getElement();
            int index0 = elem.getElementIndex(this.getStartOffset());
            int index1 = elem.getElementIndex(this.getEndOffset() - 1);
            int index = ec.getIndex();
            if (index >= index0 && index <= index1) {
                int replaceIndex = index - index0;
                int nadd = Math.min(index1 - index0 + 1, addedElems.length);
                int nremove = Math.min(index1 - index0 + 1, removedElems.length);
                View[] added = new View[nadd];
                for (int i = 0; i < nadd; ++i) {
                    added[i] = f.create(addedElems[i]);
                }
                this.replace(replaceIndex, nremove, added);
            }
            return true;
        }

        public AttributeSet getAttributes() {
            return ZoneView.this.getAttributes();
        }

        public void paint(Graphics g, Shape a) {
            this.load();
            super.paint(g, a);
        }

        public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
            this.load();
            return super.viewToModel(x, y, a, bias);
        }

        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            this.load();
            return super.modelToView(pos, a, b);
        }

        public int getStartOffset() {
            return this.start.getOffset();
        }

        public int getEndOffset() {
            return this.end.getOffset();
        }

        public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            if (this.isLoaded()) {
                super.insertUpdate(e, a, f);
            }
        }

        public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            if (this.isLoaded()) {
                super.removeUpdate(e, a, f);
            }
        }

        public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            if (this.isLoaded()) {
                super.changedUpdate(e, a, f);
            }
        }
    }
}

