/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatter;

public class MaskFormatter
extends DefaultFormatter {
    private static final char DIGIT_KEY = '#';
    private static final char LITERAL_KEY = '\'';
    private static final char UPPERCASE_KEY = 'U';
    private static final char LOWERCASE_KEY = 'L';
    private static final char ALPHA_NUMERIC_KEY = 'A';
    private static final char CHARACTER_KEY = '?';
    private static final char ANYTHING_KEY = '*';
    private static final char HEX_KEY = 'H';
    private static final MaskCharacter[] EmptyMaskChars = new MaskCharacter[0];
    private String mask;
    private transient MaskCharacter[] maskChars;
    private String validCharacters;
    private String invalidCharacters;
    private String placeholderString;
    private char placeholder;
    private boolean containsLiteralChars;

    public MaskFormatter() {
        this.setAllowsInvalid(false);
        this.containsLiteralChars = true;
        this.maskChars = EmptyMaskChars;
        this.placeholder = (char)32;
    }

    public MaskFormatter(String mask) throws ParseException {
        this();
        this.setMask(mask);
    }

    public void setMask(String mask) throws ParseException {
        this.mask = mask;
        this.updateInternalMask();
    }

    public String getMask() {
        return this.mask;
    }

    public void setValidCharacters(String validCharacters) {
        this.validCharacters = validCharacters;
    }

    public String getValidCharacters() {
        return this.validCharacters;
    }

    public void setInvalidCharacters(String invalidCharacters) {
        this.invalidCharacters = invalidCharacters;
    }

    public String getInvalidCharacters() {
        return this.invalidCharacters;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholderString = placeholder;
    }

    public String getPlaceholder() {
        return this.placeholderString;
    }

    public void setPlaceholderCharacter(char placeholder) {
        this.placeholder = placeholder;
    }

    public char getPlaceholderCharacter() {
        return this.placeholder;
    }

    public void setValueContainsLiteralCharacters(boolean containsLiteralChars) {
        this.containsLiteralChars = containsLiteralChars;
    }

    public boolean getValueContainsLiteralCharacters() {
        return this.containsLiteralChars;
    }

    public Object stringToValue(String value) throws ParseException {
        return this.stringToValue(value, true);
    }

    public String valueToString(Object value) throws ParseException {
        String sValue = value == null ? "" : value.toString();
        StringBuffer result = new StringBuffer();
        String placeholder = this.getPlaceholder();
        int[] valueCounter = new int[]{0};
        this.append(result, sValue, valueCounter, placeholder, this.maskChars);
        return result.toString();
    }

    public void install(JFormattedTextField ftf) {
        super.install(ftf);
        if (ftf != null) {
            Object value = ftf.getValue();
            try {
                this.stringToValue(this.valueToString(value));
            }
            catch (ParseException pe) {
                this.setEditValid(false);
            }
        }
    }

    private Object stringToValue(String value, boolean completeMatch) throws ParseException {
        int errorOffset = -1;
        errorOffset = this.getInvalidOffset(value, completeMatch);
        if (errorOffset == -1) {
            if (!this.getValueContainsLiteralCharacters()) {
                value = this.stripLiteralChars(value);
            }
            return super.stringToValue(value);
        }
        throw new ParseException("stringToValue passed invalid value", errorOffset);
    }

    private int getInvalidOffset(String string, boolean completeMatch) {
        int iLength = string.length();
        if (iLength != this.getMaxLength()) {
            return iLength;
        }
        int max = string.length();
        for (int counter = 0; counter < max; ++counter) {
            char aChar = string.charAt(counter);
            if (this.isValidCharacter(counter, aChar) || !completeMatch && this.isPlaceholder(counter, aChar)) continue;
            return counter;
        }
        return -1;
    }

    private void append(StringBuffer result, String value, int[] index, String placeholder, MaskCharacter[] mask) throws ParseException {
        int maxCounter = mask.length;
        for (int counter = 0; counter < maxCounter; ++counter) {
            mask[counter].append(result, value, index, placeholder);
        }
    }

    private void updateInternalMask() throws ParseException {
        ArrayList<MaskCharacter> fixed;
        String mask = this.getMask();
        ArrayList<MaskCharacter> temp = fixed = new ArrayList<MaskCharacter>();
        if (mask != null) {
            int maxCounter = mask.length();
            block10: for (int counter = 0; counter < maxCounter; ++counter) {
                char maskChar = mask.charAt(counter);
                switch (maskChar) {
                    case '#': {
                        temp.add(new DigitMaskCharacter());
                        continue block10;
                    }
                    case '\'': {
                        if (++counter >= maxCounter) continue block10;
                        maskChar = mask.charAt(counter);
                        temp.add(new LiteralCharacter(maskChar));
                        continue block10;
                    }
                    case 'U': {
                        temp.add(new UpperCaseCharacter());
                        continue block10;
                    }
                    case 'L': {
                        temp.add(new LowerCaseCharacter());
                        continue block10;
                    }
                    case 'A': {
                        temp.add(new AlphaNumericCharacter());
                        continue block10;
                    }
                    case '?': {
                        temp.add(new CharCharacter());
                        continue block10;
                    }
                    case '*': {
                        temp.add(new MaskCharacter());
                        continue block10;
                    }
                    case 'H': {
                        temp.add(new HexCharacter());
                        continue block10;
                    }
                    default: {
                        temp.add(new LiteralCharacter(maskChar));
                    }
                }
            }
        }
        if (fixed.size() == 0) {
            this.maskChars = EmptyMaskChars;
        } else {
            this.maskChars = new MaskCharacter[fixed.size()];
            fixed.toArray(this.maskChars);
        }
    }

    private MaskCharacter getMaskCharacter(int index) {
        if (index >= this.maskChars.length) {
            return null;
        }
        return this.maskChars[index];
    }

    private boolean isPlaceholder(int index, char aChar) {
        return this.getPlaceholderCharacter() == aChar;
    }

    private boolean isValidCharacter(int index, char aChar) {
        return this.getMaskCharacter(index).isValidCharacter(aChar);
    }

    private boolean isLiteral(int index) {
        return this.getMaskCharacter(index).isLiteral();
    }

    private int getMaxLength() {
        return this.maskChars.length;
    }

    private char getLiteral(int index) {
        return this.getMaskCharacter(index).getChar('\u0000');
    }

    private char getCharacter(int index, char aChar) {
        return this.getMaskCharacter(index).getChar(aChar);
    }

    private String stripLiteralChars(String string) {
        StringBuffer sb = null;
        int last = 0;
        int max = string.length();
        for (int counter = 0; counter < max; ++counter) {
            if (!this.isLiteral(counter)) continue;
            if (sb == null) {
                sb = new StringBuffer();
                if (counter > 0) {
                    sb.append(string.substring(0, counter));
                }
                last = counter + 1;
            } else if (last != counter) {
                sb.append(string.substring(last, counter));
            }
            last = counter + 1;
        }
        if (sb == null) {
            return string;
        }
        if (last != string.length()) {
            if (sb == null) {
                return string.substring(last);
            }
            sb.append(string.substring(last));
        }
        return sb.toString();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        try {
            this.updateInternalMask();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    boolean isNavigatable(int offset) {
        if (!this.getAllowsInvalid()) {
            return offset < this.getMaxLength() && !this.isLiteral(offset);
        }
        return true;
    }

    boolean isValidEdit(DefaultFormatter.ReplaceHolder rh) {
        if (!this.getAllowsInvalid()) {
            String newString = this.getReplaceString(rh.offset, rh.length, rh.text);
            try {
                rh.value = this.stringToValue(newString, false);
                return true;
            }
            catch (ParseException pe) {
                return false;
            }
        }
        return true;
    }

    boolean canReplace(DefaultFormatter.ReplaceHolder rh) {
        if (!this.getAllowsInvalid()) {
            int tl;
            StringBuffer replace = null;
            String text = rh.text;
            int n = tl = text != null ? text.length() : 0;
            if (tl == 0 && rh.length == 1 && this.getFormattedTextField().getSelectionStart() != rh.offset) {
                while (rh.offset > 0 && this.isLiteral(rh.offset)) {
                    --rh.offset;
                }
            }
            int max = Math.min(this.getMaxLength() - rh.offset, Math.max(tl, rh.length));
            int textIndex = 0;
            for (int counter = 0; counter < max; ++counter) {
                if (textIndex < tl && this.isValidCharacter(rh.offset + counter, text.charAt(textIndex))) {
                    char aChar = text.charAt(textIndex);
                    if (aChar != this.getCharacter(rh.offset + counter, aChar) && replace == null) {
                        replace = new StringBuffer();
                        if (textIndex > 0) {
                            replace.append(text.substring(0, textIndex));
                        }
                    }
                    if (replace != null) {
                        replace.append(this.getCharacter(rh.offset + counter, aChar));
                    }
                    ++textIndex;
                    continue;
                }
                if (this.isLiteral(rh.offset + counter)) {
                    if (replace != null) {
                        replace.append(this.getLiteral(rh.offset + counter));
                        if (textIndex >= tl) continue;
                        max = Math.min(max + 1, this.getMaxLength() - rh.offset);
                        continue;
                    }
                    if (textIndex > 0) {
                        replace = new StringBuffer(max);
                        replace.append(text.substring(0, textIndex));
                        replace.append(this.getLiteral(rh.offset + counter));
                        if (textIndex < tl) {
                            max = Math.min(max + 1, this.getMaxLength() - rh.offset);
                            continue;
                        }
                        if (rh.cursorPosition != -1) continue;
                        rh.cursorPosition = rh.offset + counter;
                        continue;
                    }
                    ++rh.offset;
                    --rh.length;
                    --counter;
                    --max;
                    continue;
                }
                if (textIndex >= tl) {
                    if (replace == null) {
                        replace = new StringBuffer();
                        if (text != null) {
                            replace.append(text);
                        }
                    }
                    replace.append(this.getPlaceholderCharacter());
                    if (tl <= 0 || rh.cursorPosition != -1) continue;
                    rh.cursorPosition = rh.offset + counter;
                    continue;
                }
                return false;
            }
            if (replace != null) {
                rh.text = replace.toString();
            } else if (text != null && rh.offset + tl > this.getMaxLength()) {
                rh.text = text.substring(0, this.getMaxLength() - rh.offset);
            }
            if (this.getOverwriteMode() && rh.text != null) {
                rh.length = rh.text.length();
            }
        }
        return super.canReplace(rh);
    }

    private class HexCharacter
    extends MaskCharacter {
        private HexCharacter() {
        }

        public boolean isValidCharacter(char aChar) {
            return (aChar == '0' || aChar == '1' || aChar == '2' || aChar == '3' || aChar == '4' || aChar == '5' || aChar == '6' || aChar == '7' || aChar == '8' || aChar == '9' || aChar == 'a' || aChar == 'A' || aChar == 'b' || aChar == 'B' || aChar == 'c' || aChar == 'C' || aChar == 'd' || aChar == 'D' || aChar == 'e' || aChar == 'E' || aChar == 'f' || aChar == 'F') && super.isValidCharacter(aChar);
        }

        public char getChar(char aChar) {
            if (Character.isDigit(aChar)) {
                return aChar;
            }
            return Character.toUpperCase(aChar);
        }
    }

    private class CharCharacter
    extends MaskCharacter {
        private CharCharacter() {
        }

        public boolean isValidCharacter(char aChar) {
            return Character.isLetter(aChar) && super.isValidCharacter(aChar);
        }
    }

    private class AlphaNumericCharacter
    extends MaskCharacter {
        private AlphaNumericCharacter() {
        }

        public boolean isValidCharacter(char aChar) {
            return Character.isLetterOrDigit(aChar) && super.isValidCharacter(aChar);
        }
    }

    private class LowerCaseCharacter
    extends MaskCharacter {
        private LowerCaseCharacter() {
        }

        public boolean isValidCharacter(char aChar) {
            return Character.isLetter(aChar) && super.isValidCharacter(aChar);
        }

        public char getChar(char aChar) {
            return Character.toLowerCase(aChar);
        }
    }

    private class UpperCaseCharacter
    extends MaskCharacter {
        private UpperCaseCharacter() {
        }

        public boolean isValidCharacter(char aChar) {
            return Character.isLetter(aChar) && super.isValidCharacter(aChar);
        }

        public char getChar(char aChar) {
            return Character.toUpperCase(aChar);
        }
    }

    private class DigitMaskCharacter
    extends MaskCharacter {
        private DigitMaskCharacter() {
        }

        public boolean isValidCharacter(char aChar) {
            return Character.isDigit(aChar) && super.isValidCharacter(aChar);
        }
    }

    private class LiteralCharacter
    extends MaskCharacter {
        private char fixedChar;

        public LiteralCharacter(char fixedChar) {
            this.fixedChar = fixedChar;
        }

        public boolean isLiteral() {
            return true;
        }

        public char getChar(char aChar) {
            return this.fixedChar;
        }
    }

    private class MaskCharacter {
        private MaskCharacter() {
        }

        public boolean isLiteral() {
            return false;
        }

        public boolean isValidCharacter(char aChar) {
            if (this.isLiteral()) {
                return this.getChar(aChar) == aChar;
            }
            aChar = this.getChar(aChar);
            String filter = MaskFormatter.this.getValidCharacters();
            if (filter != null && filter.indexOf(aChar) == -1) {
                return false;
            }
            filter = MaskFormatter.this.getInvalidCharacters();
            return filter == null || filter.indexOf(aChar) == -1;
        }

        public char getChar(char aChar) {
            return aChar;
        }

        public void append(StringBuffer buff, String formatting, int[] index, String placeholder) throws ParseException {
            char aChar;
            boolean inString = index[0] < formatting.length();
            char c = aChar = inString ? formatting.charAt(index[0]) : (char)'\u0000';
            if (this.isLiteral()) {
                buff.append(this.getChar(aChar));
                if (MaskFormatter.this.getValueContainsLiteralCharacters()) {
                    if (inString && aChar != this.getChar(aChar)) {
                        throw new ParseException("Invalid character: " + aChar, index[0]);
                    }
                    index[0] = index[0] + 1;
                }
            } else if (index[0] >= formatting.length()) {
                if (placeholder != null && index[0] < placeholder.length()) {
                    buff.append(placeholder.charAt(index[0]));
                } else {
                    buff.append(MaskFormatter.this.getPlaceholderCharacter());
                }
                index[0] = index[0] + 1;
            } else if (this.isValidCharacter(aChar)) {
                buff.append(this.getChar(aChar));
                index[0] = index[0] + 1;
            } else {
                throw new ParseException("Invalid character: " + aChar, index[0]);
            }
        }
    }
}

