/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.AttributedCharacterIterator;
import java.text.Format;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFormattedTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;

public class InternationalFormatter
extends DefaultFormatter {
    private static final Format.Field[] EMPTY_FIELD_ARRAY = new Format.Field[0];
    private Format format;
    private Comparable max;
    private Comparable min;
    private transient BitSet literalMask;
    private transient AttributedCharacterIterator iterator;
    private transient boolean validMask;
    private transient String string;
    private transient boolean ignoreDocumentMutate;

    public InternationalFormatter() {
        this.setOverwriteMode(false);
    }

    public InternationalFormatter(Format format) {
        this();
        this.setFormat(format);
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setMinimum(Comparable minimum) {
        if (this.getValueClass() == null && minimum != null) {
            this.setValueClass(minimum.getClass());
        }
        this.min = minimum;
    }

    public Comparable getMinimum() {
        return this.min;
    }

    public void setMaximum(Comparable max) {
        if (this.getValueClass() == null && max != null) {
            this.setValueClass(max.getClass());
        }
        this.max = max;
    }

    public Comparable getMaximum() {
        return this.max;
    }

    public void install(JFormattedTextField ftf) {
        super.install(ftf);
        this.updateMaskIfNecessary();
        this.positionCursorAtInitialLocation();
    }

    public String valueToString(Object value) throws ParseException {
        if (value == null) {
            return "";
        }
        Format f = this.getFormat();
        if (f == null) {
            return value.toString();
        }
        return f.format(value);
    }

    public Object stringToValue(String text) throws ParseException {
        Object value = this.stringToValue(text, this.getFormat());
        if (value != null && this.getValueClass() != null && !this.getValueClass().isInstance(value)) {
            value = super.stringToValue(value.toString());
        }
        try {
            if (!this.isValidValue(value, true)) {
                throw new ParseException("Value not within min/max range", 0);
            }
        }
        catch (ClassCastException cce) {
            throw new ParseException("Class cast exception comparing values: " + cce, 0);
        }
        return value;
    }

    public Format.Field[] getFields(int offset) {
        Map attrs;
        if (this.getAllowsInvalid()) {
            this.updateMask();
        }
        if ((attrs = this.getAttributes(offset)) != null && attrs.size() > 0) {
            ArrayList al = new ArrayList();
            al.addAll(attrs.keySet());
            return al.toArray(EMPTY_FIELD_ARRAY);
        }
        return EMPTY_FIELD_ARRAY;
    }

    public Object clone() throws CloneNotSupportedException {
        InternationalFormatter formatter = (InternationalFormatter)super.clone();
        formatter.literalMask = null;
        formatter.iterator = null;
        formatter.validMask = false;
        formatter.string = null;
        return formatter;
    }

    protected Action[] getActions() {
        if (this.getSupportsIncrement()) {
            return new Action[]{new IncrementAction("increment", 1), new IncrementAction("decrement", -1)};
        }
        return null;
    }

    Object stringToValue(String text, Format f) throws ParseException {
        if (f == null) {
            return text;
        }
        return f.parseObject(text);
    }

    boolean isValidValue(Object value, boolean wantsCCE) {
        Comparable min = this.getMinimum();
        try {
            if (min != null && min.compareTo(value) > 0) {
                return false;
            }
        }
        catch (ClassCastException cce) {
            if (wantsCCE) {
                throw cce;
            }
            return false;
        }
        Comparable max = this.getMaximum();
        try {
            if (max != null && max.compareTo(value) < 0) {
                return false;
            }
        }
        catch (ClassCastException cce) {
            if (wantsCCE) {
                throw cce;
            }
            return false;
        }
        return true;
    }

    Map getAttributes(int index) {
        if (this.isValidMask()) {
            AttributedCharacterIterator iterator = this.getIterator();
            if (index >= 0 && index <= iterator.getEndIndex()) {
                iterator.setIndex(index);
                return iterator.getAttributes();
            }
        }
        return null;
    }

    int getAttributeStart(AttributedCharacterIterator.Attribute id) {
        if (this.isValidMask()) {
            AttributedCharacterIterator iterator = this.getIterator();
            iterator.first();
            while (iterator.current() != '\uffff') {
                if (iterator.getAttribute(id) != null) {
                    return iterator.getIndex();
                }
                iterator.next();
            }
        }
        return -1;
    }

    AttributedCharacterIterator getIterator() {
        return this.iterator;
    }

    void updateMaskIfNecessary() {
        if (!this.getAllowsInvalid() && this.getFormat() != null) {
            if (!this.isValidMask()) {
                this.updateMask();
            } else {
                String newString = this.getFormattedTextField().getText();
                if (!newString.equals(this.string)) {
                    this.updateMask();
                }
            }
        }
    }

    void updateMask() {
        if (this.getFormat() != null) {
            Document doc = this.getFormattedTextField().getDocument();
            this.validMask = false;
            if (doc != null) {
                try {
                    this.string = doc.getText(0, doc.getLength());
                }
                catch (BadLocationException ble) {
                    this.string = null;
                }
                if (this.string != null) {
                    try {
                        Object value = this.stringToValue(this.string);
                        AttributedCharacterIterator iterator = this.getFormat().formatToCharacterIterator(value);
                        this.updateMask(iterator);
                    }
                    catch (ParseException pe) {
                    }
                    catch (IllegalArgumentException iae) {
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    int getLiteralCountTo(int index) {
        int lCount = 0;
        for (int counter = 0; counter < index; ++counter) {
            if (!this.isLiteral(counter)) continue;
            ++lCount;
        }
        return lCount;
    }

    boolean isLiteral(int index) {
        if (this.isValidMask() && index < this.string.length()) {
            return this.literalMask.get(index);
        }
        return false;
    }

    char getLiteral(int index) {
        if (this.isValidMask() && this.string != null && index < this.string.length()) {
            return this.string.charAt(index);
        }
        return '\u0000';
    }

    boolean isNavigatable(int offset) {
        return !this.isLiteral(offset);
    }

    void updateValue(Object value) {
        super.updateValue(value);
        this.updateMaskIfNecessary();
    }

    void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
        if (this.ignoreDocumentMutate) {
            fb.replace(offset, length, text, attrs);
            return;
        }
        super.replace(fb, offset, length, text, attrs);
    }

    private int getNextNonliteralIndex(int index, int direction) {
        int max = this.getFormattedTextField().getDocument().getLength();
        while (index >= 0 && index < max) {
            if (this.isLiteral(index)) {
                index += direction;
                continue;
            }
            return index;
        }
        return direction == -1 ? 0 : max;
    }

    boolean canReplace(DefaultFormatter.ReplaceHolder rh) {
        if (!this.getAllowsInvalid()) {
            int tl;
            String text = rh.text;
            int n = tl = text != null ? text.length() : 0;
            if (tl == 0 && rh.length == 1 && this.getFormattedTextField().getSelectionStart() != rh.offset) {
                rh.offset = this.getNextNonliteralIndex(rh.offset, -1);
            }
            if (this.getOverwriteMode()) {
                StringBuffer replace = null;
                int textIndex = 0;
                int max = Math.max(tl, rh.length);
                for (int counter = 0; counter < max; ++counter) {
                    if (this.isLiteral(rh.offset + counter)) {
                        if (replace != null) {
                            replace.append(this.getLiteral(rh.offset + counter));
                        }
                        if (textIndex < tl && text.charAt(textIndex) == this.getLiteral(rh.offset + counter)) {
                            ++textIndex;
                            continue;
                        }
                        if (textIndex == 0) {
                            ++rh.offset;
                            --rh.length;
                            --counter;
                            --max;
                            continue;
                        }
                        if (replace != null) continue;
                        replace = new StringBuffer(max);
                        replace.append(text.substring(0, textIndex));
                        replace.append(this.getLiteral(rh.offset + counter));
                        continue;
                    }
                    if (textIndex < tl) {
                        if (replace != null) {
                            replace.append(text.charAt(textIndex));
                        }
                        ++textIndex;
                        continue;
                    }
                    if (replace == null) {
                        replace = new StringBuffer(max);
                        if (textIndex > 0) {
                            replace.append(text.substring(0, textIndex));
                        }
                    }
                    if (replace == null) continue;
                    replace.append(' ');
                }
                if (replace != null) {
                    rh.text = replace.toString();
                }
            } else {
                rh.offset = tl > 0 ? this.getNextNonliteralIndex(rh.offset, 1) : this.getNextNonliteralIndex(rh.offset, -1);
            }
            ((ExtendedReplaceHolder)rh).endOffset = rh.offset;
            ((ExtendedReplaceHolder)rh).endTextLength = rh.text != null ? rh.text.length() : 0;
        } else {
            ((ExtendedReplaceHolder)rh).endOffset = rh.offset;
            ((ExtendedReplaceHolder)rh).endTextLength = rh.text != null ? rh.text.length() : 0;
        }
        boolean can = super.canReplace(rh);
        if (can && !this.getAllowsInvalid()) {
            ((ExtendedReplaceHolder)rh).resetFromValue(this);
        }
        return can;
    }

    boolean replace(DefaultFormatter.ReplaceHolder rh) throws BadLocationException {
        int start = -1;
        int direction = 1;
        int literalCount = -1;
        if (!(rh.length <= 0 || rh.text != null && rh.text.length() != 0 || this.getFormattedTextField().getSelectionStart() == rh.offset && rh.length <= 1)) {
            direction = -1;
        }
        if (!this.getAllowsInvalid()) {
            start = (rh.text == null || rh.text.length() == 0) && rh.length > 0 ? this.getFormattedTextField().getSelectionStart() : rh.offset;
            literalCount = this.getLiteralCountTo(start);
        }
        if (super.replace(rh)) {
            if (start != -1) {
                int end = ((ExtendedReplaceHolder)rh).endOffset;
                this.repositionCursor(literalCount, end += ((ExtendedReplaceHolder)rh).endTextLength, direction);
            } else {
                start = ((ExtendedReplaceHolder)rh).endOffset;
                if (direction == 1) {
                    start += ((ExtendedReplaceHolder)rh).endTextLength;
                }
                this.repositionCursor(start, direction);
            }
            return true;
        }
        return false;
    }

    private void repositionCursor(int startLiteralCount, int end, int direction) {
        int endLiteralCount = this.getLiteralCountTo(end);
        if (endLiteralCount != end) {
            end -= startLiteralCount;
            for (int counter = 0; counter < end; ++counter) {
                if (!this.isLiteral(counter)) continue;
                ++end;
            }
        }
        this.repositionCursor(end, 1);
    }

    char getBufferedChar(int index) {
        if (this.isValidMask() && this.string != null && index < this.string.length()) {
            return this.string.charAt(index);
        }
        return '\u0000';
    }

    boolean isValidMask() {
        return this.validMask;
    }

    boolean isLiteral(Map attributes) {
        return attributes == null || attributes.size() == 0;
    }

    private void updateMask(AttributedCharacterIterator iterator) {
        if (iterator != null) {
            this.validMask = true;
            this.iterator = iterator;
            if (this.literalMask == null) {
                this.literalMask = new BitSet();
            } else {
                for (int counter = this.literalMask.length() - 1; counter >= 0; --counter) {
                    this.literalMask.clear(counter);
                }
            }
            iterator.first();
            while (iterator.current() != '\uffff') {
                int start;
                Map<AttributedCharacterIterator.Attribute, Object> attributes = iterator.getAttributes();
                boolean set = this.isLiteral(attributes);
                int end = iterator.getRunLimit();
                for (start = iterator.getIndex(); start < end; ++start) {
                    if (set) {
                        this.literalMask.set(start);
                        continue;
                    }
                    this.literalMask.clear(start);
                }
                iterator.setIndex(start);
            }
        }
    }

    boolean canIncrement(Object field, int cursorPosition) {
        return field != null;
    }

    void selectField(Object f, int count) {
        AttributedCharacterIterator iterator = this.getIterator();
        if (iterator != null && f instanceof AttributedCharacterIterator.Attribute) {
            AttributedCharacterIterator.Attribute field = (AttributedCharacterIterator.Attribute)f;
            iterator.first();
            while (iterator.current() != '\uffff') {
                while (iterator.getAttribute(field) == null && iterator.next() != '\uffff') {
                }
                if (iterator.current() == '\uffff') continue;
                int limit = iterator.getRunLimit(field);
                if (--count <= 0) {
                    this.getFormattedTextField().select(iterator.getIndex(), limit);
                    break;
                }
                iterator.setIndex(limit);
                iterator.next();
            }
        }
    }

    Object getAdjustField(int start, Map attributes) {
        return null;
    }

    private int getFieldTypeCountTo(Object f, int start) {
        AttributedCharacterIterator iterator = this.getIterator();
        int count = 0;
        if (iterator != null && f instanceof AttributedCharacterIterator.Attribute) {
            AttributedCharacterIterator.Attribute field = (AttributedCharacterIterator.Attribute)f;
            boolean index = false;
            iterator.first();
            while (iterator.getIndex() < start) {
                while (iterator.getAttribute(field) == null && iterator.next() != '\uffff') {
                }
                if (iterator.current() == '\uffff') break;
                iterator.setIndex(iterator.getRunLimit(field));
                iterator.next();
                ++count;
            }
        }
        return count;
    }

    Object adjustValue(Object value, Map attributes, Object field, int direction) throws BadLocationException, ParseException {
        return null;
    }

    boolean getSupportsIncrement() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetValue(Object value) throws BadLocationException, ParseException {
        Document doc = this.getFormattedTextField().getDocument();
        String string = this.valueToString(value);
        try {
            this.ignoreDocumentMutate = true;
            doc.remove(0, doc.getLength());
            doc.insertString(0, string, null);
        }
        finally {
            this.ignoreDocumentMutate = false;
        }
        this.updateValue(value);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.updateMaskIfNecessary();
    }

    DefaultFormatter.ReplaceHolder getReplaceHolder(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) {
        if (this.replaceHolder == null) {
            this.replaceHolder = new ExtendedReplaceHolder();
        }
        return super.getReplaceHolder(fb, offset, length, text, attrs);
    }

    private class IncrementAction
    extends AbstractAction {
        private int direction;

        IncrementAction(String name, int direction) {
            super(name);
            this.direction = direction;
        }

        public void actionPerformed(ActionEvent ae) {
            if (InternationalFormatter.this.getFormattedTextField().isEditable()) {
                int start;
                if (InternationalFormatter.this.getAllowsInvalid()) {
                    InternationalFormatter.this.updateMask();
                }
                boolean validEdit = false;
                if (InternationalFormatter.this.isValidMask() && (start = InternationalFormatter.this.getFormattedTextField().getSelectionStart()) != -1) {
                    AttributedCharacterIterator iterator = InternationalFormatter.this.getIterator();
                    iterator.setIndex(start);
                    Map<AttributedCharacterIterator.Attribute, Object> attributes = iterator.getAttributes();
                    Object field = InternationalFormatter.this.getAdjustField(start, attributes);
                    if (InternationalFormatter.this.canIncrement(field, start)) {
                        try {
                            Object value = InternationalFormatter.this.stringToValue(InternationalFormatter.this.getFormattedTextField().getText());
                            int fieldTypeCount = InternationalFormatter.this.getFieldTypeCountTo(field, start);
                            value = InternationalFormatter.this.adjustValue(value, attributes, field, this.direction);
                            if (value != null && InternationalFormatter.this.isValidValue(value, false)) {
                                InternationalFormatter.this.resetValue(value);
                                InternationalFormatter.this.updateMask();
                                if (InternationalFormatter.this.isValidMask()) {
                                    InternationalFormatter.this.selectField(field, fieldTypeCount);
                                }
                                validEdit = true;
                            }
                        }
                        catch (ParseException pe) {
                        }
                        catch (BadLocationException ble) {
                            // empty catch block
                        }
                    }
                }
                if (!validEdit) {
                    InternationalFormatter.this.invalidEdit();
                }
            }
        }
    }

    static class ExtendedReplaceHolder
    extends DefaultFormatter.ReplaceHolder {
        int endOffset;
        int endTextLength;

        ExtendedReplaceHolder() {
        }

        void resetFromValue(InternationalFormatter formatter) {
            this.offset = 0;
            try {
                this.text = formatter.valueToString(this.value);
            }
            catch (ParseException pe) {
                this.text = "";
            }
            this.length = this.fb.getDocument().getLength();
        }
    }
}

