/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.Segment;

public abstract class AbstractWriter {
    private ElementIterator it;
    private Writer out;
    private int indentLevel = 0;
    private int indentSpace = 2;
    private Document doc = null;
    private int maxLineLength = 100;
    private int currLength = 0;
    private int startOffset = 0;
    private int endOffset = 0;
    private int offsetIndent = 0;
    private String lineSeparator;
    private boolean canWrapLines;
    private boolean isLineEmpty;
    private char[] indentChars;
    private char[] tempChars;
    private char[] newlineChars;
    private Segment segment;
    protected static final char NEWLINE = '\n';

    protected AbstractWriter(Writer w, Document doc) {
        this(w, doc, 0, doc.getLength());
    }

    protected AbstractWriter(Writer w, Document doc, int pos, int len) {
        this.doc = doc;
        this.it = new ElementIterator(doc.getDefaultRootElement());
        this.out = w;
        this.startOffset = pos;
        this.endOffset = pos + len;
        Object docNewline = doc.getProperty("__EndOfLine__");
        if (docNewline instanceof String) {
            this.setLineSeparator((String)docNewline);
        } else {
            String newline = null;
            try {
                newline = System.getProperty("line.separator");
            }
            catch (SecurityException se) {
                // empty catch block
            }
            if (newline == null) {
                newline = "\n";
            }
            this.setLineSeparator(newline);
        }
        this.canWrapLines = true;
    }

    protected AbstractWriter(Writer w, Element root) {
        this(w, root, 0, root.getEndOffset());
    }

    protected AbstractWriter(Writer w, Element root, int pos, int len) {
        this.doc = root.getDocument();
        this.it = new ElementIterator(root);
        this.out = w;
        this.startOffset = pos;
        this.endOffset = pos + len;
        this.canWrapLines = true;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    protected ElementIterator getElementIterator() {
        return this.it;
    }

    protected Writer getWriter() {
        return this.out;
    }

    protected Document getDocument() {
        return this.doc;
    }

    protected boolean inRange(Element next) {
        int startOffset = this.getStartOffset();
        int endOffset = this.getEndOffset();
        return next.getStartOffset() >= startOffset && next.getStartOffset() < endOffset || startOffset >= next.getStartOffset() && startOffset < next.getEndOffset();
    }

    protected abstract void write() throws IOException, BadLocationException;

    protected String getText(Element elem) throws BadLocationException {
        return this.doc.getText(elem.getStartOffset(), elem.getEndOffset() - elem.getStartOffset());
    }

    protected void text(Element elem) throws BadLocationException, IOException {
        int end;
        int start = Math.max(this.getStartOffset(), elem.getStartOffset());
        if (start < (end = Math.min(this.getEndOffset(), elem.getEndOffset()))) {
            if (this.segment == null) {
                this.segment = new Segment();
            }
            this.getDocument().getText(start, end - start, this.segment);
            if (this.segment.count > 0) {
                this.write(this.segment.array, this.segment.offset, this.segment.count);
            }
        }
    }

    protected void setLineLength(int l) {
        this.maxLineLength = l;
    }

    protected int getLineLength() {
        return this.maxLineLength;
    }

    protected void setCurrentLineLength(int length) {
        this.currLength = length;
        this.isLineEmpty = this.currLength == 0;
    }

    protected int getCurrentLineLength() {
        return this.currLength;
    }

    protected boolean isLineEmpty() {
        return this.isLineEmpty;
    }

    protected void setCanWrapLines(boolean newValue) {
        this.canWrapLines = newValue;
    }

    protected boolean getCanWrapLines() {
        return this.canWrapLines;
    }

    protected void setIndentSpace(int space) {
        this.indentSpace = space;
    }

    protected int getIndentSpace() {
        return this.indentSpace;
    }

    public void setLineSeparator(String value) {
        this.lineSeparator = value;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    protected void incrIndent() {
        if (this.offsetIndent > 0) {
            ++this.offsetIndent;
        } else if (++this.indentLevel * this.getIndentSpace() >= this.getLineLength()) {
            ++this.offsetIndent;
            --this.indentLevel;
        }
    }

    protected void decrIndent() {
        if (this.offsetIndent > 0) {
            --this.offsetIndent;
        } else {
            --this.indentLevel;
        }
    }

    protected int getIndentLevel() {
        return this.indentLevel;
    }

    protected void indent() throws IOException {
        int max = this.getIndentLevel() * this.getIndentSpace();
        if (this.indentChars == null || max > this.indentChars.length) {
            this.indentChars = new char[max];
            for (int counter = 0; counter < max; ++counter) {
                this.indentChars[counter] = 32;
            }
        }
        int length = this.getCurrentLineLength();
        boolean wasEmpty = this.isLineEmpty();
        this.output(this.indentChars, 0, max);
        if (wasEmpty && length == 0) {
            this.isLineEmpty = true;
        }
    }

    protected void write(char ch) throws IOException {
        if (this.tempChars == null) {
            this.tempChars = new char[128];
        }
        this.tempChars[0] = ch;
        this.write(this.tempChars, 0, 1);
    }

    protected void write(String content) throws IOException {
        if (content == null) {
            return;
        }
        int size = content.length();
        if (this.tempChars == null || this.tempChars.length < size) {
            this.tempChars = new char[size];
        }
        content.getChars(0, size, this.tempChars, 0);
        this.write(this.tempChars, 0, size);
    }

    protected void writeLineSeparator() throws IOException {
        String newline = this.getLineSeparator();
        int length = newline.length();
        if (this.newlineChars == null || this.newlineChars.length < length) {
            this.newlineChars = new char[length];
        }
        newline.getChars(0, length, this.newlineChars, 0);
        this.output(this.newlineChars, 0, length);
        this.setCurrentLineLength(0);
    }

    protected void write(char[] chars, int startIndex, int length) throws IOException {
        if (!this.getCanWrapLines()) {
            int lastIndex = startIndex;
            int endIndex = startIndex + length;
            int newlineIndex = this.indexOf(chars, '\n', startIndex, endIndex);
            while (newlineIndex != -1) {
                if (newlineIndex > lastIndex) {
                    this.output(chars, lastIndex, newlineIndex - lastIndex);
                }
                this.writeLineSeparator();
                lastIndex = newlineIndex + 1;
                newlineIndex = this.indexOf(chars, '\n', lastIndex, endIndex);
            }
            if (lastIndex < endIndex) {
                this.output(chars, lastIndex, endIndex - lastIndex);
            }
        } else {
            int lastIndex = startIndex;
            int endIndex = startIndex + length;
            int lineLength = this.getCurrentLineLength();
            int maxLength = this.getLineLength();
            while (lastIndex < endIndex) {
                int newlineIndex = this.indexOf(chars, '\n', lastIndex, endIndex);
                boolean needsNewline = false;
                boolean forceNewLine = false;
                lineLength = this.getCurrentLineLength();
                if (newlineIndex != -1 && lineLength + (newlineIndex - lastIndex) < maxLength) {
                    if (newlineIndex > lastIndex) {
                        this.output(chars, lastIndex, newlineIndex - lastIndex);
                    }
                    lastIndex = newlineIndex + 1;
                    forceNewLine = true;
                } else if (newlineIndex == -1 && lineLength + (endIndex - lastIndex) < maxLength) {
                    if (endIndex > lastIndex) {
                        this.output(chars, lastIndex, endIndex - lastIndex);
                    }
                    lastIndex = endIndex;
                } else {
                    int counter;
                    int breakPoint = -1;
                    int maxBreak = Math.min(endIndex - lastIndex, maxLength - lineLength - 1);
                    for (counter = 0; counter < maxBreak; ++counter) {
                        if (!Character.isWhitespace(chars[counter + lastIndex])) continue;
                        breakPoint = counter;
                    }
                    if (breakPoint != -1) {
                        this.output(chars, lastIndex, (breakPoint += lastIndex + 1) - lastIndex);
                        lastIndex = breakPoint;
                        needsNewline = true;
                    } else {
                        counter = Math.max(0, maxBreak);
                        maxBreak = endIndex - lastIndex;
                        while (counter < maxBreak) {
                            if (Character.isWhitespace(chars[counter + lastIndex])) {
                                breakPoint = counter;
                                break;
                            }
                            ++counter;
                        }
                        if (breakPoint == -1) {
                            this.output(chars, lastIndex, endIndex - lastIndex);
                            breakPoint = endIndex;
                        } else if (chars[breakPoint += lastIndex] == '\n') {
                            this.output(chars, lastIndex, breakPoint++ - lastIndex);
                            forceNewLine = true;
                        } else {
                            this.output(chars, lastIndex, ++breakPoint - lastIndex);
                            needsNewline = true;
                        }
                        lastIndex = breakPoint;
                    }
                }
                if (!forceNewLine && !needsNewline && lastIndex >= endIndex) continue;
                this.writeLineSeparator();
                if (lastIndex >= endIndex && forceNewLine) continue;
                this.indent();
            }
        }
    }

    protected void writeAttributes(AttributeSet attr) throws IOException {
        Enumeration<?> names = attr.getAttributeNames();
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            this.write(" " + name + "=" + attr.getAttribute(name));
        }
    }

    protected void output(char[] content, int start, int length) throws IOException {
        this.getWriter().write(content, start, length);
        this.setCurrentLineLength(this.getCurrentLineLength() + length);
    }

    private int indexOf(char[] chars, char sChar, int startIndex, int endIndex) {
        while (startIndex < endIndex) {
            if (chars[startIndex] == sChar) {
                return startIndex;
            }
            ++startIndex;
        }
        return -1;
    }
}

