/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.SwingUtilities2;
import sun.swing.plaf.synth.SynthUI;

class SynthSliderUI
extends BasicSliderUI
implements PropertyChangeListener,
SynthUI {
    protected Dimension contentDim = new Dimension();
    protected Rectangle valueRect = new Rectangle();
    protected boolean paintValue;
    private int trackHeight;
    private int trackBorder;
    private int thumbWidth;
    private int thumbHeight;
    private SynthStyle style;
    private SynthStyle sliderTrackStyle;
    private SynthStyle sliderThumbStyle;
    private transient boolean thumbActive;
    private static Rectangle unionRect = new Rectangle();

    public static ComponentUI createUI(JComponent c) {
        return new SynthSliderUI((JSlider)c);
    }

    public SynthSliderUI(JSlider c) {
        super(c);
    }

    protected void installDefaults(JSlider slider) {
        this.updateStyle(slider);
    }

    protected void uninstallDefaults() {
        SynthContext context = this.getContext((JComponent)this.slider, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
        context = this.getContext(this.slider, Region.SLIDER_TRACK, 1);
        this.sliderTrackStyle.uninstallDefaults(context);
        context.dispose();
        this.sliderTrackStyle = null;
        context = this.getContext(this.slider, Region.SLIDER_THUMB, 1);
        this.sliderThumbStyle.uninstallDefaults(context);
        context.dispose();
        this.sliderThumbStyle = null;
    }

    protected void installListeners(JSlider slider) {
        super.installListeners(slider);
        slider.addPropertyChangeListener(this);
    }

    protected void uninstallListeners(JSlider slider) {
        slider.removePropertyChangeListener(this);
        super.uninstallListeners(slider);
    }

    private void updateStyle(JSlider c) {
        SynthContext context = this.getContext((JComponent)c, 1);
        SynthStyle oldStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle) {
            this.thumbWidth = this.style.getInt(context, "Slider.thumbWidth", 30);
            this.thumbHeight = this.style.getInt(context, "Slider.thumbHeight", 14);
            this.trackBorder = this.style.getInt(context, "Slider.trackBorder", 1);
            this.trackHeight = this.thumbHeight + this.trackBorder * 2;
            this.paintValue = this.style.getBoolean(context, "Slider.paintValue", true);
            if (oldStyle != null) {
                this.uninstallKeyboardActions(c);
                this.installKeyboardActions(c);
            }
        }
        context.dispose();
        context = this.getContext(c, Region.SLIDER_TRACK, 1);
        this.sliderTrackStyle = SynthLookAndFeel.updateStyle(context, this);
        context.dispose();
        context = this.getContext(c, Region.SLIDER_THUMB, 1);
        this.sliderThumbStyle = SynthLookAndFeel.updateStyle(context, this);
        context.dispose();
    }

    protected BasicSliderUI.TrackListener createTrackListener(JSlider s) {
        return new SynthTrackListener();
    }

    private void updateThumbState(int x, int y) {
        this.setThumbActive(this.thumbRect.contains(x, y));
    }

    private void setThumbActive(boolean active) {
        if (this.thumbActive != active) {
            this.thumbActive = active;
            this.slider.repaint(this.thumbRect);
        }
    }

    public int getBaseline(JComponent c, int width, int height) {
        if (c == null) {
            throw new NullPointerException("Component must be non-null");
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("Width and height must be >= 0");
        }
        if (this.slider.getPaintLabels() && this.labelsHaveSameBaselines()) {
            Integer value;
            Insets trackInsets = new Insets(0, 0, 0, 0);
            SynthContext trackContext = this.getContext((JComponent)this.slider, Region.SLIDER_TRACK);
            this.style.getInsets(trackContext, trackInsets);
            trackContext.dispose();
            if (this.slider.getOrientation() == 0) {
                int valueHeight = 0;
                if (this.paintValue) {
                    SynthContext context = this.getContext(this.slider);
                    valueHeight = context.getStyle().getGraphicsUtils(context).getMaximumCharHeight(context);
                    context.dispose();
                }
                int tickHeight = 0;
                if (this.slider.getPaintTicks()) {
                    tickHeight = this.getTickLength();
                }
                int labelHeight = this.getHeightOfTallestLabel();
                int contentHeight = valueHeight + this.trackHeight + trackInsets.top + trackInsets.bottom + tickHeight + labelHeight + 4;
                int centerY = height / 2 - contentHeight / 2;
                centerY += valueHeight + 2;
                centerY += this.trackHeight + trackInsets.top + trackInsets.bottom;
                Component label = (Component)this.slider.getLabelTable().elements().nextElement();
                Dimension pref = label.getPreferredSize();
                return (centerY += tickHeight + 2) + label.getBaseline(pref.width, pref.height);
            }
            Integer n = value = this.slider.getInverted() ? this.getLowestValue() : this.getHighestValue();
            if (value != null) {
                int valueY = this.insetCache.top;
                int valueHeight = 0;
                if (this.paintValue) {
                    SynthContext context = this.getContext(this.slider);
                    valueHeight = context.getStyle().getGraphicsUtils(context).getMaximumCharHeight(context);
                    context.dispose();
                }
                int contentHeight = height - this.insetCache.top - this.insetCache.bottom;
                int trackY = valueY + valueHeight;
                int trackHeight = contentHeight - valueHeight;
                int yPosition = this.yPositionForValue(value, trackY, trackHeight);
                Component label = (Component)this.slider.getLabelTable().get(value);
                Dimension pref = label.getPreferredSize();
                return yPosition - pref.height / 2 + label.getBaseline(pref.width, pref.height);
            }
        }
        return -1;
    }

    public Dimension getPreferredSize(JComponent c) {
        this.recalculateIfInsetsChanged();
        Dimension d = new Dimension(this.contentDim);
        if (this.slider.getOrientation() == 1) {
            d.height = 200;
        } else {
            d.width = 200;
        }
        Insets i = this.slider.getInsets();
        d.width += i.left + i.right;
        d.height += i.top + i.bottom;
        return d;
    }

    public Dimension getMinimumSize(JComponent c) {
        this.recalculateIfInsetsChanged();
        Dimension d = new Dimension(this.contentDim);
        if (this.slider.getOrientation() == 1) {
            d.height = this.thumbRect.height + this.insetCache.top + this.insetCache.bottom;
        } else {
            d.width = this.thumbRect.width + this.insetCache.left + this.insetCache.right;
        }
        return d;
    }

    protected void calculateGeometry() {
        this.layout();
        this.calculateThumbLocation();
    }

    protected void layout() {
        SynthContext context = this.getContext(this.slider);
        SynthGraphicsUtils synthGraphics = this.style.getGraphicsUtils(context);
        Dimension size = this.getThumbSize();
        this.thumbRect.setSize(size.width, size.height);
        Insets trackInsets = new Insets(0, 0, 0, 0);
        SynthContext trackContext = this.getContext((JComponent)this.slider, Region.SLIDER_TRACK);
        this.style.getInsets(trackContext, trackInsets);
        trackContext.dispose();
        if (this.slider.getOrientation() == 0) {
            int centerY;
            this.valueRect.height = 0;
            if (this.paintValue) {
                this.valueRect.height = synthGraphics.getMaximumCharHeight(context);
            }
            this.trackRect.height = this.trackHeight;
            this.tickRect.height = 0;
            if (this.slider.getPaintTicks()) {
                this.tickRect.height = this.getTickLength();
            }
            this.labelRect.height = 0;
            if (this.slider.getPaintLabels()) {
                this.labelRect.height = this.getHeightOfTallestLabel();
            }
            this.contentDim.height = this.valueRect.height + this.trackRect.height + trackInsets.top + trackInsets.bottom + this.tickRect.height + this.labelRect.height + 4;
            this.contentDim.width = this.slider.getWidth() - this.insetCache.left - this.insetCache.right;
            int pad = 0;
            if (this.slider.getPaintLabels()) {
                this.trackRect.x = this.insetCache.left;
                this.trackRect.width = this.contentDim.width;
                Dictionary dictionary = this.slider.getLabelTable();
                if (dictionary != null) {
                    int minValue = this.slider.getMinimum();
                    int maxValue = this.slider.getMaximum();
                    int firstLblIdx = Integer.MAX_VALUE;
                    int lastLblIdx = Integer.MIN_VALUE;
                    Enumeration keys = dictionary.keys();
                    while (keys.hasMoreElements()) {
                        int keyInt = (Integer)keys.nextElement();
                        if (keyInt >= minValue && keyInt < firstLblIdx) {
                            firstLblIdx = keyInt;
                        }
                        if (keyInt > maxValue || keyInt <= lastLblIdx) continue;
                        lastLblIdx = keyInt;
                    }
                    pad = this.getPadForLabel(firstLblIdx);
                    pad = Math.max(pad, this.getPadForLabel(lastLblIdx));
                }
            }
            this.tickRect.x = this.labelRect.x = this.insetCache.left + pad;
            this.trackRect.x = this.labelRect.x;
            this.valueRect.x = this.labelRect.x;
            this.tickRect.width = this.labelRect.width = this.contentDim.width - pad * 2;
            this.trackRect.width = this.labelRect.width;
            this.valueRect.width = this.labelRect.width;
            this.valueRect.y = centerY = this.slider.getHeight() / 2 - this.contentDim.height / 2;
            this.trackRect.y = (centerY += this.valueRect.height + 2) + trackInsets.top;
            this.tickRect.y = centerY += this.trackRect.height + trackInsets.top + trackInsets.bottom;
            this.labelRect.y = centerY += this.tickRect.height + 2;
            centerY += this.labelRect.height;
        } else {
            this.trackRect.width = this.trackHeight;
            this.tickRect.width = 0;
            if (this.slider.getPaintTicks()) {
                this.tickRect.width = this.getTickLength();
            }
            this.labelRect.width = 0;
            if (this.slider.getPaintLabels()) {
                this.labelRect.width = this.getWidthOfWidestLabel();
            }
            this.valueRect.y = this.insetCache.top;
            this.valueRect.height = 0;
            if (this.paintValue) {
                this.valueRect.height = synthGraphics.getMaximumCharHeight(context);
            }
            FontMetrics fm = this.slider.getFontMetrics(this.slider.getFont());
            this.valueRect.width = Math.max(synthGraphics.computeStringWidth(context, this.slider.getFont(), fm, "" + this.slider.getMaximum()), synthGraphics.computeStringWidth(context, this.slider.getFont(), fm, "" + this.slider.getMinimum()));
            int l = this.valueRect.width / 2;
            int w1 = trackInsets.left + this.trackRect.width / 2;
            int w2 = this.trackRect.width / 2 + trackInsets.right + this.tickRect.width + this.labelRect.width;
            this.contentDim.width = Math.max(w1, l) + Math.max(w2, l) + 2 + this.insetCache.left + this.insetCache.right;
            this.contentDim.height = this.slider.getHeight() - this.insetCache.top - this.insetCache.bottom;
            this.tickRect.y = this.labelRect.y = this.valueRect.y + this.valueRect.height;
            this.trackRect.y = this.labelRect.y;
            this.tickRect.height = this.labelRect.height = this.contentDim.height - this.valueRect.height;
            this.trackRect.height = this.labelRect.height;
            int startX = this.slider.getWidth() / 2 - this.contentDim.width / 2;
            if (SynthLookAndFeel.isLeftToRight(this.slider)) {
                if (l > w1) {
                    startX += l - w1;
                }
                this.trackRect.x = startX + trackInsets.left;
                this.tickRect.x = startX += trackInsets.left + this.trackRect.width + trackInsets.right;
                this.labelRect.x = startX + this.tickRect.width + 2;
            } else {
                if (l > w2) {
                    startX += l - w2;
                }
                this.labelRect.x = startX;
                this.tickRect.x = startX += this.labelRect.width + 2;
                this.trackRect.x = startX + this.tickRect.width + trackInsets.left;
            }
        }
        context.dispose();
    }

    private int getPadForLabel(int i) {
        Dictionary dictionary = this.slider.getLabelTable();
        int pad = 0;
        Object o = dictionary.get(i);
        if (o != null) {
            int cHalfWidth;
            Component c = (Component)o;
            int centerX = this.xPositionForValue(i);
            if (centerX - (cHalfWidth = c.getPreferredSize().width / 2) < this.insetCache.left) {
                pad = Math.max(pad, this.insetCache.left - (centerX - cHalfWidth));
            }
            if (centerX + cHalfWidth > this.slider.getWidth() - this.insetCache.right) {
                pad = Math.max(pad, centerX + cHalfWidth - (this.slider.getWidth() - this.insetCache.right));
            }
        }
        return pad;
    }

    protected void calculateThumbLocation() {
        super.calculateThumbLocation();
        if (this.slider.getOrientation() == 0) {
            this.thumbRect.y += this.trackBorder;
        } else {
            this.thumbRect.x += this.trackBorder;
        }
        Point mousePosition = this.slider.getMousePosition();
        if (mousePosition != null) {
            this.updateThumbState(mousePosition.x, mousePosition.y);
        }
    }

    protected void calculateTickRect() {
        if (this.slider.getOrientation() == 0) {
            this.tickRect.x = this.trackRect.x;
            this.tickRect.y = this.trackRect.y + this.trackRect.height + 2 + this.getTickLength();
            this.tickRect.width = this.trackRect.width;
            this.tickRect.height = this.getTickLength();
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.y;
                this.tickRect.height = 0;
            }
        } else {
            if (SynthLookAndFeel.isLeftToRight(this.slider)) {
                this.tickRect.x = this.trackRect.x + this.trackRect.width;
                this.tickRect.width = this.getTickLength();
            } else {
                this.tickRect.width = this.getTickLength();
                this.tickRect.x = this.trackRect.x - this.tickRect.width;
            }
            this.tickRect.y = this.trackRect.y;
            this.tickRect.height = this.trackRect.height;
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.x;
                this.tickRect.width = 0;
            }
        }
    }

    public void setThumbLocation(int x, int y) {
        super.setThumbLocation(x, y);
        this.slider.repaint(this.valueRect.x, this.valueRect.y, this.valueRect.width, this.valueRect.height);
        this.setThumbActive(false);
    }

    protected int xPositionForValue(int value) {
        int xPosition;
        int min = this.slider.getMinimum();
        int max = this.slider.getMaximum();
        int trackLeft = this.trackRect.x + this.thumbRect.width / 2 + this.trackBorder;
        int trackRight = this.trackRect.x + this.trackRect.width - this.thumbRect.width / 2 - this.trackBorder;
        int trackLength = trackRight - trackLeft;
        double valueRange = (double)max - (double)min;
        double pixelsPerValue = (double)trackLength / valueRange;
        if (!this.drawInverted()) {
            xPosition = trackLeft;
            xPosition = (int)((long)xPosition + Math.round(pixelsPerValue * ((double)value - (double)min)));
        } else {
            xPosition = trackRight;
            xPosition = (int)((long)xPosition - Math.round(pixelsPerValue * ((double)value - (double)min)));
        }
        xPosition = Math.max(trackLeft, xPosition);
        xPosition = Math.min(trackRight, xPosition);
        return xPosition;
    }

    protected int yPositionForValue(int value, int trackY, int trackHeight) {
        int yPosition;
        int min = this.slider.getMinimum();
        int max = this.slider.getMaximum();
        int trackTop = trackY + this.thumbRect.height / 2 + this.trackBorder;
        int trackBottom = trackY + trackHeight - this.thumbRect.height / 2 - this.trackBorder;
        int trackLength = trackBottom - trackTop;
        double valueRange = (double)max - (double)min;
        double pixelsPerValue = (double)trackLength / valueRange;
        if (!this.drawInverted()) {
            yPosition = trackTop;
            yPosition = (int)((long)yPosition + Math.round(pixelsPerValue * ((double)max - (double)value)));
        } else {
            yPosition = trackTop;
            yPosition = (int)((long)yPosition + Math.round(pixelsPerValue * ((double)value - (double)min)));
        }
        yPosition = Math.max(trackTop, yPosition);
        yPosition = Math.min(trackBottom, yPosition);
        return yPosition;
    }

    public int valueForYPosition(int yPos) {
        int value;
        int minValue = this.slider.getMinimum();
        int maxValue = this.slider.getMaximum();
        int trackTop = this.trackRect.y + this.thumbRect.height / 2 + this.trackBorder;
        int trackBottom = this.trackRect.y + this.trackRect.height - this.thumbRect.height / 2 - this.trackBorder;
        int trackLength = trackBottom - trackTop;
        if (yPos <= trackTop) {
            value = this.drawInverted() ? minValue : maxValue;
        } else if (yPos >= trackBottom) {
            value = this.drawInverted() ? maxValue : minValue;
        } else {
            int distanceFromTrackTop = yPos - trackTop;
            double valueRange = (double)maxValue - (double)minValue;
            double valuePerPixel = valueRange / (double)trackLength;
            int valueFromTrackTop = (int)Math.round((double)distanceFromTrackTop * valuePerPixel);
            value = this.drawInverted() ? minValue + valueFromTrackTop : maxValue - valueFromTrackTop;
        }
        return value;
    }

    public int valueForXPosition(int xPos) {
        int value;
        int minValue = this.slider.getMinimum();
        int maxValue = this.slider.getMaximum();
        int trackLeft = this.trackRect.x + this.thumbRect.width / 2 + this.trackBorder;
        int trackRight = this.trackRect.x + this.trackRect.width - this.thumbRect.width / 2 - this.trackBorder;
        int trackLength = trackRight - trackLeft;
        if (xPos <= trackLeft) {
            value = this.drawInverted() ? maxValue : minValue;
        } else if (xPos >= trackRight) {
            value = this.drawInverted() ? minValue : maxValue;
        } else {
            int distanceFromTrackLeft = xPos - trackLeft;
            double valueRange = (double)maxValue - (double)minValue;
            double valuePerPixel = valueRange / (double)trackLength;
            int valueFromTrackLeft = (int)Math.round((double)distanceFromTrackLeft * valuePerPixel);
            value = this.drawInverted() ? maxValue - valueFromTrackLeft : minValue + valueFromTrackLeft;
        }
        return value;
    }

    protected Dimension getThumbSize() {
        Dimension size = new Dimension();
        if (this.slider.getOrientation() == 1) {
            size.width = this.thumbHeight;
            size.height = this.thumbWidth;
        } else {
            size.width = this.thumbWidth;
            size.height = this.thumbHeight;
        }
        return size;
    }

    protected void recalculateIfInsetsChanged() {
        SynthContext context = this.getContext(this.slider);
        Insets newInsets = this.style.getInsets(context, null);
        Insets compInsets = this.slider.getInsets();
        newInsets.left += compInsets.left;
        newInsets.right += compInsets.right;
        newInsets.top += compInsets.top;
        newInsets.bottom += compInsets.bottom;
        if (!newInsets.equals(this.insetCache)) {
            this.insetCache = newInsets;
            this.calculateGeometry();
        }
        context.dispose();
    }

    public Region getRegion(JComponent c) {
        return SynthLookAndFeel.getRegion(c);
    }

    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    public SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(SynthContext.class, c, SynthLookAndFeel.getRegion(c), this.style, state);
    }

    public SynthContext getContext(JComponent c, Region subregion) {
        return this.getContext(c, subregion, this.getComponentState(c, subregion));
    }

    private SynthContext getContext(JComponent c, Region subregion, int state) {
        SynthStyle style = null;
        Class<SynthContext> klass = SynthContext.class;
        if (subregion == Region.SLIDER_TRACK) {
            style = this.sliderTrackStyle;
        } else if (subregion == Region.SLIDER_THUMB) {
            style = this.sliderThumbStyle;
        }
        return SynthContext.getContext(klass, c, subregion, style, state);
    }

    public int getComponentState(JComponent c) {
        return SynthLookAndFeel.getComponentState(c);
    }

    private int getComponentState(JComponent c, Region region) {
        if (region == Region.SLIDER_THUMB && this.thumbActive && c.isEnabled()) {
            return 2;
        }
        return SynthLookAndFeel.getComponentState(c);
    }

    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintSliderBackground(context, g, 0, 0, c.getWidth(), c.getHeight(), this.slider.getOrientation());
        this.paint(context, g);
        context.dispose();
    }

    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    public void paint(SynthContext context, Graphics g) {
        this.recalculateIfInsetsChanged();
        this.recalculateIfOrientationChanged();
        Rectangle clip = g.getClipBounds();
        if (this.paintValue) {
            FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)this.slider, g);
            int labelWidth = context.getStyle().getGraphicsUtils(context).computeStringWidth(context, g.getFont(), fm, "" + this.slider.getValue());
            this.valueRect.x = this.thumbRect.x + (this.thumbRect.width - labelWidth) / 2;
            if (this.slider.getOrientation() == 0) {
                if (this.valueRect.x + labelWidth > this.insetCache.left + this.contentDim.width) {
                    this.valueRect.x = this.insetCache.left + this.contentDim.width - labelWidth;
                }
                this.valueRect.x = Math.max(this.valueRect.x, 0);
            }
            g.setColor(context.getStyle().getColor(context, ColorType.TEXT_FOREGROUND));
            context.getStyle().getGraphicsUtils(context).paintText(context, g, "" + this.slider.getValue(), this.valueRect.x, this.valueRect.y, -1);
        }
        SynthContext subcontext = this.getContext((JComponent)this.slider, Region.SLIDER_TRACK);
        this.paintTrack(subcontext, g, this.trackRect);
        subcontext.dispose();
        subcontext = this.getContext((JComponent)this.slider, Region.SLIDER_THUMB);
        this.paintThumb(subcontext, g, this.thumbRect);
        subcontext.dispose();
        if (this.slider.getPaintTicks() && clip.intersects(this.tickRect)) {
            this.paintTicks(g);
        }
        if (this.slider.getPaintLabels() && clip.intersects(this.labelRect)) {
            this.paintLabels(g);
        }
    }

    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintSliderBorder(context, g, x, y, w, h, this.slider.getOrientation());
    }

    public void paintThumb(SynthContext context, Graphics g, Rectangle thumbBounds) {
        int orientation = this.slider.getOrientation();
        SynthLookAndFeel.updateSubregion(context, g, thumbBounds);
        context.getPainter().paintSliderThumbBackground(context, g, thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height, orientation);
        context.getPainter().paintSliderThumbBorder(context, g, thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height, orientation);
    }

    public void paintTrack(SynthContext context, Graphics g, Rectangle trackBounds) {
        int orientation = this.slider.getOrientation();
        SynthLookAndFeel.updateSubregion(context, g, trackBounds);
        context.getPainter().paintSliderTrackBackground(context, g, trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height, orientation);
        context.getPainter().paintSliderTrackBorder(context, g, trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height, orientation);
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (SynthLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle((JSlider)e.getSource());
        }
    }

    protected class SynthTrackListener
    extends BasicSliderUI.TrackListener {
        protected SynthTrackListener() {
            super(SynthSliderUI.this);
        }

        public void mouseExited(MouseEvent e) {
            SynthSliderUI.this.setThumbActive(false);
        }

        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            SynthSliderUI.this.updateThumbState(e.getX(), e.getY());
        }

        public void mouseDragged(MouseEvent e) {
            int thumbMiddle = 0;
            if (!SynthSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (!SynthSliderUI.this.isDragging()) {
                return;
            }
            SynthSliderUI.this.slider.setValueIsAdjusting(true);
            switch (SynthSliderUI.this.slider.getOrientation()) {
                case 1: {
                    int halfThumbHeight = ((SynthSliderUI)SynthSliderUI.this).thumbRect.height / 2;
                    int thumbTop = e.getY() - this.offset;
                    int trackTop = ((SynthSliderUI)SynthSliderUI.this).trackRect.y;
                    int trackBottom = ((SynthSliderUI)SynthSliderUI.this).trackRect.y + ((SynthSliderUI)SynthSliderUI.this).trackRect.height - halfThumbHeight - SynthSliderUI.this.trackBorder;
                    int vMax = SynthSliderUI.this.yPositionForValue(SynthSliderUI.this.slider.getMaximum() - SynthSliderUI.this.slider.getExtent());
                    if (SynthSliderUI.this.drawInverted()) {
                        trackBottom = vMax;
                    } else {
                        trackTop = vMax;
                    }
                    thumbTop = Math.max(thumbTop, trackTop - halfThumbHeight);
                    thumbTop = Math.min(thumbTop, trackBottom - halfThumbHeight);
                    SynthSliderUI.this.setThumbLocation(((SynthSliderUI)SynthSliderUI.this).thumbRect.x, thumbTop);
                    thumbMiddle = thumbTop + halfThumbHeight;
                    SynthSliderUI.this.slider.setValue(SynthSliderUI.this.valueForYPosition(thumbMiddle));
                    break;
                }
                case 0: {
                    int halfThumbWidth = ((SynthSliderUI)SynthSliderUI.this).thumbRect.width / 2;
                    int thumbLeft = e.getX() - this.offset;
                    int trackLeft = ((SynthSliderUI)SynthSliderUI.this).trackRect.x + halfThumbWidth + SynthSliderUI.this.trackBorder;
                    int trackRight = ((SynthSliderUI)SynthSliderUI.this).trackRect.x + ((SynthSliderUI)SynthSliderUI.this).trackRect.width - halfThumbWidth - SynthSliderUI.this.trackBorder;
                    int hMax = SynthSliderUI.this.xPositionForValue(SynthSliderUI.this.slider.getMaximum() - SynthSliderUI.this.slider.getExtent());
                    if (SynthSliderUI.this.drawInverted()) {
                        trackLeft = hMax;
                    } else {
                        trackRight = hMax;
                    }
                    thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
                    thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
                    SynthSliderUI.this.setThumbLocation(thumbLeft, ((SynthSliderUI)SynthSliderUI.this).thumbRect.y);
                    thumbMiddle = thumbLeft + halfThumbWidth;
                    SynthSliderUI.this.slider.setValue(SynthSliderUI.this.valueForXPosition(thumbMiddle));
                    break;
                }
                default: {
                    return;
                }
            }
            if (SynthSliderUI.this.slider.getValueIsAdjusting()) {
                SynthSliderUI.this.setThumbActive(true);
            }
        }

        public void mouseMoved(MouseEvent e) {
            SynthSliderUI.this.updateThumbState(e.getX(), e.getY());
        }
    }
}

