/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicPopupMenuUI;
import javax.swing.plaf.synth.DefaultMenuLayout;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.plaf.synth.SynthUI;

class SynthPopupMenuUI
extends BasicPopupMenuUI
implements PropertyChangeListener,
SynthUI {
    private int maxTextWidth;
    private int maxIconWidth;
    private int maxAccelSpacingWidth;
    private int maxAcceleratorWidth;
    private int maxTextOffset;
    private int maxIconOffset;
    private SynthStyle style;

    SynthPopupMenuUI() {
    }

    public static ComponentUI createUI(JComponent x) {
        return new SynthPopupMenuUI();
    }

    public void installDefaults() {
        if (this.popupMenu.getLayout() == null || this.popupMenu.getLayout() instanceof UIResource) {
            this.popupMenu.setLayout(new DefaultMenuLayout(this.popupMenu, 1));
        }
        this.updateStyle(this.popupMenu);
    }

    private void updateStyle(JComponent c) {
        SynthContext context = this.getContext(c, 1);
        SynthStyle oldStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle && oldStyle != null) {
            this.uninstallKeyboardActions();
            this.installKeyboardActions();
        }
        context.dispose();
    }

    protected void installListeners() {
        super.installListeners();
        this.popupMenu.addPropertyChangeListener(this);
    }

    protected void uninstallDefaults() {
        SynthContext context = this.getContext(this.popupMenu, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
        if (this.popupMenu.getLayout() instanceof UIResource) {
            this.popupMenu.setLayout(null);
        }
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.popupMenu.removePropertyChangeListener(this);
    }

    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(SynthContext.class, c, SynthLookAndFeel.getRegion(c), this.style, state);
    }

    private Region getRegion(JComponent c) {
        return SynthLookAndFeel.getRegion(c);
    }

    private int getComponentState(JComponent c) {
        return SynthLookAndFeel.getComponentState(c);
    }

    void resetAlignmentHints() {
        this.maxIconOffset = 0;
        this.maxTextOffset = 0;
        this.maxAcceleratorWidth = 0;
        this.maxAccelSpacingWidth = 0;
        this.maxIconWidth = 0;
        this.maxTextWidth = 0;
    }

    int adjustTextWidth(int width) {
        this.maxTextWidth = Math.max(this.maxTextWidth, width);
        return this.maxTextWidth;
    }

    int adjustIconWidth(int width) {
        this.maxIconWidth = Math.max(this.maxIconWidth, width);
        return this.maxIconWidth;
    }

    int adjustAccelSpacingWidth(int width) {
        this.maxAccelSpacingWidth = Math.max(this.maxAccelSpacingWidth, width);
        return this.maxAccelSpacingWidth;
    }

    int adjustAcceleratorWidth(int width) {
        this.maxAcceleratorWidth = Math.max(this.maxAcceleratorWidth, width);
        return this.maxAcceleratorWidth;
    }

    int getMaxAcceleratorWidth() {
        return this.maxAcceleratorWidth;
    }

    int adjustTextOffset(int offset) {
        this.maxTextOffset = Math.max(this.maxTextOffset, offset);
        return this.maxTextOffset;
    }

    int adjustIconOffset(int offset) {
        this.maxIconOffset = Math.max(this.maxIconOffset, offset);
        return this.maxIconOffset;
    }

    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintPopupMenuBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
        context.dispose();
    }

    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SynthContext context, Graphics g) {
    }

    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintPopupMenuBorder(context, g, x, y, w, h);
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (SynthLookAndFeel.shouldUpdateStyle(e)) {
            this.updateStyle(this.popupMenu);
        }
    }
}

