/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthGraphicsUtils;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import sun.swing.SwingUtilities2;
import sun.swing.plaf.synth.SynthUI;

class SynthInternalFrameTitlePane
extends BasicInternalFrameTitlePane
implements SynthUI,
PropertyChangeListener {
    protected JPopupMenu systemPopupMenu;
    protected JButton menuButton;
    private SynthStyle style;
    private int titleSpacing;
    private int buttonSpacing;
    private int titleAlignment;

    public SynthInternalFrameTitlePane(JInternalFrame f) {
        super(f);
    }

    public String getUIClassID() {
        return "InternalFrameTitlePaneUI";
    }

    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    public SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(SynthContext.class, c, SynthLookAndFeel.getRegion(c), this.style, state);
    }

    private Region getRegion(JComponent c) {
        return SynthLookAndFeel.getRegion(c);
    }

    private int getComponentState(JComponent c) {
        if (this.frame != null && this.frame.isSelected()) {
            return 512;
        }
        return SynthLookAndFeel.getComponentState(c);
    }

    protected void addSubComponents() {
        this.menuButton.setName("InternalFrameTitlePane.menuButton");
        this.iconButton.setName("InternalFrameTitlePane.iconifyButton");
        this.maxButton.setName("InternalFrameTitlePane.maximizeButton");
        this.closeButton.setName("InternalFrameTitlePane.closeButton");
        this.add(this.menuButton);
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
    }

    protected void installListeners() {
        super.installListeners();
        this.frame.addPropertyChangeListener(this);
        this.addPropertyChangeListener(this);
    }

    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(this);
        this.removePropertyChangeListener(this);
        super.uninstallListeners();
    }

    private void updateStyle(JComponent c) {
        SynthContext context = this.getContext(this, 1);
        SynthStyle oldStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(context, this);
        if (this.style != oldStyle) {
            this.maxIcon = this.style.getIcon(context, "InternalFrameTitlePane.maximizeIcon");
            this.minIcon = this.style.getIcon(context, "InternalFrameTitlePane.minimizeIcon");
            this.iconIcon = this.style.getIcon(context, "InternalFrameTitlePane.iconifyIcon");
            this.closeIcon = this.style.getIcon(context, "InternalFrameTitlePane.closeIcon");
            this.titleSpacing = this.style.getInt(context, "InternalFrameTitlePane.titleSpacing", 2);
            this.buttonSpacing = this.style.getInt(context, "InternalFrameTitlePane.buttonSpacing", 2);
            String alignString = (String)this.style.get(context, "InternalFrameTitlePane.titleAlignment");
            this.titleAlignment = 10;
            if (alignString != null) {
                if ((alignString = alignString.toUpperCase()).equals("TRAILING")) {
                    this.titleAlignment = 11;
                } else if (alignString.equals("CENTER")) {
                    this.titleAlignment = 0;
                }
            }
        }
        context.dispose();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.updateStyle(this);
    }

    protected void uninstallDefaults() {
        SynthContext context = this.getContext(this, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
        JInternalFrame.JDesktopIcon di = this.frame.getDesktopIcon();
        if (di != null && di.getComponentPopupMenu() == this.systemPopupMenu) {
            di.setComponentPopupMenu(null);
        }
        super.uninstallDefaults();
    }

    protected void assembleSystemMenu() {
        this.systemPopupMenu = new JPopupMenuUIResource();
        this.addSystemMenuItems(this.systemPopupMenu);
        this.enableActions();
        this.menuButton = this.createNoFocusButton();
        this.updateMenuIcon();
        this.menuButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                try {
                    SynthInternalFrameTitlePane.this.frame.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                SynthInternalFrameTitlePane.this.showSystemMenu();
            }
        });
        JPopupMenu p = this.frame.getComponentPopupMenu();
        if (p == null || p instanceof UIResource) {
            this.frame.setComponentPopupMenu(this.systemPopupMenu);
        }
        if (this.frame.getDesktopIcon() != null && ((p = this.frame.getDesktopIcon().getComponentPopupMenu()) == null || p instanceof UIResource)) {
            this.frame.getDesktopIcon().setComponentPopupMenu(this.systemPopupMenu);
        }
        this.setInheritsPopupMenu(true);
    }

    protected void addSystemMenuItems(JPopupMenu menu) {
        JMenuItem mi = menu.add(this.restoreAction);
        mi.setMnemonic('R');
        mi = menu.add(this.moveAction);
        mi.setMnemonic('M');
        mi = menu.add(this.sizeAction);
        mi.setMnemonic('S');
        mi = menu.add(this.iconifyAction);
        mi.setMnemonic('n');
        mi = menu.add(this.maximizeAction);
        mi.setMnemonic('x');
        menu.add(new JSeparator());
        mi = menu.add(this.closeAction);
        mi.setMnemonic('C');
    }

    protected void showSystemMenu() {
        Insets insets = this.frame.getInsets();
        if (!this.frame.isIcon()) {
            this.systemPopupMenu.show(this.frame, insets.left, this.getY() + this.getHeight());
        } else {
            this.systemPopupMenu.show(this.menuButton, this.getX() - insets.left - insets.right, this.getY() - this.systemPopupMenu.getPreferredSize().height - insets.bottom - insets.top);
        }
    }

    public void paintComponent(Graphics g) {
        SynthContext context = this.getContext(this);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintInternalFrameTitlePaneBackground(context, g, 0, 0, this.getWidth(), this.getHeight());
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SynthContext context, Graphics g) {
        String title = this.frame.getTitle();
        if (title != null) {
            int minX;
            int maxX;
            SynthStyle style = context.getStyle();
            g.setColor(style.getColor(context, ColorType.TEXT_FOREGROUND));
            g.setFont(style.getFont(context));
            FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)this.frame, g);
            int baseline = (this.getHeight() + fm.getAscent() - fm.getLeading() - fm.getDescent()) / 2;
            JButton lastButton = null;
            if (this.frame.isIconifiable()) {
                lastButton = this.iconButton;
            } else if (this.frame.isMaximizable()) {
                lastButton = this.maxButton;
            } else if (this.frame.isClosable()) {
                lastButton = this.closeButton;
            }
            boolean ltr = SynthLookAndFeel.isLeftToRight(this.frame);
            int titleAlignment = this.titleAlignment;
            if (ltr) {
                maxX = lastButton != null ? lastButton.getX() - this.titleSpacing : this.frame.getWidth() - this.frame.getInsets().right - this.titleSpacing;
                minX = this.menuButton.getX() + this.menuButton.getWidth() + this.titleSpacing;
            } else {
                minX = lastButton != null ? lastButton.getX() + lastButton.getWidth() + this.titleSpacing : this.frame.getInsets().left + this.titleSpacing;
                maxX = this.menuButton.getX() - this.titleSpacing;
                if (titleAlignment == 10) {
                    titleAlignment = 11;
                } else if (titleAlignment == 11) {
                    titleAlignment = 10;
                }
            }
            String clippedTitle = this.getTitle(title, fm, maxX - minX);
            if (clippedTitle == title) {
                if (titleAlignment == 11) {
                    minX = maxX - style.getGraphicsUtils(context).computeStringWidth(context, g.getFont(), fm, title);
                } else if (titleAlignment == 0) {
                    int width = style.getGraphicsUtils(context).computeStringWidth(context, g.getFont(), fm, title);
                    minX = Math.max(minX, (this.getWidth() - width) / 2);
                    minX = Math.min(maxX - width, minX);
                }
            }
            style.getGraphicsUtils(context).paintText(context, g, clippedTitle, minX, baseline - fm.getAscent(), -1);
        }
    }

    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintInternalFrameTitlePaneBorder(context, g, x, y, w, h);
    }

    protected LayoutManager createLayout() {
        SynthContext context = this.getContext(this);
        LayoutManager lm = (LayoutManager)this.style.get(context, "InternalFrameTitlePane.titlePaneLayout");
        context.dispose();
        return lm != null ? lm : new SynthTitlePaneLayout();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this) {
            if (SynthLookAndFeel.shouldUpdateStyle(evt)) {
                this.updateStyle(this);
            }
        } else if (evt.getPropertyName() == "frameIcon") {
            this.updateMenuIcon();
        }
    }

    private void updateMenuIcon() {
        Icon frameIcon = this.frame.getFrameIcon();
        SynthContext context = this.getContext(this);
        if (frameIcon != null) {
            Dimension maxSize = (Dimension)context.getStyle().get(context, "InternalFrameTitlePane.maxFrameIconSize");
            int maxWidth = 16;
            int maxHeight = 16;
            if (maxSize != null) {
                maxWidth = maxSize.width;
                maxHeight = maxSize.height;
            }
            if ((frameIcon.getIconWidth() > maxWidth || frameIcon.getIconHeight() > maxHeight) && frameIcon instanceof ImageIcon) {
                frameIcon = new ImageIcon(((ImageIcon)frameIcon).getImage().getScaledInstance(maxWidth, maxHeight, 4));
            }
        }
        context.dispose();
        this.menuButton.setIcon(frameIcon);
    }

    private JButton createNoFocusButton() {
        JButton button = new JButton();
        button.setFocusable(false);
        button.setMargin(new Insets(0, 0, 0, 0));
        return button;
    }

    class SynthTitlePaneLayout
    implements LayoutManager {
        SynthTitlePaneLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        public Dimension minimumLayoutSize(Container c) {
            int subtitle_w;
            int title_length;
            Dimension pref;
            SynthContext context = SynthInternalFrameTitlePane.this.getContext(SynthInternalFrameTitlePane.this);
            int width = 0;
            int height = 0;
            int buttonCount = 0;
            if (SynthInternalFrameTitlePane.this.frame.isClosable()) {
                pref = SynthInternalFrameTitlePane.this.closeButton.getPreferredSize();
                width += pref.width;
                height = Math.max(pref.height, height);
                ++buttonCount;
            }
            if (SynthInternalFrameTitlePane.this.frame.isMaximizable()) {
                pref = SynthInternalFrameTitlePane.this.maxButton.getPreferredSize();
                width += pref.width;
                height = Math.max(pref.height, height);
                ++buttonCount;
            }
            if (SynthInternalFrameTitlePane.this.frame.isIconifiable()) {
                pref = SynthInternalFrameTitlePane.this.iconButton.getPreferredSize();
                width += pref.width;
                height = Math.max(pref.height, height);
                ++buttonCount;
            }
            pref = SynthInternalFrameTitlePane.this.menuButton.getPreferredSize();
            width += pref.width;
            height = Math.max(pref.height, height);
            width += Math.max(0, (buttonCount - 1) * SynthInternalFrameTitlePane.this.buttonSpacing);
            FontMetrics fm = SynthInternalFrameTitlePane.this.getFontMetrics(SynthInternalFrameTitlePane.this.getFont());
            SynthGraphicsUtils graphicsUtils = context.getStyle().getGraphicsUtils(context);
            String frameTitle = SynthInternalFrameTitlePane.this.frame.getTitle();
            int title_w = frameTitle != null ? graphicsUtils.computeStringWidth(context, fm.getFont(), fm, frameTitle) : 0;
            int n = title_length = frameTitle != null ? frameTitle.length() : 0;
            width = title_length > 3 ? (width += title_w < (subtitle_w = graphicsUtils.computeStringWidth(context, fm.getFont(), fm, frameTitle.substring(0, 3) + "...")) ? title_w : subtitle_w) : (width += title_w);
            height = Math.max(fm.getHeight() + 2, height);
            width += SynthInternalFrameTitlePane.this.titleSpacing + SynthInternalFrameTitlePane.this.titleSpacing;
            Insets insets = SynthInternalFrameTitlePane.this.getInsets();
            context.dispose();
            return new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
        }

        private int center(Component c, Insets insets, int x, boolean trailing) {
            Dimension pref = c.getPreferredSize();
            if (trailing) {
                x -= pref.width;
            }
            c.setBounds(x, insets.top + (SynthInternalFrameTitlePane.this.getHeight() - insets.top - insets.bottom - pref.height) / 2, pref.width, pref.height);
            if (pref.width > 0) {
                if (trailing) {
                    return x - SynthInternalFrameTitlePane.this.buttonSpacing;
                }
                return x + pref.width + SynthInternalFrameTitlePane.this.buttonSpacing;
            }
            return x;
        }

        public void layoutContainer(Container c) {
            Insets insets = c.getInsets();
            if (SynthLookAndFeel.isLeftToRight(SynthInternalFrameTitlePane.this.frame)) {
                this.center(SynthInternalFrameTitlePane.this.menuButton, insets, insets.left, false);
                int x = SynthInternalFrameTitlePane.this.getWidth() - insets.right;
                if (SynthInternalFrameTitlePane.this.frame.isClosable()) {
                    x = this.center(SynthInternalFrameTitlePane.this.closeButton, insets, x, true);
                }
                if (SynthInternalFrameTitlePane.this.frame.isMaximizable()) {
                    x = this.center(SynthInternalFrameTitlePane.this.maxButton, insets, x, true);
                }
                if (SynthInternalFrameTitlePane.this.frame.isIconifiable()) {
                    x = this.center(SynthInternalFrameTitlePane.this.iconButton, insets, x, true);
                }
            } else {
                this.center(SynthInternalFrameTitlePane.this.menuButton, insets, SynthInternalFrameTitlePane.this.getWidth() - insets.right, true);
                int x = insets.left;
                if (SynthInternalFrameTitlePane.this.frame.isClosable()) {
                    x = this.center(SynthInternalFrameTitlePane.this.closeButton, insets, x, false);
                }
                if (SynthInternalFrameTitlePane.this.frame.isMaximizable()) {
                    x = this.center(SynthInternalFrameTitlePane.this.maxButton, insets, x, false);
                }
                if (SynthInternalFrameTitlePane.this.frame.isIconifiable()) {
                    x = this.center(SynthInternalFrameTitlePane.this.iconButton, insets, x, false);
                }
            }
        }
    }

    private static class JPopupMenuUIResource
    extends JPopupMenu
    implements UIResource {
        private JPopupMenuUIResource() {
        }
    }
}

