/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.SynthButtonUI;
import javax.swing.plaf.synth.SynthContext;

class SynthArrowButton
extends JButton
implements SwingConstants,
UIResource {
    private int direction;

    public SynthArrowButton(int direction) {
        super.setFocusable(false);
        this.setDirection(direction);
        this.setDefaultCapable(false);
    }

    public String getUIClassID() {
        return "ArrowButtonUI";
    }

    public void updateUI() {
        this.setUI(new SynthArrowButtonUI());
    }

    public void setDirection(int dir) {
        this.direction = dir;
        this.putClientProperty("__arrow_direction__", new Integer(dir));
        this.repaint();
    }

    public int getDirection() {
        return this.direction;
    }

    public void setFocusable(boolean focusable) {
    }

    private static class SynthArrowButtonUI
    extends SynthButtonUI {
        private SynthArrowButtonUI() {
        }

        protected void installDefaults(AbstractButton b) {
            super.installDefaults(b);
            this.updateStyle(b);
        }

        protected void paint(SynthContext context, Graphics g) {
            SynthArrowButton button = (SynthArrowButton)context.getComponent();
            context.getPainter().paintArrowButtonForeground(context, g, 0, 0, button.getWidth(), button.getHeight(), button.getDirection());
        }

        void paintBackground(SynthContext context, Graphics g, JComponent c) {
            context.getPainter().paintArrowButtonBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        }

        public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
            context.getPainter().paintArrowButtonBorder(context, g, x, y, w, h);
        }

        public Dimension getMinimumSize() {
            return new Dimension(5, 5);
        }

        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public Dimension getPreferredSize(JComponent c) {
            SynthContext context = this.getContext(c);
            Dimension dim = null;
            if (context.getComponent().getName() == "ScrollBar.button") {
                dim = (Dimension)context.getStyle().get(context, "ScrollBar.buttonSize");
            }
            if (dim == null) {
                int size = context.getStyle().getInt(context, "ArrowButton.size", 16);
                dim = new Dimension(size, size);
            }
            context.dispose();
            return dim;
        }
    }
}

