/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.AWTError;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import javax.swing.SizeRequirements;

public class OverlayLayout
implements LayoutManager2,
Serializable {
    private Container target;
    private SizeRequirements[] xChildren;
    private SizeRequirements[] yChildren;
    private SizeRequirements xTotal;
    private SizeRequirements yTotal;

    public OverlayLayout(Container target) {
        this.target = target;
    }

    public final Container getTarget() {
        return this.target;
    }

    public void invalidateLayout(Container target) {
        this.checkContainer(target);
        this.xChildren = null;
        this.yChildren = null;
        this.xTotal = null;
        this.yTotal = null;
    }

    public void addLayoutComponent(String name, Component comp) {
        this.invalidateLayout(comp.getParent());
    }

    public void removeLayoutComponent(Component comp) {
        this.invalidateLayout(comp.getParent());
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        this.invalidateLayout(comp.getParent());
    }

    public Dimension preferredLayoutSize(Container target) {
        this.checkContainer(target);
        this.checkRequests();
        Dimension size = new Dimension(this.xTotal.preferred, this.yTotal.preferred);
        Insets insets = target.getInsets();
        size.width += insets.left + insets.right;
        size.height += insets.top + insets.bottom;
        return size;
    }

    public Dimension minimumLayoutSize(Container target) {
        this.checkContainer(target);
        this.checkRequests();
        Dimension size = new Dimension(this.xTotal.minimum, this.yTotal.minimum);
        Insets insets = target.getInsets();
        size.width += insets.left + insets.right;
        size.height += insets.top + insets.bottom;
        return size;
    }

    public Dimension maximumLayoutSize(Container target) {
        this.checkContainer(target);
        this.checkRequests();
        Dimension size = new Dimension(this.xTotal.maximum, this.yTotal.maximum);
        Insets insets = target.getInsets();
        size.width += insets.left + insets.right;
        size.height += insets.top + insets.bottom;
        return size;
    }

    public float getLayoutAlignmentX(Container target) {
        this.checkContainer(target);
        this.checkRequests();
        return this.xTotal.alignment;
    }

    public float getLayoutAlignmentY(Container target) {
        this.checkContainer(target);
        this.checkRequests();
        return this.yTotal.alignment;
    }

    public void layoutContainer(Container target) {
        this.checkContainer(target);
        this.checkRequests();
        int nChildren = target.getComponentCount();
        int[] xOffsets = new int[nChildren];
        int[] xSpans = new int[nChildren];
        int[] yOffsets = new int[nChildren];
        int[] ySpans = new int[nChildren];
        Dimension alloc = target.getSize();
        Insets in = target.getInsets();
        alloc.width -= in.left + in.right;
        alloc.height -= in.top + in.bottom;
        SizeRequirements.calculateAlignedPositions(alloc.width, this.xTotal, this.xChildren, xOffsets, xSpans);
        SizeRequirements.calculateAlignedPositions(alloc.height, this.yTotal, this.yChildren, yOffsets, ySpans);
        for (int i = 0; i < nChildren; ++i) {
            Component c = target.getComponent(i);
            c.setBounds(in.left + xOffsets[i], in.top + yOffsets[i], xSpans[i], ySpans[i]);
        }
    }

    void checkContainer(Container target) {
        if (this.target != target) {
            throw new AWTError("OverlayLayout can't be shared");
        }
    }

    void checkRequests() {
        if (this.xChildren == null || this.yChildren == null) {
            int n = this.target.getComponentCount();
            this.xChildren = new SizeRequirements[n];
            this.yChildren = new SizeRequirements[n];
            for (int i = 0; i < n; ++i) {
                Component c = this.target.getComponent(i);
                Dimension min = c.getMinimumSize();
                Dimension typ = c.getPreferredSize();
                Dimension max = c.getMaximumSize();
                this.xChildren[i] = new SizeRequirements(min.width, typ.width, max.width, c.getAlignmentX());
                this.yChildren[i] = new SizeRequirements(min.height, typ.height, max.height, c.getAlignmentY());
            }
            this.xTotal = SizeRequirements.getAlignedSizeRequirements(this.xChildren);
            this.yTotal = SizeRequirements.getAlignedSizeRequirements(this.yChildren);
        }
    }
}

