/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Icon;

public class ImageIcon
implements Icon,
Serializable,
Accessible {
    private transient String filename;
    private transient URL location;
    transient Image image;
    transient int loadStatus = 0;
    ImageObserver imageObserver;
    String description = null;
    protected static final Component component = new Component(){};
    protected static final MediaTracker tracker = new MediaTracker(component);
    private static int mediaTrackerID;
    int width = -1;
    int height = -1;
    private AccessibleImageIcon accessibleContext = null;

    public ImageIcon(String filename, String description) {
        this.image = Toolkit.getDefaultToolkit().getImage(filename);
        if (this.image == null) {
            return;
        }
        this.filename = filename;
        this.description = description;
        this.loadImage(this.image);
    }

    public ImageIcon(String filename) {
        this(filename, filename);
    }

    public ImageIcon(URL location, String description) {
        this.image = Toolkit.getDefaultToolkit().getImage(location);
        if (this.image == null) {
            return;
        }
        this.location = location;
        this.description = description;
        this.loadImage(this.image);
    }

    public ImageIcon(URL location) {
        this(location, location.toExternalForm());
    }

    public ImageIcon(Image image, String description) {
        this(image);
        this.description = description;
    }

    public ImageIcon(Image image) {
        this.image = image;
        Object o = image.getProperty("comment", this.imageObserver);
        if (o instanceof String) {
            this.description = (String)o;
        }
        this.loadImage(image);
    }

    public ImageIcon(byte[] imageData, String description) {
        this.image = Toolkit.getDefaultToolkit().createImage(imageData);
        if (this.image == null) {
            return;
        }
        this.description = description;
        this.loadImage(this.image);
    }

    public ImageIcon(byte[] imageData) {
        this.image = Toolkit.getDefaultToolkit().createImage(imageData);
        if (this.image == null) {
            return;
        }
        Object o = this.image.getProperty("comment", this.imageObserver);
        if (o instanceof String) {
            this.description = (String)o;
        }
        this.loadImage(this.image);
    }

    public ImageIcon() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadImage(Image image) {
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            int id = this.getNextID();
            tracker.addImage(image, id);
            try {
                tracker.waitForID(id, 0L);
            }
            catch (InterruptedException e) {
                System.out.println("INTERRUPTED while loading Image");
            }
            this.loadStatus = tracker.statusID(id, false);
            tracker.removeImage(image, id);
            this.width = image.getWidth(this.imageObserver);
            this.height = image.getHeight(this.imageObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextID() {
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            return ++mediaTrackerID;
        }
    }

    public int getImageLoadStatus() {
        return this.loadStatus;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        this.loadImage(image);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public synchronized void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.imageObserver == null) {
            g.drawImage(this.image, x, y, c);
        } else {
            g.drawImage(this.image, x, y, this.imageObserver);
        }
    }

    public int getIconWidth() {
        return this.width;
    }

    public int getIconHeight() {
        return this.height;
    }

    public void setImageObserver(ImageObserver observer) {
        this.imageObserver = observer;
    }

    public ImageObserver getImageObserver() {
        return this.imageObserver;
    }

    public String toString() {
        if (this.description != null) {
            return this.description;
        }
        return super.toString();
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        int w = s.readInt();
        int h = s.readInt();
        int[] pixels = (int[])s.readObject();
        if (pixels != null) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            ColorModel cm = ColorModel.getRGBdefault();
            this.image = tk.createImage(new MemoryImageSource(w, h, cm, pixels, 0, w));
            this.loadImage(this.image);
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        int[] pixels;
        s.defaultWriteObject();
        int w = this.getIconWidth();
        int h = this.getIconHeight();
        int[] nArray = pixels = this.image != null ? new int[w * h] : null;
        if (this.image != null) {
            try {
                PixelGrabber pg = new PixelGrabber(this.image, 0, 0, w, h, pixels, 0, w);
                pg.grabPixels();
                if ((pg.getStatus() & 0x80) != 0) {
                    throw new IOException("failed to load image contents");
                }
            }
            catch (InterruptedException e) {
                throw new IOException("image load interrupted");
            }
        }
        s.writeInt(w);
        s.writeInt(h);
        s.writeObject(pixels);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleImageIcon();
        }
        return this.accessibleContext;
    }

    protected class AccessibleImageIcon
    extends AccessibleContext
    implements AccessibleIcon,
    Serializable {
        protected AccessibleImageIcon() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.ICON;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }

        public Accessible getAccessibleParent() {
            return null;
        }

        public int getAccessibleIndexInParent() {
            return -1;
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int i) {
            return null;
        }

        public Locale getLocale() throws IllegalComponentStateException {
            return null;
        }

        public String getAccessibleIconDescription() {
            return ImageIcon.this.getDescription();
        }

        public void setAccessibleIconDescription(String description) {
            ImageIcon.this.setDescription(description);
        }

        public int getAccessibleIconHeight() {
            return ImageIcon.this.height;
        }

        public int getAccessibleIconWidth() {
            return ImageIcon.this.width;
        }

        private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
            s.defaultReadObject();
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            s.defaultWriteObject();
        }
    }
}

