/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiMessage;

public class MetaMessage
extends MidiMessage {
    public static final int META = 255;
    private static byte[] defaultMessage = new byte[]{-1, 0};
    private int dataLength = 0;
    private static final long mask = 127L;

    public MetaMessage() {
        this(defaultMessage);
    }

    protected MetaMessage(byte[] data) {
        super(data);
        if (data.length >= 3) {
            this.dataLength = data.length - 3;
            for (int pos = 2; pos < data.length && (data[pos] & 0x80) != 0; ++pos) {
                --this.dataLength;
            }
        }
    }

    public void setMessage(int type, byte[] data, int length) throws InvalidMidiDataException {
        if (type >= 128 || type < 0) {
            throw new InvalidMidiDataException("Invalid meta event with type " + type);
        }
        if (length > 0 && length > data.length || length < 0) {
            throw new InvalidMidiDataException("length out of bounds: " + length);
        }
        this.length = 2 + this.getVarIntLength(length) + length;
        this.dataLength = length;
        this.data = new byte[this.length];
        this.data[0] = -1;
        this.data[1] = (byte)type;
        this.writeVarInt(this.data, 2, length);
        if (length > 0) {
            System.arraycopy(data, 0, this.data, this.length - this.dataLength, this.dataLength);
        }
    }

    public int getType() {
        if (this.length >= 2) {
            return this.data[1] & 0xFF;
        }
        return 0;
    }

    public byte[] getData() {
        byte[] returnedArray = new byte[this.dataLength];
        System.arraycopy(this.data, this.length - this.dataLength, returnedArray, 0, this.dataLength);
        return returnedArray;
    }

    public Object clone() {
        byte[] newData = new byte[this.length];
        System.arraycopy(this.data, 0, newData, 0, newData.length);
        MetaMessage event = new MetaMessage(newData);
        return event;
    }

    private int getVarIntLength(long value) {
        int length = 0;
        do {
            ++length;
        } while ((value >>= 7) > 0L);
        return length;
    }

    private void writeVarInt(byte[] data, int off, long value) {
        int shift;
        for (shift = 63; shift > 0 && (value & 127L << shift) == 0L; shift -= 7) {
        }
        while (shift > 0) {
            data[off++] = (byte)((value & 127L << shift) >> shift | 0x80L);
            shift -= 7;
        }
        data[off] = (byte)(value & 0x7FL);
    }
}

