/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KeyImpl;

public class KerberosKey
implements SecretKey,
Destroyable {
    private static final long serialVersionUID = -4625402278148246993L;
    private KerberosPrincipal principal;
    private int versionNum;
    private KeyImpl key;
    private transient boolean destroyed = false;

    public KerberosKey(KerberosPrincipal principal, byte[] keyBytes, int keyType, int versionNum) {
        this.principal = principal;
        this.versionNum = versionNum;
        this.key = new KeyImpl(keyBytes, keyType);
    }

    public KerberosKey(KerberosPrincipal principal, char[] password, String algorithm) {
        this.principal = principal;
        this.key = new KeyImpl(principal, password, algorithm);
    }

    public final KerberosPrincipal getPrincipal() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return this.principal;
    }

    public final int getVersionNumber() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return this.versionNum;
    }

    public final int getKeyType() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return this.key.getKeyType();
    }

    public final String getAlgorithm() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return this.key.getAlgorithm();
    }

    public final String getFormat() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return this.key.getFormat();
    }

    public final byte[] getEncoded() {
        if (this.destroyed) {
            throw new IllegalStateException("This key is no longer valid");
        }
        return this.key.getEncoded();
    }

    public void destroy() throws DestroyFailedException {
        if (!this.destroyed) {
            this.key.destroy();
            this.principal = null;
            this.destroyed = true;
        }
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public String toString() {
        if (this.destroyed) {
            return "Destroyed Principal";
        }
        return "Kerberos Principal " + this.principal.toString() + "Key Version " + this.versionNum + "key " + this.key.toString();
    }

    public int hashCode() {
        int result = 17;
        if (this.isDestroyed()) {
            return result;
        }
        result = 37 * result + Arrays.hashCode(this.getEncoded());
        result = 37 * result + this.getKeyType();
        if (this.principal != null) {
            result = 37 * result + this.principal.hashCode();
        }
        return result * 37 + this.versionNum;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof KerberosKey)) {
            return false;
        }
        KerberosKey otherKey = (KerberosKey)other;
        if (this.isDestroyed() || otherKey.isDestroyed()) {
            return false;
        }
        if (this.versionNum != otherKey.getVersionNumber() || this.getKeyType() != otherKey.getKeyType() || !Arrays.equals(this.getEncoded(), otherKey.getEncoded())) {
            return false;
        }
        return !(this.principal == null ? otherKey.getPrincipal() != null : !this.principal.equals(otherKey.getPrincipal()));
    }
}

