/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.relation.InvalidRoleValueException;
import javax.management.relation.RelationNotFoundException;
import javax.management.relation.RelationService;
import javax.management.relation.RelationServiceNotRegisteredException;
import javax.management.relation.RelationSupportMBean;
import javax.management.relation.RelationTypeNotFoundException;
import javax.management.relation.Role;
import javax.management.relation.RoleList;
import javax.management.relation.RoleNotFoundException;
import javax.management.relation.RoleResult;
import javax.management.relation.RoleUnresolved;
import javax.management.relation.RoleUnresolvedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationSupport
implements RelationSupportMBean,
MBeanRegistration {
    private String myRelId = null;
    private ObjectName myRelServiceName = null;
    private MBeanServer myRelServiceMBeanServer = null;
    private String myRelTypeName = null;
    private Map<String, Role> myRoleName2ValueMap = new HashMap<String, Role>();
    private Boolean myInRelServFlg = null;

    public RelationSupport(String relationId, ObjectName relationServiceName, String relationTypeName, RoleList list) throws InvalidRoleValueException, IllegalArgumentException {
        JmxProperties.RELATION_LOGGER.entering(RelationSupport.class.getName(), "RelationSupport");
        this.initMembers(relationId, relationServiceName, null, relationTypeName, list);
        JmxProperties.RELATION_LOGGER.exiting(RelationSupport.class.getName(), "RelationSupport");
    }

    public RelationSupport(String relationId, ObjectName relationServiceName, MBeanServer relationServiceMBeanServer, String relationTypeName, RoleList list) throws InvalidRoleValueException, IllegalArgumentException {
        if (relationServiceMBeanServer == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationSupport.class.getName(), "RelationSupport");
        this.initMembers(relationId, relationServiceName, relationServiceMBeanServer, relationTypeName, list);
        JmxProperties.RELATION_LOGGER.exiting(RelationSupport.class.getName(), "RelationSupport");
    }

    @Override
    public List<ObjectName> getRole(String roleName) throws IllegalArgumentException, RoleNotFoundException, RelationServiceNotRegisteredException {
        if (roleName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationSupport.class.getName(), "getRole", roleName);
        List result = (List)Util.cast(this.getRoleInt(roleName, false, null, false));
        JmxProperties.RELATION_LOGGER.exiting(RelationSupport.class.getName(), "getRole");
        return result;
    }

    @Override
    public RoleResult getRoles(String[] roleNameArray) throws IllegalArgumentException, RelationServiceNotRegisteredException {
        if (roleNameArray == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationSupport.class.getName(), "getRoles");
        RoleResult result = this.getRolesInt(roleNameArray, false, null);
        JmxProperties.RELATION_LOGGER.exiting(RelationSupport.class.getName(), "getRoles");
        return result;
    }

    @Override
    public RoleResult getAllRoles() throws RelationServiceNotRegisteredException {
        JmxProperties.RELATION_LOGGER.entering(RelationSupport.class.getName(), "getAllRoles");
        RoleResult result = null;
        try {
            result = this.getAllRolesInt(false, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationSupport.class.getName(), "getAllRoles");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RoleList retrieveAllRoles() {
        RoleList result;
        JmxProperties.RELATION_LOGGER.entering(RelationSupport.class.getName(), "retrieveAllRoles");
        Map<String, Role> map = this.myRoleName2ValueMap;
        synchronized (map) {
            result = new RoleList((List<Role>)new ArrayList<Role>(this.myRoleName2ValueMap.values()));
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationSupport.class.getName(), "retrieveAllRoles");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getRoleCardinality(String roleName) throws IllegalArgumentException, RoleNotFoundException {
        if (roleName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationSupport.class.getName(), "getRoleCardinality", roleName);
        Role role = null;
        Map<String, Role> map = this.myRoleName2ValueMap;
        synchronized (map) {
            role = this.myRoleName2ValueMap.get(roleName);
        }
        if (role == null) {
            int pbType = 1;
            try {
                RelationService.throwRoleProblemException(pbType, roleName);
            }
            catch (InvalidRoleValueException exc) {
                // empty catch block
            }
        }
        ArrayList roleValue = (ArrayList)role.getRoleValue();
        JmxProperties.RELATION_LOGGER.exiting(RelationSupport.class.getName(), "getRoleCardinality");
        return new Integer(roleValue.size());
    }

    @Override
    public void setRole(Role role) throws IllegalArgumentException, RoleNotFoundException, RelationTypeNotFoundException, InvalidRoleValueException, RelationServiceNotRegisteredException, RelationNotFoundException {
        if (role == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationSupport.class.getName(), "setRole", role);
        Object result = this.setRoleInt(role, false, null, false);
        JmxProperties.RELATION_LOGGER.exiting(RelationSupport.class.getName(), "setRole");
    }

    @Override
    public RoleResult setRoles(RoleList list) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationTypeNotFoundException, RelationNotFoundException {
        if (list == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationSupport.class.getName(), "setRoles", list);
        RoleResult result = this.setRolesInt(list, false, null);
        JmxProperties.RELATION_LOGGER.exiting(RelationSupport.class.getName(), "setRoles");
        return result;
    }

    @Override
    public void handleMBeanUnregistration(ObjectName objectName, String roleName) throws IllegalArgumentException, RoleNotFoundException, InvalidRoleValueException, RelationServiceNotRegisteredException, RelationTypeNotFoundException, RelationNotFoundException {
        if (objectName == null || roleName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationSupport.class.getName(), "handleMBeanUnregistration", new Object[]{objectName, roleName});
        this.handleMBeanUnregistrationInt(objectName, roleName, false, null);
        JmxProperties.RELATION_LOGGER.exiting(RelationSupport.class.getName(), "handleMBeanUnregistration");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<ObjectName, List<String>> getReferencedMBeans() {
        JmxProperties.RELATION_LOGGER.entering(RelationSupport.class.getName(), "getReferencedMBeans");
        HashMap<ObjectName, List<String>> refMBeanMap = new HashMap<ObjectName, List<String>>();
        Map<String, Role> map = this.myRoleName2ValueMap;
        synchronized (map) {
            for (Role currRole : this.myRoleName2ValueMap.values()) {
                String currRoleName = currRole.getRoleName();
                List<ObjectName> currRefMBeanList = currRole.getRoleValue();
                for (ObjectName currRoleObjName : currRefMBeanList) {
                    ArrayList<String> mbeanRoleNameList = (ArrayList<String>)refMBeanMap.get(currRoleObjName);
                    boolean newRefFlg = false;
                    if (mbeanRoleNameList == null) {
                        newRefFlg = true;
                        mbeanRoleNameList = new ArrayList<String>();
                    }
                    mbeanRoleNameList.add(currRoleName);
                    if (!newRefFlg) continue;
                    refMBeanMap.put(currRoleObjName, mbeanRoleNameList);
                }
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationSupport.class.getName(), "getReferencedMBeans");
        return refMBeanMap;
    }

    @Override
    public String getRelationTypeName() {
        return this.myRelTypeName;
    }

    @Override
    public ObjectName getRelationServiceName() {
        return this.myRelServiceName;
    }

    @Override
    public String getRelationId() {
        return this.myRelId;
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.myRelServiceMBeanServer = server;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean isInRelationService() {
        Boolean result = null;
        Boolean bl = this.myInRelServFlg;
        synchronized (bl) {
            result = (boolean)this.myInRelServFlg;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRelationServiceManagementFlag(Boolean flag) throws IllegalArgumentException {
        if (flag == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        Boolean bl = this.myInRelServFlg;
        synchronized (bl) {
            this.myInRelServFlg = (boolean)flag;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getRoleInt(String roleName, boolean relationServCallFlg, RelationService relationServ, boolean multiRoleFlg) throws IllegalArgumentException, RoleNotFoundException, RelationServiceNotRegisteredException {
        if (roleName == null || relationServCallFlg && relationServ == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationSupport.class.getName(), "getRoleInt", roleName);
        int pbType = 0;
        Role role = null;
        Map<String, Role> map = this.myRoleName2ValueMap;
        synchronized (map) {
            role = this.myRoleName2ValueMap.get(roleName);
        }
        if (role == null) {
            pbType = 1;
        } else {
            Integer status = null;
            if (relationServCallFlg) {
                try {
                    status = relationServ.checkRoleReading(roleName, this.myRelTypeName);
                }
                catch (RelationTypeNotFoundException exc) {
                    throw new RuntimeException(exc.getMessage());
                }
            }
            Object[] params = new Object[]{roleName, this.myRelTypeName};
            String[] signature = new String[]{"java.lang.String", "java.lang.String"};
            try {
                status = (Integer)this.myRelServiceMBeanServer.invoke(this.myRelServiceName, "checkRoleReading", params, signature);
            }
            catch (MBeanException exc1) {
                throw new RuntimeException("incorrect relation type");
            }
            catch (ReflectionException exc2) {
                throw new RuntimeException(exc2.getMessage());
            }
            catch (InstanceNotFoundException exc3) {
                throw new RelationServiceNotRegisteredException(exc3.getMessage());
            }
            pbType = status;
        }
        Serializable result = null;
        if (pbType == 0) {
            result = !multiRoleFlg ? (ArrayList)((ArrayList)role.getRoleValue()).clone() : (Role)role.clone();
        } else {
            if (!multiRoleFlg) {
                try {
                    RelationService.throwRoleProblemException(pbType, roleName);
                    return null;
                }
                catch (InvalidRoleValueException exc) {
                    throw new RuntimeException(exc.getMessage());
                }
            }
            result = new RoleUnresolved(roleName, null, pbType);
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationSupport.class.getName(), "getRoleInt");
        return result;
    }

    RoleResult getRolesInt(String[] roleNameArray, boolean relationServCallFlg, RelationService relationServ) throws IllegalArgumentException, RelationServiceNotRegisteredException {
        if (roleNameArray == null || relationServCallFlg && relationServ == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationSupport.class.getName(), "getRolesInt");
        RoleList roleList = new RoleList();
        RoleUnresolvedList roleUnresList = new RoleUnresolvedList();
        for (int i = 0; i < roleNameArray.length; ++i) {
            String currRoleName = roleNameArray[i];
            Object currResult = null;
            try {
                currResult = this.getRoleInt(currRoleName, relationServCallFlg, relationServ, true);
            }
            catch (RoleNotFoundException exc) {
                return null;
            }
            if (currResult instanceof Role) {
                try {
                    roleList.add((Role)currResult);
                    continue;
                }
                catch (IllegalArgumentException exc) {
                    throw new RuntimeException(exc.getMessage());
                }
            }
            if (!(currResult instanceof RoleUnresolved)) continue;
            try {
                roleUnresList.add((RoleUnresolved)currResult);
                continue;
            }
            catch (IllegalArgumentException exc) {
                throw new RuntimeException(exc.getMessage());
            }
        }
        RoleResult result = new RoleResult(roleList, roleUnresList);
        JmxProperties.RELATION_LOGGER.exiting(RelationSupport.class.getName(), "getRolesInt");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RoleResult getAllRolesInt(boolean relationServCallFlg, RelationService relationServ) throws IllegalArgumentException, RelationServiceNotRegisteredException {
        ArrayList<String> roleNameList;
        if (relationServCallFlg && relationServ == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationSupport.class.getName(), "getAllRolesInt");
        Map<String, Role> map = this.myRoleName2ValueMap;
        synchronized (map) {
            roleNameList = new ArrayList<String>(this.myRoleName2ValueMap.keySet());
        }
        String[] roleNames = new String[roleNameList.size()];
        roleNameList.toArray(roleNames);
        RoleResult result = this.getRolesInt(roleNames, relationServCallFlg, relationServ);
        JmxProperties.RELATION_LOGGER.exiting(RelationSupport.class.getName(), "getAllRolesInt");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object setRoleInt(Role aRole, boolean relationServCallFlg, RelationService relationServ, boolean multiRoleFlg) throws IllegalArgumentException, RoleNotFoundException, InvalidRoleValueException, RelationServiceNotRegisteredException, RelationTypeNotFoundException, RelationNotFoundException {
        List<ObjectName> oldRoleValue;
        if (aRole == null || relationServCallFlg && relationServ == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationSupport.class.getName(), "setRoleInt", new Object[]{aRole, relationServCallFlg, relationServ, multiRoleFlg});
        String roleName = aRole.getRoleName();
        int pbType = 0;
        Role role = null;
        Map<String, Role> map = this.myRoleName2ValueMap;
        synchronized (map) {
            role = this.myRoleName2ValueMap.get(roleName);
        }
        Boolean initFlg = null;
        if (role == null) {
            initFlg = true;
            oldRoleValue = new ArrayList<ObjectName>();
        } else {
            initFlg = false;
            oldRoleValue = role.getRoleValue();
        }
        try {
            Integer status = null;
            if (relationServCallFlg) {
                status = relationServ.checkRoleWriting(aRole, this.myRelTypeName, initFlg);
            } else {
                Object[] params = new Object[]{aRole, this.myRelTypeName, initFlg};
                String[] signature = new String[]{"javax.management.relation.Role", "java.lang.String", "java.lang.Boolean"};
                status = (Integer)this.myRelServiceMBeanServer.invoke(this.myRelServiceName, "checkRoleWriting", params, signature);
            }
            pbType = status;
        }
        catch (MBeanException exc2) {
            Exception wrappedExc = exc2.getTargetException();
            if (wrappedExc instanceof RelationTypeNotFoundException) {
                throw (RelationTypeNotFoundException)wrappedExc;
            }
            throw new RuntimeException(wrappedExc.getMessage());
        }
        catch (ReflectionException exc3) {
            throw new RuntimeException(exc3.getMessage());
        }
        catch (RelationTypeNotFoundException exc4) {
            throw new RuntimeException(exc4.getMessage());
        }
        catch (InstanceNotFoundException exc5) {
            throw new RelationServiceNotRegisteredException(exc5.getMessage());
        }
        Serializable result = null;
        if (pbType == 0) {
            if (!initFlg.booleanValue()) {
                this.sendRoleUpdateNotification(aRole, oldRoleValue, relationServCallFlg, relationServ);
                this.updateRelationServiceMap(aRole, oldRoleValue, relationServCallFlg, relationServ);
            }
            Map<String, Role> map2 = this.myRoleName2ValueMap;
            synchronized (map2) {
                this.myRoleName2ValueMap.put(roleName, (Role)aRole.clone());
            }
            if (multiRoleFlg) {
                result = aRole;
            }
        } else {
            if (!multiRoleFlg) {
                RelationService.throwRoleProblemException(pbType, roleName);
                return null;
            }
            result = new RoleUnresolved(roleName, aRole.getRoleValue(), pbType);
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationSupport.class.getName(), "setRoleInt");
        return result;
    }

    private void sendRoleUpdateNotification(Role newRole, List<ObjectName> oldRoleValue, boolean relationServCallFlg, RelationService relationServ) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationNotFoundException {
        if (newRole == null || oldRoleValue == null || relationServCallFlg && relationServ == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationSupport.class.getName(), "sendRoleUpdateNotification", new Object[]{newRole, oldRoleValue, relationServCallFlg, relationServ});
        if (relationServCallFlg) {
            try {
                relationServ.sendRoleUpdateNotification(this.myRelId, newRole, oldRoleValue);
            }
            catch (RelationNotFoundException exc) {
                throw new RuntimeException(exc.getMessage());
            }
        }
        Object[] params = new Object[]{this.myRelId, newRole, (ArrayList)oldRoleValue};
        String[] signature = new String[]{"java.lang.String", "javax.management.relation.Role", "java.util.List"};
        try {
            this.myRelServiceMBeanServer.invoke(this.myRelServiceName, "sendRoleUpdateNotification", params, signature);
        }
        catch (ReflectionException exc1) {
            throw new RuntimeException(exc1.getMessage());
        }
        catch (InstanceNotFoundException exc2) {
            throw new RelationServiceNotRegisteredException(exc2.getMessage());
        }
        catch (MBeanException exc3) {
            Exception wrappedExc = exc3.getTargetException();
            if (wrappedExc instanceof RelationNotFoundException) {
                throw (RelationNotFoundException)wrappedExc;
            }
            throw new RuntimeException(wrappedExc.getMessage());
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationSupport.class.getName(), "sendRoleUpdateNotification");
    }

    private void updateRelationServiceMap(Role newRole, List<ObjectName> oldRoleValue, boolean relationServCallFlg, RelationService relationServ) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationNotFoundException {
        if (newRole == null || oldRoleValue == null || relationServCallFlg && relationServ == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationSupport.class.getName(), "updateRelationServiceMap", new Object[]{newRole, oldRoleValue, relationServCallFlg, relationServ});
        if (relationServCallFlg) {
            try {
                relationServ.updateRoleMap(this.myRelId, newRole, oldRoleValue);
            }
            catch (RelationNotFoundException exc) {
                throw new RuntimeException(exc.getMessage());
            }
        }
        Object[] params = new Object[]{this.myRelId, newRole, oldRoleValue};
        String[] signature = new String[]{"java.lang.String", "javax.management.relation.Role", "java.util.List"};
        try {
            this.myRelServiceMBeanServer.invoke(this.myRelServiceName, "updateRoleMap", params, signature);
        }
        catch (ReflectionException exc1) {
            throw new RuntimeException(exc1.getMessage());
        }
        catch (InstanceNotFoundException exc2) {
            throw new RelationServiceNotRegisteredException(exc2.getMessage());
        }
        catch (MBeanException exc3) {
            Exception wrappedExc = exc3.getTargetException();
            if (wrappedExc instanceof RelationNotFoundException) {
                throw (RelationNotFoundException)wrappedExc;
            }
            throw new RuntimeException(wrappedExc.getMessage());
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationSupport.class.getName(), "updateRelationServiceMap");
    }

    RoleResult setRolesInt(RoleList list, boolean relationServCallFlg, RelationService relationServ) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationTypeNotFoundException, RelationNotFoundException {
        if (list == null || relationServCallFlg && relationServ == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationSupport.class.getName(), "setRolesInt", new Object[]{list, relationServCallFlg, relationServ});
        RoleList roleList = new RoleList();
        RoleUnresolvedList roleUnresList = new RoleUnresolvedList();
        for (Role currRole : list) {
            Object currResult = null;
            try {
                currResult = this.setRoleInt(currRole, relationServCallFlg, relationServ, true);
            }
            catch (RoleNotFoundException exc1) {
            }
            catch (InvalidRoleValueException exc2) {
                // empty catch block
            }
            if (currResult instanceof Role) {
                try {
                    roleList.add((Role)currResult);
                    continue;
                }
                catch (IllegalArgumentException exc) {
                    throw new RuntimeException(exc.getMessage());
                }
            }
            if (!(currResult instanceof RoleUnresolved)) continue;
            try {
                roleUnresList.add((RoleUnresolved)currResult);
            }
            catch (IllegalArgumentException exc) {
                throw new RuntimeException(exc.getMessage());
            }
        }
        RoleResult result = new RoleResult(roleList, roleUnresList);
        JmxProperties.RELATION_LOGGER.exiting(RelationSupport.class.getName(), "setRolesInt");
        return result;
    }

    private void initMembers(String relationId, ObjectName relationServiceName, MBeanServer relationServiceMBeanServer, String relationTypeName, RoleList list) throws InvalidRoleValueException, IllegalArgumentException {
        if (relationId == null || relationServiceName == null || relationTypeName == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationSupport.class.getName(), "initMembers", new Object[]{relationId, relationServiceName, relationServiceMBeanServer, relationTypeName, list});
        this.myRelId = relationId;
        this.myRelServiceName = relationServiceName;
        this.myRelServiceMBeanServer = relationServiceMBeanServer;
        this.myRelTypeName = relationTypeName;
        this.initRoleMap(list);
        this.myInRelServFlg = Boolean.FALSE;
        JmxProperties.RELATION_LOGGER.exiting(RelationSupport.class.getName(), "initMembers");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initRoleMap(RoleList list) throws InvalidRoleValueException {
        if (list == null) {
            return;
        }
        JmxProperties.RELATION_LOGGER.entering(RelationSupport.class.getName(), "initRoleMap", list);
        Map<String, Role> map = this.myRoleName2ValueMap;
        synchronized (map) {
            for (Role currRole : list) {
                String currRoleName = currRole.getRoleName();
                if (this.myRoleName2ValueMap.containsKey(currRoleName)) {
                    StringBuilder excMsgStrB = new StringBuilder("Role name ");
                    excMsgStrB.append(currRoleName);
                    excMsgStrB.append(" used for two roles.");
                    throw new InvalidRoleValueException(excMsgStrB.toString());
                }
                this.myRoleName2ValueMap.put(currRoleName, (Role)currRole.clone());
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationSupport.class.getName(), "initRoleMap");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleMBeanUnregistrationInt(ObjectName objectName, String roleName, boolean relationServCallFlg, RelationService relationServ) throws IllegalArgumentException, RoleNotFoundException, InvalidRoleValueException, RelationServiceNotRegisteredException, RelationTypeNotFoundException, RelationNotFoundException {
        if (objectName == null || roleName == null || relationServCallFlg && relationServ == null) {
            String excMsg = "Invalid parameter.";
            throw new IllegalArgumentException(excMsg);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationSupport.class.getName(), "handleMBeanUnregistrationInt", new Object[]{objectName, roleName, relationServCallFlg, relationServ});
        Role role = null;
        Map<String, Role> map = this.myRoleName2ValueMap;
        synchronized (map) {
            role = this.myRoleName2ValueMap.get(roleName);
        }
        if (role == null) {
            StringBuilder excMsgStrB = new StringBuilder();
            String excMsg = "No role with name ";
            excMsgStrB.append(excMsg);
            excMsgStrB.append(roleName);
            throw new RoleNotFoundException(excMsgStrB.toString());
        }
        List<ObjectName> currRoleValue = role.getRoleValue();
        ArrayList<ObjectName> newRoleValue = new ArrayList<ObjectName>(currRoleValue);
        newRoleValue.remove(objectName);
        Role newRole = new Role(roleName, newRoleValue);
        Object result = this.setRoleInt(newRole, relationServCallFlg, relationServ, false);
        JmxProperties.RELATION_LOGGER.exiting(RelationSupport.class.getName(), "handleMBeanUnregistrationInt");
    }
}

