/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import com.sun.jmx.defaults.JmxProperties;
import java.util.logging.Level;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorNotification;
import javax.management.monitor.StringMonitorMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringMonitor
extends Monitor
implements StringMonitorMBean {
    private String stringToCompare = "";
    private boolean notifyMatch = false;
    private boolean notifyDiffer = false;
    private static final String[] types = new String[]{"jmx.monitor.error.runtime", "jmx.monitor.error.mbean", "jmx.monitor.error.attribute", "jmx.monitor.error.type", "jmx.monitor.string.matches", "jmx.monitor.string.differs"};
    private static final MBeanNotificationInfo[] notifsInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(types, "javax.management.monitor.MonitorNotification", "Notifications sent by the StringMonitor MBean")};
    private static final int MATCHING = 0;
    private static final int DIFFERING = 1;
    private static final int MATCHING_OR_DIFFERING = 2;

    @Override
    public synchronized void start() {
        if (this.isActive()) {
            JmxProperties.MONITOR_LOGGER.logp(Level.FINER, StringMonitor.class.getName(), "start", "the monitor is already active");
            return;
        }
        for (Monitor.ObservedObject o : this.observedObjects) {
            StringMonitorObservedObject smo = (StringMonitorObservedObject)o;
            smo.setStatus(2);
        }
        this.doStart();
    }

    @Override
    public synchronized void stop() {
        this.doStop();
    }

    @Override
    public synchronized String getDerivedGauge(ObjectName object) {
        return (String)super.getDerivedGauge(object);
    }

    @Override
    public synchronized long getDerivedGaugeTimeStamp(ObjectName object) {
        return super.getDerivedGaugeTimeStamp(object);
    }

    @Override
    @Deprecated
    public synchronized String getDerivedGauge() {
        if (this.observedObjects.isEmpty()) {
            return null;
        }
        return (String)((Monitor.ObservedObject)this.observedObjects.get(0)).getDerivedGauge();
    }

    @Override
    @Deprecated
    public synchronized long getDerivedGaugeTimeStamp() {
        if (this.observedObjects.isEmpty()) {
            return 0L;
        }
        return ((Monitor.ObservedObject)this.observedObjects.get(0)).getDerivedGaugeTimeStamp();
    }

    @Override
    public synchronized String getStringToCompare() {
        return this.stringToCompare;
    }

    @Override
    public synchronized void setStringToCompare(String value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Null string to compare");
        }
        if (this.stringToCompare.equals(value)) {
            return;
        }
        this.stringToCompare = value;
        for (Monitor.ObservedObject o : this.observedObjects) {
            StringMonitorObservedObject smo = (StringMonitorObservedObject)o;
            smo.setStatus(2);
        }
    }

    @Override
    public synchronized boolean getNotifyMatch() {
        return this.notifyMatch;
    }

    @Override
    public synchronized void setNotifyMatch(boolean value) {
        if (this.notifyMatch == value) {
            return;
        }
        this.notifyMatch = value;
    }

    @Override
    public synchronized boolean getNotifyDiffer() {
        return this.notifyDiffer;
    }

    @Override
    public synchronized void setNotifyDiffer(boolean value) {
        if (this.notifyDiffer == value) {
            return;
        }
        this.notifyDiffer = value;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return (MBeanNotificationInfo[])notifsInfo.clone();
    }

    @Override
    Monitor.ObservedObject createObservedObject(ObjectName object) {
        StringMonitorObservedObject smo = new StringMonitorObservedObject(object);
        smo.setStatus(2);
        return smo;
    }

    @Override
    synchronized boolean isComparableTypeValid(ObjectName object, String attribute, Comparable<?> value) {
        return value instanceof String;
    }

    @Override
    synchronized void onErrorNotification(MonitorNotification notification) {
        StringMonitorObservedObject o = (StringMonitorObservedObject)this.getObservedObject(notification.getObservedObject());
        if (o == null) {
            return;
        }
        o.setStatus(2);
    }

    @Override
    synchronized MonitorNotification buildAlarmNotification(ObjectName object, String attribute, Comparable<?> value) {
        String type = null;
        String msg = null;
        String trigger = null;
        StringMonitorObservedObject o = (StringMonitorObservedObject)this.getObservedObject(object);
        if (o == null) {
            return null;
        }
        if (o.getStatus() == 2) {
            if (o.getDerivedGauge().equals(this.stringToCompare)) {
                if (this.notifyMatch) {
                    type = "jmx.monitor.string.matches";
                    msg = "";
                    trigger = this.stringToCompare;
                }
                o.setStatus(1);
            } else {
                if (this.notifyDiffer) {
                    type = "jmx.monitor.string.differs";
                    msg = "";
                    trigger = this.stringToCompare;
                }
                o.setStatus(0);
            }
        } else if (o.getStatus() == 0) {
            if (o.getDerivedGauge().equals(this.stringToCompare)) {
                if (this.notifyMatch) {
                    type = "jmx.monitor.string.matches";
                    msg = "";
                    trigger = this.stringToCompare;
                }
                o.setStatus(1);
            }
        } else if (o.getStatus() == 1 && !o.getDerivedGauge().equals(this.stringToCompare)) {
            if (this.notifyDiffer) {
                type = "jmx.monitor.string.differs";
                msg = "";
                trigger = this.stringToCompare;
            }
            o.setStatus(0);
        }
        return new MonitorNotification(type, this, 0L, 0L, msg, null, null, null, trigger);
    }

    static class StringMonitorObservedObject
    extends Monitor.ObservedObject {
        private int status;

        public StringMonitorObservedObject(ObjectName observedObject) {
            super(observedObject);
        }

        public final synchronized int getStatus() {
            return this.status;
        }

        public final synchronized void setStatus(int status) {
            this.status = status;
        }
    }
}

