/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class ZipOutputStream
extends DeflaterOutputStream
implements ZipConstants {
    private XEntry current;
    private Vector<XEntry> xentries = new Vector();
    private HashSet<String> names = new HashSet();
    private CRC32 crc = new CRC32();
    private long written = 0L;
    private long locoff = 0L;
    private String comment;
    private int method = 8;
    private boolean finished;
    private boolean closed = false;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;

    private static int version(ZipEntry e) throws ZipException {
        switch (e.method) {
            case 8: {
                return 20;
            }
            case 0: {
                return 10;
            }
        }
        throw new ZipException("unsupported compression method");
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    public ZipOutputStream(OutputStream out) {
        super(out, new Deflater(-1, true));
        this.usesDefaultDeflater = true;
    }

    public void setComment(String comment) {
        if (comment != null && comment.length() > 21845 && ZipOutputStream.getUTF8Length(comment) > 65535) {
            throw new IllegalArgumentException("ZIP file comment too long.");
        }
        this.comment = comment;
    }

    public void setMethod(int method) {
        if (method != 8 && method != 0) {
            throw new IllegalArgumentException("invalid compression method");
        }
        this.method = method;
    }

    public void setLevel(int level) {
        this.def.setLevel(level);
    }

    public void putNextEntry(ZipEntry e) throws IOException {
        this.ensureOpen();
        if (this.current != null) {
            this.closeEntry();
        }
        if (e.time == -1L) {
            e.setTime(System.currentTimeMillis());
        }
        if (e.method == -1) {
            e.method = this.method;
        }
        switch (e.method) {
            case 8: {
                break;
            }
            case 0: {
                if (e.size == -1L) {
                    e.size = e.csize;
                } else if (e.csize == -1L) {
                    e.csize = e.size;
                } else if (e.size != e.csize) {
                    throw new ZipException("STORED entry where compressed != uncompressed size");
                }
                if (e.size != -1L && e.crc != -1L) break;
                throw new ZipException("STORED entry missing size, compressed size, or crc-32");
            }
            default: {
                throw new ZipException("unsupported compression method");
            }
        }
        if (!this.names.add(e.name)) {
            throw new ZipException("duplicate entry: " + e.name);
        }
        this.current = new XEntry(e, this.written);
        this.xentries.add(this.current);
        this.writeLOC(this.current);
    }

    public void closeEntry() throws IOException {
        this.ensureOpen();
        if (this.current != null) {
            ZipEntry e = this.current.entry;
            switch (e.method) {
                case 8: {
                    this.def.finish();
                    while (!this.def.finished()) {
                        this.deflate();
                    }
                    if ((this.current.flag & 8) == 0) {
                        if (e.size != this.def.getBytesRead()) {
                            throw new ZipException("invalid entry size (expected " + e.size + " but got " + this.def.getBytesRead() + " bytes)");
                        }
                        if (e.csize != this.def.getBytesWritten()) {
                            throw new ZipException("invalid entry compressed size (expected " + e.csize + " but got " + this.def.getBytesWritten() + " bytes)");
                        }
                        if (e.crc != this.crc.getValue()) {
                            throw new ZipException("invalid entry CRC-32 (expected 0x" + Long.toHexString(e.crc) + " but got 0x" + Long.toHexString(this.crc.getValue()) + ")");
                        }
                    } else {
                        e.size = this.def.getBytesRead();
                        e.csize = this.def.getBytesWritten();
                        e.crc = this.crc.getValue();
                        this.writeEXT(e);
                    }
                    this.def.reset();
                    this.written += e.csize;
                    break;
                }
                case 0: {
                    if (e.size != this.written - this.locoff) {
                        throw new ZipException("invalid entry size (expected " + e.size + " but got " + (this.written - this.locoff) + " bytes)");
                    }
                    if (e.crc == this.crc.getValue()) break;
                    throw new ZipException("invalid entry crc-32 (expected 0x" + Long.toHexString(e.crc) + " but got 0x" + Long.toHexString(this.crc.getValue()) + ")");
                }
                default: {
                    throw new ZipException("invalid compression method");
                }
            }
            this.crc.reset();
            this.current = null;
        }
    }

    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (this.current == null) {
            throw new ZipException("no current ZIP entry");
        }
        ZipEntry entry = this.current.entry;
        switch (entry.method) {
            case 8: {
                super.write(b, off, len);
                break;
            }
            case 0: {
                this.written += (long)len;
                if (this.written - this.locoff > entry.size) {
                    throw new ZipException("attempt to write past end of STORED entry");
                }
                this.out.write(b, off, len);
                break;
            }
            default: {
                throw new ZipException("invalid compression method");
            }
        }
        this.crc.update(b, off, len);
    }

    public void finish() throws IOException {
        this.ensureOpen();
        if (this.finished) {
            return;
        }
        if (this.current != null) {
            this.closeEntry();
        }
        if (this.xentries.size() < 1) {
            throw new ZipException("ZIP file must have at least one entry");
        }
        long off = this.written;
        for (XEntry xentry : this.xentries) {
            this.writeCEN(xentry);
        }
        this.writeEND(off, this.written - off);
        this.finished = true;
    }

    public void close() throws IOException {
        if (!this.closed) {
            super.close();
            this.closed = true;
        }
    }

    private void writeLOC(XEntry xentry) throws IOException {
        ZipEntry e = xentry.entry;
        int flag = xentry.flag;
        this.writeInt(67324752L);
        this.writeShort(ZipOutputStream.version(e));
        this.writeShort(flag);
        this.writeShort(e.method);
        this.writeInt(e.time);
        if ((flag & 8) == 8) {
            this.writeInt(0L);
            this.writeInt(0L);
            this.writeInt(0L);
        } else {
            this.writeInt(e.crc);
            this.writeInt(e.csize);
            this.writeInt(e.size);
        }
        byte[] nameBytes = ZipOutputStream.getUTF8Bytes(e.name);
        this.writeShort(nameBytes.length);
        this.writeShort(e.extra != null ? e.extra.length : 0);
        this.writeBytes(nameBytes, 0, nameBytes.length);
        if (e.extra != null) {
            this.writeBytes(e.extra, 0, e.extra.length);
        }
        this.locoff = this.written;
    }

    private void writeEXT(ZipEntry e) throws IOException {
        this.writeInt(134695760L);
        this.writeInt(e.crc);
        this.writeInt(e.csize);
        this.writeInt(e.size);
    }

    private void writeCEN(XEntry xentry) throws IOException {
        byte[] commentBytes;
        ZipEntry e = xentry.entry;
        int flag = xentry.flag;
        int version = ZipOutputStream.version(e);
        this.writeInt(33639248L);
        this.writeShort(version);
        this.writeShort(version);
        this.writeShort(flag);
        this.writeShort(e.method);
        this.writeInt(e.time);
        this.writeInt(e.crc);
        this.writeInt(e.csize);
        this.writeInt(e.size);
        byte[] nameBytes = ZipOutputStream.getUTF8Bytes(e.name);
        this.writeShort(nameBytes.length);
        this.writeShort(e.extra != null ? e.extra.length : 0);
        if (e.comment != null) {
            commentBytes = ZipOutputStream.getUTF8Bytes(e.comment);
            this.writeShort(commentBytes.length);
        } else {
            commentBytes = null;
            this.writeShort(0);
        }
        this.writeShort(0);
        this.writeShort(0);
        this.writeInt(0L);
        this.writeInt(xentry.offset);
        this.writeBytes(nameBytes, 0, nameBytes.length);
        if (e.extra != null) {
            this.writeBytes(e.extra, 0, e.extra.length);
        }
        if (commentBytes != null) {
            this.writeBytes(commentBytes, 0, commentBytes.length);
        }
    }

    private void writeEND(long off, long len) throws IOException {
        int count = this.xentries.size();
        this.writeInt(101010256L);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(count);
        this.writeShort(count);
        this.writeInt(len);
        this.writeInt(off);
        if (this.comment != null) {
            byte[] b = ZipOutputStream.getUTF8Bytes(this.comment);
            this.writeShort(b.length);
            this.writeBytes(b, 0, b.length);
        } else {
            this.writeShort(0);
        }
    }

    private void writeShort(int v) throws IOException {
        OutputStream out = this.out;
        out.write(v >>> 0 & 0xFF);
        out.write(v >>> 8 & 0xFF);
        this.written += 2L;
    }

    private void writeInt(long v) throws IOException {
        OutputStream out = this.out;
        out.write((int)(v >>> 0 & 0xFFL));
        out.write((int)(v >>> 8 & 0xFFL));
        out.write((int)(v >>> 16 & 0xFFL));
        out.write((int)(v >>> 24 & 0xFFL));
        this.written += 4L;
    }

    private void writeBytes(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.written += (long)len;
    }

    static int getUTF8Length(String s) {
        int count = 0;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch <= '\u007f') {
                ++count;
                continue;
            }
            if (ch <= '\u07ff') {
                count += 2;
                continue;
            }
            count += 3;
        }
        return count;
    }

    private static byte[] getUTF8Bytes(String s) {
        char[] c = s.toCharArray();
        int len = c.length;
        int count = 0;
        for (int i = 0; i < len; ++i) {
            char ch = c[i];
            if (ch <= '\u007f') {
                ++count;
                continue;
            }
            if (ch <= '\u07ff') {
                count += 2;
                continue;
            }
            count += 3;
        }
        byte[] b = new byte[count];
        int off = 0;
        for (int i = 0; i < len; ++i) {
            char ch = c[i];
            if (ch <= '\u007f') {
                b[off++] = (byte)ch;
                continue;
            }
            if (ch <= '\u07ff') {
                b[off++] = (byte)(ch >> 6 | 0xC0);
                b[off++] = (byte)(ch & 0x3F | 0x80);
                continue;
            }
            b[off++] = (byte)(ch >> 12 | 0xE0);
            b[off++] = (byte)(ch >> 6 & 0x3F | 0x80);
            b[off++] = (byte)(ch & 0x3F | 0x80);
        }
        return b;
    }

    private static class XEntry {
        public final ZipEntry entry;
        public final long offset;
        public final int flag;

        public XEntry(ZipEntry entry, long offset) {
            this.entry = entry;
            this.offset = offset;
            this.flag = entry.method == 8 && (entry.size == -1L || entry.csize == -1L || entry.crc == -1L) ? 8 : 0;
        }
    }
}

