/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class ZipInputStream
extends InflaterInputStream
implements ZipConstants {
    private ZipEntry entry;
    private int flag;
    private CRC32 crc = new CRC32();
    private long remaining;
    private byte[] tmpbuf = new byte[512];
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    private boolean closed = false;
    private boolean entryEOF = false;
    private byte[] b = new byte[256];

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    public ZipInputStream(InputStream in) {
        super(new PushbackInputStream(in, 512), new Inflater(true), 512);
        this.usesDefaultInflater = true;
        if (in == null) {
            throw new NullPointerException("in is null");
        }
    }

    public ZipEntry getNextEntry() throws IOException {
        this.ensureOpen();
        if (this.entry != null) {
            this.closeEntry();
        }
        this.crc.reset();
        this.inf.reset();
        this.entry = this.readLOC();
        if (this.entry == null) {
            return null;
        }
        if (this.entry.method == 0) {
            this.remaining = this.entry.size;
        }
        this.entryEOF = false;
        return this.entry;
    }

    public void closeEntry() throws IOException {
        this.ensureOpen();
        while (this.read(this.tmpbuf, 0, this.tmpbuf.length) != -1) {
        }
        this.entryEOF = true;
    }

    public int available() throws IOException {
        this.ensureOpen();
        if (this.entryEOF) {
            return 0;
        }
        return 1;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.entry == null) {
            return -1;
        }
        switch (this.entry.method) {
            case 8: {
                len = super.read(b, off, len);
                if (len == -1) {
                    this.readEnd(this.entry);
                    this.entryEOF = true;
                    this.entry = null;
                } else {
                    this.crc.update(b, off, len);
                }
                return len;
            }
            case 0: {
                if (this.remaining <= 0L) {
                    this.entryEOF = true;
                    this.entry = null;
                    return -1;
                }
                if ((long)len > this.remaining) {
                    len = (int)this.remaining;
                }
                if ((len = this.in.read(b, off, len)) == -1) {
                    throw new ZipException("unexpected EOF");
                }
                this.crc.update(b, off, len);
                this.remaining -= (long)len;
                if (this.remaining == 0L && this.entry.crc != this.crc.getValue()) {
                    throw new ZipException("invalid entry CRC (expected 0x" + Long.toHexString(this.entry.crc) + " but got 0x" + Long.toHexString(this.crc.getValue()) + ")");
                }
                return len;
            }
        }
        throw new ZipException("invalid compression method");
    }

    public long skip(long n) throws IOException {
        int total;
        int len;
        if (n < 0L) {
            throw new IllegalArgumentException("negative skip length");
        }
        this.ensureOpen();
        int max = (int)Math.min(n, Integer.MAX_VALUE);
        for (total = 0; total < max; total += len) {
            len = max - total;
            if (len > this.tmpbuf.length) {
                len = this.tmpbuf.length;
            }
            if ((len = this.read(this.tmpbuf, 0, len)) != -1) continue;
            this.entryEOF = true;
            break;
        }
        return total;
    }

    public void close() throws IOException {
        if (!this.closed) {
            super.close();
            this.closed = true;
        }
    }

    private ZipEntry readLOC() throws IOException {
        int blen;
        try {
            this.readFully(this.tmpbuf, 0, 30);
        }
        catch (EOFException e) {
            return null;
        }
        if (ZipInputStream.get32(this.tmpbuf, 0) != 67324752L) {
            return null;
        }
        int len = ZipInputStream.get16(this.tmpbuf, 26);
        if (len > (blen = this.b.length)) {
            while (len > (blen *= 2)) {
            }
            this.b = new byte[blen];
        }
        this.readFully(this.b, 0, len);
        ZipEntry e = this.createZipEntry(ZipInputStream.getUTF8String(this.b, 0, len));
        this.flag = ZipInputStream.get16(this.tmpbuf, 6);
        if ((this.flag & 1) == 1) {
            throw new ZipException("encrypted ZIP entry not supported");
        }
        e.method = ZipInputStream.get16(this.tmpbuf, 8);
        e.time = ZipInputStream.get32(this.tmpbuf, 10);
        if ((this.flag & 8) == 8) {
            if (e.method != 8) {
                throw new ZipException("only DEFLATED entries can have EXT descriptor");
            }
        } else {
            e.crc = ZipInputStream.get32(this.tmpbuf, 14);
            e.csize = ZipInputStream.get32(this.tmpbuf, 18);
            e.size = ZipInputStream.get32(this.tmpbuf, 22);
        }
        if ((len = ZipInputStream.get16(this.tmpbuf, 28)) > 0) {
            byte[] bb = new byte[len];
            this.readFully(bb, 0, len);
            e.setExtra(bb);
        }
        return e;
    }

    private static String getUTF8String(byte[] b, int off, int len) {
        int count = 0;
        int max = off + len;
        int i = off;
        block10: while (i < max) {
            int c = b[i++] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    continue block10;
                }
                case 12: 
                case 13: {
                    if ((b[i++] & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    ++count;
                    continue block10;
                }
                case 14: {
                    if ((b[i++] & 0xC0) != 128 || (b[i++] & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    ++count;
                    continue block10;
                }
            }
            throw new IllegalArgumentException();
        }
        if (i != max) {
            throw new IllegalArgumentException();
        }
        char[] cs = new char[count];
        i = 0;
        block11: while (off < max) {
            int c = b[off++] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cs[i++] = (char)c;
                    continue block11;
                }
                case 12: 
                case 13: {
                    cs[i++] = (char)((c & 0x1F) << 6 | b[off++] & 0x3F);
                    continue block11;
                }
                case 14: {
                    int t = (b[off++] & 0x3F) << 6;
                    cs[i++] = (char)((c & 0xF) << 12 | t | b[off++] & 0x3F);
                    continue block11;
                }
            }
            throw new IllegalArgumentException();
        }
        return new String(cs, 0, count);
    }

    protected ZipEntry createZipEntry(String name) {
        return new ZipEntry(name);
    }

    private void readEnd(ZipEntry e) throws IOException {
        int n = this.inf.getRemaining();
        if (n > 0) {
            ((PushbackInputStream)this.in).unread(this.buf, this.len - n, n);
        }
        if ((this.flag & 8) == 8) {
            this.readFully(this.tmpbuf, 0, 16);
            long sig = ZipInputStream.get32(this.tmpbuf, 0);
            if (sig != 134695760L) {
                e.crc = sig;
                e.csize = ZipInputStream.get32(this.tmpbuf, 4);
                e.size = ZipInputStream.get32(this.tmpbuf, 8);
                ((PushbackInputStream)this.in).unread(this.tmpbuf, 11, 4);
            } else {
                e.crc = ZipInputStream.get32(this.tmpbuf, 4);
                e.csize = ZipInputStream.get32(this.tmpbuf, 8);
                e.size = ZipInputStream.get32(this.tmpbuf, 12);
            }
        }
        if (e.size != this.inf.getBytesWritten()) {
            throw new ZipException("invalid entry size (expected " + e.size + " but got " + this.inf.getBytesWritten() + " bytes)");
        }
        if (e.csize != this.inf.getBytesRead()) {
            throw new ZipException("invalid entry compressed size (expected " + e.csize + " but got " + this.inf.getBytesRead() + " bytes)");
        }
        if (e.crc != this.crc.getValue()) {
            throw new ZipException("invalid entry CRC (expected 0x" + Long.toHexString(e.crc) + " but got 0x" + Long.toHexString(this.crc.getValue()) + ")");
        }
    }

    private void readFully(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int n = this.in.read(b, off, len);
            if (n == -1) {
                throw new EOFException();
            }
            off += n;
            len -= n;
        }
    }

    private static final int get16(byte[] b, int off) {
        return b[off] & 0xFF | (b[off + 1] & 0xFF) << 8;
    }

    private static final long get32(byte[] b, int off) {
        return (long)ZipInputStream.get16(b, off) | (long)ZipInputStream.get16(b, off + 2) << 16;
    }
}

