/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

public class Deflater {
    private long strm;
    private byte[] buf = new byte[0];
    private int off;
    private int len;
    private int level;
    private int strategy;
    private boolean setParams;
    private boolean finish;
    private boolean finished;
    public static final int DEFLATED = 8;
    public static final int NO_COMPRESSION = 0;
    public static final int BEST_SPEED = 1;
    public static final int BEST_COMPRESSION = 9;
    public static final int DEFAULT_COMPRESSION = -1;
    public static final int FILTERED = 1;
    public static final int HUFFMAN_ONLY = 2;
    public static final int DEFAULT_STRATEGY = 0;

    public Deflater(int level, boolean nowrap) {
        this.level = level;
        this.strategy = 0;
        this.strm = Deflater.init(level, 0, nowrap);
    }

    public Deflater(int level) {
        this(level, false);
    }

    public Deflater() {
        this(-1, false);
    }

    public synchronized void setInput(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.buf = b;
        this.off = off;
        this.len = len;
    }

    public void setInput(byte[] b) {
        this.setInput(b, 0, b.length);
    }

    public synchronized void setDictionary(byte[] b, int off, int len) {
        if (this.strm == 0L || b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Deflater.setDictionary(this.strm, b, off, len);
    }

    public void setDictionary(byte[] b) {
        this.setDictionary(b, 0, b.length);
    }

    public synchronized void setStrategy(int strategy) {
        switch (strategy) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (this.strategy != strategy) {
            this.strategy = strategy;
            this.setParams = true;
        }
    }

    public synchronized void setLevel(int level) {
        if ((level < 0 || level > 9) && level != -1) {
            throw new IllegalArgumentException("invalid compression level");
        }
        if (this.level != level) {
            this.level = level;
            this.setParams = true;
        }
    }

    public boolean needsInput() {
        return this.len <= 0;
    }

    public synchronized void finish() {
        this.finish = true;
    }

    public synchronized boolean finished() {
        return this.finished;
    }

    public synchronized int deflate(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.deflateBytes(b, off, len);
    }

    public int deflate(byte[] b) {
        return this.deflate(b, 0, b.length);
    }

    public synchronized int getAdler() {
        this.ensureOpen();
        return Deflater.getAdler(this.strm);
    }

    public int getTotalIn() {
        return (int)this.getBytesRead();
    }

    public synchronized long getBytesRead() {
        this.ensureOpen();
        return Deflater.getBytesRead(this.strm);
    }

    public int getTotalOut() {
        return (int)this.getBytesWritten();
    }

    public synchronized long getBytesWritten() {
        this.ensureOpen();
        return Deflater.getBytesWritten(this.strm);
    }

    public synchronized void reset() {
        this.ensureOpen();
        Deflater.reset(this.strm);
        this.finish = false;
        this.finished = false;
        this.len = 0;
        this.off = 0;
    }

    public synchronized void end() {
        if (this.strm != 0L) {
            Deflater.end(this.strm);
            this.strm = 0L;
            this.buf = null;
        }
    }

    protected void finalize() {
        this.end();
    }

    private void ensureOpen() {
        if (this.strm == 0L) {
            throw new NullPointerException();
        }
    }

    private static native void initIDs();

    private static native long init(int var0, int var1, boolean var2);

    private static native void setDictionary(long var0, byte[] var2, int var3, int var4);

    private native int deflateBytes(byte[] var1, int var2, int var3);

    private static native int getAdler(long var0);

    private static native long getBytesRead(long var0);

    private static native long getBytesWritten(long var0);

    private static native void reset(long var0);

    private static native void end(long var0);

    static {
        Deflater.initIDs();
    }
}

