/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.Logging;
import java.util.logging.LoggingMXBean;
import java.util.logging.LoggingPermission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogManager {
    private static LogManager manager;
    private static final Handler[] emptyHandlers;
    private Properties props = new Properties();
    private PropertyChangeSupport changes = new PropertyChangeSupport(LogManager.class);
    private static final Level defaultLevel;
    private Hashtable<String, WeakReference<Logger>> loggers = new Hashtable();
    private LogNode root = new LogNode(null);
    private Logger rootLogger;
    private volatile boolean readPrimordialConfiguration;
    private boolean initializedGlobalHandlers = true;
    private boolean deathImminent;
    private Permission ourPermission = new LoggingPermission("control", null);
    private static LoggingMXBean loggingMXBean;
    public static final String LOGGING_MXBEAN_NAME = "java.util.logging:type=Logging";

    protected LogManager() {
        try {
            Runtime.getRuntime().addShutdownHook(new Cleaner());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static LogManager getLogManager() {
        if (manager != null) {
            manager.readPrimordialConfiguration();
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPrimordialConfiguration() {
        if (!this.readPrimordialConfiguration) {
            LogManager logManager = this;
            synchronized (logManager) {
                if (!this.readPrimordialConfiguration) {
                    if (System.out == null) {
                        return;
                    }
                    this.readPrimordialConfiguration = true;
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                            @Override
                            public Object run() throws Exception {
                                LogManager.this.readConfiguration();
                                return null;
                            }
                        });
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) throws SecurityException {
        if (l == null) {
            throw new NullPointerException();
        }
        this.checkAccess();
        this.changes.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) throws SecurityException {
        this.checkAccess();
        this.changes.removePropertyChangeListener(l);
    }

    synchronized Logger demandLogger(String name) {
        Logger result = this.getLogger(name);
        if (result == null) {
            result = new Logger(name, null);
            this.addLogger(result);
            result = this.getLogger(name);
        }
        return result;
    }

    private void processParentHandlers(Logger logger, String name) {
        int ix2;
        int ix = 1;
        while ((ix2 = name.indexOf(".", ix)) >= 0) {
            String pname = name.substring(0, ix2);
            if (this.getProperty(pname + ".level") != null || this.getProperty(pname + ".handlers") != null) {
                this.demandLogger(pname);
            }
            ix = ix2 + 1;
        }
    }

    private void loadLoggerHandlers(final Logger logger, final String name, final String handlersPropertyName) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                boolean useParent;
                if (logger != LogManager.this.rootLogger && !(useParent = LogManager.this.getBooleanProperty(name + ".useParentHandlers", true))) {
                    logger.setUseParentHandlers(false);
                }
                String[] names = LogManager.this.parseClassNames(handlersPropertyName);
                for (int i = 0; i < names.length; ++i) {
                    String word = names[i];
                    try {
                        Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(word);
                        Handler hdl = (Handler)clz.newInstance();
                        try {
                            String levs = LogManager.this.getProperty(word + ".level");
                            if (levs != null) {
                                hdl.setLevel(Level.parse(levs));
                            }
                        }
                        catch (Exception ex) {
                            System.err.println("Can't set level for " + word);
                        }
                        logger.addHandler(hdl);
                        continue;
                    }
                    catch (Exception ex) {
                        System.err.println("Can't load log handler \"" + word + "\"");
                        System.err.println("" + ex);
                        ex.printStackTrace();
                    }
                }
                return null;
            }
        });
    }

    public synchronized boolean addLogger(Logger logger) {
        WeakReference<Logger> nodeRef;
        String name = logger.getName();
        if (name == null) {
            throw new NullPointerException();
        }
        WeakReference<Logger> ref = this.loggers.get(name);
        if (ref != null) {
            if (ref.get() == null) {
                this.loggers.remove(name);
            } else {
                return false;
            }
        }
        this.loggers.put(name, new WeakReference<Logger>(logger));
        Level level = this.getLevelProperty(name + ".level", null);
        if (level != null) {
            LogManager.doSetLevel(logger, level);
        }
        this.loadLoggerHandlers(logger, name, name + ".handlers");
        this.processParentHandlers(logger, name);
        LogNode node = this.findNode(name);
        node.loggerRef = new WeakReference<Logger>(logger);
        Logger parent = null;
        LogNode nodep = node.parent;
        while (nodep != null && ((nodeRef = nodep.loggerRef) == null || (parent = (Logger)nodeRef.get()) == null)) {
            nodep = nodep.parent;
        }
        if (parent != null) {
            LogManager.doSetParent(logger, parent);
        }
        node.walkAndSetParent(logger);
        return true;
    }

    private static void doSetLevel(final Logger logger, final Level level) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            logger.setLevel(level);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                logger.setLevel(level);
                return null;
            }
        });
    }

    private static void doSetParent(final Logger logger, final Logger parent) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            logger.setParent(parent);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                logger.setParent(parent);
                return null;
            }
        });
    }

    private LogNode findNode(String name) {
        if (name == null || name.equals("")) {
            return this.root;
        }
        LogNode node = this.root;
        while (name.length() > 0) {
            LogNode child;
            String head;
            int ix = name.indexOf(".");
            if (ix > 0) {
                head = name.substring(0, ix);
                name = name.substring(ix + 1);
            } else {
                head = name;
                name = "";
            }
            if (node.children == null) {
                node.children = new HashMap();
            }
            if ((child = node.children.get(head)) == null) {
                child = new LogNode(node);
                node.children.put(head, child);
            }
            node = child;
        }
        return node;
    }

    public synchronized Logger getLogger(String name) {
        WeakReference<Logger> ref = this.loggers.get(name);
        if (ref == null) {
            return null;
        }
        Logger logger = (Logger)ref.get();
        if (logger == null) {
            this.loggers.remove(name);
        }
        return logger;
    }

    public synchronized Enumeration<String> getLoggerNames() {
        return this.loggers.keys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfiguration() throws IOException, SecurityException {
        String fname;
        this.checkAccess();
        String cname = System.getProperty("java.util.logging.config.class");
        if (cname != null) {
            try {
                try {
                    Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(cname);
                    clz.newInstance();
                    return;
                }
                catch (ClassNotFoundException ex) {
                    Class<?> clz = Thread.currentThread().getContextClassLoader().loadClass(cname);
                    clz.newInstance();
                    return;
                }
            }
            catch (Exception ex) {
                System.err.println("Logging configuration class \"" + cname + "\" failed");
                System.err.println("" + ex);
            }
        }
        if ((fname = System.getProperty("java.util.logging.config.file")) == null) {
            fname = System.getProperty("java.home");
            if (fname == null) {
                throw new Error("Can't find java.home ??");
            }
            File f = new File(fname, "lib");
            f = new File(f, "logging.properties");
            fname = f.getCanonicalPath();
        }
        FileInputStream in = new FileInputStream(fname);
        BufferedInputStream bin = new BufferedInputStream(in);
        try {
            this.readConfiguration(bin);
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws SecurityException {
        this.checkAccess();
        LogManager logManager = this;
        synchronized (logManager) {
            this.props = new Properties();
            this.initializedGlobalHandlers = true;
        }
        Enumeration<String> enum_ = this.getLoggerNames();
        while (enum_.hasMoreElements()) {
            String name = enum_.nextElement();
            this.resetLogger(name);
        }
    }

    private void resetLogger(String name) {
        Logger logger = this.getLogger(name);
        if (logger == null) {
            return;
        }
        Handler[] targets = logger.getHandlers();
        for (int i = 0; i < targets.length; ++i) {
            Handler h = targets[i];
            logger.removeHandler(h);
            try {
                h.close();
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (name != null && name.equals("")) {
            logger.setLevel(defaultLevel);
        } else {
            logger.setLevel(null);
        }
    }

    private String[] parseClassNames(String propertyName) {
        String hands = this.getProperty(propertyName);
        if (hands == null) {
            return new String[0];
        }
        hands = hands.trim();
        int ix = 0;
        Vector<String> result = new Vector<String>();
        while (ix < hands.length()) {
            int end;
            for (end = ix; end < hands.length() && !Character.isWhitespace(hands.charAt(end)) && hands.charAt(end) != ','; ++end) {
            }
            String word = hands.substring(ix, end);
            ix = end + 1;
            if ((word = word.trim()).length() == 0) continue;
            result.add(word);
        }
        return result.toArray(new String[result.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfiguration(InputStream ins) throws IOException, SecurityException {
        this.checkAccess();
        this.reset();
        this.props.load(ins);
        String[] names = this.parseClassNames("config");
        for (int i = 0; i < names.length; ++i) {
            String word = names[i];
            try {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(word);
                clz.newInstance();
                continue;
            }
            catch (Exception ex) {
                System.err.println("Can't load config class \"" + word + "\"");
                System.err.println("" + ex);
            }
        }
        this.setLevelsOnExistingLoggers();
        this.changes.firePropertyChange(null, null, null);
        LogManager logManager = this;
        synchronized (logManager) {
            this.initializedGlobalHandlers = false;
        }
    }

    public String getProperty(String name) {
        return this.props.getProperty(name);
    }

    String getStringProperty(String name, String defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        return val.trim();
    }

    int getIntProperty(String name, int defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(val.trim());
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    boolean getBooleanProperty(String name, boolean defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        if ((val = val.toLowerCase()).equals("true") || val.equals("1")) {
            return true;
        }
        if (val.equals("false") || val.equals("0")) {
            return false;
        }
        return defaultValue;
    }

    Level getLevelProperty(String name, Level defaultValue) {
        String val = this.getProperty(name);
        if (val == null) {
            return defaultValue;
        }
        try {
            return Level.parse(val.trim());
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    Filter getFilterProperty(String name, Filter defaultValue) {
        String val = this.getProperty(name);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Filter)clz.newInstance();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return defaultValue;
    }

    Formatter getFormatterProperty(String name, Formatter defaultValue) {
        String val = this.getProperty(name);
        try {
            if (val != null) {
                Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(val);
                return (Formatter)clz.newInstance();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return defaultValue;
    }

    private synchronized void initializeGlobalHandlers() {
        if (this.initializedGlobalHandlers) {
            return;
        }
        this.initializedGlobalHandlers = true;
        if (this.deathImminent) {
            return;
        }
        this.loadLoggerHandlers(this.rootLogger, null, "handlers");
    }

    public void checkAccess() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return;
        }
        sm.checkPermission(this.ourPermission);
    }

    private synchronized void setLevelsOnExistingLoggers() {
        Enumeration<?> enum_ = this.props.propertyNames();
        while (enum_.hasMoreElements()) {
            String key = (String)enum_.nextElement();
            if (!key.endsWith(".level")) continue;
            int ix = key.length() - 6;
            String name = key.substring(0, ix);
            Level level = this.getLevelProperty(key, null);
            if (level == null) {
                System.err.println("Bad level value for property: " + key);
                continue;
            }
            Logger l = this.getLogger(name);
            if (l == null) continue;
            l.setLevel(level);
        }
    }

    public static synchronized LoggingMXBean getLoggingMXBean() {
        if (loggingMXBean == null) {
            loggingMXBean = new Logging();
        }
        return loggingMXBean;
    }

    static {
        emptyHandlers = new Handler[0];
        defaultLevel = Level.INFO;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                String cname = null;
                try {
                    cname = System.getProperty("java.util.logging.manager");
                    if (cname != null) {
                        try {
                            Class<?> clz = ClassLoader.getSystemClassLoader().loadClass(cname);
                            manager = (LogManager)clz.newInstance();
                        }
                        catch (ClassNotFoundException ex) {
                            Class<?> clz = Thread.currentThread().getContextClassLoader().loadClass(cname);
                            manager = (LogManager)clz.newInstance();
                        }
                    }
                }
                catch (Exception ex) {
                    System.err.println("Could not load Logmanager \"" + cname + "\"");
                    ex.printStackTrace();
                }
                if (manager == null) {
                    manager = new LogManager();
                }
                LogManager logManager = manager;
                LogManager logManager2 = manager;
                logManager2.getClass();
                logManager.rootLogger = logManager2.new RootLogger();
                manager.addLogger(manager.rootLogger);
                Logger.global.setLogManager(manager);
                manager.addLogger(Logger.global);
                return null;
            }
        });
        loggingMXBean = null;
    }

    private class RootLogger
    extends Logger {
        private RootLogger() {
            super("", null);
            this.setLevel(defaultLevel);
        }

        public void log(LogRecord record) {
            LogManager.this.initializeGlobalHandlers();
            super.log(record);
        }

        public void addHandler(Handler h) {
            LogManager.this.initializeGlobalHandlers();
            super.addHandler(h);
        }

        public void removeHandler(Handler h) {
            LogManager.this.initializeGlobalHandlers();
            super.removeHandler(h);
        }

        public Handler[] getHandlers() {
            LogManager.this.initializeGlobalHandlers();
            return super.getHandlers();
        }
    }

    private static class LogNode {
        HashMap<String, LogNode> children;
        WeakReference<Logger> loggerRef;
        LogNode parent;

        LogNode(LogNode parent) {
            this.parent = parent;
        }

        void walkAndSetParent(Logger parent) {
            if (this.children == null) {
                return;
            }
            for (LogNode node : this.children.values()) {
                Logger logger;
                WeakReference<Logger> ref = node.loggerRef;
                Logger logger2 = logger = ref == null ? null : (Logger)ref.get();
                if (logger == null) {
                    node.walkAndSetParent(parent);
                    continue;
                }
                LogManager.doSetParent(logger, parent);
            }
        }
    }

    private class Cleaner
    extends Thread {
        private Cleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LogManager mgr = manager;
            LogManager logManager = LogManager.this;
            synchronized (logManager) {
                LogManager.this.deathImminent = true;
                LogManager.this.initializedGlobalHandlers = true;
            }
            LogManager.this.reset();
        }
    }
}

