/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteBufferAsCharBufferRB;
import java.nio.ByteBufferAsCharBufferRL;
import java.nio.ByteBufferAsDoubleBufferRB;
import java.nio.ByteBufferAsDoubleBufferRL;
import java.nio.ByteBufferAsFloatBufferRB;
import java.nio.ByteBufferAsFloatBufferRL;
import java.nio.ByteBufferAsIntBufferRB;
import java.nio.ByteBufferAsIntBufferRL;
import java.nio.ByteBufferAsLongBufferRB;
import java.nio.ByteBufferAsLongBufferRL;
import java.nio.ByteBufferAsShortBufferRB;
import java.nio.ByteBufferAsShortBufferRL;
import java.nio.CharBuffer;
import java.nio.DirectByteBuffer;
import java.nio.DirectCharBufferRS;
import java.nio.DirectCharBufferRU;
import java.nio.DirectDoubleBufferRS;
import java.nio.DirectDoubleBufferRU;
import java.nio.DirectFloatBufferRS;
import java.nio.DirectFloatBufferRU;
import java.nio.DirectIntBufferRS;
import java.nio.DirectIntBufferRU;
import java.nio.DirectLongBufferRS;
import java.nio.DirectLongBufferRU;
import java.nio.DirectShortBufferRS;
import java.nio.DirectShortBufferRU;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;
import sun.nio.ch.DirectBuffer;

class DirectByteBufferR
extends DirectByteBuffer
implements DirectBuffer {
    DirectByteBufferR(int cap) {
        super(cap);
    }

    protected DirectByteBufferR(int cap, long addr, Runnable unmapper) {
        super(cap, addr, unmapper);
    }

    DirectByteBufferR(DirectBuffer db, int mark, int pos, int lim, int cap, int off) {
        super(db, mark, pos, lim, cap, off);
    }

    public ByteBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int off = pos << 0;
        assert (off >= 0);
        return new DirectByteBufferR(this, -1, 0, rem, rem, off);
    }

    public ByteBuffer duplicate() {
        return new DirectByteBufferR(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    public ByteBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    public ByteBuffer put(byte x) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer put(int i, byte x) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer put(ByteBuffer src) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer put(byte[] src, int offset, int length) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    public boolean isDirect() {
        return true;
    }

    public boolean isReadOnly() {
        return true;
    }

    byte _get(int i) {
        return unsafe.getByte(this.address + (long)i);
    }

    void _put(int i, byte b) {
        throw new ReadOnlyBufferException();
    }

    private ByteBuffer putChar(long a, char x) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putChar(char x) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putChar(int i, char x) {
        throw new ReadOnlyBufferException();
    }

    public CharBuffer asCharBuffer() {
        int off = this.position();
        int lim = this.limit();
        assert (off <= lim);
        int rem = off <= lim ? lim - off : 0;
        int size = rem >> 1;
        if (!unaligned && (this.address + (long)off) % 2L != 0L) {
            return this.bigEndian ? new ByteBufferAsCharBufferRB(this, -1, 0, size, size, off) : new ByteBufferAsCharBufferRL(this, -1, 0, size, size, off);
        }
        return this.nativeByteOrder ? new DirectCharBufferRU(this, -1, 0, size, size, off) : new DirectCharBufferRS(this, -1, 0, size, size, off);
    }

    private ByteBuffer putShort(long a, short x) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putShort(short x) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putShort(int i, short x) {
        throw new ReadOnlyBufferException();
    }

    public ShortBuffer asShortBuffer() {
        int off = this.position();
        int lim = this.limit();
        assert (off <= lim);
        int rem = off <= lim ? lim - off : 0;
        int size = rem >> 1;
        if (!unaligned && (this.address + (long)off) % 2L != 0L) {
            return this.bigEndian ? new ByteBufferAsShortBufferRB(this, -1, 0, size, size, off) : new ByteBufferAsShortBufferRL(this, -1, 0, size, size, off);
        }
        return this.nativeByteOrder ? new DirectShortBufferRU(this, -1, 0, size, size, off) : new DirectShortBufferRS(this, -1, 0, size, size, off);
    }

    private ByteBuffer putInt(long a, int x) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putInt(int x) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putInt(int i, int x) {
        throw new ReadOnlyBufferException();
    }

    public IntBuffer asIntBuffer() {
        int off = this.position();
        int lim = this.limit();
        assert (off <= lim);
        int rem = off <= lim ? lim - off : 0;
        int size = rem >> 2;
        if (!unaligned && (this.address + (long)off) % 4L != 0L) {
            return this.bigEndian ? new ByteBufferAsIntBufferRB(this, -1, 0, size, size, off) : new ByteBufferAsIntBufferRL(this, -1, 0, size, size, off);
        }
        return this.nativeByteOrder ? new DirectIntBufferRU(this, -1, 0, size, size, off) : new DirectIntBufferRS(this, -1, 0, size, size, off);
    }

    private ByteBuffer putLong(long a, long x) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putLong(long x) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putLong(int i, long x) {
        throw new ReadOnlyBufferException();
    }

    public LongBuffer asLongBuffer() {
        int off = this.position();
        int lim = this.limit();
        assert (off <= lim);
        int rem = off <= lim ? lim - off : 0;
        int size = rem >> 3;
        if (!unaligned && (this.address + (long)off) % 8L != 0L) {
            return this.bigEndian ? new ByteBufferAsLongBufferRB(this, -1, 0, size, size, off) : new ByteBufferAsLongBufferRL(this, -1, 0, size, size, off);
        }
        return this.nativeByteOrder ? new DirectLongBufferRU(this, -1, 0, size, size, off) : new DirectLongBufferRS(this, -1, 0, size, size, off);
    }

    private ByteBuffer putFloat(long a, float x) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putFloat(float x) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putFloat(int i, float x) {
        throw new ReadOnlyBufferException();
    }

    public FloatBuffer asFloatBuffer() {
        int off = this.position();
        int lim = this.limit();
        assert (off <= lim);
        int rem = off <= lim ? lim - off : 0;
        int size = rem >> 2;
        if (!unaligned && (this.address + (long)off) % 4L != 0L) {
            return this.bigEndian ? new ByteBufferAsFloatBufferRB(this, -1, 0, size, size, off) : new ByteBufferAsFloatBufferRL(this, -1, 0, size, size, off);
        }
        return this.nativeByteOrder ? new DirectFloatBufferRU(this, -1, 0, size, size, off) : new DirectFloatBufferRS(this, -1, 0, size, size, off);
    }

    private ByteBuffer putDouble(long a, double x) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putDouble(double x) {
        throw new ReadOnlyBufferException();
    }

    public ByteBuffer putDouble(int i, double x) {
        throw new ReadOnlyBufferException();
    }

    public DoubleBuffer asDoubleBuffer() {
        int off = this.position();
        int lim = this.limit();
        assert (off <= lim);
        int rem = off <= lim ? lim - off : 0;
        int size = rem >> 3;
        if (!unaligned && (this.address + (long)off) % 8L != 0L) {
            return this.bigEndian ? new ByteBufferAsDoubleBufferRB(this, -1, 0, size, size, off) : new ByteBufferAsDoubleBufferRL(this, -1, 0, size, size, off);
        }
        return this.nativeByteOrder ? new DirectDoubleBufferRU(this, -1, 0, size, size, off) : new DirectDoubleBufferRS(this, -1, 0, size, size, off);
    }
}

