/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationFormatError;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.nio.ByteBuffer;
import java.util.Map;
import sun.misc.SharedSecrets;
import sun.reflect.MethodAccessor;
import sun.reflect.Reflection;
import sun.reflect.annotation.AnnotationParser;
import sun.reflect.annotation.AnnotationType;
import sun.reflect.annotation.ExceptionProxy;
import sun.reflect.generics.factory.CoreReflectionFactory;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.repository.MethodRepository;
import sun.reflect.generics.scope.MethodScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Method
extends AccessibleObject
implements GenericDeclaration,
Member {
    private Class clazz;
    private int slot;
    private String name;
    private Class returnType;
    private Class[] parameterTypes;
    private Class[] exceptionTypes;
    private int modifiers;
    private transient String signature;
    private transient MethodRepository genericInfo;
    private byte[] annotations;
    private byte[] parameterAnnotations;
    private byte[] annotationDefault;
    private volatile MethodAccessor methodAccessor;
    private Method root;
    private Class securityCheckCache;
    private Class securityCheckTargetClassCache;
    private static final int LANGUAGE_MODIFIERS = 1343;
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private transient Map<Class, Annotation> declaredAnnotations;

    private String getGenericSignature() {
        return this.signature;
    }

    private GenericsFactory getFactory() {
        return CoreReflectionFactory.make(this, MethodScope.make(this));
    }

    private MethodRepository getGenericInfo() {
        if (this.genericInfo == null) {
            this.genericInfo = MethodRepository.make(this.getGenericSignature(), this.getFactory());
        }
        return this.genericInfo;
    }

    Method(Class declaringClass, String name, Class[] parameterTypes, Class returnType, Class[] checkedExceptions, int modifiers, int slot, String signature, byte[] annotations, byte[] parameterAnnotations, byte[] annotationDefault) {
        this.clazz = declaringClass;
        this.name = name;
        this.parameterTypes = parameterTypes;
        this.returnType = returnType;
        this.exceptionTypes = checkedExceptions;
        this.modifiers = modifiers;
        this.slot = slot;
        this.signature = signature;
        this.annotations = annotations;
        this.parameterAnnotations = parameterAnnotations;
        this.annotationDefault = annotationDefault;
    }

    Method copy() {
        Method res = new Method(this.clazz, this.name, this.parameterTypes, this.returnType, this.exceptionTypes, this.modifiers, this.slot, this.signature, this.annotations, this.parameterAnnotations, this.annotationDefault);
        res.root = this;
        res.methodAccessor = this.methodAccessor;
        return res;
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.clazz;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    public TypeVariable<Method>[] getTypeParameters() {
        if (this.getGenericSignature() != null) {
            return this.getGenericInfo().getTypeParameters();
        }
        return new TypeVariable[0];
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public Type getGenericReturnType() {
        if (this.getGenericSignature() != null) {
            return this.getGenericInfo().getReturnType();
        }
        return this.getReturnType();
    }

    public Class<?>[] getParameterTypes() {
        return (Class[])this.parameterTypes.clone();
    }

    public Type[] getGenericParameterTypes() {
        if (this.getGenericSignature() != null) {
            return this.getGenericInfo().getParameterTypes();
        }
        return this.getParameterTypes();
    }

    public Class<?>[] getExceptionTypes() {
        return (Class[])this.exceptionTypes.clone();
    }

    public Type[] getGenericExceptionTypes() {
        Type[] result;
        if (this.getGenericSignature() != null && (result = this.getGenericInfo().getExceptionTypes()).length > 0) {
            return result;
        }
        return this.getExceptionTypes();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Method) {
            Method other = (Method)obj;
            if (this.getDeclaringClass() == other.getDeclaringClass() && this.getName() == other.getName()) {
                if (!this.returnType.equals(other.getReturnType())) {
                    return false;
                }
                Class[] params1 = this.parameterTypes;
                Class[] params2 = other.parameterTypes;
                if (params1.length == params2.length) {
                    for (int i = 0; i < params1.length; ++i) {
                        if (params1[i] == params2[i]) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        try {
            StringBuffer sb = new StringBuffer();
            int mod = this.getModifiers() & 0x53F;
            if (mod != 0) {
                sb.append(Modifier.toString(mod) + " ");
            }
            sb.append(Field.getTypeName(this.getReturnType()) + " ");
            sb.append(Field.getTypeName(this.getDeclaringClass()) + ".");
            sb.append(this.getName() + "(");
            Class[] params = this.parameterTypes;
            for (int j = 0; j < params.length; ++j) {
                sb.append(Field.getTypeName(params[j]));
                if (j >= params.length - 1) continue;
                sb.append(",");
            }
            sb.append(")");
            Class[] exceptions = this.exceptionTypes;
            if (exceptions.length > 0) {
                sb.append(" throws ");
                for (int k = 0; k < exceptions.length; ++k) {
                    sb.append(exceptions[k].getName());
                    if (k >= exceptions.length - 1) continue;
                    sb.append(",");
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    public String toGenericString() {
        try {
            TypeVariable<Method>[] typeparms;
            StringBuilder sb = new StringBuilder();
            int mod = this.getModifiers() & 0x53F;
            if (mod != 0) {
                sb.append(Modifier.toString(mod) + " ");
            }
            if ((typeparms = this.getTypeParameters()).length > 0) {
                boolean first = true;
                sb.append("<");
                for (TypeVariable<Method> typeparm : typeparms) {
                    if (!first) {
                        sb.append(",");
                    }
                    sb.append(typeparm.toString());
                    first = false;
                }
                sb.append("> ");
            }
            Type genRetType = this.getGenericReturnType();
            sb.append((genRetType instanceof Class ? Field.getTypeName((Class)genRetType) : genRetType.toString()) + " ");
            sb.append(Field.getTypeName(this.getDeclaringClass()) + ".");
            sb.append(this.getName() + "(");
            Type[] params = this.getGenericParameterTypes();
            for (int j = 0; j < params.length; ++j) {
                String param = params[j] instanceof Class ? Field.getTypeName((Class)params[j]) : params[j].toString();
                sb.append(param);
                if (j >= params.length - 1) continue;
                sb.append(",");
            }
            sb.append(")");
            Type[] exceptions = this.getGenericExceptionTypes();
            if (exceptions.length > 0) {
                sb.append(" throws ");
                for (int k = 0; k < exceptions.length; ++k) {
                    sb.append(exceptions[k] instanceof Class ? ((Class)exceptions[k]).getName() : exceptions[k].toString());
                    if (k >= exceptions.length - 1) continue;
                    sb.append(",");
                }
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "<" + e + ">";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object obj, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!this.override && !Reflection.quickCheckMemberAccess(this.clazz, this.modifiers)) {
            boolean cached;
            Class caller = Reflection.getCallerClass(1);
            Class<?> targetClass = obj == null || !Modifier.isProtected(this.modifiers) ? this.clazz : obj.getClass();
            Method method = this;
            synchronized (method) {
                cached = this.securityCheckCache == caller && this.securityCheckTargetClassCache == targetClass;
            }
            if (!cached) {
                Reflection.ensureMemberAccess(caller, this.clazz, obj, this.modifiers);
                method = this;
                synchronized (method) {
                    this.securityCheckCache = caller;
                    this.securityCheckTargetClassCache = targetClass;
                }
            }
        }
        if (this.methodAccessor == null) {
            this.acquireMethodAccessor();
        }
        return this.methodAccessor.invoke(obj, args);
    }

    public boolean isBridge() {
        return (this.getModifiers() & 0x40) != 0;
    }

    public boolean isVarArgs() {
        return (this.getModifiers() & 0x80) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return Modifier.isSynthetic(this.getModifiers());
    }

    private void acquireMethodAccessor() {
        MethodAccessor tmp = null;
        if (this.root != null) {
            tmp = this.root.getMethodAccessor();
        }
        if (tmp != null) {
            this.methodAccessor = tmp;
            return;
        }
        tmp = reflectionFactory.newMethodAccessor(this);
        this.setMethodAccessor(tmp);
    }

    MethodAccessor getMethodAccessor() {
        return this.methodAccessor;
    }

    void setMethodAccessor(MethodAccessor accessor) {
        this.methodAccessor = accessor;
        if (this.root != null) {
            this.root.setMethodAccessor(accessor);
        }
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        if (annotationClass == null) {
            throw new NullPointerException();
        }
        return (T)this.declaredAnnotations().get(annotationClass);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.declaredAnnotations().values().toArray(EMPTY_ANNOTATION_ARRAY);
    }

    private synchronized Map<Class, Annotation> declaredAnnotations() {
        if (this.declaredAnnotations == null) {
            this.declaredAnnotations = AnnotationParser.parseAnnotations(this.annotations, SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this.getDeclaringClass());
        }
        return this.declaredAnnotations;
    }

    public Object getDefaultValue() {
        if (this.annotationDefault == null) {
            return null;
        }
        Class memberType = AnnotationType.invocationHandlerReturnType(this.getReturnType());
        Object result = AnnotationParser.parseMemberValue(memberType, ByteBuffer.wrap(this.annotationDefault), SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this.getDeclaringClass());
        if (result instanceof ExceptionProxy) {
            throw new AnnotationFormatError("Invalid default: " + this);
        }
        return result;
    }

    public Annotation[][] getParameterAnnotations() {
        int numParameters = this.parameterTypes.length;
        if (this.parameterAnnotations == null) {
            return new Annotation[numParameters][0];
        }
        Annotation[][] result = AnnotationParser.parseParameterAnnotations(this.parameterAnnotations, SharedSecrets.getJavaLangAccess().getConstantPool(this.getDeclaringClass()), this.getDeclaringClass());
        if (result.length != numParameters) {
            throw new AnnotationFormatError("Parameter annotations don't match number of parameters");
        }
        return result;
    }
}

