/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.ReferenceQueue;
import sun.misc.Cleaner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Reference<T> {
    private T referent;
    ReferenceQueue<? super T> queue;
    Reference next;
    private transient Reference<T> discovered;
    private static Lock lock;
    private static Reference pending;

    public T get() {
        return this.referent;
    }

    public void clear() {
        this.referent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnqueued() {
        Reference reference = this;
        synchronized (reference) {
            return this.queue != ReferenceQueue.NULL && this.next != null;
        }
    }

    public boolean enqueue() {
        return this.queue.enqueue(this);
    }

    Reference(T referent) {
        this(referent, null);
    }

    Reference(T referent, ReferenceQueue<? super T> queue) {
        this.referent = referent;
        this.queue = queue == null ? ReferenceQueue.NULL : queue;
    }

    static {
        ThreadGroup tg;
        lock = new Lock();
        pending = null;
        ThreadGroup tgn = tg = Thread.currentThread().getThreadGroup();
        while (tgn != null) {
            tg = tgn;
            tgn = tg.getParent();
        }
        ReferenceHandler handler = new ReferenceHandler(tg, "Reference Handler");
        handler.setPriority(10);
        handler.setDaemon(true);
        handler.start();
    }

    private static class ReferenceHandler
    extends Thread {
        ReferenceHandler(ThreadGroup g, String name) {
            super(g, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Reference r;
                Lock lock = lock;
                synchronized (lock) {
                    if (pending == null) {
                        try {
                            lock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                    Reference rn = r.next;
                    r = pending;
                    pending = rn == r ? null : rn;
                    r.next = r;
                }
                if (r instanceof Cleaner) {
                    ((Cleaner)r).clean();
                    continue;
                }
                ReferenceQueue q = r.queue;
                if (q == ReferenceQueue.NULL) continue;
                q.enqueue(r);
            }
        }
    }

    private static class Lock {
        private Lock() {
        }
    }
}

