/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProcessImpl {
    private ProcessImpl() {
    }

    private static byte[] toCString(String s) {
        if (s == null) {
            return null;
        }
        byte[] bytes = s.getBytes();
        byte[] result = new byte[bytes.length + 1];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        result[result.length - 1] = 0;
        return result;
    }

    static Process start(String[] cmdarray, Map<String, String> environment, String dir, boolean redirectErrorStream) throws IOException {
        assert (cmdarray != null && cmdarray.length > 0);
        byte[][] args = new byte[cmdarray.length - 1][];
        int size = args.length;
        for (int i = 0; i < args.length; ++i) {
            args[i] = cmdarray[i + 1].getBytes();
            size += args[i].length;
        }
        byte[] argBlock = new byte[size];
        int i = 0;
        for (byte[] arg : args) {
            System.arraycopy(arg, 0, argBlock, i, arg.length);
            i += arg.length + 1;
        }
        int[] envc = new int[1];
        byte[] envBlock = ProcessEnvironment.toEnvironmentBlock(environment, envc);
        return new UNIXProcess(ProcessImpl.toCString(cmdarray[0]), argBlock, args.length, envBlock, envc[0], ProcessImpl.toCString(dir), redirectErrorStream);
    }
}

