/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProcessEnvironment {
    private static final HashMap<Variable, Value> theEnvironment;
    private static final Map<String, String> theUnmodifiableEnvironment;
    static final int MIN_NAME_LENGTH = 0;

    static String getenv(String name) {
        return theUnmodifiableEnvironment.get(name);
    }

    static Map<String, String> getenv() {
        return theUnmodifiableEnvironment;
    }

    static Map<String, String> environment() {
        return new StringEnvironment((Map)theEnvironment.clone());
    }

    static Map<String, String> emptyEnvironment(int capacity) {
        return new StringEnvironment(new HashMap<Variable, Value>(capacity));
    }

    private static native byte[][] environ();

    private ProcessEnvironment() {
    }

    private static void validateVariable(String name) {
        if (name.indexOf(61) != -1 || name.indexOf(0) != -1) {
            throw new IllegalArgumentException("Invalid environment variable name: \"" + name + "\"");
        }
    }

    private static void validateValue(String value) {
        if (value.indexOf(0) != -1) {
            throw new IllegalArgumentException("Invalid environment variable value: \"" + value + "\"");
        }
    }

    static byte[] toEnvironmentBlock(Map<String, String> map, int[] envc) {
        return map == null ? null : ((StringEnvironment)map).toEnvironmentBlock(envc);
    }

    private static int arrayCompare(byte[] x, byte[] y) {
        int min = x.length < y.length ? x.length : y.length;
        for (int i = 0; i < min; ++i) {
            if (x[i] == y[i]) continue;
            return x[i] - y[i];
        }
        return x.length - y.length;
    }

    private static boolean arrayEquals(byte[] x, byte[] y) {
        if (x.length != y.length) {
            return false;
        }
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == y[i]) continue;
            return false;
        }
        return true;
    }

    private static int arrayHash(byte[] x) {
        int hash = 0;
        for (int i = 0; i < x.length; ++i) {
            hash = 31 * hash + x[i];
        }
        return hash;
    }

    static {
        byte[][] environ = ProcessEnvironment.environ();
        theEnvironment = new HashMap(environ.length / 2 + 3);
        for (int i = environ.length - 1; i > 0; i -= 2) {
            theEnvironment.put(Variable.valueOf(environ[i - 1]), Value.valueOf(environ[i]));
        }
        theUnmodifiableEnvironment = Collections.unmodifiableMap(new StringEnvironment(theEnvironment));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringKeySet
    extends AbstractSet<String> {
        private final Set<Variable> s;

        public StringKeySet(Set<Variable> s) {
            this.s = s;
        }

        @Override
        public int size() {
            return this.s.size();
        }

        @Override
        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        @Override
        public void clear() {
            this.s.clear();
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){
                Iterator<Variable> i;
                {
                    this.i = StringKeySet.this.s.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public String next() {
                    return this.i.next().toString();
                }

                @Override
                public void remove() {
                    this.i.remove();
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            return this.s.contains(Variable.valueOfQueryOnly(o));
        }

        @Override
        public boolean remove(Object o) {
            return this.s.remove(Variable.valueOfQueryOnly(o));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringValues
    extends AbstractCollection<String> {
        private final Collection<Value> c;

        public StringValues(Collection<Value> c) {
            this.c = c;
        }

        @Override
        public int size() {
            return this.c.size();
        }

        @Override
        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        @Override
        public void clear() {
            this.c.clear();
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){
                Iterator<Value> i;
                {
                    this.i = StringValues.this.c.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public String next() {
                    return this.i.next().toString();
                }

                @Override
                public void remove() {
                    this.i.remove();
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            return this.c.contains(Value.valueOfQueryOnly(o));
        }

        @Override
        public boolean remove(Object o) {
            return this.c.remove(Value.valueOfQueryOnly(o));
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof StringValues && ((Object)this.c).equals(((StringValues)o).c);
        }

        @Override
        public int hashCode() {
            return ((Object)this.c).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringEntrySet
    extends AbstractSet<Map.Entry<String, String>> {
        private final Set<Map.Entry<Variable, Value>> s;

        public StringEntrySet(Set<Map.Entry<Variable, Value>> s) {
            this.s = s;
        }

        @Override
        public int size() {
            return this.s.size();
        }

        @Override
        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        @Override
        public void clear() {
            this.s.clear();
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            return new Iterator<Map.Entry<String, String>>(){
                Iterator<Map.Entry<Variable, Value>> i;
                {
                    this.i = StringEntrySet.this.s.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public Map.Entry<String, String> next() {
                    return new StringEntry(this.i.next());
                }

                @Override
                public void remove() {
                    this.i.remove();
                }
            };
        }

        private static Map.Entry<Variable, Value> vvEntry(final Object o) {
            if (o instanceof StringEntry) {
                return ((StringEntry)o).e;
            }
            return new Map.Entry<Variable, Value>(){

                @Override
                public Variable getKey() {
                    return Variable.valueOfQueryOnly(((Map.Entry)o).getKey());
                }

                @Override
                public Value getValue() {
                    return Value.valueOfQueryOnly(((Map.Entry)o).getValue());
                }

                @Override
                public Value setValue(Value value) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            return this.s.contains(StringEntrySet.vvEntry(o));
        }

        @Override
        public boolean remove(Object o) {
            return this.s.remove(StringEntrySet.vvEntry(o));
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof StringEntrySet && ((Object)this.s).equals(((StringEntrySet)o).s);
        }

        @Override
        public int hashCode() {
            return ((Object)this.s).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringEntry
    implements Map.Entry<String, String> {
        private final Map.Entry<Variable, Value> e;

        public StringEntry(Map.Entry<Variable, Value> e) {
            this.e = e;
        }

        @Override
        public String getKey() {
            return this.e.getKey().toString();
        }

        @Override
        public String getValue() {
            return this.e.getValue().toString();
        }

        @Override
        public String setValue(String newValue) {
            return this.e.setValue(Value.valueOf(newValue)).toString();
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof StringEntry && ((Object)this.e).equals(((StringEntry)o).e);
        }

        @Override
        public int hashCode() {
            return ((Object)this.e).hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringEnvironment
    extends AbstractMap<String, String> {
        private Map<Variable, Value> m;

        private static String toString(Value v) {
            return v == null ? null : v.toString();
        }

        public StringEnvironment(Map<Variable, Value> m) {
            this.m = m;
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.m.containsKey(Variable.valueOfQueryOnly(key));
        }

        @Override
        public boolean containsValue(Object value) {
            return this.m.containsValue(Value.valueOfQueryOnly(value));
        }

        @Override
        public String get(Object key) {
            return StringEnvironment.toString(this.m.get(Variable.valueOfQueryOnly(key)));
        }

        @Override
        public String put(String key, String value) {
            return StringEnvironment.toString(this.m.put(Variable.valueOf(key), Value.valueOf(value)));
        }

        @Override
        public String remove(Object key) {
            return StringEnvironment.toString(this.m.remove(Variable.valueOfQueryOnly(key)));
        }

        @Override
        public Set<String> keySet() {
            return new StringKeySet(this.m.keySet());
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return new StringEntrySet(this.m.entrySet());
        }

        @Override
        public Collection<String> values() {
            return new StringValues(this.m.values());
        }

        public byte[] toEnvironmentBlock(int[] envc) {
            int count = this.m.size() * 2;
            for (Map.Entry<Variable, Value> entry : this.m.entrySet()) {
                count += entry.getKey().getBytes().length;
                count += entry.getValue().getBytes().length;
            }
            byte[] block = new byte[count];
            int i = 0;
            for (Map.Entry<Variable, Value> entry : this.m.entrySet()) {
                byte[] key = entry.getKey().getBytes();
                byte[] value = entry.getValue().getBytes();
                System.arraycopy(key, 0, block, i, key.length);
                i += key.length;
                block[i++] = 61;
                System.arraycopy(value, 0, block, i, value.length);
                i += value.length + 1;
            }
            envc[0] = this.m.size();
            return block;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Value
    extends ExternalData
    implements Comparable<Value> {
        protected Value(String str, byte[] bytes) {
            super(str, bytes);
        }

        public static Value valueOfQueryOnly(Object str) {
            return Value.valueOfQueryOnly((String)str);
        }

        public static Value valueOfQueryOnly(String str) {
            return new Value(str, str.getBytes());
        }

        public static Value valueOf(String str) {
            ProcessEnvironment.validateValue(str);
            return Value.valueOfQueryOnly(str);
        }

        public static Value valueOf(byte[] bytes) {
            return new Value(new String(bytes), bytes);
        }

        @Override
        public int compareTo(Value value) {
            return ProcessEnvironment.arrayCompare(this.getBytes(), value.getBytes());
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Value && super.equals(o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Variable
    extends ExternalData
    implements Comparable<Variable> {
        protected Variable(String str, byte[] bytes) {
            super(str, bytes);
        }

        public static Variable valueOfQueryOnly(Object str) {
            return Variable.valueOfQueryOnly((String)str);
        }

        public static Variable valueOfQueryOnly(String str) {
            return new Variable(str, str.getBytes());
        }

        public static Variable valueOf(String str) {
            ProcessEnvironment.validateVariable(str);
            return Variable.valueOfQueryOnly(str);
        }

        public static Variable valueOf(byte[] bytes) {
            return new Variable(new String(bytes), bytes);
        }

        @Override
        public int compareTo(Variable variable) {
            return ProcessEnvironment.arrayCompare(this.getBytes(), variable.getBytes());
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Variable && super.equals(o);
        }
    }

    private static abstract class ExternalData {
        protected final String str;
        protected final byte[] bytes;

        protected ExternalData(String str, byte[] bytes) {
            this.str = str;
            this.bytes = bytes;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public String toString() {
            return this.str;
        }

        public boolean equals(Object o) {
            return o instanceof ExternalData && ProcessEnvironment.arrayEquals(this.getBytes(), ((ExternalData)o).getBytes());
        }

        public int hashCode() {
            return ProcessEnvironment.arrayHash(this.getBytes());
        }
    }
}

