/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PushbackInputStream
extends FilterInputStream {
    protected byte[] buf;
    protected int pos;

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    public PushbackInputStream(InputStream in, int size) {
        super(in);
        if (size <= 0) {
            throw new IllegalArgumentException("size <= 0");
        }
        this.buf = new byte[size];
        this.pos = size;
    }

    public PushbackInputStream(InputStream in) {
        this(in, 1);
    }

    public int read() throws IOException {
        this.ensureOpen();
        if (this.pos < this.buf.length) {
            return this.buf[this.pos++] & 0xFF;
        }
        return super.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int avail = this.buf.length - this.pos;
        if (avail > 0) {
            if (len < avail) {
                avail = len;
            }
            System.arraycopy(this.buf, this.pos, b, off, avail);
            this.pos += avail;
            off += avail;
            len -= avail;
        }
        if (len > 0) {
            if ((len = super.read(b, off, len)) == -1) {
                return avail == 0 ? -1 : avail;
            }
            return avail + len;
        }
        return avail;
    }

    public void unread(int b) throws IOException {
        this.ensureOpen();
        if (this.pos == 0) {
            throw new IOException("Push back buffer is full");
        }
        this.buf[--this.pos] = (byte)b;
    }

    public void unread(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        if (len > this.pos) {
            throw new IOException("Push back buffer is full");
        }
        this.pos -= len;
        System.arraycopy(b, off, this.buf, this.pos, len);
    }

    public void unread(byte[] b) throws IOException {
        this.unread(b, 0, b.length);
    }

    public int available() throws IOException {
        this.ensureOpen();
        return this.buf.length - this.pos + super.available();
    }

    public long skip(long n) throws IOException {
        this.ensureOpen();
        if (n <= 0L) {
            return 0L;
        }
        long pskip = this.buf.length - this.pos;
        if (pskip > 0L) {
            if (n < pskip) {
                pskip = n;
            }
            this.pos = (int)((long)this.pos + pskip);
            n -= pskip;
        }
        if (n > 0L) {
            pskip += super.skip(n);
        }
        return pskip;
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized void mark(int readlimit) {
    }

    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    public synchronized void close() throws IOException {
        if (this.in == null) {
            return;
        }
        this.in.close();
        this.in = null;
        this.buf = null;
    }
}

