/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.AccessController;
import java.util.Formatter;
import java.util.Locale;
import sun.security.action.GetPropertyAction;

public class PrintWriter
extends Writer {
    protected Writer out;
    private boolean autoFlush = false;
    private boolean trouble = false;
    private Formatter formatter;
    private PrintStream psOut = null;
    private String lineSeparator;

    public PrintWriter(Writer out) {
        this(out, false);
    }

    public PrintWriter(Writer out, boolean autoFlush) {
        super(out);
        this.out = out;
        this.autoFlush = autoFlush;
        this.lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    }

    public PrintWriter(OutputStream out) {
        this(out, false);
    }

    public PrintWriter(OutputStream out, boolean autoFlush) {
        this(new BufferedWriter(new OutputStreamWriter(out)), autoFlush);
        if (out instanceof PrintStream) {
            this.psOut = (PrintStream)out;
        }
    }

    public PrintWriter(String fileName) throws FileNotFoundException {
        this(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fileName))), false);
    }

    public PrintWriter(String fileName, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        this(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), csn)), false);
    }

    public PrintWriter(File file) throws FileNotFoundException {
        this(new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file))), false);
    }

    public PrintWriter(File file, String csn) throws FileNotFoundException, UnsupportedEncodingException {
        this(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), csn)), false);
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.out.flush();
            }
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.out == null) {
                    return;
                }
                this.out.close();
                this.out = null;
            }
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    public boolean checkError() {
        if (this.out != null) {
            this.flush();
        }
        if (this.out instanceof PrintWriter) {
            PrintWriter pw = (PrintWriter)this.out;
            return pw.checkError();
        }
        if (this.psOut != null) {
            return this.psOut.checkError();
        }
        return this.trouble;
    }

    protected void setError() {
        this.trouble = true;
    }

    protected void clearError() {
        this.trouble = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int c) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.out.write(c);
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] buf, int off, int len) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.out.write(buf, off, len);
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    public void write(char[] buf) {
        this.write(buf, 0, buf.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String s, int off, int len) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.out.write(s, off, len);
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    public void write(String s) {
        this.write(s, 0, s.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newLine() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                this.out.write(this.lineSeparator);
                if (this.autoFlush) {
                    this.out.flush();
                }
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = true;
        }
    }

    public void print(boolean b) {
        this.write(b ? "true" : "false");
    }

    public void print(char c) {
        this.write(c);
    }

    public void print(int i) {
        this.write(String.valueOf(i));
    }

    public void print(long l) {
        this.write(String.valueOf(l));
    }

    public void print(float f) {
        this.write(String.valueOf(f));
    }

    public void print(double d) {
        this.write(String.valueOf(d));
    }

    public void print(char[] s) {
        this.write(s);
    }

    public void print(String s) {
        if (s == null) {
            s = "null";
        }
        this.write(s);
    }

    public void print(Object obj) {
        this.write(String.valueOf(obj));
    }

    public void println() {
        this.newLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(boolean x) {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char x) {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(int x) {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(long x) {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(float x) {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(double x) {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] x) {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String x) {
        Object object = this.lock;
        synchronized (object) {
            this.print(x);
            this.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object x) {
        String s = String.valueOf(x);
        Object object = this.lock;
        synchronized (object) {
            this.print(s);
            this.println();
        }
    }

    public PrintWriter printf(String format, Object ... args) {
        return this.format(format, args);
    }

    public PrintWriter printf(Locale l, String format, Object ... args) {
        return this.format(l, format, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintWriter format(String format, Object ... args) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                if (this.formatter == null || this.formatter.locale() != Locale.getDefault()) {
                    this.formatter = new Formatter(this);
                }
                this.formatter.format(Locale.getDefault(), format, args);
                if (this.autoFlush) {
                    this.out.flush();
                }
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = true;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintWriter format(Locale l, String format, Object ... args) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                if (this.formatter == null || this.formatter.locale() != l) {
                    this.formatter = new Formatter(this, l);
                }
                this.formatter.format(l, format, args);
                if (this.autoFlush) {
                    this.out.flush();
                }
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.trouble = true;
        }
        return this;
    }

    public PrintWriter append(CharSequence csq) {
        if (csq == null) {
            this.write("null");
        } else {
            this.write(((Object)csq).toString());
        }
        return this;
    }

    public PrintWriter append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        this.write(((Object)cs.subSequence(start, end)).toString());
        return this;
    }

    public PrintWriter append(char c) {
        this.write(c);
        return this;
    }
}

