/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import com.sun.beans.ObjectHandler;
import java.beans.ExceptionListener;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import sun.reflect.misc.ConstructorUtil;
import sun.reflect.misc.MethodUtil;
import sun.reflect.misc.ReflectUtil;

class ReflectionUtils {
    private static Reference methodCacheRef;

    ReflectionUtils() {
    }

    public static Class typeToClass(Class type) {
        return type.isPrimitive() ? ObjectHandler.typeNameToClass(type.getName()) : type;
    }

    public static boolean isPrimitive(Class type) {
        return ReflectionUtils.primitiveTypeFor(type) != null;
    }

    public static Class primitiveTypeFor(Class wrapper) {
        if (wrapper == Boolean.class) {
            return Boolean.TYPE;
        }
        if (wrapper == Byte.class) {
            return Byte.TYPE;
        }
        if (wrapper == Character.class) {
            return Character.TYPE;
        }
        if (wrapper == Short.class) {
            return Short.TYPE;
        }
        if (wrapper == Integer.class) {
            return Integer.TYPE;
        }
        if (wrapper == Long.class) {
            return Long.TYPE;
        }
        if (wrapper == Float.class) {
            return Float.TYPE;
        }
        if (wrapper == Double.class) {
            return Double.TYPE;
        }
        if (wrapper == Void.class) {
            return Void.TYPE;
        }
        return null;
    }

    private static boolean matchArguments(Class[] argClasses, Class[] argTypes) {
        return ReflectionUtils.matchArguments(argClasses, argTypes, false);
    }

    private static boolean matchExplicitArguments(Class[] argClasses, Class[] argTypes) {
        return ReflectionUtils.matchArguments(argClasses, argTypes, true);
    }

    private static boolean matchArguments(Class[] argClasses, Class[] argTypes, boolean explicit) {
        boolean match = argClasses.length == argTypes.length;
        for (int j = 0; j < argClasses.length && match; ++j) {
            Class argType = argTypes[j];
            if (argType.isPrimitive()) {
                argType = ReflectionUtils.typeToClass(argType);
            }
            if (explicit) {
                if (argClasses[j] == argType) continue;
                match = false;
                continue;
            }
            if (argClasses[j] == null || argType.isAssignableFrom(argClasses[j])) continue;
            match = false;
        }
        return match;
    }

    static Method getPublicMethod(Class declaringClass, String methodName, Class[] argClasses) throws NoSuchMethodException {
        Method m = ReflectionUtils.findPublicMethod(declaringClass, methodName, argClasses);
        if (m == null) {
            throw new NoSuchMethodException(declaringClass.getName() + "." + methodName);
        }
        return m;
    }

    public static Method findPublicMethod(Class declaringClass, String methodName, Class[] argClasses) {
        Method method;
        if (argClasses.length == 0) {
            try {
                return MethodUtil.getMethod(declaringClass, methodName, argClasses);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            catch (SecurityException se) {
                // empty catch block
            }
        }
        Method[] methods = MethodUtil.getPublicMethods(declaringClass);
        ArrayList<Method> list = new ArrayList<Method>();
        for (int i = 0; i < methods.length; ++i) {
            method = methods[i];
            if (!method.getName().equals(methodName) || !ReflectionUtils.matchArguments(argClasses, method.getParameterTypes())) continue;
            list.add(method);
        }
        if (list.size() > 0) {
            if (list.size() == 1) {
                return (Method)list.get(0);
            }
            ListIterator iterator = list.listIterator();
            while (iterator.hasNext()) {
                method = (Method)iterator.next();
                if (!ReflectionUtils.matchExplicitArguments(argClasses, method.getParameterTypes())) continue;
                return method;
            }
            return ReflectionUtils.getMostSpecificMethod(list, argClasses);
        }
        return null;
    }

    private static Method getMostSpecificMethod(List methods, Class[] args) {
        int matches;
        Method method = null;
        int lastMatch = matches = 0;
        ListIterator iterator = methods.listIterator();
        while (iterator.hasNext()) {
            Method m = (Method)iterator.next();
            Class<?>[] mArgs = m.getParameterTypes();
            matches = 0;
            for (int i = 0; i < args.length; ++i) {
                Class mArg = mArgs[i];
                if (mArg.isPrimitive()) {
                    mArg = ReflectionUtils.typeToClass(mArg);
                }
                if (args[i] != mArg) continue;
                ++matches;
            }
            if (matches == 0 && lastMatch == 0) {
                if (method == null) {
                    method = m;
                    continue;
                }
                if (ReflectionUtils.matchArguments(method.getParameterTypes(), m.getParameterTypes())) continue;
                method = m;
                continue;
            }
            if (matches > lastMatch) {
                lastMatch = matches;
                method = m;
                continue;
            }
            if (matches != lastMatch) continue;
            method = null;
        }
        return method;
    }

    public static Method findMethod(Class targetClass, String methodName, Class[] argClasses) {
        Method m = ReflectionUtils.findPublicMethod(targetClass, methodName, argClasses);
        if (m != null && Modifier.isPublic(m.getDeclaringClass().getModifiers())) {
            return m;
        }
        for (Class type = targetClass; type != null; type = type.getSuperclass()) {
            Class<?>[] interfaces = type.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                m = ReflectionUtils.findPublicMethod(interfaces[i], methodName, argClasses);
                if (m == null) continue;
                return m;
            }
        }
        return null;
    }

    public static synchronized Method getMethod(Class targetClass, String methodName, Class[] argClasses) {
        Signature signature = new Signature(targetClass, methodName, argClasses);
        Method method = null;
        HashMap<Signature, Method> methodCache = null;
        boolean cache = false;
        if (ReflectUtil.isPackageAccessible(targetClass)) {
            cache = true;
        }
        if (cache && methodCacheRef != null && (methodCache = (HashMap<Signature, Method>)methodCacheRef.get()) != null && (method = (Method)methodCache.get(signature)) != null) {
            return method;
        }
        method = ReflectionUtils.findMethod(targetClass, methodName, argClasses);
        if (cache && method != null) {
            if (methodCache == null) {
                methodCache = new HashMap<Signature, Method>();
                methodCacheRef = new SoftReference(methodCache);
            }
            methodCache.put(signature, method);
        }
        return method;
    }

    public static Constructor getConstructor(Class cls, Class[] args) {
        Constructor constructor = null;
        Constructor[] ctors = ConstructorUtil.getConstructors(cls);
        for (int i = 0; i < ctors.length; ++i) {
            if (!ReflectionUtils.matchArguments(args, ctors[i].getParameterTypes())) continue;
            constructor = ctors[i];
        }
        return constructor;
    }

    public static Object getPrivateField(Object instance, Class cls, String name) {
        return ReflectionUtils.getPrivateField(instance, cls, name, null);
    }

    public static Object getPrivateField(Object instance, Class cls, String name, ExceptionListener el) {
        try {
            Field f = cls.getDeclaredField(name);
            f.setAccessible(true);
            return f.get(instance);
        }
        catch (Exception e) {
            if (el != null) {
                el.exceptionThrown(e);
            }
            return null;
        }
    }

    private static class Signature {
        private Class targetClass;
        private String methodName;
        private Class[] argClasses;
        private volatile int hashCode = 0;

        public Signature(Class targetClass, String methodName, Class[] argClasses) {
            this.targetClass = targetClass;
            this.methodName = methodName;
            this.argClasses = argClasses;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            Signature that = (Signature)o2;
            if (this.targetClass != that.targetClass) {
                return false;
            }
            if (!this.methodName.equals(that.methodName)) {
                return false;
            }
            if (this.argClasses.length != that.argClasses.length) {
                return false;
            }
            for (int i = 0; i < this.argClasses.length; ++i) {
                if (this.argClasses[i] == that.argClasses[i]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 17;
                result = 37 * result + this.targetClass.hashCode();
                result = 37 * result + this.methodName.hashCode();
                if (this.argClasses != null) {
                    for (int i = 0; i < this.argClasses.length; ++i) {
                        result = 37 * result + (this.argClasses[i] == null ? 0 : this.argClasses[i].hashCode());
                    }
                }
                this.hashCode = result;
            }
            return this.hashCode;
        }
    }
}

