/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Color;
import java.awt.MultipleGradientPaint;
import java.awt.MultipleGradientPaintContext;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;

final class RadialGradientPaintContext
extends MultipleGradientPaintContext {
    private boolean isSimpleFocus = false;
    private boolean isNonCyclic = false;
    private float radius;
    private float centerX;
    private float centerY;
    private float focusX;
    private float focusY;
    private float radiusSq;
    private float constA;
    private float constB;
    private float gDeltaDelta;
    private float trivial;
    private static final float SCALEBACK = 0.99f;
    private static final int SQRT_LUT_SIZE = 2048;
    private static float[] sqrtLut = new float[2049];

    RadialGradientPaintContext(RadialGradientPaint paint, ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform t, RenderingHints hints, float cx, float cy, float r, float fx, float fy, float[] fractions, Color[] colors, MultipleGradientPaint.CycleMethod cycleMethod, MultipleGradientPaint.ColorSpaceType colorSpace) {
        super(paint, cm, deviceBounds, userBounds, t, hints, fractions, colors, cycleMethod, colorSpace);
        this.centerX = cx;
        this.centerY = cy;
        this.focusX = fx;
        this.focusY = fy;
        this.radius = r;
        this.isSimpleFocus = this.focusX == this.centerX && this.focusY == this.centerY;
        this.isNonCyclic = cycleMethod == MultipleGradientPaint.CycleMethod.NO_CYCLE;
        this.radiusSq = this.radius * this.radius;
        float dX = this.focusX - this.centerX;
        float dY = this.focusY - this.centerY;
        double distSq = dX * dX + dY * dY;
        if (distSq > (double)(this.radiusSq * 0.99f)) {
            float scalefactor = (float)Math.sqrt((double)(this.radiusSq * 0.99f) / distSq);
            this.focusX = this.centerX + (dX *= scalefactor);
            this.focusY = this.centerY + (dY *= scalefactor);
        }
        this.trivial = (float)Math.sqrt(this.radiusSq - dX * dX);
        this.constA = this.a02 - this.centerX;
        this.constB = this.a12 - this.centerY;
        this.gDeltaDelta = 2.0f * (this.a00 * this.a00 + this.a10 * this.a10) / this.radiusSq;
    }

    protected void fillRaster(int[] pixels, int off, int adjust, int x, int y, int w, int h) {
        if (this.isSimpleFocus && this.isNonCyclic && this.isSimpleLookup) {
            this.simpleNonCyclicFillRaster(pixels, off, adjust, x, y, w, h);
        } else {
            this.cyclicCircularGradientFillRaster(pixels, off, adjust, x, y, w, h);
        }
    }

    private void simpleNonCyclicFillRaster(int[] pixels, int off, int adjust, int x, int y, int w, int h) {
        float rowX = this.a00 * (float)x + this.a01 * (float)y + this.constA;
        float rowY = this.a10 * (float)x + this.a11 * (float)y + this.constB;
        float gDeltaDelta = this.gDeltaDelta;
        adjust += w;
        int rgbclip = this.gradient[this.fastGradientArraySize];
        for (int j = 0; j < h; ++j) {
            int i;
            float gRel = (rowX * rowX + rowY * rowY) / this.radiusSq;
            float gDelta = 2.0f * (this.a00 * rowX + this.a10 * rowY) / this.radiusSq + gDeltaDelta / 2.0f;
            for (i = 0; i < w && gRel >= 1.0f; ++i) {
                pixels[off + i] = rgbclip;
                gRel += gDelta;
                gDelta += gDeltaDelta;
            }
            while (i < w && gRel < 1.0f) {
                int gIndex;
                if (gRel <= 0.0f) {
                    gIndex = 0;
                } else {
                    float fIndex = gRel * 2048.0f;
                    int iIndex = (int)fIndex;
                    float s0 = sqrtLut[iIndex];
                    float s1 = sqrtLut[iIndex + 1] - s0;
                    fIndex = s0 + (fIndex - (float)iIndex) * s1;
                    gIndex = (int)(fIndex * (float)this.fastGradientArraySize);
                }
                pixels[off + i] = this.gradient[gIndex];
                gRel += gDelta;
                gDelta += gDeltaDelta;
                ++i;
            }
            while (i < w) {
                pixels[off + i] = rgbclip;
                ++i;
            }
            off += adjust;
            rowX += this.a01;
            rowY += this.a11;
        }
    }

    private void cyclicCircularGradientFillRaster(int[] pixels, int off, int adjust, int x, int y, int w, int h) {
        double constC = -this.radiusSq + this.centerX * this.centerX + this.centerY * this.centerY;
        float constX = this.a00 * (float)x + this.a01 * (float)y + this.a02;
        float constY = this.a10 * (float)x + this.a11 * (float)y + this.a12;
        float precalc2 = 2.0f * this.centerY;
        float precalc3 = -2.0f * this.centerX;
        int indexer = off;
        int pixInc = w + adjust;
        for (int j = 0; j < h; ++j) {
            float X = this.a01 * (float)j + constX;
            float Y = this.a11 * (float)j + constY;
            for (int i = 0; i < w; ++i) {
                double solutionY;
                double solutionX;
                if (X == this.focusX) {
                    solutionX = this.focusX;
                    solutionY = this.centerY;
                    solutionY += Y > this.focusY ? (double)this.trivial : (double)(-this.trivial);
                } else {
                    double slope = (Y - this.focusY) / (X - this.focusX);
                    double yintcpt = (double)Y - slope * (double)X;
                    double A = slope * slope + 1.0;
                    double B = (double)precalc3 + -2.0 * slope * ((double)this.centerY - yintcpt);
                    double C = constC + yintcpt * (yintcpt - (double)precalc2);
                    float det = (float)Math.sqrt(B * B - 4.0 * A * C);
                    solutionX = -B;
                    solutionX += X < this.focusX ? (double)(-det) : (double)det;
                    solutionY = slope * (solutionX /= 2.0 * A) + yintcpt;
                }
                float deltaXSq = X - this.focusX;
                deltaXSq *= deltaXSq;
                float deltaYSq = Y - this.focusY;
                deltaYSq *= deltaYSq;
                float currentToFocusSq = deltaXSq + deltaYSq;
                deltaXSq = (float)solutionX - this.focusX;
                deltaXSq *= deltaXSq;
                deltaYSq = (float)solutionY - this.focusY;
                deltaYSq *= deltaYSq;
                float intersectToFocusSq = deltaXSq + deltaYSq;
                float g = (float)Math.sqrt(currentToFocusSq / intersectToFocusSq);
                pixels[indexer + i] = this.indexIntoGradientsArrays(g);
                X += this.a00;
                Y += this.a10;
            }
            indexer += pixInc;
        }
    }

    static {
        for (int i = 0; i < sqrtLut.length; ++i) {
            RadialGradientPaintContext.sqrtLut[i] = (float)Math.sqrt((float)i / 2048.0f);
        }
    }
}

