/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.DisplayMode;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.ColorModel;
import sun.awt.AppContext;

public abstract class GraphicsDevice {
    private Window fullScreenWindow;
    private AppContext fullScreenAppContext;
    private final Object fsAppContextLock = new Object();
    private Rectangle windowedModeBounds;
    public static final int TYPE_RASTER_SCREEN = 0;
    public static final int TYPE_PRINTER = 1;
    public static final int TYPE_IMAGE_BUFFER = 2;

    protected GraphicsDevice() {
    }

    public abstract int getType();

    public abstract String getIDstring();

    public abstract GraphicsConfiguration[] getConfigurations();

    public abstract GraphicsConfiguration getDefaultConfiguration();

    public GraphicsConfiguration getBestConfiguration(GraphicsConfigTemplate gct) {
        GraphicsConfiguration[] configs = this.getConfigurations();
        return gct.getBestConfiguration(configs);
    }

    public boolean isFullScreenSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFullScreenWindow(Window w) {
        if (this.fullScreenWindow != null && this.windowedModeBounds != null) {
            this.fullScreenWindow.setBounds(this.windowedModeBounds);
        }
        Object object = this.fsAppContextLock;
        synchronized (object) {
            this.fullScreenAppContext = w == null ? null : AppContext.getAppContext();
            this.fullScreenWindow = w;
        }
        if (this.fullScreenWindow != null) {
            this.windowedModeBounds = this.fullScreenWindow.getBounds();
            Rectangle screenBounds = this.getDefaultConfiguration().getBounds();
            this.fullScreenWindow.setBounds(screenBounds.x, screenBounds.y, screenBounds.width, screenBounds.height);
            this.fullScreenWindow.setVisible(true);
            this.fullScreenWindow.toFront();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Window getFullScreenWindow() {
        Window returnWindow = null;
        Object object = this.fsAppContextLock;
        synchronized (object) {
            if (this.fullScreenAppContext == AppContext.getAppContext()) {
                returnWindow = this.fullScreenWindow;
            }
        }
        return returnWindow;
    }

    public boolean isDisplayChangeSupported() {
        return false;
    }

    public void setDisplayMode(DisplayMode dm) {
        throw new UnsupportedOperationException("Cannot change display mode");
    }

    public DisplayMode getDisplayMode() {
        GraphicsConfiguration gc = this.getDefaultConfiguration();
        Rectangle r = gc.getBounds();
        ColorModel cm = gc.getColorModel();
        return new DisplayMode(r.width, r.height, cm.getPixelSize(), 0);
    }

    public DisplayMode[] getDisplayModes() {
        return new DisplayMode[]{this.getDisplayMode()};
    }

    public int getAvailableAcceleratedMemory() {
        return -1;
    }
}

