/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.wsdl.parser;

import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundPortType;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLFeaturedObject;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLModel;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLOperation;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLService;
import com.sun.xml.internal.ws.api.wsdl.parser.WSDLParserExtension;
import com.sun.xml.internal.ws.api.wsdl.parser.WSDLParserExtensionContext;
import com.sun.xml.internal.ws.model.wsdl.WSDLBoundOperationImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLBoundPortTypeImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLFaultImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLOperationImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLPortImpl;
import com.sun.xml.internal.ws.model.wsdl.WSDLPortTypeImpl;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.internal.ws.wsdl.parser.ParserUtil;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.AddressingFeature;

public class W3CAddressingWSDLParserExtension
extends WSDLParserExtension {
    protected static final String COLON_DELIMITER = ":";
    protected static final String SLASH_DELIMITER = "/";

    public boolean bindingElements(WSDLBoundPortType binding, XMLStreamReader reader) {
        return this.addressibleElement(reader, binding);
    }

    public boolean portElements(WSDLPort port, XMLStreamReader reader) {
        return this.addressibleElement(reader, port);
    }

    private boolean addressibleElement(XMLStreamReader reader, WSDLFeaturedObject binding) {
        QName ua = reader.getName();
        if (ua.equals(AddressingVersion.W3C.wsdlExtensionTag)) {
            String required = reader.getAttributeValue("http://schemas.xmlsoap.org/wsdl/", "required");
            binding.addFeature(new AddressingFeature(true, Boolean.parseBoolean(required)));
            XMLStreamReaderUtil.skipElement(reader);
            return true;
        }
        return false;
    }

    public boolean bindingOperationElements(WSDLBoundOperation operation, XMLStreamReader reader) {
        WSDLBoundOperationImpl impl = (WSDLBoundOperationImpl)operation;
        QName anon = reader.getName();
        if (anon.equals(AddressingVersion.W3C.wsdlAnonymousTag)) {
            block7: {
                try {
                    String value = reader.getElementText();
                    if (value == null || value.trim().equals("")) {
                        throw new WebServiceException("Null values not permitted in wsaw:Anonymous.");
                    }
                    if (value.equals("optional")) {
                        impl.setAnonymous(WSDLBoundOperation.ANONYMOUS.optional);
                        break block7;
                    }
                    if (value.equals("required")) {
                        impl.setAnonymous(WSDLBoundOperation.ANONYMOUS.required);
                        break block7;
                    }
                    if (value.equals("prohibited")) {
                        impl.setAnonymous(WSDLBoundOperation.ANONYMOUS.prohibited);
                        break block7;
                    }
                    throw new WebServiceException("wsaw:Anonymous value \"" + value + "\" not understood.");
                }
                catch (XMLStreamException e) {
                    throw new WebServiceException(e);
                }
            }
            return true;
        }
        return false;
    }

    public boolean portTypeOperationInput(WSDLOperation o, XMLStreamReader reader) {
        WSDLOperationImpl impl = (WSDLOperationImpl)o;
        String action = ParserUtil.getAttribute(reader, AddressingVersion.W3C.wsdlActionTag);
        if (action != null) {
            impl.getInput().setAction(action);
            impl.getInput().setDefaultAction(false);
        }
        return false;
    }

    public boolean portTypeOperationOutput(WSDLOperation o, XMLStreamReader reader) {
        WSDLOperationImpl impl = (WSDLOperationImpl)o;
        String action = ParserUtil.getAttribute(reader, AddressingVersion.W3C.wsdlActionTag);
        if (action != null) {
            impl.getOutput().setAction(action);
        }
        return false;
    }

    public boolean portTypeOperationFault(WSDLOperation o, XMLStreamReader reader) {
        WSDLOperationImpl impl = (WSDLOperationImpl)o;
        String action = ParserUtil.getAttribute(reader, AddressingVersion.W3C.wsdlActionTag);
        if (action != null) {
            String name = ParserUtil.getMandatoryNonEmptyAttribute(reader, "name");
            impl.getFaultActionMap().put(name, action);
        }
        return false;
    }

    public void finished(WSDLParserExtensionContext context) {
        WSDLModel model = context.getWSDLModel();
        for (WSDLService wSDLService : model.getServices().values()) {
            for (WSDLPort wSDLPort : wSDLService.getPorts()) {
                WSDLPortImpl port = (WSDLPortImpl)wSDLPort;
                WSDLBoundPortTypeImpl binding = port.getBinding();
                this.populateActions(binding);
                this.patchAnonymousDefault(binding);
            }
        }
    }

    protected String getNamespaceURI() {
        return AddressingVersion.W3C.wsdlNsUri;
    }

    private void populateActions(WSDLBoundPortTypeImpl binding) {
        WSDLPortTypeImpl porttype = binding.getPortType();
        for (WSDLOperationImpl o : porttype.getOperations()) {
            WSDLBoundOperationImpl wboi = binding.get(o.getName());
            if (wboi == null) {
                o.getInput().setAction(this.defaultInputAction(o));
                continue;
            }
            String soapAction = wboi.getSOAPAction();
            if (o.getInput().getAction() == null || o.getInput().getAction().equals("")) {
                if (soapAction != null && !soapAction.equals("")) {
                    o.getInput().setAction(soapAction);
                } else {
                    o.getInput().setAction(this.defaultInputAction(o));
                }
            }
            if (o.getOutput() == null) continue;
            if (o.getOutput().getAction() == null || o.getOutput().getAction().equals("")) {
                o.getOutput().setAction(this.defaultOutputAction(o));
            }
            if (o.getFaults() == null || !o.getFaults().iterator().hasNext()) continue;
            Map<String, String> map = o.getFaultActionMap();
            for (WSDLFaultImpl f : o.getFaults()) {
                if (map.get(f.getName()) != null && !map.get(f.getName()).equals("")) continue;
                map.put(f.getName(), this.defaultFaultAction(f.getName(), o));
            }
        }
    }

    protected void patchAnonymousDefault(WSDLBoundPortTypeImpl binding) {
        for (WSDLBoundOperationImpl wbo : binding.getBindingOperations()) {
            if (wbo.getAnonymous() != null) continue;
            wbo.setAnonymous(WSDLBoundOperation.ANONYMOUS.optional);
        }
    }

    private String defaultInputAction(WSDLOperation o) {
        return W3CAddressingWSDLParserExtension.buildAction(o.getInput().getName(), o, false);
    }

    private String defaultOutputAction(WSDLOperation o) {
        return W3CAddressingWSDLParserExtension.buildAction(o.getOutput().getName(), o, false);
    }

    private String defaultFaultAction(String name, WSDLOperation o) {
        return W3CAddressingWSDLParserExtension.buildAction(name, o, true);
    }

    protected static final String buildAction(String name, WSDLOperation o, boolean isFault) {
        String tns = o.getName().getNamespaceURI();
        String delim = SLASH_DELIMITER;
        if (!tns.startsWith("http")) {
            delim = COLON_DELIMITER;
        }
        if (tns.endsWith(delim)) {
            tns = tns.substring(0, tns.length() - 1);
        }
        if (o.getPortTypeName() == null) {
            throw new WebServiceException("\"" + o.getName() + "\" operation's owning portType name is null.");
        }
        return tns + delim + o.getPortTypeName().getLocalPart() + delim + (isFault ? o.getName().getLocalPart() + delim + "Fault" + delim : "") + name;
    }
}

