/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server.sei;

import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.model.AbstractSEIModelImpl;
import com.sun.xml.internal.ws.model.JavaMethodImpl;
import com.sun.xml.internal.ws.server.sei.EndpointMethodDispatcher;
import com.sun.xml.internal.ws.server.sei.EndpointMethodHandler;
import com.sun.xml.internal.ws.server.sei.SEIInvokerTube;
import java.util.HashMap;
import java.util.Map;

final class SOAPActionBasedDispatcher
implements EndpointMethodDispatcher {
    private final Map<String, EndpointMethodHandler> methodHandlers;

    public SOAPActionBasedDispatcher(AbstractSEIModelImpl model, WSBinding binding, SEIInvokerTube invokerTube) {
        String soapAction;
        HashMap<String, Integer> unique = new HashMap<String, Integer>();
        for (JavaMethodImpl m : model.getJavaMethods()) {
            soapAction = m.getOperation().getSOAPAction();
            Integer count = (Integer)unique.get(soapAction);
            if (count == null) {
                unique.put(soapAction, 1);
                continue;
            }
            count = count + 1;
            unique.put(soapAction, count);
        }
        this.methodHandlers = new HashMap<String, EndpointMethodHandler>();
        for (JavaMethodImpl m : model.getJavaMethods()) {
            soapAction = m.getOperation().getSOAPAction();
            if ((Integer)unique.get(soapAction) != 1) continue;
            this.methodHandlers.put('\"' + soapAction + '\"', new EndpointMethodHandler(invokerTube, m, binding));
        }
    }

    @Nullable
    public EndpointMethodHandler getEndpointMethodHandler(Packet request) {
        return request.soapAction == null ? null : this.methodHandlers.get(request.soapAction);
    }
}

