/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server.sei;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.message.HeaderList;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Messages;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.model.AbstractSEIModelImpl;
import com.sun.xml.internal.ws.model.JavaMethodImpl;
import com.sun.xml.internal.ws.server.sei.DispatchException;
import com.sun.xml.internal.ws.server.sei.EndpointMethodDispatcher;
import com.sun.xml.internal.ws.server.sei.EndpointMethodHandler;
import com.sun.xml.internal.ws.server.sei.SEIInvokerTube;
import java.util.HashMap;
import java.util.Map;

final class ActionBasedDispatcher
implements EndpointMethodDispatcher {
    private final WSBinding binding;
    private final Map<String, EndpointMethodHandler> actionMethodHandlers;
    @NotNull
    private final AddressingVersion av;

    public ActionBasedDispatcher(AbstractSEIModelImpl model, WSBinding binding, SEIInvokerTube invokerTube) {
        this.binding = binding;
        assert (binding.getAddressingVersion() != null);
        this.av = binding.getAddressingVersion();
        this.actionMethodHandlers = new HashMap<String, EndpointMethodHandler>();
        for (JavaMethodImpl m : model.getJavaMethods()) {
            EndpointMethodHandler handler = new EndpointMethodHandler(invokerTube, m, binding);
            String action = m.getInputAction();
            if (action != null && !action.equals("")) {
                this.actionMethodHandlers.put(action, handler);
                continue;
            }
            action = m.getOperation().getOperation().getInput().getAction();
            if (action == null) continue;
            this.actionMethodHandlers.put(action, handler);
        }
    }

    public EndpointMethodHandler getEndpointMethodHandler(Packet request) throws DispatchException {
        HeaderList hl = request.getMessage().getHeaders();
        String action = hl.getAction(this.av, this.binding.getSOAPVersion());
        if (action == null) {
            return null;
        }
        EndpointMethodHandler h = this.actionMethodHandlers.get(action);
        if (h != null) {
            return h;
        }
        Message result = Messages.create(action, this.av, this.binding.getSOAPVersion());
        throw new DispatchException(result);
    }
}

