/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.handler;

import com.sun.xml.internal.ws.api.message.Attachment;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.util.ReadOnlyPropertyException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.xml.ws.handler.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MessageContextImpl
implements MessageContext {
    private Map<String, Object> fallbackMap = null;
    private Set<String> handlerScopeProps;
    Packet packet;

    void fallback() {
        if (this.fallbackMap == null) {
            this.fallbackMap = new HashMap<String, Object>();
            this.fallbackMap.putAll(this.packet.createMapView());
            this.fallbackMap.putAll(this.packet.invocationProperties);
        }
    }

    public MessageContextImpl(Packet packet) {
        this.packet = packet;
        this.handlerScopeProps = packet.getHandlerScopePropertyNames(false);
    }

    protected void updatePacket() {
        throw new UnsupportedOperationException("wrong call");
    }

    @Override
    public void setScope(String name, MessageContext.Scope scope) {
        if (!this.containsKey(name)) {
            throw new IllegalArgumentException("Property " + name + " does not exist.");
        }
        if (scope == MessageContext.Scope.APPLICATION) {
            this.handlerScopeProps.remove(name);
        } else {
            this.handlerScopeProps.add(name);
        }
    }

    @Override
    public MessageContext.Scope getScope(String name) {
        if (!this.containsKey(name)) {
            throw new IllegalArgumentException("Property " + name + " does not exist.");
        }
        if (this.handlerScopeProps.contains(name)) {
            return MessageContext.Scope.HANDLER;
        }
        return MessageContext.Scope.APPLICATION;
    }

    @Override
    public int size() {
        this.fallback();
        return this.fallbackMap.size();
    }

    @Override
    public boolean isEmpty() {
        this.fallback();
        return this.fallbackMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.fallbackMap == null) {
            if (this.packet.supports(key)) {
                return true;
            }
            return this.packet.invocationProperties.containsKey(key);
        }
        this.fallback();
        return this.fallbackMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.fallback();
        return this.fallbackMap.containsValue(value);
    }

    @Override
    public Object put(String key, Object value) {
        if (this.fallbackMap == null) {
            if (this.packet.supports(key)) {
                return this.packet.put(key, value);
            }
            if (!this.packet.invocationProperties.containsKey(key)) {
                this.handlerScopeProps.add(key);
            }
            return this.packet.invocationProperties.put(key, value);
        }
        this.fallback();
        if (!this.fallbackMap.containsKey(key)) {
            this.handlerScopeProps.add(key);
        }
        return this.fallbackMap.put(key, value);
    }

    @Override
    public Object get(Object key) {
        Object value;
        if (key == null) {
            return null;
        }
        if (this.fallbackMap == null) {
            value = this.packet.supports(key) ? this.packet.get(key) : this.packet.invocationProperties.get(key);
        } else {
            this.fallback();
            value = this.fallbackMap.get(key);
        }
        if (key.equals("javax.xml.ws.binding.attachments.outbound") || key.equals("javax.xml.ws.binding.attachments.inbound")) {
            HashMap<String, DataHandler> atts = (HashMap<String, DataHandler>)value;
            if (atts == null) {
                atts = new HashMap<String, DataHandler>();
            }
            AttachmentSet attSet = this.packet.getMessage().getAttachments();
            for (Attachment att : attSet) {
                atts.put(att.getContentId(), att.asDataHandler());
            }
            return atts;
        }
        return value;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> t) {
        this.fallback();
        for (String string : t.keySet()) {
            if (this.fallbackMap.containsKey(string)) continue;
            this.handlerScopeProps.add(string);
        }
        this.fallbackMap.putAll(t);
    }

    @Override
    public void clear() {
        this.fallback();
        this.fallbackMap.clear();
    }

    @Override
    public Object remove(Object key) {
        this.fallback();
        this.handlerScopeProps.remove(key);
        return this.fallbackMap.remove(key);
    }

    @Override
    public Set<String> keySet() {
        this.fallback();
        return this.fallbackMap.keySet();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        this.fallback();
        return this.fallbackMap.entrySet();
    }

    @Override
    public Collection<Object> values() {
        this.fallback();
        return this.fallbackMap.values();
    }

    void fill(Packet packet) {
        if (this.fallbackMap != null) {
            for (Map.Entry<String, Object> entry : this.fallbackMap.entrySet()) {
                String key = entry.getKey();
                if (packet.supports(key)) {
                    try {
                        packet.put(key, entry.getValue());
                    }
                    catch (ReadOnlyPropertyException e) {}
                    continue;
                }
                packet.invocationProperties.put(key, entry.getValue());
            }
            packet.createMapView().keySet().retainAll(this.fallbackMap.keySet());
            packet.invocationProperties.keySet().retainAll(this.fallbackMap.keySet());
        }
    }
}

