/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth;

import com.sun.security.auth.PolicyParser;
import com.sun.security.auth.PrincipalComparator;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.ResourceBundle;
import javax.security.auth.Subject;
import sun.security.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SubjectCodeSource
extends CodeSource
implements Serializable {
    private static final long serialVersionUID = 6039418085604715275L;
    private static final ResourceBundle rb = AccessController.doPrivileged(new PrivilegedAction<ResourceBundle>(){

        @Override
        public ResourceBundle run() {
            return ResourceBundle.getBundle("sun.security.util.AuthResources");
        }
    });
    private Subject subject;
    private LinkedList<PolicyParser.PrincipalEntry> principals;
    private static final Class[] PARAMS = new Class[]{String.class};
    private static final Debug debug = Debug.getInstance("auth", "\t[Auth Access]");
    private ClassLoader sysClassLoader;

    SubjectCodeSource(Subject subject, LinkedList<PolicyParser.PrincipalEntry> principals, URL url, Certificate[] certs) {
        super(url, certs);
        this.subject = subject;
        this.principals = principals == null ? new LinkedList() : new LinkedList<PolicyParser.PrincipalEntry>(principals);
        this.sysClassLoader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }

    LinkedList<PolicyParser.PrincipalEntry> getPrincipals() {
        return this.principals;
    }

    Subject getSubject() {
        return this.subject;
    }

    @Override
    public boolean implies(CodeSource codesource) {
        LinkedList<PolicyParser.PrincipalEntry> subjectList = null;
        if (codesource == null || !(codesource instanceof SubjectCodeSource) || !super.implies(codesource)) {
            if (debug != null) {
                debug.println("\tSubjectCodeSource.implies: FAILURE 1");
            }
            return false;
        }
        SubjectCodeSource that = (SubjectCodeSource)codesource;
        if (this.principals == null) {
            if (debug != null) {
                debug.println("\tSubjectCodeSource.implies: PASS 1");
            }
            return true;
        }
        if (that.getSubject() == null || that.getSubject().getPrincipals().size() == 0) {
            if (debug != null) {
                debug.println("\tSubjectCodeSource.implies: FAILURE 2");
            }
            return false;
        }
        ListIterator<PolicyParser.PrincipalEntry> li = this.principals.listIterator(0);
        while (li.hasNext()) {
            PolicyParser.PrincipalEntry pppe = li.next();
            try {
                Class<?> principalComparator = Class.forName(pppe.principalClass, true, this.sysClassLoader);
                Constructor<?> c = principalComparator.getConstructor(PARAMS);
                PrincipalComparator pc = (PrincipalComparator)c.newInstance(pppe.principalName);
                if (!pc.implies(that.getSubject())) {
                    if (debug != null) {
                        debug.println("\tSubjectCodeSource.implies: FAILURE 3");
                    }
                    return false;
                }
                if (debug != null) {
                    debug.println("\tSubjectCodeSource.implies: PASS 2");
                }
                return true;
            }
            catch (Exception e) {
                if (subjectList == null) {
                    if (that.getSubject() == null) {
                        if (debug != null) {
                            debug.println("\tSubjectCodeSource.implies: FAILURE 4");
                        }
                        return false;
                    }
                    Iterator<Principal> i = that.getSubject().getPrincipals().iterator();
                    subjectList = new LinkedList<PolicyParser.PrincipalEntry>();
                    while (i.hasNext()) {
                        Principal p = i.next();
                        PolicyParser.PrincipalEntry spppe = new PolicyParser.PrincipalEntry(p.getClass().getName(), p.getName());
                        subjectList.add(spppe);
                    }
                }
                if (this.subjectListImpliesPrincipalEntry(subjectList, pppe)) continue;
                if (debug != null) {
                    debug.println("\tSubjectCodeSource.implies: FAILURE 5");
                }
                return false;
            }
        }
        if (debug != null) {
            debug.println("\tSubjectCodeSource.implies: PASS 3");
        }
        return true;
    }

    private boolean subjectListImpliesPrincipalEntry(LinkedList<PolicyParser.PrincipalEntry> subjectList, PolicyParser.PrincipalEntry pppe) {
        ListIterator<PolicyParser.PrincipalEntry> li = subjectList.listIterator(0);
        while (li.hasNext()) {
            PolicyParser.PrincipalEntry listPppe = li.next();
            if (!pppe.principalClass.equals("WILDCARD_PRINCIPAL_CLASS") && !pppe.principalClass.equals(listPppe.principalClass) || !pppe.principalName.equals("WILDCARD_PRINCIPAL_NAME") && !pppe.principalName.equals(listPppe.principalName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SubjectCodeSource)) {
            return false;
        }
        SubjectCodeSource that = (SubjectCodeSource)obj;
        try {
            if (this.getSubject() != that.getSubject()) {
                return false;
            }
        }
        catch (SecurityException se) {
            return false;
        }
        if (this.principals == null && that.principals != null || this.principals != null && that.principals == null) {
            return false;
        }
        return this.principals == null || that.principals == null || this.principals.containsAll(that.principals) && that.principals.containsAll(this.principals);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        String returnMe = super.toString();
        if (this.getSubject() != null) {
            if (debug != null) {
                final Subject finalSubject = this.getSubject();
                returnMe = returnMe + "\n" + AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return finalSubject.toString();
                    }
                });
            } else {
                returnMe = returnMe + "\n" + this.getSubject().toString();
            }
        }
        if (this.principals != null) {
            ListIterator li = this.principals.listIterator();
            while (li.hasNext()) {
                PolicyParser.PrincipalEntry pppe = (PolicyParser.PrincipalEntry)li.next();
                returnMe = returnMe + rb.getString("\n") + pppe.principalClass + " " + pppe.principalName;
            }
        }
        return returnMe;
    }
}

