/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils.resolver;

import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverException;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverSpi;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;

public class ResourceResolver {
    static Logger log = Logger.getLogger(ResourceResolver.class.getName());
    static boolean _alreadyInitialized = false;
    static List _resolverVector = null;
    List _individualResolverVector = null;
    protected ResourceResolverSpi _resolverSpi = null;

    private ResourceResolver(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this._resolverSpi = (ResourceResolverSpi)Class.forName(className).newInstance();
    }

    public ResourceResolver(ResourceResolverSpi resourceResolver) {
        this._resolverSpi = resourceResolver;
    }

    public static final ResourceResolver getInstance(Attr uri, String BaseURI) throws ResourceResolverException {
        int length = _resolverVector.size();
        for (int i = 0; i < length; ++i) {
            ResourceResolver resolver = (ResourceResolver)_resolverVector.get(i);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "check resolvability by class " + resolver.getClass().getName());
            }
            if (resolver == null || !resolver.canResolve(uri, BaseURI)) continue;
            return resolver;
        }
        Object[] exArgs = new Object[]{uri != null ? uri.getNodeValue() : "null", BaseURI};
        throw new ResourceResolverException("utils.resolver.noClass", exArgs, uri, BaseURI);
    }

    public static final ResourceResolver getInstance(Attr uri, String BaseURI, List individualResolvers) throws ResourceResolverException {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "I was asked to create a ResourceResolver and got " + individualResolvers.size());
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, " extra resolvers to my existing " + _resolverVector.size() + " system-wide resolvers");
        }
        int size = 0;
        if (individualResolvers != null && (size = individualResolvers.size()) > 0) {
            for (int i = 0; i < size; ++i) {
                ResourceResolver resolver = (ResourceResolver)individualResolvers.get(i);
                if (resolver == null) continue;
                String currentClass = resolver._resolverSpi.getClass().getName();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "check resolvability by class " + currentClass);
                }
                if (!resolver.canResolve(uri, BaseURI)) continue;
                return resolver;
            }
        }
        return ResourceResolver.getInstance(uri, BaseURI);
    }

    public static void init() {
        if (!_alreadyInitialized) {
            _resolverVector = new ArrayList(10);
            _alreadyInitialized = true;
        }
    }

    public static void register(String className) {
        ResourceResolver resolver = null;
        try {
            resolver = new ResourceResolver(className);
            _resolverVector.add(resolver);
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error loading resolver " + className + " disabling it");
        }
        catch (NoClassDefFoundError e) {
            log.log(Level.WARNING, "Error loading resolver " + className + " disabling it");
        }
    }

    public static void registerAtStart(String className) {
        _resolverVector.add(0, className);
    }

    public static XMLSignatureInput resolveStatic(Attr uri, String BaseURI) throws ResourceResolverException {
        ResourceResolver myResolver = ResourceResolver.getInstance(uri, BaseURI);
        return myResolver.resolve(uri, BaseURI);
    }

    public XMLSignatureInput resolve(Attr uri, String BaseURI) throws ResourceResolverException {
        return this._resolverSpi.engineResolve(uri, BaseURI);
    }

    public void setProperty(String key, String value) {
        this._resolverSpi.engineSetProperty(key, value);
    }

    public String getProperty(String key) {
        return this._resolverSpi.engineGetProperty(key);
    }

    public void addProperties(Map properties) {
        this._resolverSpi.engineAddProperies(properties);
    }

    public String[] getPropertyKeys() {
        return this._resolverSpi.engineGetPropertyKeys();
    }

    public boolean understandsProperty(String propertyToTest) {
        return this._resolverSpi.understandsProperty(propertyToTest);
    }

    private boolean canResolve(Attr uri, String BaseURI) {
        return this._resolverSpi.engineCanResolve(uri, BaseURI);
    }
}

