/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.transforms.implementations;

import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityRuntimeException;
import com.sun.org.apache.xml.internal.security.signature.NodeFilter;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.TransformSpi;
import com.sun.org.apache.xml.internal.security.transforms.TransformationException;
import com.sun.org.apache.xml.internal.security.utils.CachedXPathAPIHolder;
import com.sun.org.apache.xml.internal.security.utils.CachedXPathFuncHereAPI;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.utils.PrefixResolverDefault;
import com.sun.org.apache.xpath.internal.objects.XObject;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TransformXPath
extends TransformSpi {
    static Logger log = Logger.getLogger(TransformXPath.class.getName());
    public static final String implementedTransformURI = "http://www.w3.org/TR/1999/REC-xpath-19991116";

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input) throws TransformationException {
        try {
            CachedXPathAPIHolder.setDoc(this._transformObject.getElement().getOwnerDocument());
            Element xpathElement = XMLUtils.selectDsNode(this._transformObject.getElement().getFirstChild(), "XPath", 0);
            if (xpathElement == null) {
                Object[] exArgs = new Object[]{"ds:XPath", "Transform"};
                throw new TransformationException("xml.WrongContent", exArgs);
            }
            Node xpathnode = xpathElement.getChildNodes().item(0);
            String str = CachedXPathFuncHereAPI.getStrFromNode(xpathnode);
            input.setNeedsToBeExpanded(this.needsCircunvent(str));
            if (xpathnode == null) {
                throw new DOMException(3, "Text must be in ds:Xpath");
            }
            input.addNodeFilter(new XPathNodeFilter(xpathElement, xpathnode, str));
            input.setNodeSet(true);
            return input;
        }
        catch (DOMException ex) {
            throw new TransformationException("empty", ex);
        }
    }

    private boolean needsCircunvent(String str) {
        return true;
    }

    class XPathNodeFilter
    implements NodeFilter {
        PrefixResolverDefault prefixResolver;
        CachedXPathFuncHereAPI xPathFuncHereAPI = new CachedXPathFuncHereAPI(CachedXPathAPIHolder.getCachedXPathAPI());
        Node xpathnode;
        String str;

        XPathNodeFilter(Element xpathElement, Node xpathnode, String str) {
            this.xpathnode = xpathnode;
            this.str = str;
            this.prefixResolver = new PrefixResolverDefault(xpathElement);
        }

        public boolean isNodeInclude(Node currentNode) {
            try {
                XObject includeInResult = this.xPathFuncHereAPI.eval(currentNode, this.xpathnode, this.str, this.prefixResolver);
                return includeInResult.bool();
            }
            catch (TransformerException e) {
                Object[] eArgs = new Object[]{currentNode};
                throw new XMLSecurityRuntimeException("signature.Transform.node", eArgs, e);
            }
            catch (Exception e) {
                Object[] eArgs = new Object[]{currentNode, new Short(currentNode.getNodeType())};
                throw new XMLSecurityRuntimeException("signature.Transform.nodeAndType", eArgs, e);
            }
        }
    }
}

